/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.fis.model.ConflictException;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateRequest;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateResponse;
import software.amazon.awssdk.services.fis.model.DeleteExperimentTemplateRequest;
import software.amazon.awssdk.services.fis.model.DeleteExperimentTemplateResponse;
import software.amazon.awssdk.services.fis.model.FisException;
import software.amazon.awssdk.services.fis.model.GetActionRequest;
import software.amazon.awssdk.services.fis.model.GetActionResponse;
import software.amazon.awssdk.services.fis.model.GetExperimentRequest;
import software.amazon.awssdk.services.fis.model.GetExperimentResponse;
import software.amazon.awssdk.services.fis.model.GetExperimentTemplateRequest;
import software.amazon.awssdk.services.fis.model.GetExperimentTemplateResponse;
import software.amazon.awssdk.services.fis.model.GetTargetResourceTypeRequest;
import software.amazon.awssdk.services.fis.model.GetTargetResourceTypeResponse;
import software.amazon.awssdk.services.fis.model.ListActionsRequest;
import software.amazon.awssdk.services.fis.model.ListActionsResponse;
import software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse;
import software.amazon.awssdk.services.fis.model.ListExperimentsRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentsResponse;
import software.amazon.awssdk.services.fis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fis.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest;
import software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse;
import software.amazon.awssdk.services.fis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.fis.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.fis.model.StartExperimentRequest;
import software.amazon.awssdk.services.fis.model.StartExperimentResponse;
import software.amazon.awssdk.services.fis.model.StopExperimentRequest;
import software.amazon.awssdk.services.fis.model.StopExperimentResponse;
import software.amazon.awssdk.services.fis.model.TagResourceRequest;
import software.amazon.awssdk.services.fis.model.TagResourceResponse;
import software.amazon.awssdk.services.fis.model.UntagResourceRequest;
import software.amazon.awssdk.services.fis.model.UntagResourceResponse;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateRequest;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateResponse;
import software.amazon.awssdk.services.fis.model.ValidationException;
import software.amazon.awssdk.services.fis.paginators.ListActionsIterable;
import software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesIterable;
import software.amazon.awssdk.services.fis.paginators.ListExperimentsIterable;
import software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesIterable;

/**
 * Service client for accessing FIS. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Fault Injection Simulator is a managed service that enables you to perform fault injection experiments on your Amazon
 * Web Services workloads. For more information, see the <a
 * href="https://docs.aws.amazon.com/fis/latest/userguide/">Fault Injection Simulator User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface FisClient extends SdkClient {
    String SERVICE_NAME = "fis";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "fis";

    /**
     * Create a {@link FisClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FisClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FisClient}.
     */
    static FisClientBuilder builder() {
        return new DefaultFisClientBuilder();
    }

    /**
     * <p>
     * Creates an experiment template.
     * </p>
     * <p>
     * An experiment template includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Targets</b>: A target can be a specific resource in your Amazon Web Services environment, or one or more
     * resources that match criteria that you specify, for example, resources that have specific tags.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Actions</b>: The actions to carry out on the target. You can specify multiple actions, the duration of each
     * action, and when to start each action during an experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Stop conditions</b>: If a stop condition is triggered while an experiment is running, the experiment is
     * automatically stopped. You can define a stop condition as a CloudWatch alarm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates</a> in the
     * <i>Fault Injection Simulator User Guide</i>.
     * </p>
     *
     * @param createExperimentTemplateRequest
     * @return Result of the CreateExperimentTemplate operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ConflictException
     *         The request could not be processed because of a conflict.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.CreateExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExperimentTemplateResponse createExperimentTemplate(
            CreateExperimentTemplateRequest createExperimentTemplateRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an experiment template.
     * </p>
     * <p>
     * An experiment template includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Targets</b>: A target can be a specific resource in your Amazon Web Services environment, or one or more
     * resources that match criteria that you specify, for example, resources that have specific tags.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Actions</b>: The actions to carry out on the target. You can specify multiple actions, the duration of each
     * action, and when to start each action during an experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Stop conditions</b>: If a stop condition is triggered while an experiment is running, the experiment is
     * automatically stopped. You can define a stop condition as a CloudWatch alarm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates</a> in the
     * <i>Fault Injection Simulator User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExperimentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateExperimentTemplateRequest#builder()}
     * </p>
     *
     * @param createExperimentTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateExperimentTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateExperimentTemplate operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ConflictException
     *         The request could not be processed because of a conflict.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.CreateExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExperimentTemplateResponse createExperimentTemplate(
            Consumer<CreateExperimentTemplateRequest.Builder> createExperimentTemplateRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            FisException {
        return createExperimentTemplate(CreateExperimentTemplateRequest.builder().applyMutation(createExperimentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified experiment template.
     * </p>
     *
     * @param deleteExperimentTemplateRequest
     * @return Result of the DeleteExperimentTemplate operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.DeleteExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExperimentTemplateResponse deleteExperimentTemplate(
            DeleteExperimentTemplateRequest deleteExperimentTemplateRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified experiment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExperimentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteExperimentTemplateRequest#builder()}
     * </p>
     *
     * @param deleteExperimentTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExperimentTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteExperimentTemplate operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.DeleteExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExperimentTemplateResponse deleteExperimentTemplate(
            Consumer<DeleteExperimentTemplateRequest.Builder> deleteExperimentTemplateRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        return deleteExperimentTemplate(DeleteExperimentTemplateRequest.builder().applyMutation(deleteExperimentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified FIS action.
     * </p>
     *
     * @param getActionRequest
     * @return Result of the GetAction operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.GetAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetAction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetActionResponse getAction(GetActionRequest getActionRequest) throws ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified FIS action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetActionRequest.Builder} avoiding the need to
     * create one manually via {@link GetActionRequest#builder()}
     * </p>
     *
     * @param getActionRequest
     *        A {@link Consumer} that will call methods on {@link GetActionRequest.Builder} to create a request.
     * @return Result of the GetAction operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.GetAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetAction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetActionResponse getAction(Consumer<GetActionRequest.Builder> getActionRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        return getAction(GetActionRequest.builder().applyMutation(getActionRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified experiment.
     * </p>
     *
     * @param getExperimentRequest
     * @return Result of the GetExperiment operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.GetExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExperimentResponse getExperiment(GetExperimentRequest getExperimentRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExperimentRequest.Builder} avoiding the need to
     * create one manually via {@link GetExperimentRequest#builder()}
     * </p>
     *
     * @param getExperimentRequest
     *        A {@link Consumer} that will call methods on {@link GetExperimentRequest.Builder} to create a request.
     * @return Result of the GetExperiment operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.GetExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExperimentResponse getExperiment(Consumer<GetExperimentRequest.Builder> getExperimentRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        return getExperiment(GetExperimentRequest.builder().applyMutation(getExperimentRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified experiment template.
     * </p>
     *
     * @param getExperimentTemplateRequest
     * @return Result of the GetExperimentTemplate operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.GetExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExperimentTemplateResponse getExperimentTemplate(GetExperimentTemplateRequest getExperimentTemplateRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified experiment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExperimentTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link GetExperimentTemplateRequest#builder()}
     * </p>
     *
     * @param getExperimentTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetExperimentTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the GetExperimentTemplate operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.GetExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExperimentTemplateResponse getExperimentTemplate(
            Consumer<GetExperimentTemplateRequest.Builder> getExperimentTemplateRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        return getExperimentTemplate(GetExperimentTemplateRequest.builder().applyMutation(getExperimentTemplateRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified resource type.
     * </p>
     *
     * @param getTargetResourceTypeRequest
     * @return Result of the GetTargetResourceType operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.GetTargetResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetTargetResourceType" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTargetResourceTypeResponse getTargetResourceType(GetTargetResourceTypeRequest getTargetResourceTypeRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTargetResourceTypeRequest.Builder} avoiding the
     * need to create one manually via {@link GetTargetResourceTypeRequest#builder()}
     * </p>
     *
     * @param getTargetResourceTypeRequest
     *        A {@link Consumer} that will call methods on {@link GetTargetResourceTypeRequest.Builder} to create a
     *        request.
     * @return Result of the GetTargetResourceType operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.GetTargetResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetTargetResourceType" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTargetResourceTypeResponse getTargetResourceType(
            Consumer<GetTargetResourceTypeRequest.Builder> getTargetResourceTypeRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        return getTargetResourceType(GetTargetResourceTypeRequest.builder().applyMutation(getTargetResourceTypeRequest).build());
    }

    /**
     * <p>
     * Lists the available FIS actions.
     * </p>
     *
     * @param listActionsRequest
     * @return Result of the ListActions operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsResponse listActions(ListActionsRequest listActionsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available FIS actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActionsRequest#builder()}
     * </p>
     *
     * @param listActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListActionsRequest.Builder} to create a request.
     * @return Result of the ListActions operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsResponse listActions(Consumer<ListActionsRequest.Builder> listActionsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, FisException {
        return listActions(ListActionsRequest.builder().applyMutation(listActionsRequest).build());
    }

    /**
     * <p>
     * Lists the available FIS actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.fis.model.ListActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fis.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     *     for (software.amazon.awssdk.services.fis.model.ListActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.fis.model.ListActionsRequest)} operation.</b>
     * </p>
     *
     * @param listActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsIterable listActionsPaginator(ListActionsRequest listActionsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available FIS actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.fis.model.ListActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fis.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     *     for (software.amazon.awssdk.services.fis.model.ListActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.fis.model.ListActionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActionsRequest#builder()}
     * </p>
     *
     * @param listActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListActionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsIterable listActionsPaginator(Consumer<ListActionsRequest.Builder> listActionsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, FisException {
        return listActionsPaginator(ListActionsRequest.builder().applyMutation(listActionsRequest).build());
    }

    /**
     * <p>
     * Lists your experiment templates.
     * </p>
     *
     * @param listExperimentTemplatesRequest
     * @return Result of the ListExperimentTemplates operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListExperimentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperimentTemplatesResponse listExperimentTemplates(ListExperimentTemplatesRequest listExperimentTemplatesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your experiment templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListExperimentTemplatesRequest#builder()}
     * </p>
     *
     * @param listExperimentTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperimentTemplatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListExperimentTemplates operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListExperimentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperimentTemplatesResponse listExperimentTemplates(
            Consumer<ListExperimentTemplatesRequest.Builder> listExperimentTemplatesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, FisException {
        return listExperimentTemplates(ListExperimentTemplatesRequest.builder().applyMutation(listExperimentTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Lists your experiment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperimentTemplates(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesIterable responses = client.listExperimentTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesIterable responses = client
     *             .listExperimentTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesIterable responses = client.listExperimentTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperimentTemplates(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExperimentTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListExperimentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperimentTemplatesIterable listExperimentTemplatesPaginator(
            ListExperimentTemplatesRequest listExperimentTemplatesRequest) throws ValidationException, AwsServiceException,
            SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your experiment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperimentTemplates(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesIterable responses = client.listExperimentTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesIterable responses = client
     *             .listExperimentTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesIterable responses = client.listExperimentTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperimentTemplates(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListExperimentTemplatesRequest#builder()}
     * </p>
     *
     * @param listExperimentTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperimentTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListExperimentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperimentTemplatesIterable listExperimentTemplatesPaginator(
            Consumer<ListExperimentTemplatesRequest.Builder> listExperimentTemplatesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, FisException {
        return listExperimentTemplatesPaginator(ListExperimentTemplatesRequest.builder()
                .applyMutation(listExperimentTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists your experiments.
     * </p>
     *
     * @param listExperimentsRequest
     * @return Result of the ListExperiments operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsResponse listExperiments(ListExperimentsRequest listExperimentsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your experiments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperimentsRequest#builder()}
     * </p>
     *
     * @param listExperimentsRequest
     *        A {@link Consumer} that will call methods on {@link ListExperimentsRequest.Builder} to create a request.
     * @return Result of the ListExperiments operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsResponse listExperiments(Consumer<ListExperimentsRequest.Builder> listExperimentsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, FisException {
        return listExperiments(ListExperimentsRequest.builder().applyMutation(listExperimentsRequest).build());
    }

    /**
     * <p>
     * Lists your experiments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExperiments(software.amazon.awssdk.services.fis.model.ListExperimentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fis.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     *     for (software.amazon.awssdk.services.fis.model.ListExperimentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiments(software.amazon.awssdk.services.fis.model.ListExperimentsRequest)} operation.</b>
     * </p>
     *
     * @param listExperimentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsIterable listExperimentsPaginator(ListExperimentsRequest listExperimentsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your experiments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExperiments(software.amazon.awssdk.services.fis.model.ListExperimentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fis.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     *     for (software.amazon.awssdk.services.fis.model.ListExperimentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiments(software.amazon.awssdk.services.fis.model.ListExperimentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperimentsRequest#builder()}
     * </p>
     *
     * @param listExperimentsRequest
     *        A {@link Consumer} that will call methods on {@link ListExperimentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsIterable listExperimentsPaginator(Consumer<ListExperimentsRequest.Builder> listExperimentsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, FisException {
        return listExperimentsPaginator(ListExperimentsRequest.builder().applyMutation(listExperimentsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AwsServiceException,
            SdkClientException, FisException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the target resource types.
     * </p>
     *
     * @param listTargetResourceTypesRequest
     * @return Result of the ListTargetResourceTypes operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListTargetResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetResourceTypesResponse listTargetResourceTypes(ListTargetResourceTypesRequest listTargetResourceTypesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the target resource types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTargetResourceTypesRequest#builder()}
     * </p>
     *
     * @param listTargetResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListTargetResourceTypesRequest.Builder} to create a
     *        request.
     * @return Result of the ListTargetResourceTypes operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListTargetResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetResourceTypesResponse listTargetResourceTypes(
            Consumer<ListTargetResourceTypesRequest.Builder> listTargetResourceTypesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, FisException {
        return listTargetResourceTypes(ListTargetResourceTypesRequest.builder().applyMutation(listTargetResourceTypesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the target resource types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTargetResourceTypes(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesIterable responses = client.listTargetResourceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesIterable responses = client
     *             .listTargetResourceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesIterable responses = client.listTargetResourceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetResourceTypes(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTargetResourceTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListTargetResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetResourceTypesIterable listTargetResourceTypesPaginator(
            ListTargetResourceTypesRequest listTargetResourceTypesRequest) throws ValidationException, AwsServiceException,
            SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the target resource types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTargetResourceTypes(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesIterable responses = client.listTargetResourceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesIterable responses = client
     *             .listTargetResourceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesIterable responses = client.listTargetResourceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetResourceTypes(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTargetResourceTypesRequest#builder()}
     * </p>
     *
     * @param listTargetResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListTargetResourceTypesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.ListTargetResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetResourceTypesIterable listTargetResourceTypesPaginator(
            Consumer<ListTargetResourceTypesRequest.Builder> listTargetResourceTypesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, FisException {
        return listTargetResourceTypesPaginator(ListTargetResourceTypesRequest.builder()
                .applyMutation(listTargetResourceTypesRequest).build());
    }

    /**
     * <p>
     * Starts running an experiment from the specified experiment template.
     * </p>
     *
     * @param startExperimentRequest
     * @return Result of the StartExperiment operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ConflictException
     *         The request could not be processed because of a conflict.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.StartExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StartExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default StartExperimentResponse startExperiment(StartExperimentRequest startExperimentRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts running an experiment from the specified experiment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link StartExperimentRequest#builder()}
     * </p>
     *
     * @param startExperimentRequest
     *        A {@link Consumer} that will call methods on {@link StartExperimentRequest.Builder} to create a request.
     * @return Result of the StartExperiment operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ConflictException
     *         The request could not be processed because of a conflict.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.StartExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StartExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default StartExperimentResponse startExperiment(Consumer<StartExperimentRequest.Builder> startExperimentRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, FisException {
        return startExperiment(StartExperimentRequest.builder().applyMutation(startExperimentRequest).build());
    }

    /**
     * <p>
     * Stops the specified experiment.
     * </p>
     *
     * @param stopExperimentRequest
     * @return Result of the StopExperiment operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.StopExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StopExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default StopExperimentResponse stopExperiment(StopExperimentRequest stopExperimentRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopExperimentRequest.Builder} avoiding the need to
     * create one manually via {@link StopExperimentRequest#builder()}
     * </p>
     *
     * @param stopExperimentRequest
     *        A {@link Consumer} that will call methods on {@link StopExperimentRequest.Builder} to create a request.
     * @return Result of the StopExperiment operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.StopExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StopExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default StopExperimentResponse stopExperiment(Consumer<StopExperimentRequest.Builder> stopExperimentRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FisException {
        return stopExperiment(StopExperimentRequest.builder().applyMutation(stopExperimentRequest).build());
    }

    /**
     * <p>
     * Applies the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AwsServiceException,
            SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws AwsServiceException,
            SdkClientException, FisException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AwsServiceException,
            SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AwsServiceException, SdkClientException, FisException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified experiment template.
     * </p>
     *
     * @param updateExperimentTemplateRequest
     * @return Result of the UpdateExperimentTemplate operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.UpdateExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateExperimentTemplateResponse updateExperimentTemplate(
            UpdateExperimentTemplateRequest updateExperimentTemplateRequest) throws ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, FisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified experiment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExperimentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateExperimentTemplateRequest#builder()}
     * </p>
     *
     * @param updateExperimentTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateExperimentTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateExperimentTemplate operation returned by the service.
     * @throws ValidationException
     *         The specified input is not valid, or fails to satisfy the constraints for the request.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FisClient.UpdateExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateExperimentTemplateResponse updateExperimentTemplate(
            Consumer<UpdateExperimentTemplateRequest.Builder> updateExperimentTemplateRequest) throws ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, FisException {
        return updateExperimentTemplate(UpdateExperimentTemplateRequest.builder().applyMutation(updateExperimentTemplateRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
