/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for experiment logging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExperimentTemplateLogConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateExperimentTemplateLogConfigurationInput.Builder, CreateExperimentTemplateLogConfigurationInput> {
    private static final SdkField<ExperimentTemplateCloudWatchLogsLogConfigurationInput> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField
            .<ExperimentTemplateCloudWatchLogsLogConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("cloudWatchLogsConfiguration")
            .getter(getter(CreateExperimentTemplateLogConfigurationInput::cloudWatchLogsConfiguration))
            .setter(setter(Builder::cloudWatchLogsConfiguration))
            .constructor(ExperimentTemplateCloudWatchLogsLogConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsConfiguration")
                    .build()).build();

    private static final SdkField<ExperimentTemplateS3LogConfigurationInput> S3_CONFIGURATION_FIELD = SdkField
            .<ExperimentTemplateS3LogConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("s3Configuration")
            .getter(getter(CreateExperimentTemplateLogConfigurationInput::s3Configuration))
            .setter(setter(Builder::s3Configuration)).constructor(ExperimentTemplateS3LogConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()).build();

    private static final SdkField<Integer> LOG_SCHEMA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("logSchemaVersion").getter(getter(CreateExperimentTemplateLogConfigurationInput::logSchemaVersion))
            .setter(setter(Builder::logSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSchemaVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGS_CONFIGURATION_FIELD, S3_CONFIGURATION_FIELD, LOG_SCHEMA_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration;

    private final ExperimentTemplateS3LogConfigurationInput s3Configuration;

    private final Integer logSchemaVersion;

    private CreateExperimentTemplateLogConfigurationInput(BuilderImpl builder) {
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.s3Configuration = builder.s3Configuration;
        this.logSchemaVersion = builder.logSchemaVersion;
    }

    /**
     * <p>
     * The configuration for experiment logging to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return The configuration for experiment logging to Amazon CloudWatch Logs.
     */
    public final ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration() {
        return cloudWatchLogsConfiguration;
    }

    /**
     * <p>
     * The configuration for experiment logging to Amazon S3.
     * </p>
     * 
     * @return The configuration for experiment logging to Amazon S3.
     */
    public final ExperimentTemplateS3LogConfigurationInput s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * The schema version.
     * </p>
     * 
     * @return The schema version.
     */
    public final Integer logSchemaVersion() {
        return logSchemaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(logSchemaVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentTemplateLogConfigurationInput)) {
            return false;
        }
        CreateExperimentTemplateLogConfigurationInput other = (CreateExperimentTemplateLogConfigurationInput) obj;
        return Objects.equals(cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration())
                && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(logSchemaVersion(), other.logSchemaVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExperimentTemplateLogConfigurationInput")
                .add("CloudWatchLogsConfiguration", cloudWatchLogsConfiguration()).add("S3Configuration", s3Configuration())
                .add("LogSchemaVersion", logSchemaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogsConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsConfiguration()));
        case "s3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "logSchemaVersion":
            return Optional.ofNullable(clazz.cast(logSchemaVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExperimentTemplateLogConfigurationInput, T> g) {
        return obj -> g.apply((CreateExperimentTemplateLogConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateExperimentTemplateLogConfigurationInput> {
        /**
         * <p>
         * The configuration for experiment logging to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param cloudWatchLogsConfiguration
         *        The configuration for experiment logging to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsConfiguration(ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration);

        /**
         * <p>
         * The configuration for experiment logging to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExperimentTemplateCloudWatchLogsLogConfigurationInput.Builder} avoiding the need to create one
         * manually via {@link ExperimentTemplateCloudWatchLogsLogConfigurationInput#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link ExperimentTemplateCloudWatchLogsLogConfigurationInput.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #cloudWatchLogsConfiguration(ExperimentTemplateCloudWatchLogsLogConfigurationInput)}.
         * 
         * @param cloudWatchLogsConfiguration
         *        a consumer that will call methods on
         *        {@link ExperimentTemplateCloudWatchLogsLogConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsConfiguration(ExperimentTemplateCloudWatchLogsLogConfigurationInput)
         */
        default Builder cloudWatchLogsConfiguration(
                Consumer<ExperimentTemplateCloudWatchLogsLogConfigurationInput.Builder> cloudWatchLogsConfiguration) {
            return cloudWatchLogsConfiguration(ExperimentTemplateCloudWatchLogsLogConfigurationInput.builder()
                    .applyMutation(cloudWatchLogsConfiguration).build());
        }

        /**
         * <p>
         * The configuration for experiment logging to Amazon S3.
         * </p>
         * 
         * @param s3Configuration
         *        The configuration for experiment logging to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(ExperimentTemplateS3LogConfigurationInput s3Configuration);

        /**
         * <p>
         * The configuration for experiment logging to Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExperimentTemplateS3LogConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link ExperimentTemplateS3LogConfigurationInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentTemplateS3LogConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #s3Configuration(ExperimentTemplateS3LogConfigurationInput)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link ExperimentTemplateS3LogConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(ExperimentTemplateS3LogConfigurationInput)
         */
        default Builder s3Configuration(Consumer<ExperimentTemplateS3LogConfigurationInput.Builder> s3Configuration) {
            return s3Configuration(ExperimentTemplateS3LogConfigurationInput.builder().applyMutation(s3Configuration).build());
        }

        /**
         * <p>
         * The schema version.
         * </p>
         * 
         * @param logSchemaVersion
         *        The schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSchemaVersion(Integer logSchemaVersion);
    }

    static final class BuilderImpl implements Builder {
        private ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration;

        private ExperimentTemplateS3LogConfigurationInput s3Configuration;

        private Integer logSchemaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperimentTemplateLogConfigurationInput model) {
            cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            s3Configuration(model.s3Configuration);
            logSchemaVersion(model.logSchemaVersion);
        }

        public final ExperimentTemplateCloudWatchLogsLogConfigurationInput.Builder getCloudWatchLogsConfiguration() {
            return cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLogsConfiguration(
                ExperimentTemplateCloudWatchLogsLogConfigurationInput.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(
                ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final ExperimentTemplateS3LogConfigurationInput.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(ExperimentTemplateS3LogConfigurationInput.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(ExperimentTemplateS3LogConfigurationInput s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final Integer getLogSchemaVersion() {
            return logSchemaVersion;
        }

        public final void setLogSchemaVersion(Integer logSchemaVersion) {
            this.logSchemaVersion = logSchemaVersion;
        }

        @Override
        public final Builder logSchemaVersion(Integer logSchemaVersion) {
            this.logSchemaVersion = logSchemaVersion;
            return this;
        }

        @Override
        public CreateExperimentTemplateLogConfigurationInput build() {
            return new CreateExperimentTemplateLogConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
