/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the action for an experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentAction.Builder, ExperimentAction> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionId").getter(getter(ExperimentAction::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ExperimentAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(ExperimentAction::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TARGETS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("targets")
            .getter(getter(ExperimentAction::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> START_AFTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("startAfter")
            .getter(getter(ExperimentAction::startAfter))
            .setter(setter(Builder::startAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startAfter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ExperimentActionState> STATE_FIELD = SdkField
            .<ExperimentActionState> builder(MarshallingType.SDK_POJO).memberName("state")
            .getter(getter(ExperimentAction::state)).setter(setter(Builder::state)).constructor(ExperimentActionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            DESCRIPTION_FIELD, PARAMETERS_FIELD, TARGETS_FIELD, START_AFTER_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String description;

    private final Map<String, String> parameters;

    private final Map<String, String> targets;

    private final List<String> startAfter;

    private final ExperimentActionState state;

    private ExperimentAction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.targets = builder.targets;
        this.startAfter = builder.startAfter;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the action.
     * </p>
     * 
     * @return The ID of the action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The description for the action.
     * </p>
     * 
     * @return The description for the action.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the action.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The targets for the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The targets for the action.
     */
    public final Map<String, String> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the StartAfter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStartAfter() {
        return startAfter != null && !(startAfter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the action that must be completed before this action starts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStartAfter} method.
     * </p>
     * 
     * @return The name of the action that must be completed before this action starts.
     */
    public final List<String> startAfter() {
        return startAfter;
    }

    /**
     * <p>
     * The state of the action.
     * </p>
     * 
     * @return The state of the action.
     */
    public final ExperimentActionState state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStartAfter() ? startAfter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentAction)) {
            return false;
        }
        ExperimentAction other = (ExperimentAction) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(description(), other.description())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasStartAfter() == other.hasStartAfter() && Objects.equals(startAfter(), other.startAfter())
                && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentAction").add("ActionId", actionId()).add("Description", description())
                .add("Parameters", hasParameters() ? parameters() : null).add("Targets", hasTargets() ? targets() : null)
                .add("StartAfter", hasStartAfter() ? startAfter() : null).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "startAfter":
            return Optional.ofNullable(clazz.cast(startAfter()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentAction, T> g) {
        return obj -> g.apply((ExperimentAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentAction> {
        /**
         * <p>
         * The ID of the action.
         * </p>
         * 
         * @param actionId
         *        The ID of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The description for the action.
         * </p>
         * 
         * @param description
         *        The description for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The parameters for the action.
         * </p>
         * 
         * @param parameters
         *        The parameters for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The targets for the action.
         * </p>
         * 
         * @param targets
         *        The targets for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, String> targets);

        /**
         * <p>
         * The name of the action that must be completed before this action starts.
         * </p>
         * 
         * @param startAfter
         *        The name of the action that must be completed before this action starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAfter(Collection<String> startAfter);

        /**
         * <p>
         * The name of the action that must be completed before this action starts.
         * </p>
         * 
         * @param startAfter
         *        The name of the action that must be completed before this action starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAfter(String... startAfter);

        /**
         * <p>
         * The state of the action.
         * </p>
         * 
         * @param state
         *        The state of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ExperimentActionState state);

        /**
         * <p>
         * The state of the action.
         * </p>
         * This is a convenience that creates an instance of the {@link ExperimentActionState.Builder} avoiding the need
         * to create one manually via {@link ExperimentActionState#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentActionState.Builder#build()} is called immediately and
         * its result is passed to {@link #state(ExperimentActionState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ExperimentActionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ExperimentActionState)
         */
        default Builder state(Consumer<ExperimentActionState.Builder> state) {
            return state(ExperimentActionState.builder().applyMutation(state).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String description;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> targets = DefaultSdkAutoConstructMap.getInstance();

        private List<String> startAfter = DefaultSdkAutoConstructList.getInstance();

        private ExperimentActionState state;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentAction model) {
            actionId(model.actionId);
            description(model.description);
            parameters(model.parameters);
            targets(model.targets);
            startAfter(model.startAfter);
            state(model.state);
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        @Transient
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ExperimentActionParameterMapCopier.copy(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ExperimentActionParameterMapCopier.copy(parameters);
            return this;
        }

        public final Map<String, String> getTargets() {
            if (targets instanceof SdkAutoConstructMap) {
                return null;
            }
            return targets;
        }

        public final void setTargets(Map<String, String> targets) {
            this.targets = ExperimentActionTargetMapCopier.copy(targets);
        }

        @Override
        @Transient
        public final Builder targets(Map<String, String> targets) {
            this.targets = ExperimentActionTargetMapCopier.copy(targets);
            return this;
        }

        public final Collection<String> getStartAfter() {
            if (startAfter instanceof SdkAutoConstructList) {
                return null;
            }
            return startAfter;
        }

        public final void setStartAfter(Collection<String> startAfter) {
            this.startAfter = ExperimentActionStartAfterListCopier.copy(startAfter);
        }

        @Override
        @Transient
        public final Builder startAfter(Collection<String> startAfter) {
            this.startAfter = ExperimentActionStartAfterListCopier.copy(startAfter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder startAfter(String... startAfter) {
            startAfter(Arrays.asList(startAfter));
            return this;
        }

        public final ExperimentActionState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(ExperimentActionState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        @Transient
        public final Builder state(ExperimentActionState state) {
            this.state = state;
            return this;
        }

        @Override
        public ExperimentAction build() {
            return new ExperimentAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
