/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTargetAccountConfigurationResponse extends FisResponse implements
        ToCopyableBuilder<DeleteTargetAccountConfigurationResponse.Builder, DeleteTargetAccountConfigurationResponse> {
    private static final SdkField<TargetAccountConfiguration> TARGET_ACCOUNT_CONFIGURATION_FIELD = SdkField
            .<TargetAccountConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("targetAccountConfiguration")
            .getter(getter(DeleteTargetAccountConfigurationResponse::targetAccountConfiguration))
            .setter(setter(Builder::targetAccountConfiguration))
            .constructor(TargetAccountConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TARGET_ACCOUNT_CONFIGURATION_FIELD));

    private final TargetAccountConfiguration targetAccountConfiguration;

    private DeleteTargetAccountConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.targetAccountConfiguration = builder.targetAccountConfiguration;
    }

    /**
     * <p>
     * Information about the target account configuration.
     * </p>
     * 
     * @return Information about the target account configuration.
     */
    public final TargetAccountConfiguration targetAccountConfiguration() {
        return targetAccountConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetAccountConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTargetAccountConfigurationResponse)) {
            return false;
        }
        DeleteTargetAccountConfigurationResponse other = (DeleteTargetAccountConfigurationResponse) obj;
        return Objects.equals(targetAccountConfiguration(), other.targetAccountConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTargetAccountConfigurationResponse")
                .add("TargetAccountConfiguration", targetAccountConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetAccountConfiguration":
            return Optional.ofNullable(clazz.cast(targetAccountConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTargetAccountConfigurationResponse, T> g) {
        return obj -> g.apply((DeleteTargetAccountConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteTargetAccountConfigurationResponse> {
        /**
         * <p>
         * Information about the target account configuration.
         * </p>
         * 
         * @param targetAccountConfiguration
         *        Information about the target account configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountConfiguration(TargetAccountConfiguration targetAccountConfiguration);

        /**
         * <p>
         * Information about the target account configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetAccountConfiguration.Builder}
         * avoiding the need to create one manually via {@link TargetAccountConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetAccountConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #targetAccountConfiguration(TargetAccountConfiguration)}.
         * 
         * @param targetAccountConfiguration
         *        a consumer that will call methods on {@link TargetAccountConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetAccountConfiguration(TargetAccountConfiguration)
         */
        default Builder targetAccountConfiguration(Consumer<TargetAccountConfiguration.Builder> targetAccountConfiguration) {
            return targetAccountConfiguration(TargetAccountConfiguration.builder().applyMutation(targetAccountConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends FisResponse.BuilderImpl implements Builder {
        private TargetAccountConfiguration targetAccountConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTargetAccountConfigurationResponse model) {
            super(model);
            targetAccountConfiguration(model.targetAccountConfiguration);
        }

        public final TargetAccountConfiguration.Builder getTargetAccountConfiguration() {
            return targetAccountConfiguration != null ? targetAccountConfiguration.toBuilder() : null;
        }

        public final void setTargetAccountConfiguration(TargetAccountConfiguration.BuilderImpl targetAccountConfiguration) {
            this.targetAccountConfiguration = targetAccountConfiguration != null ? targetAccountConfiguration.build() : null;
        }

        @Override
        public final Builder targetAccountConfiguration(TargetAccountConfiguration targetAccountConfiguration) {
            this.targetAccountConfiguration = targetAccountConfiguration;
            return this;
        }

        @Override
        public DeleteTargetAccountConfigurationResponse build() {
            return new DeleteTargetAccountConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
