/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an experiment template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentTemplate.Builder, ExperimentTemplate> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ExperimentTemplate::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ExperimentTemplate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, ExperimentTemplateTarget>> TARGETS_FIELD = SdkField
            .<Map<String, ExperimentTemplateTarget>> builder(MarshallingType.MAP)
            .memberName("targets")
            .getter(getter(ExperimentTemplate::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExperimentTemplateTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTemplateTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ExperimentTemplateAction>> ACTIONS_FIELD = SdkField
            .<Map<String, ExperimentTemplateAction>> builder(MarshallingType.MAP)
            .memberName("actions")
            .getter(getter(ExperimentTemplate::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExperimentTemplateAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTemplateAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ExperimentTemplateStopCondition>> STOP_CONDITIONS_FIELD = SdkField
            .<List<ExperimentTemplateStopCondition>> builder(MarshallingType.LIST)
            .memberName("stopConditions")
            .getter(getter(ExperimentTemplate::stopConditions))
            .setter(setter(Builder::stopConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentTemplateStopCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTemplateStopCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(ExperimentTemplate::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(ExperimentTemplate::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ExperimentTemplate::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ExperimentTemplate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ExperimentTemplateLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<ExperimentTemplateLogConfiguration> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(ExperimentTemplate::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(ExperimentTemplateLogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final SdkField<ExperimentTemplateExperimentOptions> EXPERIMENT_OPTIONS_FIELD = SdkField
            .<ExperimentTemplateExperimentOptions> builder(MarshallingType.SDK_POJO).memberName("experimentOptions")
            .getter(getter(ExperimentTemplate::experimentOptions)).setter(setter(Builder::experimentOptions))
            .constructor(ExperimentTemplateExperimentOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentOptions").build()).build();

    private static final SdkField<Long> TARGET_ACCOUNT_CONFIGURATIONS_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("targetAccountConfigurationsCount")
            .getter(getter(ExperimentTemplate::targetAccountConfigurationsCount))
            .setter(setter(Builder::targetAccountConfigurationsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountConfigurationsCount")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            TARGETS_FIELD, ACTIONS_FIELD, STOP_CONDITIONS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, ROLE_ARN_FIELD,
            TAGS_FIELD, LOG_CONFIGURATION_FIELD, EXPERIMENT_OPTIONS_FIELD, TARGET_ACCOUNT_CONFIGURATIONS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String description;

    private final Map<String, ExperimentTemplateTarget> targets;

    private final Map<String, ExperimentTemplateAction> actions;

    private final List<ExperimentTemplateStopCondition> stopConditions;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final String roleArn;

    private final Map<String, String> tags;

    private final ExperimentTemplateLogConfiguration logConfiguration;

    private final ExperimentTemplateExperimentOptions experimentOptions;

    private final Long targetAccountConfigurationsCount;

    private ExperimentTemplate(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.stopConditions = builder.stopConditions;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.logConfiguration = builder.logConfiguration;
        this.experimentOptions = builder.experimentOptions;
        this.targetAccountConfigurationsCount = builder.targetAccountConfigurationsCount;
    }

    /**
     * <p>
     * The ID of the experiment template.
     * </p>
     * 
     * @return The ID of the experiment template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The description for the experiment template.
     * </p>
     * 
     * @return The description for the experiment template.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The targets for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The targets for the experiment.
     */
    public final Map<String, ExperimentTemplateTarget> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The actions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions for the experiment.
     */
    public final Map<String, ExperimentTemplateAction> actions() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StopConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStopConditions() {
        return stopConditions != null && !(stopConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stop conditions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStopConditions} method.
     * </p>
     * 
     * @return The stop conditions for the experiment.
     */
    public final List<ExperimentTemplateStopCondition> stopConditions() {
        return stopConditions;
    }

    /**
     * <p>
     * The time the experiment template was created.
     * </p>
     * 
     * @return The time the experiment template was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the experiment template was last updated.
     * </p>
     * 
     * @return The time the experiment template was last updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the experiment template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the experiment template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for experiment logging.
     * </p>
     * 
     * @return The configuration for experiment logging.
     */
    public final ExperimentTemplateLogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The experiment options for an experiment template.
     * </p>
     * 
     * @return The experiment options for an experiment template.
     */
    public final ExperimentTemplateExperimentOptions experimentOptions() {
        return experimentOptions;
    }

    /**
     * <p>
     * The count of target account configurations for the experiment template.
     * </p>
     * 
     * @return The count of target account configurations for the experiment template.
     */
    public final Long targetAccountConfigurationsCount() {
        return targetAccountConfigurationsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStopConditions() ? stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(experimentOptions());
        hashCode = 31 * hashCode + Objects.hashCode(targetAccountConfigurationsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplate)) {
            return false;
        }
        ExperimentTemplate other = (ExperimentTemplate) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && hasStopConditions() == other.hasStopConditions() && Objects.equals(stopConditions(), other.stopConditions())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(experimentOptions(), other.experimentOptions())
                && Objects.equals(targetAccountConfigurationsCount(), other.targetAccountConfigurationsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentTemplate").add("Id", id()).add("Description", description())
                .add("Targets", hasTargets() ? targets() : null).add("Actions", hasActions() ? actions() : null)
                .add("StopConditions", hasStopConditions() ? stopConditions() : null).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null)
                .add("LogConfiguration", logConfiguration()).add("ExperimentOptions", experimentOptions())
                .add("TargetAccountConfigurationsCount", targetAccountConfigurationsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "stopConditions":
            return Optional.ofNullable(clazz.cast(stopConditions()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "experimentOptions":
            return Optional.ofNullable(clazz.cast(experimentOptions()));
        case "targetAccountConfigurationsCount":
            return Optional.ofNullable(clazz.cast(targetAccountConfigurationsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTemplate, T> g) {
        return obj -> g.apply((ExperimentTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentTemplate> {
        /**
         * <p>
         * The ID of the experiment template.
         * </p>
         * 
         * @param id
         *        The ID of the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description for the experiment template.
         * </p>
         * 
         * @param description
         *        The description for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The targets for the experiment.
         * </p>
         * 
         * @param targets
         *        The targets for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, ExperimentTemplateTarget> targets);

        /**
         * <p>
         * The actions for the experiment.
         * </p>
         * 
         * @param actions
         *        The actions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Map<String, ExperimentTemplateAction> actions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(Collection<ExperimentTemplateStopCondition> stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(ExperimentTemplateStopCondition... stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fis.model.ExperimentTemplateStopCondition.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.fis.model.ExperimentTemplateStopCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fis.model.ExperimentTemplateStopCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stopConditions(List<ExperimentTemplateStopCondition>)}.
         * 
         * @param stopConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fis.model.ExperimentTemplateStopCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopConditions(java.util.Collection<ExperimentTemplateStopCondition>)
         */
        Builder stopConditions(Consumer<ExperimentTemplateStopCondition.Builder>... stopConditions);

        /**
         * <p>
         * The time the experiment template was created.
         * </p>
         * 
         * @param creationTime
         *        The time the experiment template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the experiment template was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time the experiment template was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The tags for the experiment template.
         * </p>
         * 
         * @param tags
         *        The tags for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration for experiment logging.
         * </p>
         * 
         * @param logConfiguration
         *        The configuration for experiment logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(ExperimentTemplateLogConfiguration logConfiguration);

        /**
         * <p>
         * The configuration for experiment logging.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExperimentTemplateLogConfiguration.Builder} avoiding the need to create one manually via
         * {@link ExperimentTemplateLogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentTemplateLogConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logConfiguration(ExperimentTemplateLogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link ExperimentTemplateLogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(ExperimentTemplateLogConfiguration)
         */
        default Builder logConfiguration(Consumer<ExperimentTemplateLogConfiguration.Builder> logConfiguration) {
            return logConfiguration(ExperimentTemplateLogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The experiment options for an experiment template.
         * </p>
         * 
         * @param experimentOptions
         *        The experiment options for an experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentOptions(ExperimentTemplateExperimentOptions experimentOptions);

        /**
         * <p>
         * The experiment options for an experiment template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExperimentTemplateExperimentOptions.Builder} avoiding the need to create one manually via
         * {@link ExperimentTemplateExperimentOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentTemplateExperimentOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #experimentOptions(ExperimentTemplateExperimentOptions)}.
         * 
         * @param experimentOptions
         *        a consumer that will call methods on {@link ExperimentTemplateExperimentOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentOptions(ExperimentTemplateExperimentOptions)
         */
        default Builder experimentOptions(Consumer<ExperimentTemplateExperimentOptions.Builder> experimentOptions) {
            return experimentOptions(ExperimentTemplateExperimentOptions.builder().applyMutation(experimentOptions).build());
        }

        /**
         * <p>
         * The count of target account configurations for the experiment template.
         * </p>
         * 
         * @param targetAccountConfigurationsCount
         *        The count of target account configurations for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountConfigurationsCount(Long targetAccountConfigurationsCount);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String description;

        private Map<String, ExperimentTemplateTarget> targets = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ExperimentTemplateAction> actions = DefaultSdkAutoConstructMap.getInstance();

        private List<ExperimentTemplateStopCondition> stopConditions = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastUpdateTime;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ExperimentTemplateLogConfiguration logConfiguration;

        private ExperimentTemplateExperimentOptions experimentOptions;

        private Long targetAccountConfigurationsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTemplate model) {
            id(model.id);
            description(model.description);
            targets(model.targets);
            actions(model.actions);
            stopConditions(model.stopConditions);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            roleArn(model.roleArn);
            tags(model.tags);
            logConfiguration(model.logConfiguration);
            experimentOptions(model.experimentOptions);
            targetAccountConfigurationsCount(model.targetAccountConfigurationsCount);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ExperimentTemplateTarget.Builder> getTargets() {
            Map<String, ExperimentTemplateTarget.Builder> result = ExperimentTemplateTargetMapCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTargets(Map<String, ExperimentTemplateTarget.BuilderImpl> targets) {
            this.targets = ExperimentTemplateTargetMapCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Map<String, ExperimentTemplateTarget> targets) {
            this.targets = ExperimentTemplateTargetMapCopier.copy(targets);
            return this;
        }

        public final Map<String, ExperimentTemplateAction.Builder> getActions() {
            Map<String, ExperimentTemplateAction.Builder> result = ExperimentTemplateActionMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, ExperimentTemplateAction.BuilderImpl> actions) {
            this.actions = ExperimentTemplateActionMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Map<String, ExperimentTemplateAction> actions) {
            this.actions = ExperimentTemplateActionMapCopier.copy(actions);
            return this;
        }

        public final List<ExperimentTemplateStopCondition.Builder> getStopConditions() {
            List<ExperimentTemplateStopCondition.Builder> result = ExperimentTemplateStopConditionListCopier
                    .copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopConditions(Collection<ExperimentTemplateStopCondition.BuilderImpl> stopConditions) {
            this.stopConditions = ExperimentTemplateStopConditionListCopier.copyFromBuilder(stopConditions);
        }

        @Override
        public final Builder stopConditions(Collection<ExperimentTemplateStopCondition> stopConditions) {
            this.stopConditions = ExperimentTemplateStopConditionListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(ExperimentTemplateStopCondition... stopConditions) {
            stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<ExperimentTemplateStopCondition.Builder>... stopConditions) {
            stopConditions(Stream.of(stopConditions).map(c -> ExperimentTemplateStopCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ExperimentTemplateLogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(ExperimentTemplateLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(ExperimentTemplateLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final ExperimentTemplateExperimentOptions.Builder getExperimentOptions() {
            return experimentOptions != null ? experimentOptions.toBuilder() : null;
        }

        public final void setExperimentOptions(ExperimentTemplateExperimentOptions.BuilderImpl experimentOptions) {
            this.experimentOptions = experimentOptions != null ? experimentOptions.build() : null;
        }

        @Override
        public final Builder experimentOptions(ExperimentTemplateExperimentOptions experimentOptions) {
            this.experimentOptions = experimentOptions;
            return this;
        }

        public final Long getTargetAccountConfigurationsCount() {
            return targetAccountConfigurationsCount;
        }

        public final void setTargetAccountConfigurationsCount(Long targetAccountConfigurationsCount) {
            this.targetAccountConfigurationsCount = targetAccountConfigurationsCount;
        }

        @Override
        public final Builder targetAccountConfigurationsCount(Long targetAccountConfigurationsCount) {
            this.targetAccountConfigurationsCount = targetAccountConfigurationsCount;
            return this;
        }

        @Override
        public ExperimentTemplate build() {
            return new ExperimentTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
