/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExperimentTemplateRequest extends FisRequest implements
        ToCopyableBuilder<CreateExperimentTemplateRequest.Builder, CreateExperimentTemplateRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateExperimentTemplateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateExperimentTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<CreateExperimentTemplateStopConditionInput>> STOP_CONDITIONS_FIELD = SdkField
            .<List<CreateExperimentTemplateStopConditionInput>> builder(MarshallingType.LIST)
            .memberName("stopConditions")
            .getter(getter(CreateExperimentTemplateRequest::stopConditions))
            .setter(setter(Builder::stopConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateExperimentTemplateStopConditionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateExperimentTemplateStopConditionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, CreateExperimentTemplateTargetInput>> TARGETS_FIELD = SdkField
            .<Map<String, CreateExperimentTemplateTargetInput>> builder(MarshallingType.MAP)
            .memberName("targets")
            .getter(getter(CreateExperimentTemplateRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CreateExperimentTemplateTargetInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateExperimentTemplateTargetInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, CreateExperimentTemplateActionInput>> ACTIONS_FIELD = SdkField
            .<Map<String, CreateExperimentTemplateActionInput>> builder(MarshallingType.MAP)
            .memberName("actions")
            .getter(getter(CreateExperimentTemplateRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CreateExperimentTemplateActionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateExperimentTemplateActionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateExperimentTemplateRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateExperimentTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<CreateExperimentTemplateLogConfigurationInput> LOG_CONFIGURATION_FIELD = SdkField
            .<CreateExperimentTemplateLogConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(CreateExperimentTemplateRequest::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(CreateExperimentTemplateLogConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final SdkField<CreateExperimentTemplateExperimentOptionsInput> EXPERIMENT_OPTIONS_FIELD = SdkField
            .<CreateExperimentTemplateExperimentOptionsInput> builder(MarshallingType.SDK_POJO).memberName("experimentOptions")
            .getter(getter(CreateExperimentTemplateRequest::experimentOptions)).setter(setter(Builder::experimentOptions))
            .constructor(CreateExperimentTemplateExperimentOptionsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, STOP_CONDITIONS_FIELD, TARGETS_FIELD, ACTIONS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD,
            LOG_CONFIGURATION_FIELD, EXPERIMENT_OPTIONS_FIELD));

    private final String clientToken;

    private final String description;

    private final List<CreateExperimentTemplateStopConditionInput> stopConditions;

    private final Map<String, CreateExperimentTemplateTargetInput> targets;

    private final Map<String, CreateExperimentTemplateActionInput> actions;

    private final String roleArn;

    private final Map<String, String> tags;

    private final CreateExperimentTemplateLogConfigurationInput logConfiguration;

    private final CreateExperimentTemplateExperimentOptionsInput experimentOptions;

    private CreateExperimentTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.stopConditions = builder.stopConditions;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.logConfiguration = builder.logConfiguration;
        this.experimentOptions = builder.experimentOptions;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description for the experiment template.
     * </p>
     * 
     * @return A description for the experiment template.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the StopConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStopConditions() {
        return stopConditions != null && !(stopConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stop conditions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStopConditions} method.
     * </p>
     * 
     * @return The stop conditions.
     */
    public final List<CreateExperimentTemplateStopConditionInput> stopConditions() {
        return stopConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The targets for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The targets for the experiment.
     */
    public final Map<String, CreateExperimentTemplateTargetInput> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The actions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions for the experiment.
     */
    public final Map<String, CreateExperimentTemplateActionInput> actions() {
        return actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions
     * on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service
     *         actions on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to the experiment template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the experiment template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for experiment logging.
     * </p>
     * 
     * @return The configuration for experiment logging.
     */
    public final CreateExperimentTemplateLogConfigurationInput logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The experiment options for the experiment template.
     * </p>
     * 
     * @return The experiment options for the experiment template.
     */
    public final CreateExperimentTemplateExperimentOptionsInput experimentOptions() {
        return experimentOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasStopConditions() ? stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(experimentOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentTemplateRequest)) {
            return false;
        }
        CreateExperimentTemplateRequest other = (CreateExperimentTemplateRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasStopConditions() == other.hasStopConditions() && Objects.equals(stopConditions(), other.stopConditions())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(experimentOptions(), other.experimentOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExperimentTemplateRequest").add("ClientToken", clientToken())
                .add("Description", description()).add("StopConditions", hasStopConditions() ? stopConditions() : null)
                .add("Targets", hasTargets() ? targets() : null).add("Actions", hasActions() ? actions() : null)
                .add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).add("LogConfiguration", logConfiguration())
                .add("ExperimentOptions", experimentOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "stopConditions":
            return Optional.ofNullable(clazz.cast(stopConditions()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "experimentOptions":
            return Optional.ofNullable(clazz.cast(experimentOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExperimentTemplateRequest, T> g) {
        return obj -> g.apply((CreateExperimentTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateExperimentTemplateRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description for the experiment template.
         * </p>
         * 
         * @param description
         *        A description for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stop conditions.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(Collection<CreateExperimentTemplateStopConditionInput> stopConditions);

        /**
         * <p>
         * The stop conditions.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(CreateExperimentTemplateStopConditionInput... stopConditions);

        /**
         * <p>
         * The stop conditions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fis.model.CreateExperimentTemplateStopConditionInput.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.fis.model.CreateExperimentTemplateStopConditionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fis.model.CreateExperimentTemplateStopConditionInput.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #stopConditions(List<CreateExperimentTemplateStopConditionInput>)}.
         * 
         * @param stopConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fis.model.CreateExperimentTemplateStopConditionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopConditions(java.util.Collection<CreateExperimentTemplateStopConditionInput>)
         */
        Builder stopConditions(Consumer<CreateExperimentTemplateStopConditionInput.Builder>... stopConditions);

        /**
         * <p>
         * The targets for the experiment.
         * </p>
         * 
         * @param targets
         *        The targets for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, CreateExperimentTemplateTargetInput> targets);

        /**
         * <p>
         * The actions for the experiment.
         * </p>
         * 
         * @param actions
         *        The actions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Map<String, CreateExperimentTemplateActionInput> actions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service
         * actions on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform
         *        service actions on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The tags to apply to the experiment template.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration for experiment logging.
         * </p>
         * 
         * @param logConfiguration
         *        The configuration for experiment logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(CreateExperimentTemplateLogConfigurationInput logConfiguration);

        /**
         * <p>
         * The configuration for experiment logging.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateExperimentTemplateLogConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link CreateExperimentTemplateLogConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateExperimentTemplateLogConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #logConfiguration(CreateExperimentTemplateLogConfigurationInput)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link CreateExperimentTemplateLogConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(CreateExperimentTemplateLogConfigurationInput)
         */
        default Builder logConfiguration(Consumer<CreateExperimentTemplateLogConfigurationInput.Builder> logConfiguration) {
            return logConfiguration(CreateExperimentTemplateLogConfigurationInput.builder().applyMutation(logConfiguration)
                    .build());
        }

        /**
         * <p>
         * The experiment options for the experiment template.
         * </p>
         * 
         * @param experimentOptions
         *        The experiment options for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentOptions(CreateExperimentTemplateExperimentOptionsInput experimentOptions);

        /**
         * <p>
         * The experiment options for the experiment template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateExperimentTemplateExperimentOptionsInput.Builder} avoiding the need to create one manually via
         * {@link CreateExperimentTemplateExperimentOptionsInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateExperimentTemplateExperimentOptionsInput.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #experimentOptions(CreateExperimentTemplateExperimentOptionsInput)}.
         * 
         * @param experimentOptions
         *        a consumer that will call methods on {@link CreateExperimentTemplateExperimentOptionsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentOptions(CreateExperimentTemplateExperimentOptionsInput)
         */
        default Builder experimentOptions(Consumer<CreateExperimentTemplateExperimentOptionsInput.Builder> experimentOptions) {
            return experimentOptions(CreateExperimentTemplateExperimentOptionsInput.builder().applyMutation(experimentOptions)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FisRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private List<CreateExperimentTemplateStopConditionInput> stopConditions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, CreateExperimentTemplateTargetInput> targets = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, CreateExperimentTemplateActionInput> actions = DefaultSdkAutoConstructMap.getInstance();

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private CreateExperimentTemplateLogConfigurationInput logConfiguration;

        private CreateExperimentTemplateExperimentOptionsInput experimentOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperimentTemplateRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            stopConditions(model.stopConditions);
            targets(model.targets);
            actions(model.actions);
            roleArn(model.roleArn);
            tags(model.tags);
            logConfiguration(model.logConfiguration);
            experimentOptions(model.experimentOptions);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<CreateExperimentTemplateStopConditionInput.Builder> getStopConditions() {
            List<CreateExperimentTemplateStopConditionInput.Builder> result = CreateExperimentTemplateStopConditionInputListCopier
                    .copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopConditions(Collection<CreateExperimentTemplateStopConditionInput.BuilderImpl> stopConditions) {
            this.stopConditions = CreateExperimentTemplateStopConditionInputListCopier.copyFromBuilder(stopConditions);
        }

        @Override
        public final Builder stopConditions(Collection<CreateExperimentTemplateStopConditionInput> stopConditions) {
            this.stopConditions = CreateExperimentTemplateStopConditionInputListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(CreateExperimentTemplateStopConditionInput... stopConditions) {
            stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<CreateExperimentTemplateStopConditionInput.Builder>... stopConditions) {
            stopConditions(Stream.of(stopConditions)
                    .map(c -> CreateExperimentTemplateStopConditionInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, CreateExperimentTemplateTargetInput.Builder> getTargets() {
            Map<String, CreateExperimentTemplateTargetInput.Builder> result = CreateExperimentTemplateTargetInputMapCopier
                    .copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTargets(Map<String, CreateExperimentTemplateTargetInput.BuilderImpl> targets) {
            this.targets = CreateExperimentTemplateTargetInputMapCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Map<String, CreateExperimentTemplateTargetInput> targets) {
            this.targets = CreateExperimentTemplateTargetInputMapCopier.copy(targets);
            return this;
        }

        public final Map<String, CreateExperimentTemplateActionInput.Builder> getActions() {
            Map<String, CreateExperimentTemplateActionInput.Builder> result = CreateExperimentTemplateActionInputMapCopier
                    .copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, CreateExperimentTemplateActionInput.BuilderImpl> actions) {
            this.actions = CreateExperimentTemplateActionInputMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Map<String, CreateExperimentTemplateActionInput> actions) {
            this.actions = CreateExperimentTemplateActionInputMapCopier.copy(actions);
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final CreateExperimentTemplateLogConfigurationInput.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(CreateExperimentTemplateLogConfigurationInput.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(CreateExperimentTemplateLogConfigurationInput logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final CreateExperimentTemplateExperimentOptionsInput.Builder getExperimentOptions() {
            return experimentOptions != null ? experimentOptions.toBuilder() : null;
        }

        public final void setExperimentOptions(CreateExperimentTemplateExperimentOptionsInput.BuilderImpl experimentOptions) {
            this.experimentOptions = experimentOptions != null ? experimentOptions.build() : null;
        }

        @Override
        public final Builder experimentOptions(CreateExperimentTemplateExperimentOptionsInput experimentOptions) {
            this.experimentOptions = experimentOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExperimentTemplateRequest build() {
            return new CreateExperimentTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
