/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSafetyLeverResponse extends FisResponse implements
        ToCopyableBuilder<GetSafetyLeverResponse.Builder, GetSafetyLeverResponse> {
    private static final SdkField<SafetyLever> SAFETY_LEVER_FIELD = SdkField.<SafetyLever> builder(MarshallingType.SDK_POJO)
            .memberName("safetyLever").getter(getter(GetSafetyLeverResponse::safetyLever)).setter(setter(Builder::safetyLever))
            .constructor(SafetyLever::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("safetyLever").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAFETY_LEVER_FIELD));

    private final SafetyLever safetyLever;

    private GetSafetyLeverResponse(BuilderImpl builder) {
        super(builder);
        this.safetyLever = builder.safetyLever;
    }

    /**
     * <p>
     * Information about the safety lever.
     * </p>
     * 
     * @return Information about the safety lever.
     */
    public final SafetyLever safetyLever() {
        return safetyLever;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(safetyLever());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSafetyLeverResponse)) {
            return false;
        }
        GetSafetyLeverResponse other = (GetSafetyLeverResponse) obj;
        return Objects.equals(safetyLever(), other.safetyLever());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSafetyLeverResponse").add("SafetyLever", safetyLever()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "safetyLever":
            return Optional.ofNullable(clazz.cast(safetyLever()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSafetyLeverResponse, T> g) {
        return obj -> g.apply((GetSafetyLeverResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSafetyLeverResponse> {
        /**
         * <p>
         * Information about the safety lever.
         * </p>
         * 
         * @param safetyLever
         *        Information about the safety lever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder safetyLever(SafetyLever safetyLever);

        /**
         * <p>
         * Information about the safety lever.
         * </p>
         * This is a convenience method that creates an instance of the {@link SafetyLever.Builder} avoiding the need to
         * create one manually via {@link SafetyLever#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SafetyLever.Builder#build()} is called immediately and its result
         * is passed to {@link #safetyLever(SafetyLever)}.
         * 
         * @param safetyLever
         *        a consumer that will call methods on {@link SafetyLever.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #safetyLever(SafetyLever)
         */
        default Builder safetyLever(Consumer<SafetyLever.Builder> safetyLever) {
            return safetyLever(SafetyLever.builder().applyMutation(safetyLever).build());
        }
    }

    static final class BuilderImpl extends FisResponse.BuilderImpl implements Builder {
        private SafetyLever safetyLever;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSafetyLeverResponse model) {
            super(model);
            safetyLever(model.safetyLever);
        }

        public final SafetyLever.Builder getSafetyLever() {
            return safetyLever != null ? safetyLever.toBuilder() : null;
        }

        public final void setSafetyLever(SafetyLever.BuilderImpl safetyLever) {
            this.safetyLever = safetyLever != null ? safetyLever.build() : null;
        }

        @Override
        public final Builder safetyLever(SafetyLever safetyLever) {
            this.safetyLever = safetyLever;
            return this;
        }

        @Override
        public GetSafetyLeverResponse build() {
            return new GetSafetyLeverResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
