/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies experiment options for running an experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExperimentExperimentOptionsInput implements SdkPojo, Serializable,
        ToCopyableBuilder<StartExperimentExperimentOptionsInput.Builder, StartExperimentExperimentOptionsInput> {
    private static final SdkField<String> ACTIONS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionsMode").getter(getter(StartExperimentExperimentOptionsInput::actionsModeAsString))
            .setter(setter(Builder::actionsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionsMode;

    private StartExperimentExperimentOptionsInput(BuilderImpl builder) {
        this.actionsMode = builder.actionsMode;
    }

    /**
     * <p>
     * Specifies the actions mode for experiment options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionsMode} will
     * return {@link ActionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionsModeAsString}.
     * </p>
     * 
     * @return Specifies the actions mode for experiment options.
     * @see ActionsMode
     */
    public final ActionsMode actionsMode() {
        return ActionsMode.fromValue(actionsMode);
    }

    /**
     * <p>
     * Specifies the actions mode for experiment options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionsMode} will
     * return {@link ActionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionsModeAsString}.
     * </p>
     * 
     * @return Specifies the actions mode for experiment options.
     * @see ActionsMode
     */
    public final String actionsModeAsString() {
        return actionsMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionsModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExperimentExperimentOptionsInput)) {
            return false;
        }
        StartExperimentExperimentOptionsInput other = (StartExperimentExperimentOptionsInput) obj;
        return Objects.equals(actionsModeAsString(), other.actionsModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExperimentExperimentOptionsInput").add("ActionsMode", actionsModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionsMode":
            return Optional.ofNullable(clazz.cast(actionsModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExperimentExperimentOptionsInput, T> g) {
        return obj -> g.apply((StartExperimentExperimentOptionsInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartExperimentExperimentOptionsInput> {
        /**
         * <p>
         * Specifies the actions mode for experiment options.
         * </p>
         * 
         * @param actionsMode
         *        Specifies the actions mode for experiment options.
         * @see ActionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionsMode
         */
        Builder actionsMode(String actionsMode);

        /**
         * <p>
         * Specifies the actions mode for experiment options.
         * </p>
         * 
         * @param actionsMode
         *        Specifies the actions mode for experiment options.
         * @see ActionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionsMode
         */
        Builder actionsMode(ActionsMode actionsMode);
    }

    static final class BuilderImpl implements Builder {
        private String actionsMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExperimentExperimentOptionsInput model) {
            actionsMode(model.actionsMode);
        }

        public final String getActionsMode() {
            return actionsMode;
        }

        public final void setActionsMode(String actionsMode) {
            this.actionsMode = actionsMode;
        }

        @Override
        public final Builder actionsMode(String actionsMode) {
            this.actionsMode = actionsMode;
            return this;
        }

        @Override
        public final Builder actionsMode(ActionsMode actionsMode) {
            this.actionsMode(actionsMode == null ? null : actionsMode.toString());
            return this;
        }

        @Override
        public StartExperimentExperimentOptionsInput build() {
            return new StartExperimentExperimentOptionsInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
