/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fis.model.ExperimentSummary;
import software.amazon.awssdk.services.fis.model.ExperimentSummaryListCopier;
import software.amazon.awssdk.services.fis.model.FisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperimentsResponse
extends FisResponse
implements ToCopyableBuilder<Builder, ListExperimentsResponse> {
    private static final SdkField<List<ExperimentSummary>> EXPERIMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("experiments").getter(ListExperimentsResponse.getter(ListExperimentsResponse::experiments)).setter(ListExperimentsResponse.setter(Builder::experiments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experiments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExperimentsResponse.getter(ListExperimentsResponse::nextToken)).setter(ListExperimentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("experiments", EXPERIMENTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ExperimentSummary> experiments;
    private final String nextToken;

    private ListExperimentsResponse(BuilderImpl builder) {
        super(builder);
        this.experiments = builder.experiments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExperiments() {
        return this.experiments != null && !(this.experiments instanceof SdkAutoConstructList);
    }

    public final List<ExperimentSummary> experiments() {
        return this.experiments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExperiments() ? this.experiments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentsResponse)) {
            return false;
        }
        ListExperimentsResponse other = (ListExperimentsResponse)((Object)obj);
        return this.hasExperiments() == other.hasExperiments() && Objects.equals(this.experiments(), other.experiments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperimentsResponse").add("Experiments", this.hasExperiments() ? this.experiments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "experiments": {
                return Optional.ofNullable(clazz.cast(this.experiments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentsResponse, T> g) {
        return obj -> g.apply((ListExperimentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisResponse.BuilderImpl
    implements Builder {
        private List<ExperimentSummary> experiments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentsResponse model) {
            super(model);
            this.experiments(model.experiments);
            this.nextToken(model.nextToken);
        }

        public final List<ExperimentSummary.Builder> getExperiments() {
            List<ExperimentSummary.Builder> result = ExperimentSummaryListCopier.copyToBuilder(this.experiments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExperiments(Collection<ExperimentSummary.BuilderImpl> experiments) {
            this.experiments = ExperimentSummaryListCopier.copyFromBuilder(experiments);
        }

        @Override
        public final Builder experiments(Collection<ExperimentSummary> experiments) {
            this.experiments = ExperimentSummaryListCopier.copy(experiments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder experiments(ExperimentSummary ... experiments) {
            this.experiments(Arrays.asList(experiments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder experiments(Consumer<ExperimentSummary.Builder> ... experiments) {
            this.experiments(Stream.of(experiments).map(c -> (ExperimentSummary)((ExperimentSummary.Builder)ExperimentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExperimentsResponse build() {
            return new ListExperimentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperimentsResponse> {
        public Builder experiments(Collection<ExperimentSummary> var1);

        public Builder experiments(ExperimentSummary ... var1);

        public Builder experiments(Consumer<ExperimentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

