/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisClient;
import software.amazon.awssdk.services.fis.internal.UserAgentUtils;
import software.amazon.awssdk.services.fis.model.ActionSummary;
import software.amazon.awssdk.services.fis.model.ListActionsRequest;
import software.amazon.awssdk.services.fis.model.ListActionsResponse;

public class ListActionsIterable
implements SdkIterable<ListActionsResponse> {
    private final FisClient client;
    private final ListActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActionsIterable(FisClient client, ListActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListActionsResponseFetcher();
    }

    public Iterator<ListActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionSummary> actions() {
        Function<ListActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actions() != null) {
                return response.actions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActionsResponseFetcher
    implements SyncPageFetcher<ListActionsResponse> {
        private ListActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActionsResponse nextPage(ListActionsResponse previousPage) {
            if (previousPage == null) {
                return ListActionsIterable.this.client.listActions(ListActionsIterable.this.firstRequest);
            }
            return ListActionsIterable.this.client.listActions((ListActionsRequest)((Object)ListActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

