/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the report configuration for the experiment. For more information, see <a
 * href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-report-configuration">Experiment report
 * configurations for AWS FIS</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentReportConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentReportConfiguration.Builder, ExperimentReportConfiguration> {
    private static final SdkField<ExperimentReportConfigurationOutputs> OUTPUTS_FIELD = SdkField
            .<ExperimentReportConfigurationOutputs> builder(MarshallingType.SDK_POJO).memberName("outputs")
            .getter(getter(ExperimentReportConfiguration::outputs)).setter(setter(Builder::outputs))
            .constructor(ExperimentReportConfigurationOutputs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build()).build();

    private static final SdkField<ExperimentReportConfigurationDataSources> DATA_SOURCES_FIELD = SdkField
            .<ExperimentReportConfigurationDataSources> builder(MarshallingType.SDK_POJO).memberName("dataSources")
            .getter(getter(ExperimentReportConfiguration::dataSources)).setter(setter(Builder::dataSources))
            .constructor(ExperimentReportConfigurationDataSources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<String> PRE_EXPERIMENT_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preExperimentDuration").getter(getter(ExperimentReportConfiguration::preExperimentDuration))
            .setter(setter(Builder::preExperimentDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preExperimentDuration").build())
            .build();

    private static final SdkField<String> POST_EXPERIMENT_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postExperimentDuration").getter(getter(ExperimentReportConfiguration::postExperimentDuration))
            .setter(setter(Builder::postExperimentDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postExperimentDuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUTS_FIELD,
            DATA_SOURCES_FIELD, PRE_EXPERIMENT_DURATION_FIELD, POST_EXPERIMENT_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExperimentReportConfigurationOutputs outputs;

    private final ExperimentReportConfigurationDataSources dataSources;

    private final String preExperimentDuration;

    private final String postExperimentDuration;

    private ExperimentReportConfiguration(BuilderImpl builder) {
        this.outputs = builder.outputs;
        this.dataSources = builder.dataSources;
        this.preExperimentDuration = builder.preExperimentDuration;
        this.postExperimentDuration = builder.postExperimentDuration;
    }

    /**
     * <p>
     * The output destinations of the experiment report.
     * </p>
     * 
     * @return The output destinations of the experiment report.
     */
    public final ExperimentReportConfigurationOutputs outputs() {
        return outputs;
    }

    /**
     * <p>
     * The data sources for the experiment report.
     * </p>
     * 
     * @return The data sources for the experiment report.
     */
    public final ExperimentReportConfigurationDataSources dataSources() {
        return dataSources;
    }

    /**
     * <p>
     * The duration before the experiment start time for the data sources to include in the report.
     * </p>
     * 
     * @return The duration before the experiment start time for the data sources to include in the report.
     */
    public final String preExperimentDuration() {
        return preExperimentDuration;
    }

    /**
     * <p>
     * The duration after the experiment end time for the data sources to include in the report.
     * </p>
     * 
     * @return The duration after the experiment end time for the data sources to include in the report.
     */
    public final String postExperimentDuration() {
        return postExperimentDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(preExperimentDuration());
        hashCode = 31 * hashCode + Objects.hashCode(postExperimentDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentReportConfiguration)) {
            return false;
        }
        ExperimentReportConfiguration other = (ExperimentReportConfiguration) obj;
        return Objects.equals(outputs(), other.outputs()) && Objects.equals(dataSources(), other.dataSources())
                && Objects.equals(preExperimentDuration(), other.preExperimentDuration())
                && Objects.equals(postExperimentDuration(), other.postExperimentDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentReportConfiguration").add("Outputs", outputs()).add("DataSources", dataSources())
                .add("PreExperimentDuration", preExperimentDuration()).add("PostExperimentDuration", postExperimentDuration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "dataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "preExperimentDuration":
            return Optional.ofNullable(clazz.cast(preExperimentDuration()));
        case "postExperimentDuration":
            return Optional.ofNullable(clazz.cast(postExperimentDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("outputs", OUTPUTS_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("preExperimentDuration", PRE_EXPERIMENT_DURATION_FIELD);
        map.put("postExperimentDuration", POST_EXPERIMENT_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentReportConfiguration, T> g) {
        return obj -> g.apply((ExperimentReportConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentReportConfiguration> {
        /**
         * <p>
         * The output destinations of the experiment report.
         * </p>
         * 
         * @param outputs
         *        The output destinations of the experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(ExperimentReportConfigurationOutputs outputs);

        /**
         * <p>
         * The output destinations of the experiment report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExperimentReportConfigurationOutputs.Builder} avoiding the need to create one manually via
         * {@link ExperimentReportConfigurationOutputs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentReportConfigurationOutputs.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(ExperimentReportConfigurationOutputs)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link ExperimentReportConfigurationOutputs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(ExperimentReportConfigurationOutputs)
         */
        default Builder outputs(Consumer<ExperimentReportConfigurationOutputs.Builder> outputs) {
            return outputs(ExperimentReportConfigurationOutputs.builder().applyMutation(outputs).build());
        }

        /**
         * <p>
         * The data sources for the experiment report.
         * </p>
         * 
         * @param dataSources
         *        The data sources for the experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(ExperimentReportConfigurationDataSources dataSources);

        /**
         * <p>
         * The data sources for the experiment report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExperimentReportConfigurationDataSources.Builder} avoiding the need to create one manually via
         * {@link ExperimentReportConfigurationDataSources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentReportConfigurationDataSources.Builder#build()} is
         * called immediately and its result is passed to {@link #dataSources(ExperimentReportConfigurationDataSources)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link ExperimentReportConfigurationDataSources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(ExperimentReportConfigurationDataSources)
         */
        default Builder dataSources(Consumer<ExperimentReportConfigurationDataSources.Builder> dataSources) {
            return dataSources(ExperimentReportConfigurationDataSources.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * The duration before the experiment start time for the data sources to include in the report.
         * </p>
         * 
         * @param preExperimentDuration
         *        The duration before the experiment start time for the data sources to include in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preExperimentDuration(String preExperimentDuration);

        /**
         * <p>
         * The duration after the experiment end time for the data sources to include in the report.
         * </p>
         * 
         * @param postExperimentDuration
         *        The duration after the experiment end time for the data sources to include in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postExperimentDuration(String postExperimentDuration);
    }

    static final class BuilderImpl implements Builder {
        private ExperimentReportConfigurationOutputs outputs;

        private ExperimentReportConfigurationDataSources dataSources;

        private String preExperimentDuration;

        private String postExperimentDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentReportConfiguration model) {
            outputs(model.outputs);
            dataSources(model.dataSources);
            preExperimentDuration(model.preExperimentDuration);
            postExperimentDuration(model.postExperimentDuration);
        }

        public final ExperimentReportConfigurationOutputs.Builder getOutputs() {
            return outputs != null ? outputs.toBuilder() : null;
        }

        public final void setOutputs(ExperimentReportConfigurationOutputs.BuilderImpl outputs) {
            this.outputs = outputs != null ? outputs.build() : null;
        }

        @Override
        public final Builder outputs(ExperimentReportConfigurationOutputs outputs) {
            this.outputs = outputs;
            return this;
        }

        public final ExperimentReportConfigurationDataSources.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        public final void setDataSources(ExperimentReportConfigurationDataSources.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public final Builder dataSources(ExperimentReportConfigurationDataSources dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final String getPreExperimentDuration() {
            return preExperimentDuration;
        }

        public final void setPreExperimentDuration(String preExperimentDuration) {
            this.preExperimentDuration = preExperimentDuration;
        }

        @Override
        public final Builder preExperimentDuration(String preExperimentDuration) {
            this.preExperimentDuration = preExperimentDuration;
            return this;
        }

        public final String getPostExperimentDuration() {
            return postExperimentDuration;
        }

        public final void setPostExperimentDuration(String postExperimentDuration) {
            this.postExperimentDuration = postExperimentDuration;
        }

        @Override
        public final Builder postExperimentDuration(String postExperimentDuration) {
            this.postExperimentDuration = postExperimentDuration;
            return this;
        }

        @Override
        public ExperimentReportConfiguration build() {
            return new ExperimentReportConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
