/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of an experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentSummary.Builder, ExperimentSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ExperimentSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ExperimentSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> EXPERIMENT_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experimentTemplateId").getter(getter(ExperimentSummary::experimentTemplateId))
            .setter(setter(Builder::experimentTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplateId").build())
            .build();

    private static final SdkField<ExperimentState> STATE_FIELD = SdkField.<ExperimentState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(ExperimentSummary::state)).setter(setter(Builder::state))
            .constructor(ExperimentState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(ExperimentSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ExperimentSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ExperimentOptions> EXPERIMENT_OPTIONS_FIELD = SdkField
            .<ExperimentOptions> builder(MarshallingType.SDK_POJO).memberName("experimentOptions")
            .getter(getter(ExperimentSummary::experimentOptions)).setter(setter(Builder::experimentOptions))
            .constructor(ExperimentOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            EXPERIMENT_TEMPLATE_ID_FIELD, STATE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD, EXPERIMENT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String experimentTemplateId;

    private final ExperimentState state;

    private final Instant creationTime;

    private final Map<String, String> tags;

    private final ExperimentOptions experimentOptions;

    private ExperimentSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.experimentTemplateId = builder.experimentTemplateId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
        this.experimentOptions = builder.experimentOptions;
    }

    /**
     * <p>
     * The ID of the experiment.
     * </p>
     * 
     * @return The ID of the experiment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the experiment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the experiment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the experiment template.
     * </p>
     * 
     * @return The ID of the experiment template.
     */
    public final String experimentTemplateId() {
        return experimentTemplateId;
    }

    /**
     * <p>
     * The state of the experiment.
     * </p>
     * 
     * @return The state of the experiment.
     */
    public final ExperimentState state() {
        return state;
    }

    /**
     * <p>
     * The time that the experiment was created.
     * </p>
     * 
     * @return The time that the experiment was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the experiment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The experiment options for the experiment.
     * </p>
     * 
     * @return The experiment options for the experiment.
     */
    public final ExperimentOptions experimentOptions() {
        return experimentOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(experimentTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(experimentOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentSummary)) {
            return false;
        }
        ExperimentSummary other = (ExperimentSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(experimentTemplateId(), other.experimentTemplateId()) && Objects.equals(state(), other.state())
                && Objects.equals(creationTime(), other.creationTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(experimentOptions(), other.experimentOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentSummary").add("Id", id()).add("Arn", arn())
                .add("ExperimentTemplateId", experimentTemplateId()).add("State", state()).add("CreationTime", creationTime())
                .add("Tags", hasTags() ? tags() : null).add("ExperimentOptions", experimentOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "experimentTemplateId":
            return Optional.ofNullable(clazz.cast(experimentTemplateId()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "experimentOptions":
            return Optional.ofNullable(clazz.cast(experimentOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("experimentTemplateId", EXPERIMENT_TEMPLATE_ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("experimentOptions", EXPERIMENT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentSummary, T> g) {
        return obj -> g.apply((ExperimentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentSummary> {
        /**
         * <p>
         * The ID of the experiment.
         * </p>
         * 
         * @param id
         *        The ID of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the experiment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the experiment template.
         * </p>
         * 
         * @param experimentTemplateId
         *        The ID of the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentTemplateId(String experimentTemplateId);

        /**
         * <p>
         * The state of the experiment.
         * </p>
         * 
         * @param state
         *        The state of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ExperimentState state);

        /**
         * <p>
         * The state of the experiment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentState.Builder} avoiding the
         * need to create one manually via {@link ExperimentState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(ExperimentState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ExperimentState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ExperimentState)
         */
        default Builder state(Consumer<ExperimentState.Builder> state) {
            return state(ExperimentState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The time that the experiment was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the experiment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The tags for the experiment.
         * </p>
         * 
         * @param tags
         *        The tags for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The experiment options for the experiment.
         * </p>
         * 
         * @param experimentOptions
         *        The experiment options for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentOptions(ExperimentOptions experimentOptions);

        /**
         * <p>
         * The experiment options for the experiment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentOptions.Builder} avoiding the
         * need to create one manually via {@link ExperimentOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentOptions(ExperimentOptions)}.
         * 
         * @param experimentOptions
         *        a consumer that will call methods on {@link ExperimentOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentOptions(ExperimentOptions)
         */
        default Builder experimentOptions(Consumer<ExperimentOptions.Builder> experimentOptions) {
            return experimentOptions(ExperimentOptions.builder().applyMutation(experimentOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String experimentTemplateId;

        private ExperimentState state;

        private Instant creationTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ExperimentOptions experimentOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentSummary model) {
            id(model.id);
            arn(model.arn);
            experimentTemplateId(model.experimentTemplateId);
            state(model.state);
            creationTime(model.creationTime);
            tags(model.tags);
            experimentOptions(model.experimentOptions);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getExperimentTemplateId() {
            return experimentTemplateId;
        }

        public final void setExperimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
        }

        @Override
        public final Builder experimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        public final ExperimentState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(ExperimentState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ExperimentState state) {
            this.state = state;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ExperimentOptions.Builder getExperimentOptions() {
            return experimentOptions != null ? experimentOptions.toBuilder() : null;
        }

        public final void setExperimentOptions(ExperimentOptions.BuilderImpl experimentOptions) {
            this.experimentOptions = experimentOptions != null ? experimentOptions.build() : null;
        }

        @Override
        public final Builder experimentOptions(ExperimentOptions experimentOptions) {
            this.experimentOptions = experimentOptions;
            return this;
        }

        @Override
        public ExperimentSummary build() {
            return new ExperimentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
