/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the outputs for the experiment templates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentTemplateReportConfigurationOutputsInput
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ExperimentTemplateReportConfigurationOutputsInput.Builder, ExperimentTemplateReportConfigurationOutputsInput> {
    private static final SdkField<ReportConfigurationS3OutputInput> S3_CONFIGURATION_FIELD = SdkField
            .<ReportConfigurationS3OutputInput> builder(MarshallingType.SDK_POJO).memberName("s3Configuration")
            .getter(getter(ExperimentTemplateReportConfigurationOutputsInput::s3Configuration))
            .setter(setter(Builder::s3Configuration)).constructor(ReportConfigurationS3OutputInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReportConfigurationS3OutputInput s3Configuration;

    private ExperimentTemplateReportConfigurationOutputsInput(BuilderImpl builder) {
        this.s3Configuration = builder.s3Configuration;
    }

    /**
     * <p>
     * The S3 destination for the experiment report.
     * </p>
     * 
     * @return The S3 destination for the experiment report.
     */
    public final ReportConfigurationS3OutputInput s3Configuration() {
        return s3Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplateReportConfigurationOutputsInput)) {
            return false;
        }
        ExperimentTemplateReportConfigurationOutputsInput other = (ExperimentTemplateReportConfigurationOutputsInput) obj;
        return Objects.equals(s3Configuration(), other.s3Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentTemplateReportConfigurationOutputsInput").add("S3Configuration", s3Configuration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Configuration", S3_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTemplateReportConfigurationOutputsInput, T> g) {
        return obj -> g.apply((ExperimentTemplateReportConfigurationOutputsInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentTemplateReportConfigurationOutputsInput> {
        /**
         * <p>
         * The S3 destination for the experiment report.
         * </p>
         * 
         * @param s3Configuration
         *        The S3 destination for the experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(ReportConfigurationS3OutputInput s3Configuration);

        /**
         * <p>
         * The S3 destination for the experiment report.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportConfigurationS3OutputInput.Builder}
         * avoiding the need to create one manually via {@link ReportConfigurationS3OutputInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportConfigurationS3OutputInput.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Configuration(ReportConfigurationS3OutputInput)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link ReportConfigurationS3OutputInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(ReportConfigurationS3OutputInput)
         */
        default Builder s3Configuration(Consumer<ReportConfigurationS3OutputInput.Builder> s3Configuration) {
            return s3Configuration(ReportConfigurationS3OutputInput.builder().applyMutation(s3Configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReportConfigurationS3OutputInput s3Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTemplateReportConfigurationOutputsInput model) {
            s3Configuration(model.s3Configuration);
        }

        public final ReportConfigurationS3OutputInput.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(ReportConfigurationS3OutputInput.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(ReportConfigurationS3OutputInput s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        @Override
        public ExperimentTemplateReportConfigurationOutputsInput build() {
            return new ExperimentTemplateReportConfigurationOutputsInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
