/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExperimentTargetAccountConfigurationsRequest extends FisRequest
        implements
        ToCopyableBuilder<ListExperimentTargetAccountConfigurationsRequest.Builder, ListExperimentTargetAccountConfigurationsRequest> {
    private static final SdkField<String> EXPERIMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experimentId").getter(getter(ListExperimentTargetAccountConfigurationsRequest::experimentId))
            .setter(setter(Builder::experimentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListExperimentTargetAccountConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ID_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String experimentId;

    private final String nextToken;

    private ListExperimentTargetAccountConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.experimentId = builder.experimentId;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the experiment.
     * </p>
     * 
     * @return The ID of the experiment.
     */
    public final String experimentId() {
        return experimentId;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(experimentId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentTargetAccountConfigurationsRequest)) {
            return false;
        }
        ListExperimentTargetAccountConfigurationsRequest other = (ListExperimentTargetAccountConfigurationsRequest) obj;
        return Objects.equals(experimentId(), other.experimentId()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExperimentTargetAccountConfigurationsRequest").add("ExperimentId", experimentId())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "experimentId":
            return Optional.ofNullable(clazz.cast(experimentId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", EXPERIMENT_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentTargetAccountConfigurationsRequest, T> g) {
        return obj -> g.apply((ListExperimentTargetAccountConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListExperimentTargetAccountConfigurationsRequest> {
        /**
         * <p>
         * The ID of the experiment.
         * </p>
         * 
         * @param experimentId
         *        The ID of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentId(String experimentId);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FisRequest.BuilderImpl implements Builder {
        private String experimentId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentTargetAccountConfigurationsRequest model) {
            super(model);
            experimentId(model.experimentId);
            nextToken(model.nextToken);
        }

        public final String getExperimentId() {
            return experimentId;
        }

        public final void setExperimentId(String experimentId) {
            this.experimentId = experimentId;
        }

        @Override
        public final Builder experimentId(String experimentId) {
            this.experimentId = experimentId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExperimentTargetAccountConfigurationsRequest build() {
            return new ListExperimentTargetAccountConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
