/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTargetAccountConfigurationsResponse extends FisResponse implements
        ToCopyableBuilder<ListTargetAccountConfigurationsResponse.Builder, ListTargetAccountConfigurationsResponse> {
    private static final SdkField<List<TargetAccountConfigurationSummary>> TARGET_ACCOUNT_CONFIGURATIONS_FIELD = SdkField
            .<List<TargetAccountConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("targetAccountConfigurations")
            .getter(getter(ListTargetAccountConfigurationsResponse::targetAccountConfigurations))
            .setter(setter(Builder::targetAccountConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetAccountConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetAccountConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTargetAccountConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TARGET_ACCOUNT_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TargetAccountConfigurationSummary> targetAccountConfigurations;

    private final String nextToken;

    private ListTargetAccountConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.targetAccountConfigurations = builder.targetAccountConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetAccountConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetAccountConfigurations() {
        return targetAccountConfigurations != null && !(targetAccountConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target account configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetAccountConfigurations} method.
     * </p>
     * 
     * @return The target account configurations.
     */
    public final List<TargetAccountConfigurationSummary> targetAccountConfigurations() {
        return targetAccountConfigurations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetAccountConfigurations() ? targetAccountConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetAccountConfigurationsResponse)) {
            return false;
        }
        ListTargetAccountConfigurationsResponse other = (ListTargetAccountConfigurationsResponse) obj;
        return hasTargetAccountConfigurations() == other.hasTargetAccountConfigurations()
                && Objects.equals(targetAccountConfigurations(), other.targetAccountConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTargetAccountConfigurationsResponse")
                .add("TargetAccountConfigurations", hasTargetAccountConfigurations() ? targetAccountConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetAccountConfigurations":
            return Optional.ofNullable(clazz.cast(targetAccountConfigurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetAccountConfigurations", TARGET_ACCOUNT_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTargetAccountConfigurationsResponse, T> g) {
        return obj -> g.apply((ListTargetAccountConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTargetAccountConfigurationsResponse> {
        /**
         * <p>
         * The target account configurations.
         * </p>
         * 
         * @param targetAccountConfigurations
         *        The target account configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountConfigurations(Collection<TargetAccountConfigurationSummary> targetAccountConfigurations);

        /**
         * <p>
         * The target account configurations.
         * </p>
         * 
         * @param targetAccountConfigurations
         *        The target account configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountConfigurations(TargetAccountConfigurationSummary... targetAccountConfigurations);

        /**
         * <p>
         * The target account configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fis.model.TargetAccountConfigurationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.fis.model.TargetAccountConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fis.model.TargetAccountConfigurationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #targetAccountConfigurations(List<TargetAccountConfigurationSummary>)}.
         * 
         * @param targetAccountConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fis.model.TargetAccountConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetAccountConfigurations(java.util.Collection<TargetAccountConfigurationSummary>)
         */
        Builder targetAccountConfigurations(Consumer<TargetAccountConfigurationSummary.Builder>... targetAccountConfigurations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FisResponse.BuilderImpl implements Builder {
        private List<TargetAccountConfigurationSummary> targetAccountConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetAccountConfigurationsResponse model) {
            super(model);
            targetAccountConfigurations(model.targetAccountConfigurations);
            nextToken(model.nextToken);
        }

        public final List<TargetAccountConfigurationSummary.Builder> getTargetAccountConfigurations() {
            List<TargetAccountConfigurationSummary.Builder> result = TargetAccountConfigurationListCopier
                    .copyToBuilder(this.targetAccountConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetAccountConfigurations(
                Collection<TargetAccountConfigurationSummary.BuilderImpl> targetAccountConfigurations) {
            this.targetAccountConfigurations = TargetAccountConfigurationListCopier.copyFromBuilder(targetAccountConfigurations);
        }

        @Override
        public final Builder targetAccountConfigurations(Collection<TargetAccountConfigurationSummary> targetAccountConfigurations) {
            this.targetAccountConfigurations = TargetAccountConfigurationListCopier.copy(targetAccountConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountConfigurations(TargetAccountConfigurationSummary... targetAccountConfigurations) {
            targetAccountConfigurations(Arrays.asList(targetAccountConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountConfigurations(
                Consumer<TargetAccountConfigurationSummary.Builder>... targetAccountConfigurations) {
            targetAccountConfigurations(Stream.of(targetAccountConfigurations)
                    .map(c -> TargetAccountConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTargetAccountConfigurationsResponse build() {
            return new ListTargetAccountConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
