/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resolved target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolvedTarget implements SdkPojo, Serializable, ToCopyableBuilder<ResolvedTarget.Builder, ResolvedTarget> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ResolvedTarget::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetName").getter(getter(ResolvedTarget::targetName)).setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetName").build()).build();

    private static final SdkField<Map<String, String>> TARGET_INFORMATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("targetInformation")
            .getter(getter(ResolvedTarget::targetInformation))
            .setter(setter(Builder::targetInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInformation").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            TARGET_NAME_FIELD, TARGET_INFORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String targetName;

    private final Map<String, String> targetInformation;

    private ResolvedTarget(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.targetName = builder.targetName;
        this.targetInformation = builder.targetInformation;
    }

    /**
     * <p>
     * The resource type of the target.
     * </p>
     * 
     * @return The resource type of the target.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the target.
     * </p>
     * 
     * @return The name of the target.
     */
    public final String targetName() {
        return targetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetInformation property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetInformation() {
        return targetInformation != null && !(targetInformation instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about the target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetInformation} method.
     * </p>
     * 
     * @return Information about the target.
     */
    public final Map<String, String> targetInformation() {
        return targetInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetInformation() ? targetInformation() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedTarget)) {
            return false;
        }
        ResolvedTarget other = (ResolvedTarget) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(targetName(), other.targetName())
                && hasTargetInformation() == other.hasTargetInformation()
                && Objects.equals(targetInformation(), other.targetInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolvedTarget").add("ResourceType", resourceType()).add("TargetName", targetName())
                .add("TargetInformation", hasTargetInformation() ? targetInformation() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "targetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        case "targetInformation":
            return Optional.ofNullable(clazz.cast(targetInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("targetName", TARGET_NAME_FIELD);
        map.put("targetInformation", TARGET_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolvedTarget, T> g) {
        return obj -> g.apply((ResolvedTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolvedTarget> {
        /**
         * <p>
         * The resource type of the target.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The name of the target.
         * </p>
         * 
         * @param targetName
         *        The name of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);

        /**
         * <p>
         * Information about the target.
         * </p>
         * 
         * @param targetInformation
         *        Information about the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInformation(Map<String, String> targetInformation);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String targetName;

        private Map<String, String> targetInformation = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedTarget model) {
            resourceType(model.resourceType);
            targetName(model.targetName);
            targetInformation(model.targetInformation);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getTargetName() {
            return targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final Map<String, String> getTargetInformation() {
            if (targetInformation instanceof SdkAutoConstructMap) {
                return null;
            }
            return targetInformation;
        }

        public final void setTargetInformation(Map<String, String> targetInformation) {
            this.targetInformation = TargetInformationMapCopier.copy(targetInformation);
        }

        @Override
        public final Builder targetInformation(Map<String, String> targetInformation) {
            this.targetInformation = TargetInformationMapCopier.copy(targetInformation);
            return this;
        }

        @Override
        public ResolvedTarget build() {
            return new ResolvedTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
