/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSafetyLeverStateRequest extends FisRequest implements
        ToCopyableBuilder<UpdateSafetyLeverStateRequest.Builder, UpdateSafetyLeverStateRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateSafetyLeverStateRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<UpdateSafetyLeverStateInput> STATE_FIELD = SdkField
            .<UpdateSafetyLeverStateInput> builder(MarshallingType.SDK_POJO).memberName("state")
            .getter(getter(UpdateSafetyLeverStateRequest::state)).setter(setter(Builder::state))
            .constructor(UpdateSafetyLeverStateInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final UpdateSafetyLeverStateInput state;

    private UpdateSafetyLeverStateRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the safety lever.
     * </p>
     * 
     * @return The ID of the safety lever.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The state of the safety lever.
     * </p>
     * 
     * @return The state of the safety lever.
     */
    public final UpdateSafetyLeverStateInput state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSafetyLeverStateRequest)) {
            return false;
        }
        UpdateSafetyLeverStateRequest other = (UpdateSafetyLeverStateRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSafetyLeverStateRequest").add("Id", id()).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSafetyLeverStateRequest, T> g) {
        return obj -> g.apply((UpdateSafetyLeverStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSafetyLeverStateRequest> {
        /**
         * <p>
         * The ID of the safety lever.
         * </p>
         * 
         * @param id
         *        The ID of the safety lever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The state of the safety lever.
         * </p>
         * 
         * @param state
         *        The state of the safety lever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(UpdateSafetyLeverStateInput state);

        /**
         * <p>
         * The state of the safety lever.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateSafetyLeverStateInput.Builder}
         * avoiding the need to create one manually via {@link UpdateSafetyLeverStateInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateSafetyLeverStateInput.Builder#build()} is called
         * immediately and its result is passed to {@link #state(UpdateSafetyLeverStateInput)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link UpdateSafetyLeverStateInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(UpdateSafetyLeverStateInput)
         */
        default Builder state(Consumer<UpdateSafetyLeverStateInput.Builder> state) {
            return state(UpdateSafetyLeverStateInput.builder().applyMutation(state).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FisRequest.BuilderImpl implements Builder {
        private String id;

        private UpdateSafetyLeverStateInput state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSafetyLeverStateRequest model) {
            super(model);
            id(model.id);
            state(model.state);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final UpdateSafetyLeverStateInput.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(UpdateSafetyLeverStateInput.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(UpdateSafetyLeverStateInput state) {
            this.state = state;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSafetyLeverStateRequest build() {
            return new UpdateSafetyLeverStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
