/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisAsyncClient;
import software.amazon.awssdk.services.fis.internal.UserAgentUtils;
import software.amazon.awssdk.services.fis.model.ListTargetAccountConfigurationsRequest;
import software.amazon.awssdk.services.fis.model.ListTargetAccountConfigurationsResponse;
import software.amazon.awssdk.services.fis.model.TargetAccountConfigurationSummary;

public class ListTargetAccountConfigurationsPublisher
implements SdkPublisher<ListTargetAccountConfigurationsResponse> {
    private final FisAsyncClient client;
    private final ListTargetAccountConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTargetAccountConfigurationsPublisher(FisAsyncClient client, ListTargetAccountConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTargetAccountConfigurationsPublisher(FisAsyncClient client, ListTargetAccountConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTargetAccountConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTargetAccountConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TargetAccountConfigurationSummary> targetAccountConfigurations() {
        Function<ListTargetAccountConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targetAccountConfigurations() != null) {
                return response.targetAccountConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTargetAccountConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTargetAccountConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListTargetAccountConfigurationsResponse> {
        private ListTargetAccountConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetAccountConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTargetAccountConfigurationsResponse> nextPage(ListTargetAccountConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListTargetAccountConfigurationsPublisher.this.client.listTargetAccountConfigurations(ListTargetAccountConfigurationsPublisher.this.firstRequest);
            }
            return ListTargetAccountConfigurationsPublisher.this.client.listTargetAccountConfigurations((ListTargetAccountConfigurationsRequest)((Object)ListTargetAccountConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

