/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fis.model.FisResponse;
import software.amazon.awssdk.services.fis.model.ResolvedTarget;
import software.amazon.awssdk.services.fis.model.ResolvedTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperimentResolvedTargetsResponse
extends FisResponse
implements ToCopyableBuilder<Builder, ListExperimentResolvedTargetsResponse> {
    private static final SdkField<List<ResolvedTarget>> RESOLVED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resolvedTargets").getter(ListExperimentResolvedTargetsResponse.getter(ListExperimentResolvedTargetsResponse::resolvedTargets)).setter(ListExperimentResolvedTargetsResponse.setter(Builder::resolvedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolvedTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExperimentResolvedTargetsResponse.getter(ListExperimentResolvedTargetsResponse::nextToken)).setter(ListExperimentResolvedTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVED_TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExperimentResolvedTargetsResponse.memberNameToFieldInitializer();
    private final List<ResolvedTarget> resolvedTargets;
    private final String nextToken;

    private ListExperimentResolvedTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.resolvedTargets = builder.resolvedTargets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResolvedTargets() {
        return this.resolvedTargets != null && !(this.resolvedTargets instanceof SdkAutoConstructList);
    }

    public final List<ResolvedTarget> resolvedTargets() {
        return this.resolvedTargets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolvedTargets() ? this.resolvedTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentResolvedTargetsResponse)) {
            return false;
        }
        ListExperimentResolvedTargetsResponse other = (ListExperimentResolvedTargetsResponse)((Object)obj);
        return this.hasResolvedTargets() == other.hasResolvedTargets() && Objects.equals(this.resolvedTargets(), other.resolvedTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperimentResolvedTargetsResponse").add("ResolvedTargets", this.hasResolvedTargets() ? this.resolvedTargets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resolvedTargets": {
                return Optional.ofNullable(clazz.cast(this.resolvedTargets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resolvedTargets", RESOLVED_TARGETS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentResolvedTargetsResponse, T> g) {
        return obj -> g.apply((ListExperimentResolvedTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisResponse.BuilderImpl
    implements Builder {
        private List<ResolvedTarget> resolvedTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentResolvedTargetsResponse model) {
            super(model);
            this.resolvedTargets(model.resolvedTargets);
            this.nextToken(model.nextToken);
        }

        public final List<ResolvedTarget.Builder> getResolvedTargets() {
            List<ResolvedTarget.Builder> result = ResolvedTargetListCopier.copyToBuilder(this.resolvedTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResolvedTargets(Collection<ResolvedTarget.BuilderImpl> resolvedTargets) {
            this.resolvedTargets = ResolvedTargetListCopier.copyFromBuilder(resolvedTargets);
        }

        @Override
        public final Builder resolvedTargets(Collection<ResolvedTarget> resolvedTargets) {
            this.resolvedTargets = ResolvedTargetListCopier.copy(resolvedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedTargets(ResolvedTarget ... resolvedTargets) {
            this.resolvedTargets(Arrays.asList(resolvedTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedTargets(Consumer<ResolvedTarget.Builder> ... resolvedTargets) {
            this.resolvedTargets(Stream.of(resolvedTargets).map(c -> (ResolvedTarget)((ResolvedTarget.Builder)ResolvedTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExperimentResolvedTargetsResponse build() {
            return new ListExperimentResolvedTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperimentResolvedTargetsResponse> {
        public Builder resolvedTargets(Collection<ResolvedTarget> var1);

        public Builder resolvedTargets(ResolvedTarget ... var1);

        public Builder resolvedTargets(Consumer<ResolvedTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

