/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateSummary;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateSummaryListCopier;
import software.amazon.awssdk.services.fis.model.FisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperimentTemplatesResponse
extends FisResponse
implements ToCopyableBuilder<Builder, ListExperimentTemplatesResponse> {
    private static final SdkField<List<ExperimentTemplateSummary>> EXPERIMENT_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("experimentTemplates").getter(ListExperimentTemplatesResponse.getter(ListExperimentTemplatesResponse::experimentTemplates)).setter(ListExperimentTemplatesResponse.setter(Builder::experimentTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExperimentTemplatesResponse.getter(ListExperimentTemplatesResponse::nextToken)).setter(ListExperimentTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExperimentTemplatesResponse.memberNameToFieldInitializer();
    private final List<ExperimentTemplateSummary> experimentTemplates;
    private final String nextToken;

    private ListExperimentTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.experimentTemplates = builder.experimentTemplates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExperimentTemplates() {
        return this.experimentTemplates != null && !(this.experimentTemplates instanceof SdkAutoConstructList);
    }

    public final List<ExperimentTemplateSummary> experimentTemplates() {
        return this.experimentTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExperimentTemplates() ? this.experimentTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentTemplatesResponse)) {
            return false;
        }
        ListExperimentTemplatesResponse other = (ListExperimentTemplatesResponse)((Object)obj);
        return this.hasExperimentTemplates() == other.hasExperimentTemplates() && Objects.equals(this.experimentTemplates(), other.experimentTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperimentTemplatesResponse").add("ExperimentTemplates", this.hasExperimentTemplates() ? this.experimentTemplates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "experimentTemplates": {
                return Optional.ofNullable(clazz.cast(this.experimentTemplates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("experimentTemplates", EXPERIMENT_TEMPLATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentTemplatesResponse, T> g) {
        return obj -> g.apply((ListExperimentTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisResponse.BuilderImpl
    implements Builder {
        private List<ExperimentTemplateSummary> experimentTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentTemplatesResponse model) {
            super(model);
            this.experimentTemplates(model.experimentTemplates);
            this.nextToken(model.nextToken);
        }

        public final List<ExperimentTemplateSummary.Builder> getExperimentTemplates() {
            List<ExperimentTemplateSummary.Builder> result = ExperimentTemplateSummaryListCopier.copyToBuilder(this.experimentTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExperimentTemplates(Collection<ExperimentTemplateSummary.BuilderImpl> experimentTemplates) {
            this.experimentTemplates = ExperimentTemplateSummaryListCopier.copyFromBuilder(experimentTemplates);
        }

        @Override
        public final Builder experimentTemplates(Collection<ExperimentTemplateSummary> experimentTemplates) {
            this.experimentTemplates = ExperimentTemplateSummaryListCopier.copy(experimentTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder experimentTemplates(ExperimentTemplateSummary ... experimentTemplates) {
            this.experimentTemplates(Arrays.asList(experimentTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder experimentTemplates(Consumer<ExperimentTemplateSummary.Builder> ... experimentTemplates) {
            this.experimentTemplates(Stream.of(experimentTemplates).map(c -> (ExperimentTemplateSummary)((ExperimentTemplateSummary.Builder)ExperimentTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExperimentTemplatesResponse build() {
            return new ListExperimentTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperimentTemplatesResponse> {
        public Builder experimentTemplates(Collection<ExperimentTemplateSummary> var1);

        public Builder experimentTemplates(ExperimentTemplateSummary ... var1);

        public Builder experimentTemplates(Consumer<ExperimentTemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

