/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateActionParameterMapCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateActionStartAfterListCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateActionTargetMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExperimentTemplateActionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateExperimentTemplateActionInput> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(CreateExperimentTemplateActionInput.getter(CreateExperimentTemplateActionInput::actionId)).setter(CreateExperimentTemplateActionInput.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateExperimentTemplateActionInput.getter(CreateExperimentTemplateActionInput::description)).setter(CreateExperimentTemplateActionInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(CreateExperimentTemplateActionInput.getter(CreateExperimentTemplateActionInput::parameters)).setter(CreateExperimentTemplateActionInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targets").getter(CreateExperimentTemplateActionInput.getter(CreateExperimentTemplateActionInput::targets)).setter(CreateExperimentTemplateActionInput.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> START_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("startAfter").getter(CreateExperimentTemplateActionInput.getter(CreateExperimentTemplateActionInput::startAfter)).setter(CreateExperimentTemplateActionInput.setter(Builder::startAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startAfter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD, TARGETS_FIELD, START_AFTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExperimentTemplateActionInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String description;
    private final Map<String, String> parameters;
    private final Map<String, String> targets;
    private final List<String> startAfter;

    private CreateExperimentTemplateActionInput(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.targets = builder.targets;
        this.startAfter = builder.startAfter;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> targets() {
        return this.targets;
    }

    public final boolean hasStartAfter() {
        return this.startAfter != null && !(this.startAfter instanceof SdkAutoConstructList);
    }

    public final List<String> startAfter() {
        return this.startAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStartAfter() ? this.startAfter() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentTemplateActionInput)) {
            return false;
        }
        CreateExperimentTemplateActionInput other = (CreateExperimentTemplateActionInput)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.description(), other.description()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasStartAfter() == other.hasStartAfter() && Objects.equals(this.startAfter(), other.startAfter());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExperimentTemplateActionInput").add("ActionId", (Object)this.actionId()).add("Description", (Object)this.description()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Targets", this.hasTargets() ? this.targets() : null).add("StartAfter", this.hasStartAfter() ? this.startAfter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "startAfter": {
                return Optional.ofNullable(clazz.cast(this.startAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionId", ACTION_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("startAfter", START_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExperimentTemplateActionInput, T> g) {
        return obj -> g.apply((CreateExperimentTemplateActionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String description;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> targets = DefaultSdkAutoConstructMap.getInstance();
        private List<String> startAfter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperimentTemplateActionInput model) {
            this.actionId(model.actionId);
            this.description(model.description);
            this.parameters(model.parameters);
            this.targets(model.targets);
            this.startAfter(model.startAfter);
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ExperimentTemplateActionParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ExperimentTemplateActionParameterMapCopier.copy(parameters);
            return this;
        }

        public final Map<String, String> getTargets() {
            if (this.targets instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Map<String, String> targets) {
            this.targets = ExperimentTemplateActionTargetMapCopier.copy(targets);
        }

        @Override
        public final Builder targets(Map<String, String> targets) {
            this.targets = ExperimentTemplateActionTargetMapCopier.copy(targets);
            return this;
        }

        public final Collection<String> getStartAfter() {
            if (this.startAfter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.startAfter;
        }

        public final void setStartAfter(Collection<String> startAfter) {
            this.startAfter = ExperimentTemplateActionStartAfterListCopier.copy(startAfter);
        }

        @Override
        public final Builder startAfter(Collection<String> startAfter) {
            this.startAfter = ExperimentTemplateActionStartAfterListCopier.copy(startAfter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startAfter(String ... startAfter) {
            this.startAfter(Arrays.asList(startAfter));
            return this;
        }

        public CreateExperimentTemplateActionInput build() {
            return new CreateExperimentTemplateActionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateExperimentTemplateActionInput> {
        public Builder actionId(String var1);

        public Builder description(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder targets(Map<String, String> var1);

        public Builder startAfter(Collection<String> var1);

        public Builder startAfter(String ... var1);
    }
}

