/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ExperimentReportS3ReportListCopier {
    static List<ExperimentReportS3Report> copy(Collection<? extends ExperimentReportS3Report> experimentReportS3ReportListParam) {
        List<ExperimentReportS3Report> list;
        if (experimentReportS3ReportListParam == null || experimentReportS3ReportListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExperimentReportS3Report> modifiableList = new ArrayList<>(experimentReportS3ReportListParam.size());
            experimentReportS3ReportListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExperimentReportS3Report> copyFromBuilder(
            Collection<? extends ExperimentReportS3Report.Builder> experimentReportS3ReportListParam) {
        List<ExperimentReportS3Report> list;
        if (experimentReportS3ReportListParam == null || experimentReportS3ReportListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExperimentReportS3Report> modifiableList = new ArrayList<>(experimentReportS3ReportListParam.size());
            experimentReportS3ReportListParam.forEach(entry -> {
                ExperimentReportS3Report member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExperimentReportS3Report.Builder> copyToBuilder(
            Collection<? extends ExperimentReportS3Report> experimentReportS3ReportListParam) {
        List<ExperimentReportS3Report.Builder> list;
        if (experimentReportS3ReportListParam == null || experimentReportS3ReportListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExperimentReportS3Report.Builder> modifiableList = new ArrayList<>(experimentReportS3ReportListParam.size());
            experimentReportS3ReportListParam.forEach(entry -> {
                ExperimentReportS3Report.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
