/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an experiment option for an experiment template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExperimentTemplateExperimentOptionsInput implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateExperimentTemplateExperimentOptionsInput.Builder, UpdateExperimentTemplateExperimentOptionsInput> {
    private static final SdkField<String> EMPTY_TARGET_RESOLUTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emptyTargetResolutionMode")
            .getter(getter(UpdateExperimentTemplateExperimentOptionsInput::emptyTargetResolutionModeAsString))
            .setter(setter(Builder::emptyTargetResolutionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emptyTargetResolutionMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EMPTY_TARGET_RESOLUTION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String emptyTargetResolutionMode;

    private UpdateExperimentTemplateExperimentOptionsInput(BuilderImpl builder) {
        this.emptyTargetResolutionMode = builder.emptyTargetResolutionMode;
    }

    /**
     * <p>
     * The empty target resolution mode of the experiment template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #emptyTargetResolutionMode} will return {@link EmptyTargetResolutionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #emptyTargetResolutionModeAsString}.
     * </p>
     * 
     * @return The empty target resolution mode of the experiment template.
     * @see EmptyTargetResolutionMode
     */
    public final EmptyTargetResolutionMode emptyTargetResolutionMode() {
        return EmptyTargetResolutionMode.fromValue(emptyTargetResolutionMode);
    }

    /**
     * <p>
     * The empty target resolution mode of the experiment template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #emptyTargetResolutionMode} will return {@link EmptyTargetResolutionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #emptyTargetResolutionModeAsString}.
     * </p>
     * 
     * @return The empty target resolution mode of the experiment template.
     * @see EmptyTargetResolutionMode
     */
    public final String emptyTargetResolutionModeAsString() {
        return emptyTargetResolutionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emptyTargetResolutionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperimentTemplateExperimentOptionsInput)) {
            return false;
        }
        UpdateExperimentTemplateExperimentOptionsInput other = (UpdateExperimentTemplateExperimentOptionsInput) obj;
        return Objects.equals(emptyTargetResolutionModeAsString(), other.emptyTargetResolutionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExperimentTemplateExperimentOptionsInput")
                .add("EmptyTargetResolutionMode", emptyTargetResolutionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "emptyTargetResolutionMode":
            return Optional.ofNullable(clazz.cast(emptyTargetResolutionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("emptyTargetResolutionMode", EMPTY_TARGET_RESOLUTION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExperimentTemplateExperimentOptionsInput, T> g) {
        return obj -> g.apply((UpdateExperimentTemplateExperimentOptionsInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateExperimentTemplateExperimentOptionsInput> {
        /**
         * <p>
         * The empty target resolution mode of the experiment template.
         * </p>
         * 
         * @param emptyTargetResolutionMode
         *        The empty target resolution mode of the experiment template.
         * @see EmptyTargetResolutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmptyTargetResolutionMode
         */
        Builder emptyTargetResolutionMode(String emptyTargetResolutionMode);

        /**
         * <p>
         * The empty target resolution mode of the experiment template.
         * </p>
         * 
         * @param emptyTargetResolutionMode
         *        The empty target resolution mode of the experiment template.
         * @see EmptyTargetResolutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmptyTargetResolutionMode
         */
        Builder emptyTargetResolutionMode(EmptyTargetResolutionMode emptyTargetResolutionMode);
    }

    static final class BuilderImpl implements Builder {
        private String emptyTargetResolutionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExperimentTemplateExperimentOptionsInput model) {
            emptyTargetResolutionMode(model.emptyTargetResolutionMode);
        }

        public final String getEmptyTargetResolutionMode() {
            return emptyTargetResolutionMode;
        }

        public final void setEmptyTargetResolutionMode(String emptyTargetResolutionMode) {
            this.emptyTargetResolutionMode = emptyTargetResolutionMode;
        }

        @Override
        public final Builder emptyTargetResolutionMode(String emptyTargetResolutionMode) {
            this.emptyTargetResolutionMode = emptyTargetResolutionMode;
            return this;
        }

        @Override
        public final Builder emptyTargetResolutionMode(EmptyTargetResolutionMode emptyTargetResolutionMode) {
            this.emptyTargetResolutionMode(emptyTargetResolutionMode == null ? null : emptyTargetResolutionMode.toString());
            return this;
        }

        @Override
        public UpdateExperimentTemplateExperimentOptionsInput build() {
            return new UpdateExperimentTemplateExperimentOptionsInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
