/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComplianceDetailResponse extends FmsResponse implements
        ToCopyableBuilder<GetComplianceDetailResponse.Builder, GetComplianceDetailResponse> {
    private static final SdkField<PolicyComplianceDetail> POLICY_COMPLIANCE_DETAIL_FIELD = SdkField
            .<PolicyComplianceDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetComplianceDetailResponse::policyComplianceDetail)).setter(setter(Builder::policyComplianceDetail))
            .constructor(PolicyComplianceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyComplianceDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(POLICY_COMPLIANCE_DETAIL_FIELD));

    private final PolicyComplianceDetail policyComplianceDetail;

    private GetComplianceDetailResponse(BuilderImpl builder) {
        super(builder);
        this.policyComplianceDetail = builder.policyComplianceDetail;
    }

    /**
     * <p>
     * Information about the resources and the policy that you specified in the <code>GetComplianceDetail</code>
     * request.
     * </p>
     * 
     * @return Information about the resources and the policy that you specified in the <code>GetComplianceDetail</code>
     *         request.
     */
    public PolicyComplianceDetail policyComplianceDetail() {
        return policyComplianceDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyComplianceDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailResponse)) {
            return false;
        }
        GetComplianceDetailResponse other = (GetComplianceDetailResponse) obj;
        return Objects.equals(policyComplianceDetail(), other.policyComplianceDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetComplianceDetailResponse").add("PolicyComplianceDetail", policyComplianceDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyComplianceDetail":
            return Optional.ofNullable(clazz.cast(policyComplianceDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceDetailResponse, T> g) {
        return obj -> g.apply((GetComplianceDetailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetComplianceDetailResponse> {
        /**
         * <p>
         * Information about the resources and the policy that you specified in the <code>GetComplianceDetail</code>
         * request.
         * </p>
         * 
         * @param policyComplianceDetail
         *        Information about the resources and the policy that you specified in the
         *        <code>GetComplianceDetail</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyComplianceDetail(PolicyComplianceDetail policyComplianceDetail);

        /**
         * <p>
         * Information about the resources and the policy that you specified in the <code>GetComplianceDetail</code>
         * request.
         * </p>
         * This is a convenience that creates an instance of the {@link PolicyComplianceDetail.Builder} avoiding the
         * need to create one manually via {@link PolicyComplianceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyComplianceDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #policyComplianceDetail(PolicyComplianceDetail)}.
         * 
         * @param policyComplianceDetail
         *        a consumer that will call methods on {@link PolicyComplianceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyComplianceDetail(PolicyComplianceDetail)
         */
        default Builder policyComplianceDetail(Consumer<PolicyComplianceDetail.Builder> policyComplianceDetail) {
            return policyComplianceDetail(PolicyComplianceDetail.builder().applyMutation(policyComplianceDetail).build());
        }
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private PolicyComplianceDetail policyComplianceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailResponse model) {
            super(model);
            policyComplianceDetail(model.policyComplianceDetail);
        }

        public final PolicyComplianceDetail.Builder getPolicyComplianceDetail() {
            return policyComplianceDetail != null ? policyComplianceDetail.toBuilder() : null;
        }

        @Override
        public final Builder policyComplianceDetail(PolicyComplianceDetail policyComplianceDetail) {
            this.policyComplianceDetail = policyComplianceDetail;
            return this;
        }

        public final void setPolicyComplianceDetail(PolicyComplianceDetail.BuilderImpl policyComplianceDetail) {
            this.policyComplianceDetail = policyComplianceDetail != null ? policyComplianceDetail.build() : null;
        }

        @Override
        public GetComplianceDetailResponse build() {
            return new GetComplianceDetailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
