/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AppsListData;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAppsListResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, GetAppsListResponse> {
    private static final SdkField<AppsListData> APPS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetAppsListResponse.getter(GetAppsListResponse::appsList)).setter(GetAppsListResponse.setter(Builder::appsList)).constructor(AppsListData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsList").build()}).build();
    private static final SdkField<String> APPS_LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAppsListResponse.getter(GetAppsListResponse::appsListArn)).setter(GetAppsListResponse.setter(Builder::appsListArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsListArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_LIST_FIELD, APPS_LIST_ARN_FIELD));
    private final AppsListData appsList;
    private final String appsListArn;

    private GetAppsListResponse(BuilderImpl builder) {
        super(builder);
        this.appsList = builder.appsList;
        this.appsListArn = builder.appsListArn;
    }

    public AppsListData appsList() {
        return this.appsList;
    }

    public String appsListArn() {
        return this.appsListArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.appsListArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppsListResponse)) {
            return false;
        }
        GetAppsListResponse other = (GetAppsListResponse)((Object)obj);
        return Objects.equals(this.appsList(), other.appsList()) && Objects.equals(this.appsListArn(), other.appsListArn());
    }

    public String toString() {
        return ToString.builder((String)"GetAppsListResponse").add("AppsList", (Object)this.appsList()).add("AppsListArn", (Object)this.appsListArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppsList": {
                return Optional.ofNullable(clazz.cast(this.appsList()));
            }
            case "AppsListArn": {
                return Optional.ofNullable(clazz.cast(this.appsListArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppsListResponse, T> g) {
        return obj -> g.apply((GetAppsListResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private AppsListData appsList;
        private String appsListArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppsListResponse model) {
            super(model);
            this.appsList(model.appsList);
            this.appsListArn(model.appsListArn);
        }

        public final AppsListData.Builder getAppsList() {
            return this.appsList != null ? this.appsList.toBuilder() : null;
        }

        @Override
        public final Builder appsList(AppsListData appsList) {
            this.appsList = appsList;
            return this;
        }

        public final void setAppsList(AppsListData.BuilderImpl appsList) {
            this.appsList = appsList != null ? appsList.build() : null;
        }

        public final String getAppsListArn() {
            return this.appsListArn;
        }

        @Override
        public final Builder appsListArn(String appsListArn) {
            this.appsListArn = appsListArn;
            return this;
        }

        public final void setAppsListArn(String appsListArn) {
            this.appsListArn = appsListArn;
        }

        @Override
        public GetAppsListResponse build() {
            return new GetAppsListResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAppsListResponse> {
        public Builder appsList(AppsListData var1);

        default public Builder appsList(Consumer<AppsListData.Builder> appsList) {
            return this.appsList((AppsListData)((AppsListData.Builder)AppsListData.builder().applyMutation(appsList)).build());
        }

        public Builder appsListArn(String var1);
    }
}

