/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProtocolsListRequest extends FmsRequest implements
        ToCopyableBuilder<GetProtocolsListRequest.Builder, GetProtocolsListRequest> {
    private static final SdkField<String> LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetProtocolsListRequest::listId)).setter(setter(Builder::listId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()).build();

    private static final SdkField<Boolean> DEFAULT_LIST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetProtocolsListRequest::defaultList)).setter(setter(Builder::defaultList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ID_FIELD,
            DEFAULT_LIST_FIELD));

    private final String listId;

    private final Boolean defaultList;

    private GetProtocolsListRequest(BuilderImpl builder) {
        super(builder);
        this.listId = builder.listId;
        this.defaultList = builder.defaultList;
    }

    /**
     * <p>
     * The ID of the AWS Firewall Manager protocols list that you want the details for.
     * </p>
     * 
     * @return The ID of the AWS Firewall Manager protocols list that you want the details for.
     */
    public String listId() {
        return listId;
    }

    /**
     * <p>
     * Specifies whether the list to retrieve is a default list owned by AWS Firewall Manager.
     * </p>
     * 
     * @return Specifies whether the list to retrieve is a default list owned by AWS Firewall Manager.
     */
    public Boolean defaultList() {
        return defaultList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProtocolsListRequest)) {
            return false;
        }
        GetProtocolsListRequest other = (GetProtocolsListRequest) obj;
        return Objects.equals(listId(), other.listId()) && Objects.equals(defaultList(), other.defaultList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetProtocolsListRequest").add("ListId", listId()).add("DefaultList", defaultList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListId":
            return Optional.ofNullable(clazz.cast(listId()));
        case "DefaultList":
            return Optional.ofNullable(clazz.cast(defaultList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProtocolsListRequest, T> g) {
        return obj -> g.apply((GetProtocolsListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetProtocolsListRequest> {
        /**
         * <p>
         * The ID of the AWS Firewall Manager protocols list that you want the details for.
         * </p>
         * 
         * @param listId
         *        The ID of the AWS Firewall Manager protocols list that you want the details for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listId(String listId);

        /**
         * <p>
         * Specifies whether the list to retrieve is a default list owned by AWS Firewall Manager.
         * </p>
         * 
         * @param defaultList
         *        Specifies whether the list to retrieve is a default list owned by AWS Firewall Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultList(Boolean defaultList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String listId;

        private Boolean defaultList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProtocolsListRequest model) {
            super(model);
            listId(model.listId);
            defaultList(model.defaultList);
        }

        public final String getListId() {
            return listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        public final Boolean getDefaultList() {
            return defaultList;
        }

        @Override
        public final Builder defaultList(Boolean defaultList) {
            this.defaultList = defaultList;
            return this;
        }

        public final void setDefaultList(Boolean defaultList) {
            this.defaultList = defaultList;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProtocolsListRequest build() {
            return new GetProtocolsListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
