/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PartialMatchesCopier {
    static List<PartialMatch> copy(Collection<PartialMatch> partialMatchesParam) {
        if (partialMatchesParam == null || partialMatchesParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<PartialMatch> partialMatchesParamCopy = new ArrayList<>(partialMatchesParam);
        return Collections.unmodifiableList(partialMatchesParamCopy);
    }

    static List<PartialMatch> copyFromBuilder(Collection<? extends PartialMatch.Builder> partialMatchesParam) {
        if (partialMatchesParam == null) {
            return null;
        }
        return copy(partialMatchesParam.stream().map(PartialMatch.Builder::build).collect(toList()));
    }
}
