/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violations for an EC2 instance resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2InstanceViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2InstanceViolation.Builder, AwsEc2InstanceViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(AwsEc2InstanceViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<List<AwsEc2NetworkInterfaceViolation>> AWS_EC2_NETWORK_INTERFACE_VIOLATIONS_FIELD = SdkField
            .<List<AwsEc2NetworkInterfaceViolation>> builder(MarshallingType.LIST)
            .memberName("AwsEc2NetworkInterfaceViolations")
            .getter(getter(AwsEc2InstanceViolation::awsEc2NetworkInterfaceViolations))
            .setter(setter(Builder::awsEc2NetworkInterfaceViolations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterfaceViolations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2NetworkInterfaceViolation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2NetworkInterfaceViolation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            AWS_EC2_NETWORK_INTERFACE_VIOLATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final List<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations;

    private AwsEc2InstanceViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.awsEc2NetworkInterfaceViolations = builder.awsEc2NetworkInterfaceViolations;
    }

    /**
     * <p>
     * The resource ID of the EC2 instance.
     * </p>
     * 
     * @return The resource ID of the EC2 instance.
     */
    public String violationTarget() {
        return violationTarget;
    }

    /**
     * Returns true if the AwsEc2NetworkInterfaceViolations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasAwsEc2NetworkInterfaceViolations() {
        return awsEc2NetworkInterfaceViolations != null && !(awsEc2NetworkInterfaceViolations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Violations for network interfaces associated with the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAwsEc2NetworkInterfaceViolations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Violations for network interfaces associated with the EC2 instance.
     */
    public List<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations() {
        return awsEc2NetworkInterfaceViolations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2NetworkInterfaceViolations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2InstanceViolation)) {
            return false;
        }
        AwsEc2InstanceViolation other = (AwsEc2InstanceViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget())
                && Objects.equals(awsEc2NetworkInterfaceViolations(), other.awsEc2NetworkInterfaceViolations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsEc2InstanceViolation").add("ViolationTarget", violationTarget())
                .add("AwsEc2NetworkInterfaceViolations", awsEc2NetworkInterfaceViolations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "AwsEc2NetworkInterfaceViolations":
            return Optional.ofNullable(clazz.cast(awsEc2NetworkInterfaceViolations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2InstanceViolation, T> g) {
        return obj -> g.apply((AwsEc2InstanceViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2InstanceViolation> {
        /**
         * <p>
         * The resource ID of the EC2 instance.
         * </p>
         * 
         * @param violationTarget
         *        The resource ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * Violations for network interfaces associated with the EC2 instance.
         * </p>
         * 
         * @param awsEc2NetworkInterfaceViolations
         *        Violations for network interfaces associated with the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2NetworkInterfaceViolations(Collection<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations);

        /**
         * <p>
         * Violations for network interfaces associated with the EC2 instance.
         * </p>
         * 
         * @param awsEc2NetworkInterfaceViolations
         *        Violations for network interfaces associated with the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2NetworkInterfaceViolations(AwsEc2NetworkInterfaceViolation... awsEc2NetworkInterfaceViolations);

        /**
         * <p>
         * Violations for network interfaces associated with the EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2NetworkInterfaceViolation>.Builder}
         * avoiding the need to create one manually via {@link List<AwsEc2NetworkInterfaceViolation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2NetworkInterfaceViolation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #awsEc2NetworkInterfaceViolations(List<AwsEc2NetworkInterfaceViolation>)}.
         * 
         * @param awsEc2NetworkInterfaceViolations
         *        a consumer that will call methods on {@link List<AwsEc2NetworkInterfaceViolation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2NetworkInterfaceViolations(List<AwsEc2NetworkInterfaceViolation>)
         */
        Builder awsEc2NetworkInterfaceViolations(
                Consumer<AwsEc2NetworkInterfaceViolation.Builder>... awsEc2NetworkInterfaceViolations);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private List<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2InstanceViolation model) {
            violationTarget(model.violationTarget);
            awsEc2NetworkInterfaceViolations(model.awsEc2NetworkInterfaceViolations);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        public final Collection<AwsEc2NetworkInterfaceViolation.Builder> getAwsEc2NetworkInterfaceViolations() {
            return awsEc2NetworkInterfaceViolations != null ? awsEc2NetworkInterfaceViolations.stream()
                    .map(AwsEc2NetworkInterfaceViolation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder awsEc2NetworkInterfaceViolations(
                Collection<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations) {
            this.awsEc2NetworkInterfaceViolations = AwsEc2NetworkInterfaceViolationsCopier.copy(awsEc2NetworkInterfaceViolations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsEc2NetworkInterfaceViolations(AwsEc2NetworkInterfaceViolation... awsEc2NetworkInterfaceViolations) {
            awsEc2NetworkInterfaceViolations(Arrays.asList(awsEc2NetworkInterfaceViolations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsEc2NetworkInterfaceViolations(
                Consumer<AwsEc2NetworkInterfaceViolation.Builder>... awsEc2NetworkInterfaceViolations) {
            awsEc2NetworkInterfaceViolations(Stream.of(awsEc2NetworkInterfaceViolations)
                    .map(c -> AwsEc2NetworkInterfaceViolation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAwsEc2NetworkInterfaceViolations(
                Collection<AwsEc2NetworkInterfaceViolation.BuilderImpl> awsEc2NetworkInterfaceViolations) {
            this.awsEc2NetworkInterfaceViolations = AwsEc2NetworkInterfaceViolationsCopier
                    .copyFromBuilder(awsEc2NetworkInterfaceViolations);
        }

        @Override
        public AwsEc2InstanceViolation build() {
            return new AwsEc2InstanceViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
