/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violations for network interfaces associated with an EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2NetworkInterfaceViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2NetworkInterfaceViolation.Builder, AwsEc2NetworkInterfaceViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(AwsEc2NetworkInterfaceViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<List<String>> VIOLATING_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ViolatingSecurityGroups")
            .getter(getter(AwsEc2NetworkInterfaceViolation::violatingSecurityGroups))
            .setter(setter(Builder::violatingSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            VIOLATING_SECURITY_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final List<String> violatingSecurityGroups;

    private AwsEc2NetworkInterfaceViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.violatingSecurityGroups = builder.violatingSecurityGroups;
    }

    /**
     * <p>
     * The resource ID of the network interface.
     * </p>
     * 
     * @return The resource ID of the network interface.
     */
    public String violationTarget() {
        return violationTarget;
    }

    /**
     * Returns true if the ViolatingSecurityGroups property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasViolatingSecurityGroups() {
        return violatingSecurityGroups != null && !(violatingSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of security groups that violate the rules specified in the master security group of the AWS Firewall Manager
     * policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasViolatingSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of security groups that violate the rules specified in the master security group of the AWS Firewall
     *         Manager policy.
     */
    public List<String> violatingSecurityGroups() {
        return violatingSecurityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(violatingSecurityGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceViolation)) {
            return false;
        }
        AwsEc2NetworkInterfaceViolation other = (AwsEc2NetworkInterfaceViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget())
                && Objects.equals(violatingSecurityGroups(), other.violatingSecurityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsEc2NetworkInterfaceViolation").add("ViolationTarget", violationTarget())
                .add("ViolatingSecurityGroups", violatingSecurityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "ViolatingSecurityGroups":
            return Optional.ofNullable(clazz.cast(violatingSecurityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceViolation, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2NetworkInterfaceViolation> {
        /**
         * <p>
         * The resource ID of the network interface.
         * </p>
         * 
         * @param violationTarget
         *        The resource ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * List of security groups that violate the rules specified in the master security group of the AWS Firewall
         * Manager policy.
         * </p>
         * 
         * @param violatingSecurityGroups
         *        List of security groups that violate the rules specified in the master security group of the AWS
         *        Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingSecurityGroups(Collection<String> violatingSecurityGroups);

        /**
         * <p>
         * List of security groups that violate the rules specified in the master security group of the AWS Firewall
         * Manager policy.
         * </p>
         * 
         * @param violatingSecurityGroups
         *        List of security groups that violate the rules specified in the master security group of the AWS
         *        Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingSecurityGroups(String... violatingSecurityGroups);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private List<String> violatingSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceViolation model) {
            violationTarget(model.violationTarget);
            violatingSecurityGroups(model.violatingSecurityGroups);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        public final Collection<String> getViolatingSecurityGroups() {
            return violatingSecurityGroups;
        }

        @Override
        public final Builder violatingSecurityGroups(Collection<String> violatingSecurityGroups) {
            this.violatingSecurityGroups = ResourceIdListCopier.copy(violatingSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingSecurityGroups(String... violatingSecurityGroups) {
            violatingSecurityGroups(Arrays.asList(violatingSecurityGroups));
            return this;
        }

        public final void setViolatingSecurityGroups(Collection<String> violatingSecurityGroups) {
            this.violatingSecurityGroups = ResourceIdListCopier.copy(violatingSecurityGroups);
        }

        @Override
        public AwsEc2NetworkInterfaceViolation build() {
            return new AwsEc2NetworkInterfaceViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
