/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An AWS Firewall Manager protocols list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtocolsListData implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtocolsListData.Builder, ProtocolsListData> {
    private static final SdkField<String> LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ListId")
            .getter(getter(ProtocolsListData::listId)).setter(setter(Builder::listId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()).build();

    private static final SdkField<String> LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListName").getter(getter(ProtocolsListData::listName)).setter(setter(Builder::listName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()).build();

    private static final SdkField<String> LIST_UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListUpdateToken").getter(getter(ProtocolsListData::listUpdateToken))
            .setter(setter(Builder::listUpdateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListUpdateToken").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(ProtocolsListData::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(ProtocolsListData::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<List<String>> PROTOCOLS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProtocolsList")
            .getter(getter(ProtocolsListData::protocolsList))
            .setter(setter(Builder::protocolsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> PREVIOUS_PROTOCOLS_LIST_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("PreviousProtocolsList")
            .getter(getter(ProtocolsListData::previousProtocolsList))
            .setter(setter(Builder::previousProtocolsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousProtocolsList").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ID_FIELD,
            LIST_NAME_FIELD, LIST_UPDATE_TOKEN_FIELD, CREATE_TIME_FIELD, LAST_UPDATE_TIME_FIELD, PROTOCOLS_LIST_FIELD,
            PREVIOUS_PROTOCOLS_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String listId;

    private final String listName;

    private final String listUpdateToken;

    private final Instant createTime;

    private final Instant lastUpdateTime;

    private final List<String> protocolsList;

    private final Map<String, List<String>> previousProtocolsList;

    private ProtocolsListData(BuilderImpl builder) {
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.listUpdateToken = builder.listUpdateToken;
        this.createTime = builder.createTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.protocolsList = builder.protocolsList;
        this.previousProtocolsList = builder.previousProtocolsList;
    }

    /**
     * <p>
     * The ID of the AWS Firewall Manager protocols list.
     * </p>
     * 
     * @return The ID of the AWS Firewall Manager protocols list.
     */
    public String listId() {
        return listId;
    }

    /**
     * <p>
     * The name of the AWS Firewall Manager protocols list.
     * </p>
     * 
     * @return The name of the AWS Firewall Manager protocols list.
     */
    public String listName() {
        return listName;
    }

    /**
     * <p>
     * A unique identifier for each update to the list. When you update the list, the update token must match the token
     * of the current version of the application list. You can retrieve the update token by getting the list.
     * </p>
     * 
     * @return A unique identifier for each update to the list. When you update the list, the update token must match
     *         the token of the current version of the application list. You can retrieve the update token by getting
     *         the list.
     */
    public String listUpdateToken() {
        return listUpdateToken;
    }

    /**
     * <p>
     * The time that the AWS Firewall Manager protocols list was created.
     * </p>
     * 
     * @return The time that the AWS Firewall Manager protocols list was created.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time that the AWS Firewall Manager protocols list was last updated.
     * </p>
     * 
     * @return The time that the AWS Firewall Manager protocols list was last updated.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * Returns true if the ProtocolsList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProtocolsList() {
        return protocolsList != null && !(protocolsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of protocols in the AWS Firewall Manager protocols list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProtocolsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of protocols in the AWS Firewall Manager protocols list.
     */
    public List<String> protocolsList() {
        return protocolsList;
    }

    /**
     * Returns true if the PreviousProtocolsList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPreviousProtocolsList() {
        return previousProtocolsList != null && !(previousProtocolsList instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of previous version numbers to their corresponding protocol arrays.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPreviousProtocolsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of previous version numbers to their corresponding protocol arrays.
     */
    public Map<String, List<String>> previousProtocolsList() {
        return previousProtocolsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listId());
        hashCode = 31 * hashCode + Objects.hashCode(listName());
        hashCode = 31 * hashCode + Objects.hashCode(listUpdateToken());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(protocolsList());
        hashCode = 31 * hashCode + Objects.hashCode(previousProtocolsList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolsListData)) {
            return false;
        }
        ProtocolsListData other = (ProtocolsListData) obj;
        return Objects.equals(listId(), other.listId()) && Objects.equals(listName(), other.listName())
                && Objects.equals(listUpdateToken(), other.listUpdateToken()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(protocolsList(), other.protocolsList())
                && Objects.equals(previousProtocolsList(), other.previousProtocolsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProtocolsListData").add("ListId", listId()).add("ListName", listName())
                .add("ListUpdateToken", listUpdateToken()).add("CreateTime", createTime())
                .add("LastUpdateTime", lastUpdateTime()).add("ProtocolsList", protocolsList())
                .add("PreviousProtocolsList", previousProtocolsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListId":
            return Optional.ofNullable(clazz.cast(listId()));
        case "ListName":
            return Optional.ofNullable(clazz.cast(listName()));
        case "ListUpdateToken":
            return Optional.ofNullable(clazz.cast(listUpdateToken()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "ProtocolsList":
            return Optional.ofNullable(clazz.cast(protocolsList()));
        case "PreviousProtocolsList":
            return Optional.ofNullable(clazz.cast(previousProtocolsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtocolsListData, T> g) {
        return obj -> g.apply((ProtocolsListData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtocolsListData> {
        /**
         * <p>
         * The ID of the AWS Firewall Manager protocols list.
         * </p>
         * 
         * @param listId
         *        The ID of the AWS Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listId(String listId);

        /**
         * <p>
         * The name of the AWS Firewall Manager protocols list.
         * </p>
         * 
         * @param listName
         *        The name of the AWS Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listName(String listName);

        /**
         * <p>
         * A unique identifier for each update to the list. When you update the list, the update token must match the
         * token of the current version of the application list. You can retrieve the update token by getting the list.
         * </p>
         * 
         * @param listUpdateToken
         *        A unique identifier for each update to the list. When you update the list, the update token must match
         *        the token of the current version of the application list. You can retrieve the update token by getting
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listUpdateToken(String listUpdateToken);

        /**
         * <p>
         * The time that the AWS Firewall Manager protocols list was created.
         * </p>
         * 
         * @param createTime
         *        The time that the AWS Firewall Manager protocols list was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time that the AWS Firewall Manager protocols list was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time that the AWS Firewall Manager protocols list was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * An array of protocols in the AWS Firewall Manager protocols list.
         * </p>
         * 
         * @param protocolsList
         *        An array of protocols in the AWS Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsList(Collection<String> protocolsList);

        /**
         * <p>
         * An array of protocols in the AWS Firewall Manager protocols list.
         * </p>
         * 
         * @param protocolsList
         *        An array of protocols in the AWS Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsList(String... protocolsList);

        /**
         * <p>
         * A map of previous version numbers to their corresponding protocol arrays.
         * </p>
         * 
         * @param previousProtocolsList
         *        A map of previous version numbers to their corresponding protocol arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousProtocolsList(Map<String, ? extends Collection<String>> previousProtocolsList);
    }

    static final class BuilderImpl implements Builder {
        private String listId;

        private String listName;

        private String listUpdateToken;

        private Instant createTime;

        private Instant lastUpdateTime;

        private List<String> protocolsList = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> previousProtocolsList = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolsListData model) {
            listId(model.listId);
            listName(model.listName);
            listUpdateToken(model.listUpdateToken);
            createTime(model.createTime);
            lastUpdateTime(model.lastUpdateTime);
            protocolsList(model.protocolsList);
            previousProtocolsList(model.previousProtocolsList);
        }

        public final String getListId() {
            return listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        public final String getListName() {
            return listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        public final String getListUpdateToken() {
            return listUpdateToken;
        }

        @Override
        public final Builder listUpdateToken(String listUpdateToken) {
            this.listUpdateToken = listUpdateToken;
            return this;
        }

        public final void setListUpdateToken(String listUpdateToken) {
            this.listUpdateToken = listUpdateToken;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final Collection<String> getProtocolsList() {
            return protocolsList;
        }

        @Override
        public final Builder protocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsList(String... protocolsList) {
            protocolsList(Arrays.asList(protocolsList));
            return this;
        }

        public final void setProtocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
        }

        public final Map<String, ? extends Collection<String>> getPreviousProtocolsList() {
            return previousProtocolsList;
        }

        @Override
        public final Builder previousProtocolsList(Map<String, ? extends Collection<String>> previousProtocolsList) {
            this.previousProtocolsList = PreviousProtocolsListCopier.copy(previousProtocolsList);
            return this;
        }

        public final void setPreviousProtocolsList(Map<String, ? extends Collection<String>> previousProtocolsList) {
            this.previousProtocolsList = PreviousProtocolsListCopier.copy(previousProtocolsList);
        }

        @Override
        public ProtocolsListData build() {
            return new ProtocolsListData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
