/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the AWS Firewall Manager protocols list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtocolsListDataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtocolsListDataSummary.Builder, ProtocolsListDataSummary> {
    private static final SdkField<String> LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListArn").getter(getter(ProtocolsListDataSummary::listArn)).setter(setter(Builder::listArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListArn").build()).build();

    private static final SdkField<String> LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ListId")
            .getter(getter(ProtocolsListDataSummary::listId)).setter(setter(Builder::listId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()).build();

    private static final SdkField<String> LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListName").getter(getter(ProtocolsListDataSummary::listName)).setter(setter(Builder::listName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()).build();

    private static final SdkField<List<String>> PROTOCOLS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProtocolsList")
            .getter(getter(ProtocolsListDataSummary::protocolsList))
            .setter(setter(Builder::protocolsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ARN_FIELD, LIST_ID_FIELD,
            LIST_NAME_FIELD, PROTOCOLS_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String listArn;

    private final String listId;

    private final String listName;

    private final List<String> protocolsList;

    private ProtocolsListDataSummary(BuilderImpl builder) {
        this.listArn = builder.listArn;
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.protocolsList = builder.protocolsList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified protocols list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified protocols list.
     */
    public String listArn() {
        return listArn;
    }

    /**
     * <p>
     * The ID of the specified protocols list.
     * </p>
     * 
     * @return The ID of the specified protocols list.
     */
    public String listId() {
        return listId;
    }

    /**
     * <p>
     * The name of the specified protocols list.
     * </p>
     * 
     * @return The name of the specified protocols list.
     */
    public String listName() {
        return listName;
    }

    /**
     * Returns true if the ProtocolsList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProtocolsList() {
        return protocolsList != null && !(protocolsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of protocols in the AWS Firewall Manager protocols list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProtocolsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of protocols in the AWS Firewall Manager protocols list.
     */
    public List<String> protocolsList() {
        return protocolsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listArn());
        hashCode = 31 * hashCode + Objects.hashCode(listId());
        hashCode = 31 * hashCode + Objects.hashCode(listName());
        hashCode = 31 * hashCode + Objects.hashCode(protocolsList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolsListDataSummary)) {
            return false;
        }
        ProtocolsListDataSummary other = (ProtocolsListDataSummary) obj;
        return Objects.equals(listArn(), other.listArn()) && Objects.equals(listId(), other.listId())
                && Objects.equals(listName(), other.listName()) && Objects.equals(protocolsList(), other.protocolsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProtocolsListDataSummary").add("ListArn", listArn()).add("ListId", listId())
                .add("ListName", listName()).add("ProtocolsList", protocolsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListArn":
            return Optional.ofNullable(clazz.cast(listArn()));
        case "ListId":
            return Optional.ofNullable(clazz.cast(listId()));
        case "ListName":
            return Optional.ofNullable(clazz.cast(listName()));
        case "ProtocolsList":
            return Optional.ofNullable(clazz.cast(protocolsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtocolsListDataSummary, T> g) {
        return obj -> g.apply((ProtocolsListDataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtocolsListDataSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified protocols list.
         * </p>
         * 
         * @param listArn
         *        The Amazon Resource Name (ARN) of the specified protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listArn(String listArn);

        /**
         * <p>
         * The ID of the specified protocols list.
         * </p>
         * 
         * @param listId
         *        The ID of the specified protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listId(String listId);

        /**
         * <p>
         * The name of the specified protocols list.
         * </p>
         * 
         * @param listName
         *        The name of the specified protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listName(String listName);

        /**
         * <p>
         * An array of protocols in the AWS Firewall Manager protocols list.
         * </p>
         * 
         * @param protocolsList
         *        An array of protocols in the AWS Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsList(Collection<String> protocolsList);

        /**
         * <p>
         * An array of protocols in the AWS Firewall Manager protocols list.
         * </p>
         * 
         * @param protocolsList
         *        An array of protocols in the AWS Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsList(String... protocolsList);
    }

    static final class BuilderImpl implements Builder {
        private String listArn;

        private String listId;

        private String listName;

        private List<String> protocolsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolsListDataSummary model) {
            listArn(model.listArn);
            listId(model.listId);
            listName(model.listName);
            protocolsList(model.protocolsList);
        }

        public final String getListArn() {
            return listArn;
        }

        @Override
        public final Builder listArn(String listArn) {
            this.listArn = listArn;
            return this;
        }

        public final void setListArn(String listArn) {
            this.listArn = listArn;
        }

        public final String getListId() {
            return listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        public final String getListName() {
            return listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        public final Collection<String> getProtocolsList() {
            return protocolsList;
        }

        @Override
        public final Builder protocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsList(String... protocolsList) {
            protocolsList(Arrays.asList(protocolsList));
            return this;
        }

        public final void setProtocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
        }

        @Override
        public ProtocolsListDataSummary build() {
            return new ProtocolsListDataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
