/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProtocolsListResponse extends FmsResponse implements
        ToCopyableBuilder<PutProtocolsListResponse.Builder, PutProtocolsListResponse> {
    private static final SdkField<ProtocolsListData> PROTOCOLS_LIST_FIELD = SdkField
            .<ProtocolsListData> builder(MarshallingType.SDK_POJO).memberName("ProtocolsList")
            .getter(getter(PutProtocolsListResponse::protocolsList)).setter(setter(Builder::protocolsList))
            .constructor(ProtocolsListData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolsList").build()).build();

    private static final SdkField<String> PROTOCOLS_LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtocolsListArn").getter(getter(PutProtocolsListResponse::protocolsListArn))
            .setter(setter(Builder::protocolsListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolsListArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOLS_LIST_FIELD,
            PROTOCOLS_LIST_ARN_FIELD));

    private final ProtocolsListData protocolsList;

    private final String protocolsListArn;

    private PutProtocolsListResponse(BuilderImpl builder) {
        super(builder);
        this.protocolsList = builder.protocolsList;
        this.protocolsListArn = builder.protocolsListArn;
    }

    /**
     * <p>
     * The details of the AWS Firewall Manager protocols list.
     * </p>
     * 
     * @return The details of the AWS Firewall Manager protocols list.
     */
    public ProtocolsListData protocolsList() {
        return protocolsList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protocols list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the protocols list.
     */
    public String protocolsListArn() {
        return protocolsListArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protocolsList());
        hashCode = 31 * hashCode + Objects.hashCode(protocolsListArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProtocolsListResponse)) {
            return false;
        }
        PutProtocolsListResponse other = (PutProtocolsListResponse) obj;
        return Objects.equals(protocolsList(), other.protocolsList())
                && Objects.equals(protocolsListArn(), other.protocolsListArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutProtocolsListResponse").add("ProtocolsList", protocolsList())
                .add("ProtocolsListArn", protocolsListArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtocolsList":
            return Optional.ofNullable(clazz.cast(protocolsList()));
        case "ProtocolsListArn":
            return Optional.ofNullable(clazz.cast(protocolsListArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProtocolsListResponse, T> g) {
        return obj -> g.apply((PutProtocolsListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutProtocolsListResponse> {
        /**
         * <p>
         * The details of the AWS Firewall Manager protocols list.
         * </p>
         * 
         * @param protocolsList
         *        The details of the AWS Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsList(ProtocolsListData protocolsList);

        /**
         * <p>
         * The details of the AWS Firewall Manager protocols list.
         * </p>
         * This is a convenience that creates an instance of the {@link ProtocolsListData.Builder} avoiding the need to
         * create one manually via {@link ProtocolsListData#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProtocolsListData.Builder#build()} is called immediately and its
         * result is passed to {@link #protocolsList(ProtocolsListData)}.
         * 
         * @param protocolsList
         *        a consumer that will call methods on {@link ProtocolsListData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolsList(ProtocolsListData)
         */
        default Builder protocolsList(Consumer<ProtocolsListData.Builder> protocolsList) {
            return protocolsList(ProtocolsListData.builder().applyMutation(protocolsList).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the protocols list.
         * </p>
         * 
         * @param protocolsListArn
         *        The Amazon Resource Name (ARN) of the protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsListArn(String protocolsListArn);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private ProtocolsListData protocolsList;

        private String protocolsListArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProtocolsListResponse model) {
            super(model);
            protocolsList(model.protocolsList);
            protocolsListArn(model.protocolsListArn);
        }

        public final ProtocolsListData.Builder getProtocolsList() {
            return protocolsList != null ? protocolsList.toBuilder() : null;
        }

        @Override
        public final Builder protocolsList(ProtocolsListData protocolsList) {
            this.protocolsList = protocolsList;
            return this;
        }

        public final void setProtocolsList(ProtocolsListData.BuilderImpl protocolsList) {
            this.protocolsList = protocolsList != null ? protocolsList.build() : null;
        }

        public final String getProtocolsListArn() {
            return protocolsListArn;
        }

        @Override
        public final Builder protocolsListArn(String protocolsListArn) {
            this.protocolsListArn = protocolsListArn;
            return this;
        }

        public final void setProtocolsListArn(String protocolsListArn) {
            this.protocolsListArn = protocolsListArn;
        }

        @Override
        public PutProtocolsListResponse build() {
            return new PutProtocolsListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
