/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail based on resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceViolation.Builder, ResourceViolation> {
    private static final SdkField<AwsVPCSecurityGroupViolation> AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD = SdkField
            .<AwsVPCSecurityGroupViolation> builder(MarshallingType.SDK_POJO)
            .memberName("AwsVPCSecurityGroupViolation")
            .getter(getter(ResourceViolation::awsVPCSecurityGroupViolation))
            .setter(setter(Builder::awsVPCSecurityGroupViolation))
            .constructor(AwsVPCSecurityGroupViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsVPCSecurityGroupViolation")
                    .build()).build();

    private static final SdkField<AwsEc2NetworkInterfaceViolation> AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD = SdkField
            .<AwsEc2NetworkInterfaceViolation> builder(MarshallingType.SDK_POJO)
            .memberName("AwsEc2NetworkInterfaceViolation")
            .getter(getter(ResourceViolation::awsEc2NetworkInterfaceViolation))
            .setter(setter(Builder::awsEc2NetworkInterfaceViolation))
            .constructor(AwsEc2NetworkInterfaceViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterfaceViolation")
                    .build()).build();

    private static final SdkField<AwsEc2InstanceViolation> AWS_EC2_INSTANCE_VIOLATION_FIELD = SdkField
            .<AwsEc2InstanceViolation> builder(MarshallingType.SDK_POJO).memberName("AwsEc2InstanceViolation")
            .getter(getter(ResourceViolation::awsEc2InstanceViolation)).setter(setter(Builder::awsEc2InstanceViolation))
            .constructor(AwsEc2InstanceViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2InstanceViolation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD, AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD, AWS_EC2_INSTANCE_VIOLATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;

    private final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;

    private final AwsEc2InstanceViolation awsEc2InstanceViolation;

    private ResourceViolation(BuilderImpl builder) {
        this.awsVPCSecurityGroupViolation = builder.awsVPCSecurityGroupViolation;
        this.awsEc2NetworkInterfaceViolation = builder.awsEc2NetworkInterfaceViolation;
        this.awsEc2InstanceViolation = builder.awsEc2InstanceViolation;
    }

    /**
     * <p>
     * Violation details for security groups.
     * </p>
     * 
     * @return Violation details for security groups.
     */
    public AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation() {
        return awsVPCSecurityGroupViolation;
    }

    /**
     * <p>
     * Violation details for network interface.
     * </p>
     * 
     * @return Violation details for network interface.
     */
    public AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation() {
        return awsEc2NetworkInterfaceViolation;
    }

    /**
     * <p>
     * Violation details for an EC2 instance.
     * </p>
     * 
     * @return Violation details for an EC2 instance.
     */
    public AwsEc2InstanceViolation awsEc2InstanceViolation() {
        return awsEc2InstanceViolation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsVPCSecurityGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2NetworkInterfaceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2InstanceViolation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceViolation)) {
            return false;
        }
        ResourceViolation other = (ResourceViolation) obj;
        return Objects.equals(awsVPCSecurityGroupViolation(), other.awsVPCSecurityGroupViolation())
                && Objects.equals(awsEc2NetworkInterfaceViolation(), other.awsEc2NetworkInterfaceViolation())
                && Objects.equals(awsEc2InstanceViolation(), other.awsEc2InstanceViolation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceViolation").add("AwsVPCSecurityGroupViolation", awsVPCSecurityGroupViolation())
                .add("AwsEc2NetworkInterfaceViolation", awsEc2NetworkInterfaceViolation())
                .add("AwsEc2InstanceViolation", awsEc2InstanceViolation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsVPCSecurityGroupViolation":
            return Optional.ofNullable(clazz.cast(awsVPCSecurityGroupViolation()));
        case "AwsEc2NetworkInterfaceViolation":
            return Optional.ofNullable(clazz.cast(awsEc2NetworkInterfaceViolation()));
        case "AwsEc2InstanceViolation":
            return Optional.ofNullable(clazz.cast(awsEc2InstanceViolation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceViolation, T> g) {
        return obj -> g.apply((ResourceViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceViolation> {
        /**
         * <p>
         * Violation details for security groups.
         * </p>
         * 
         * @param awsVPCSecurityGroupViolation
         *        Violation details for security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation);

        /**
         * <p>
         * Violation details for security groups.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsVPCSecurityGroupViolation.Builder} avoiding
         * the need to create one manually via {@link AwsVPCSecurityGroupViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsVPCSecurityGroupViolation.Builder#build()} is called
         * immediately and its result is passed to {@link #awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation)}.
         * 
         * @param awsVPCSecurityGroupViolation
         *        a consumer that will call methods on {@link AwsVPCSecurityGroupViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation)
         */
        default Builder awsVPCSecurityGroupViolation(Consumer<AwsVPCSecurityGroupViolation.Builder> awsVPCSecurityGroupViolation) {
            return awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.builder()
                    .applyMutation(awsVPCSecurityGroupViolation).build());
        }

        /**
         * <p>
         * Violation details for network interface.
         * </p>
         * 
         * @param awsEc2NetworkInterfaceViolation
         *        Violation details for network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation);

        /**
         * <p>
         * Violation details for network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2NetworkInterfaceViolation.Builder}
         * avoiding the need to create one manually via {@link AwsEc2NetworkInterfaceViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2NetworkInterfaceViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation)}.
         * 
         * @param awsEc2NetworkInterfaceViolation
         *        a consumer that will call methods on {@link AwsEc2NetworkInterfaceViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation)
         */
        default Builder awsEc2NetworkInterfaceViolation(
                Consumer<AwsEc2NetworkInterfaceViolation.Builder> awsEc2NetworkInterfaceViolation) {
            return awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation.builder()
                    .applyMutation(awsEc2NetworkInterfaceViolation).build());
        }

        /**
         * <p>
         * Violation details for an EC2 instance.
         * </p>
         * 
         * @param awsEc2InstanceViolation
         *        Violation details for an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation);

        /**
         * <p>
         * Violation details for an EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2InstanceViolation.Builder} avoiding the
         * need to create one manually via {@link AwsEc2InstanceViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2InstanceViolation.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEc2InstanceViolation(AwsEc2InstanceViolation)}.
         * 
         * @param awsEc2InstanceViolation
         *        a consumer that will call methods on {@link AwsEc2InstanceViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2InstanceViolation(AwsEc2InstanceViolation)
         */
        default Builder awsEc2InstanceViolation(Consumer<AwsEc2InstanceViolation.Builder> awsEc2InstanceViolation) {
            return awsEc2InstanceViolation(AwsEc2InstanceViolation.builder().applyMutation(awsEc2InstanceViolation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;

        private AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;

        private AwsEc2InstanceViolation awsEc2InstanceViolation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceViolation model) {
            awsVPCSecurityGroupViolation(model.awsVPCSecurityGroupViolation);
            awsEc2NetworkInterfaceViolation(model.awsEc2NetworkInterfaceViolation);
            awsEc2InstanceViolation(model.awsEc2InstanceViolation);
        }

        public final AwsVPCSecurityGroupViolation.Builder getAwsVPCSecurityGroupViolation() {
            return awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation;
            return this;
        }

        public final void setAwsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.BuilderImpl awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.build()
                    : null;
        }

        public final AwsEc2NetworkInterfaceViolation.Builder getAwsEc2NetworkInterfaceViolation() {
            return awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation;
            return this;
        }

        public final void setAwsEc2NetworkInterfaceViolation(
                AwsEc2NetworkInterfaceViolation.BuilderImpl awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation
                    .build() : null;
        }

        public final AwsEc2InstanceViolation.Builder getAwsEc2InstanceViolation() {
            return awsEc2InstanceViolation != null ? awsEc2InstanceViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation;
            return this;
        }

        public final void setAwsEc2InstanceViolation(AwsEc2InstanceViolation.BuilderImpl awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation != null ? awsEc2InstanceViolation.build() : null;
        }

        @Override
        public ResourceViolation build() {
            return new ResourceViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
