/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a set of permissions for a security group rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroupRuleDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityGroupRuleDescription.Builder, SecurityGroupRuleDescription> {
    private static final SdkField<String> IPV4_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPV4Range").getter(getter(SecurityGroupRuleDescription::ipv4Range)).setter(setter(Builder::ipv4Range))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPV4Range").build()).build();

    private static final SdkField<String> IPV6_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPV6Range").getter(getter(SecurityGroupRuleDescription::ipv6Range)).setter(setter(Builder::ipv6Range))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPV6Range").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId").getter(getter(SecurityGroupRuleDescription::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(SecurityGroupRuleDescription::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Long> FROM_PORT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("FromPort")
            .getter(getter(SecurityGroupRuleDescription::fromPort)).setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").build()).build();

    private static final SdkField<Long> TO_PORT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ToPort")
            .getter(getter(SecurityGroupRuleDescription::toPort)).setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_RANGE_FIELD,
            IPV6_RANGE_FIELD, PREFIX_LIST_ID_FIELD, PROTOCOL_FIELD, FROM_PORT_FIELD, TO_PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipv4Range;

    private final String ipv6Range;

    private final String prefixListId;

    private final String protocol;

    private final Long fromPort;

    private final Long toPort;

    private SecurityGroupRuleDescription(BuilderImpl builder) {
        this.ipv4Range = builder.ipv4Range;
        this.ipv6Range = builder.ipv6Range;
        this.prefixListId = builder.prefixListId;
        this.protocol = builder.protocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
    }

    /**
     * <p>
     * The IPv4 ranges for the security group rule.
     * </p>
     * 
     * @return The IPv4 ranges for the security group rule.
     */
    public String ipv4Range() {
        return ipv4Range;
    }

    /**
     * <p>
     * The IPv6 ranges for the security group rule.
     * </p>
     * 
     * @return The IPv6 ranges for the security group rule.
     */
    public String ipv6Range() {
        return ipv6Range;
    }

    /**
     * <p>
     * The ID of the prefix list for the security group rule.
     * </p>
     * 
     * @return The ID of the prefix list for the security group rule.
     */
    public String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
     *         number.
     */
    public String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
     * <code>-1</code> indicates all ICMP/ICMPv6 types.
     * </p>
     * 
     * @return The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
     *         <code>-1</code> indicates all ICMP/ICMPv6 types.
     */
    public Long fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code>
     * indicates all ICMP/ICMPv6 codes.
     * </p>
     * 
     * @return The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of
     *         <code>-1</code> indicates all ICMP/ICMPv6 codes.
     */
    public Long toPort() {
        return toPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv4Range());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Range());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupRuleDescription)) {
            return false;
        }
        SecurityGroupRuleDescription other = (SecurityGroupRuleDescription) obj;
        return Objects.equals(ipv4Range(), other.ipv4Range()) && Objects.equals(ipv6Range(), other.ipv6Range())
                && Objects.equals(prefixListId(), other.prefixListId()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(fromPort(), other.fromPort()) && Objects.equals(toPort(), other.toPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SecurityGroupRuleDescription").add("IPV4Range", ipv4Range()).add("IPV6Range", ipv6Range())
                .add("PrefixListId", prefixListId()).add("Protocol", protocol()).add("FromPort", fromPort())
                .add("ToPort", toPort()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPV4Range":
            return Optional.ofNullable(clazz.cast(ipv4Range()));
        case "IPV6Range":
            return Optional.ofNullable(clazz.cast(ipv6Range()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupRuleDescription, T> g) {
        return obj -> g.apply((SecurityGroupRuleDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroupRuleDescription> {
        /**
         * <p>
         * The IPv4 ranges for the security group rule.
         * </p>
         * 
         * @param ipv4Range
         *        The IPv4 ranges for the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Range(String ipv4Range);

        /**
         * <p>
         * The IPv6 ranges for the security group rule.
         * </p>
         * 
         * @param ipv6Range
         *        The IPv6 ranges for the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Range(String ipv6Range);

        /**
         * <p>
         * The ID of the prefix list for the security group rule.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list for the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.
         * </p>
         * 
         * @param protocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
         *        number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
         * <code>-1</code> indicates all ICMP/ICMPv6 types.
         * </p>
         * 
         * @param fromPort
         *        The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
         *        <code>-1</code> indicates all ICMP/ICMPv6 types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Long fromPort);

        /**
         * <p>
         * The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code>
         * indicates all ICMP/ICMPv6 codes.
         * </p>
         * 
         * @param toPort
         *        The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of
         *        <code>-1</code> indicates all ICMP/ICMPv6 codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Long toPort);
    }

    static final class BuilderImpl implements Builder {
        private String ipv4Range;

        private String ipv6Range;

        private String prefixListId;

        private String protocol;

        private Long fromPort;

        private Long toPort;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupRuleDescription model) {
            ipv4Range(model.ipv4Range);
            ipv6Range(model.ipv6Range);
            prefixListId(model.prefixListId);
            protocol(model.protocol);
            fromPort(model.fromPort);
            toPort(model.toPort);
        }

        public final String getIpv4Range() {
            return ipv4Range;
        }

        @Override
        public final Builder ipv4Range(String ipv4Range) {
            this.ipv4Range = ipv4Range;
            return this;
        }

        public final void setIpv4Range(String ipv4Range) {
            this.ipv4Range = ipv4Range;
        }

        public final String getIpv6Range() {
            return ipv6Range;
        }

        @Override
        public final Builder ipv6Range(String ipv6Range) {
            this.ipv6Range = ipv6Range;
            return this;
        }

        public final void setIpv6Range(String ipv6Range) {
            this.ipv6Range = ipv6Range;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Long getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Long fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Long fromPort) {
            this.fromPort = fromPort;
        }

        public final Long getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Long toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Long toPort) {
            this.toPort = toPort;
        }

        @Override
        public SecurityGroupRuleDescription build() {
            return new SecurityGroupRuleDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
