/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail based on resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceViolation.Builder, ResourceViolation> {
    private static final SdkField<AwsVPCSecurityGroupViolation> AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD = SdkField
            .<AwsVPCSecurityGroupViolation> builder(MarshallingType.SDK_POJO)
            .memberName("AwsVPCSecurityGroupViolation")
            .getter(getter(ResourceViolation::awsVPCSecurityGroupViolation))
            .setter(setter(Builder::awsVPCSecurityGroupViolation))
            .constructor(AwsVPCSecurityGroupViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsVPCSecurityGroupViolation")
                    .build()).build();

    private static final SdkField<AwsEc2NetworkInterfaceViolation> AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD = SdkField
            .<AwsEc2NetworkInterfaceViolation> builder(MarshallingType.SDK_POJO)
            .memberName("AwsEc2NetworkInterfaceViolation")
            .getter(getter(ResourceViolation::awsEc2NetworkInterfaceViolation))
            .setter(setter(Builder::awsEc2NetworkInterfaceViolation))
            .constructor(AwsEc2NetworkInterfaceViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterfaceViolation")
                    .build()).build();

    private static final SdkField<AwsEc2InstanceViolation> AWS_EC2_INSTANCE_VIOLATION_FIELD = SdkField
            .<AwsEc2InstanceViolation> builder(MarshallingType.SDK_POJO).memberName("AwsEc2InstanceViolation")
            .getter(getter(ResourceViolation::awsEc2InstanceViolation)).setter(setter(Builder::awsEc2InstanceViolation))
            .constructor(AwsEc2InstanceViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2InstanceViolation").build())
            .build();

    private static final SdkField<NetworkFirewallMissingFirewallViolation> NETWORK_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD = SdkField
            .<NetworkFirewallMissingFirewallViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallMissingFirewallViolation")
            .getter(getter(ResourceViolation::networkFirewallMissingFirewallViolation))
            .setter(setter(Builder::networkFirewallMissingFirewallViolation))
            .constructor(NetworkFirewallMissingFirewallViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallMissingFirewallViolation").build()).build();

    private static final SdkField<NetworkFirewallMissingSubnetViolation> NETWORK_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD = SdkField
            .<NetworkFirewallMissingSubnetViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallMissingSubnetViolation")
            .getter(getter(ResourceViolation::networkFirewallMissingSubnetViolation))
            .setter(setter(Builder::networkFirewallMissingSubnetViolation))
            .constructor(NetworkFirewallMissingSubnetViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallMissingSubnetViolation").build()).build();

    private static final SdkField<NetworkFirewallMissingExpectedRTViolation> NETWORK_FIREWALL_MISSING_EXPECTED_RT_VIOLATION_FIELD = SdkField
            .<NetworkFirewallMissingExpectedRTViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallMissingExpectedRTViolation")
            .getter(getter(ResourceViolation::networkFirewallMissingExpectedRTViolation))
            .setter(setter(Builder::networkFirewallMissingExpectedRTViolation))
            .constructor(NetworkFirewallMissingExpectedRTViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallMissingExpectedRTViolation").build()).build();

    private static final SdkField<NetworkFirewallPolicyModifiedViolation> NETWORK_FIREWALL_POLICY_MODIFIED_VIOLATION_FIELD = SdkField
            .<NetworkFirewallPolicyModifiedViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallPolicyModifiedViolation")
            .getter(getter(ResourceViolation::networkFirewallPolicyModifiedViolation))
            .setter(setter(Builder::networkFirewallPolicyModifiedViolation))
            .constructor(NetworkFirewallPolicyModifiedViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallPolicyModifiedViolation").build()).build();

    private static final SdkField<DnsRuleGroupPriorityConflictViolation> DNS_RULE_GROUP_PRIORITY_CONFLICT_VIOLATION_FIELD = SdkField
            .<DnsRuleGroupPriorityConflictViolation> builder(MarshallingType.SDK_POJO)
            .memberName("DnsRuleGroupPriorityConflictViolation")
            .getter(getter(ResourceViolation::dnsRuleGroupPriorityConflictViolation))
            .setter(setter(Builder::dnsRuleGroupPriorityConflictViolation))
            .constructor(DnsRuleGroupPriorityConflictViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DnsRuleGroupPriorityConflictViolation").build()).build();

    private static final SdkField<DnsDuplicateRuleGroupViolation> DNS_DUPLICATE_RULE_GROUP_VIOLATION_FIELD = SdkField
            .<DnsDuplicateRuleGroupViolation> builder(MarshallingType.SDK_POJO)
            .memberName("DnsDuplicateRuleGroupViolation")
            .getter(getter(ResourceViolation::dnsDuplicateRuleGroupViolation))
            .setter(setter(Builder::dnsDuplicateRuleGroupViolation))
            .constructor(DnsDuplicateRuleGroupViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsDuplicateRuleGroupViolation")
                    .build()).build();

    private static final SdkField<DnsRuleGroupLimitExceededViolation> DNS_RULE_GROUP_LIMIT_EXCEEDED_VIOLATION_FIELD = SdkField
            .<DnsRuleGroupLimitExceededViolation> builder(MarshallingType.SDK_POJO)
            .memberName("DnsRuleGroupLimitExceededViolation")
            .getter(getter(ResourceViolation::dnsRuleGroupLimitExceededViolation))
            .setter(setter(Builder::dnsRuleGroupLimitExceededViolation))
            .constructor(DnsRuleGroupLimitExceededViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRuleGroupLimitExceededViolation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD, AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD, AWS_EC2_INSTANCE_VIOLATION_FIELD,
            NETWORK_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD,
            NETWORK_FIREWALL_MISSING_EXPECTED_RT_VIOLATION_FIELD, NETWORK_FIREWALL_POLICY_MODIFIED_VIOLATION_FIELD,
            DNS_RULE_GROUP_PRIORITY_CONFLICT_VIOLATION_FIELD, DNS_DUPLICATE_RULE_GROUP_VIOLATION_FIELD,
            DNS_RULE_GROUP_LIMIT_EXCEEDED_VIOLATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;

    private final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;

    private final AwsEc2InstanceViolation awsEc2InstanceViolation;

    private final NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation;

    private final NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation;

    private final NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation;

    private final NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation;

    private final DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation;

    private final DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation;

    private final DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation;

    private ResourceViolation(BuilderImpl builder) {
        this.awsVPCSecurityGroupViolation = builder.awsVPCSecurityGroupViolation;
        this.awsEc2NetworkInterfaceViolation = builder.awsEc2NetworkInterfaceViolation;
        this.awsEc2InstanceViolation = builder.awsEc2InstanceViolation;
        this.networkFirewallMissingFirewallViolation = builder.networkFirewallMissingFirewallViolation;
        this.networkFirewallMissingSubnetViolation = builder.networkFirewallMissingSubnetViolation;
        this.networkFirewallMissingExpectedRTViolation = builder.networkFirewallMissingExpectedRTViolation;
        this.networkFirewallPolicyModifiedViolation = builder.networkFirewallPolicyModifiedViolation;
        this.dnsRuleGroupPriorityConflictViolation = builder.dnsRuleGroupPriorityConflictViolation;
        this.dnsDuplicateRuleGroupViolation = builder.dnsDuplicateRuleGroupViolation;
        this.dnsRuleGroupLimitExceededViolation = builder.dnsRuleGroupLimitExceededViolation;
    }

    /**
     * <p>
     * Violation details for security groups.
     * </p>
     * 
     * @return Violation details for security groups.
     */
    public final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation() {
        return awsVPCSecurityGroupViolation;
    }

    /**
     * <p>
     * Violation details for network interface.
     * </p>
     * 
     * @return Violation details for network interface.
     */
    public final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation() {
        return awsEc2NetworkInterfaceViolation;
    }

    /**
     * <p>
     * Violation details for an EC2 instance.
     * </p>
     * 
     * @return Violation details for an EC2 instance.
     */
    public final AwsEc2InstanceViolation awsEc2InstanceViolation() {
        return awsEc2InstanceViolation;
    }

    /**
     * <p>
     * Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed
     * firewall in its VPC.
     * </p>
     * 
     * @return Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager
     *         managed firewall in its VPC.
     */
    public final NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation() {
        return networkFirewallMissingFirewallViolation;
    }

    /**
     * <p>
     * Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the expected
     * Firewall Manager managed subnet.
     * </p>
     * 
     * @return Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the
     *         expected Firewall Manager managed subnet.
     */
    public final NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation() {
        return networkFirewallMissingSubnetViolation;
    }

    /**
     * <p>
     * Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the expected
     * Firewall Manager managed route table.
     * </p>
     * 
     * @return Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the
     *         expected Firewall Manager managed route table.
     */
    public final NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation() {
        return networkFirewallMissingExpectedRTViolation;
    }

    /**
     * <p>
     * Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual account
     * has been modified in a way that makes it noncompliant. For example, the individual account owner might have
     * deleted a rule group, changed the priority of a stateless rule group, or changed a policy default action.
     * </p>
     * 
     * @return Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual
     *         account has been modified in a way that makes it noncompliant. For example, the individual account owner
     *         might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy
     *         default action.
     */
    public final NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation() {
        return networkFirewallPolicyModifiedViolation;
    }

    /**
     * <p>
     * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
     * associate with a VPC has the same priority as a rule group that's already associated.
     * </p>
     * 
     * @return Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried
     *         to associate with a VPC has the same priority as a rule group that's already associated.
     */
    public final DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation() {
        return dnsRuleGroupPriorityConflictViolation;
    }

    /**
     * <p>
     * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
     * associate with a VPC is already associated with the VPC and can't be associated again.
     * </p>
     * 
     * @return Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried
     *         to associate with a VPC is already associated with the VPC and can't be associated again.
     */
    public final DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation() {
        return dnsDuplicateRuleGroupViolation;
    }

    /**
     * <p>
     * Violation details for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS
     * Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed.
     * </p>
     * 
     * @return Violation details for a DNS Firewall policy that indicates that the VPC reached the limit for associated
     *         DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed.
     */
    public final DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation() {
        return dnsRuleGroupLimitExceededViolation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsVPCSecurityGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2NetworkInterfaceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2InstanceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallMissingFirewallViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallMissingSubnetViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallMissingExpectedRTViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallPolicyModifiedViolation());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRuleGroupPriorityConflictViolation());
        hashCode = 31 * hashCode + Objects.hashCode(dnsDuplicateRuleGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRuleGroupLimitExceededViolation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceViolation)) {
            return false;
        }
        ResourceViolation other = (ResourceViolation) obj;
        return Objects.equals(awsVPCSecurityGroupViolation(), other.awsVPCSecurityGroupViolation())
                && Objects.equals(awsEc2NetworkInterfaceViolation(), other.awsEc2NetworkInterfaceViolation())
                && Objects.equals(awsEc2InstanceViolation(), other.awsEc2InstanceViolation())
                && Objects.equals(networkFirewallMissingFirewallViolation(), other.networkFirewallMissingFirewallViolation())
                && Objects.equals(networkFirewallMissingSubnetViolation(), other.networkFirewallMissingSubnetViolation())
                && Objects.equals(networkFirewallMissingExpectedRTViolation(), other.networkFirewallMissingExpectedRTViolation())
                && Objects.equals(networkFirewallPolicyModifiedViolation(), other.networkFirewallPolicyModifiedViolation())
                && Objects.equals(dnsRuleGroupPriorityConflictViolation(), other.dnsRuleGroupPriorityConflictViolation())
                && Objects.equals(dnsDuplicateRuleGroupViolation(), other.dnsDuplicateRuleGroupViolation())
                && Objects.equals(dnsRuleGroupLimitExceededViolation(), other.dnsRuleGroupLimitExceededViolation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceViolation").add("AwsVPCSecurityGroupViolation", awsVPCSecurityGroupViolation())
                .add("AwsEc2NetworkInterfaceViolation", awsEc2NetworkInterfaceViolation())
                .add("AwsEc2InstanceViolation", awsEc2InstanceViolation())
                .add("NetworkFirewallMissingFirewallViolation", networkFirewallMissingFirewallViolation())
                .add("NetworkFirewallMissingSubnetViolation", networkFirewallMissingSubnetViolation())
                .add("NetworkFirewallMissingExpectedRTViolation", networkFirewallMissingExpectedRTViolation())
                .add("NetworkFirewallPolicyModifiedViolation", networkFirewallPolicyModifiedViolation())
                .add("DnsRuleGroupPriorityConflictViolation", dnsRuleGroupPriorityConflictViolation())
                .add("DnsDuplicateRuleGroupViolation", dnsDuplicateRuleGroupViolation())
                .add("DnsRuleGroupLimitExceededViolation", dnsRuleGroupLimitExceededViolation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsVPCSecurityGroupViolation":
            return Optional.ofNullable(clazz.cast(awsVPCSecurityGroupViolation()));
        case "AwsEc2NetworkInterfaceViolation":
            return Optional.ofNullable(clazz.cast(awsEc2NetworkInterfaceViolation()));
        case "AwsEc2InstanceViolation":
            return Optional.ofNullable(clazz.cast(awsEc2InstanceViolation()));
        case "NetworkFirewallMissingFirewallViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallMissingFirewallViolation()));
        case "NetworkFirewallMissingSubnetViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallMissingSubnetViolation()));
        case "NetworkFirewallMissingExpectedRTViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallMissingExpectedRTViolation()));
        case "NetworkFirewallPolicyModifiedViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallPolicyModifiedViolation()));
        case "DnsRuleGroupPriorityConflictViolation":
            return Optional.ofNullable(clazz.cast(dnsRuleGroupPriorityConflictViolation()));
        case "DnsDuplicateRuleGroupViolation":
            return Optional.ofNullable(clazz.cast(dnsDuplicateRuleGroupViolation()));
        case "DnsRuleGroupLimitExceededViolation":
            return Optional.ofNullable(clazz.cast(dnsRuleGroupLimitExceededViolation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceViolation, T> g) {
        return obj -> g.apply((ResourceViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceViolation> {
        /**
         * <p>
         * Violation details for security groups.
         * </p>
         * 
         * @param awsVPCSecurityGroupViolation
         *        Violation details for security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation);

        /**
         * <p>
         * Violation details for security groups.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsVPCSecurityGroupViolation.Builder} avoiding
         * the need to create one manually via {@link AwsVPCSecurityGroupViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsVPCSecurityGroupViolation.Builder#build()} is called
         * immediately and its result is passed to {@link #awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation)}.
         * 
         * @param awsVPCSecurityGroupViolation
         *        a consumer that will call methods on {@link AwsVPCSecurityGroupViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation)
         */
        default Builder awsVPCSecurityGroupViolation(Consumer<AwsVPCSecurityGroupViolation.Builder> awsVPCSecurityGroupViolation) {
            return awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.builder()
                    .applyMutation(awsVPCSecurityGroupViolation).build());
        }

        /**
         * <p>
         * Violation details for network interface.
         * </p>
         * 
         * @param awsEc2NetworkInterfaceViolation
         *        Violation details for network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation);

        /**
         * <p>
         * Violation details for network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2NetworkInterfaceViolation.Builder}
         * avoiding the need to create one manually via {@link AwsEc2NetworkInterfaceViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2NetworkInterfaceViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation)}.
         * 
         * @param awsEc2NetworkInterfaceViolation
         *        a consumer that will call methods on {@link AwsEc2NetworkInterfaceViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation)
         */
        default Builder awsEc2NetworkInterfaceViolation(
                Consumer<AwsEc2NetworkInterfaceViolation.Builder> awsEc2NetworkInterfaceViolation) {
            return awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation.builder()
                    .applyMutation(awsEc2NetworkInterfaceViolation).build());
        }

        /**
         * <p>
         * Violation details for an EC2 instance.
         * </p>
         * 
         * @param awsEc2InstanceViolation
         *        Violation details for an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation);

        /**
         * <p>
         * Violation details for an EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2InstanceViolation.Builder} avoiding the
         * need to create one manually via {@link AwsEc2InstanceViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2InstanceViolation.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEc2InstanceViolation(AwsEc2InstanceViolation)}.
         * 
         * @param awsEc2InstanceViolation
         *        a consumer that will call methods on {@link AwsEc2InstanceViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2InstanceViolation(AwsEc2InstanceViolation)
         */
        default Builder awsEc2InstanceViolation(Consumer<AwsEc2InstanceViolation.Builder> awsEc2InstanceViolation) {
            return awsEc2InstanceViolation(AwsEc2InstanceViolation.builder().applyMutation(awsEc2InstanceViolation).build());
        }

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed
         * firewall in its VPC.
         * </p>
         * 
         * @param networkFirewallMissingFirewallViolation
         *        Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager
         *        managed firewall in its VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallMissingFirewallViolation(
                NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation);

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed
         * firewall in its VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkFirewallMissingFirewallViolation.Builder}
         * avoiding the need to create one manually via {@link NetworkFirewallMissingFirewallViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallMissingFirewallViolation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation)}.
         * 
         * @param networkFirewallMissingFirewallViolation
         *        a consumer that will call methods on {@link NetworkFirewallMissingFirewallViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation)
         */
        default Builder networkFirewallMissingFirewallViolation(
                Consumer<NetworkFirewallMissingFirewallViolation.Builder> networkFirewallMissingFirewallViolation) {
            return networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation.builder()
                    .applyMutation(networkFirewallMissingFirewallViolation).build());
        }

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the
         * expected Firewall Manager managed subnet.
         * </p>
         * 
         * @param networkFirewallMissingSubnetViolation
         *        Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing
         *        the expected Firewall Manager managed subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation);

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the
         * expected Firewall Manager managed subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkFirewallMissingSubnetViolation.Builder}
         * avoiding the need to create one manually via {@link NetworkFirewallMissingSubnetViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallMissingSubnetViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation)}.
         * 
         * @param networkFirewallMissingSubnetViolation
         *        a consumer that will call methods on {@link NetworkFirewallMissingSubnetViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation)
         */
        default Builder networkFirewallMissingSubnetViolation(
                Consumer<NetworkFirewallMissingSubnetViolation.Builder> networkFirewallMissingSubnetViolation) {
            return networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation.builder()
                    .applyMutation(networkFirewallMissingSubnetViolation).build());
        }

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the
         * expected Firewall Manager managed route table.
         * </p>
         * 
         * @param networkFirewallMissingExpectedRTViolation
         *        Violation detail for an Network Firewall policy that indicates that a subnet is not associated with
         *        the expected Firewall Manager managed route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallMissingExpectedRTViolation(
                NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation);

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the
         * expected Firewall Manager managed route table.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link NetworkFirewallMissingExpectedRTViolation.Builder} avoiding the need to create one manually via
         * {@link NetworkFirewallMissingExpectedRTViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallMissingExpectedRTViolation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation)}.
         * 
         * @param networkFirewallMissingExpectedRTViolation
         *        a consumer that will call methods on {@link NetworkFirewallMissingExpectedRTViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation)
         */
        default Builder networkFirewallMissingExpectedRTViolation(
                Consumer<NetworkFirewallMissingExpectedRTViolation.Builder> networkFirewallMissingExpectedRTViolation) {
            return networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation.builder()
                    .applyMutation(networkFirewallMissingExpectedRTViolation).build());
        }

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual
         * account has been modified in a way that makes it noncompliant. For example, the individual account owner
         * might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default
         * action.
         * </p>
         * 
         * @param networkFirewallPolicyModifiedViolation
         *        Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual
         *        account has been modified in a way that makes it noncompliant. For example, the individual account
         *        owner might have deleted a rule group, changed the priority of a stateless rule group, or changed a
         *        policy default action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallPolicyModifiedViolation(
                NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation);

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual
         * account has been modified in a way that makes it noncompliant. For example, the individual account owner
         * might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default
         * action.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkFirewallPolicyModifiedViolation.Builder}
         * avoiding the need to create one manually via {@link NetworkFirewallPolicyModifiedViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallPolicyModifiedViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation)}.
         * 
         * @param networkFirewallPolicyModifiedViolation
         *        a consumer that will call methods on {@link NetworkFirewallPolicyModifiedViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation)
         */
        default Builder networkFirewallPolicyModifiedViolation(
                Consumer<NetworkFirewallPolicyModifiedViolation.Builder> networkFirewallPolicyModifiedViolation) {
            return networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation.builder()
                    .applyMutation(networkFirewallPolicyModifiedViolation).build());
        }

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
         * associate with a VPC has the same priority as a rule group that's already associated.
         * </p>
         * 
         * @param dnsRuleGroupPriorityConflictViolation
         *        Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager
         *        tried to associate with a VPC has the same priority as a rule group that's already associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation);

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
         * associate with a VPC has the same priority as a rule group that's already associated.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsRuleGroupPriorityConflictViolation.Builder}
         * avoiding the need to create one manually via {@link DnsRuleGroupPriorityConflictViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsRuleGroupPriorityConflictViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation)}.
         * 
         * @param dnsRuleGroupPriorityConflictViolation
         *        a consumer that will call methods on {@link DnsRuleGroupPriorityConflictViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation)
         */
        default Builder dnsRuleGroupPriorityConflictViolation(
                Consumer<DnsRuleGroupPriorityConflictViolation.Builder> dnsRuleGroupPriorityConflictViolation) {
            return dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation.builder()
                    .applyMutation(dnsRuleGroupPriorityConflictViolation).build());
        }

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
         * associate with a VPC is already associated with the VPC and can't be associated again.
         * </p>
         * 
         * @param dnsDuplicateRuleGroupViolation
         *        Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager
         *        tried to associate with a VPC is already associated with the VPC and can't be associated again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation);

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
         * associate with a VPC is already associated with the VPC and can't be associated again.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsDuplicateRuleGroupViolation.Builder} avoiding
         * the need to create one manually via {@link DnsDuplicateRuleGroupViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsDuplicateRuleGroupViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation)}.
         * 
         * @param dnsDuplicateRuleGroupViolation
         *        a consumer that will call methods on {@link DnsDuplicateRuleGroupViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation)
         */
        default Builder dnsDuplicateRuleGroupViolation(
                Consumer<DnsDuplicateRuleGroupViolation.Builder> dnsDuplicateRuleGroupViolation) {
            return dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation.builder()
                    .applyMutation(dnsDuplicateRuleGroupViolation).build());
        }

        /**
         * <p>
         * Violation details for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS
         * Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed.
         * </p>
         * 
         * @param dnsRuleGroupLimitExceededViolation
         *        Violation details for a DNS Firewall policy that indicates that the VPC reached the limit for
         *        associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the
         *        VPC and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation);

        /**
         * <p>
         * Violation details for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS
         * Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsRuleGroupLimitExceededViolation.Builder}
         * avoiding the need to create one manually via {@link DnsRuleGroupLimitExceededViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsRuleGroupLimitExceededViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation)}.
         * 
         * @param dnsRuleGroupLimitExceededViolation
         *        a consumer that will call methods on {@link DnsRuleGroupLimitExceededViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation)
         */
        default Builder dnsRuleGroupLimitExceededViolation(
                Consumer<DnsRuleGroupLimitExceededViolation.Builder> dnsRuleGroupLimitExceededViolation) {
            return dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation.builder()
                    .applyMutation(dnsRuleGroupLimitExceededViolation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;

        private AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;

        private AwsEc2InstanceViolation awsEc2InstanceViolation;

        private NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation;

        private NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation;

        private NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation;

        private NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation;

        private DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation;

        private DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation;

        private DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceViolation model) {
            awsVPCSecurityGroupViolation(model.awsVPCSecurityGroupViolation);
            awsEc2NetworkInterfaceViolation(model.awsEc2NetworkInterfaceViolation);
            awsEc2InstanceViolation(model.awsEc2InstanceViolation);
            networkFirewallMissingFirewallViolation(model.networkFirewallMissingFirewallViolation);
            networkFirewallMissingSubnetViolation(model.networkFirewallMissingSubnetViolation);
            networkFirewallMissingExpectedRTViolation(model.networkFirewallMissingExpectedRTViolation);
            networkFirewallPolicyModifiedViolation(model.networkFirewallPolicyModifiedViolation);
            dnsRuleGroupPriorityConflictViolation(model.dnsRuleGroupPriorityConflictViolation);
            dnsDuplicateRuleGroupViolation(model.dnsDuplicateRuleGroupViolation);
            dnsRuleGroupLimitExceededViolation(model.dnsRuleGroupLimitExceededViolation);
        }

        public final AwsVPCSecurityGroupViolation.Builder getAwsVPCSecurityGroupViolation() {
            return awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation;
            return this;
        }

        public final void setAwsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.BuilderImpl awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.build()
                    : null;
        }

        public final AwsEc2NetworkInterfaceViolation.Builder getAwsEc2NetworkInterfaceViolation() {
            return awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation;
            return this;
        }

        public final void setAwsEc2NetworkInterfaceViolation(
                AwsEc2NetworkInterfaceViolation.BuilderImpl awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation
                    .build() : null;
        }

        public final AwsEc2InstanceViolation.Builder getAwsEc2InstanceViolation() {
            return awsEc2InstanceViolation != null ? awsEc2InstanceViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation;
            return this;
        }

        public final void setAwsEc2InstanceViolation(AwsEc2InstanceViolation.BuilderImpl awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation != null ? awsEc2InstanceViolation.build() : null;
        }

        public final NetworkFirewallMissingFirewallViolation.Builder getNetworkFirewallMissingFirewallViolation() {
            return networkFirewallMissingFirewallViolation != null ? networkFirewallMissingFirewallViolation.toBuilder() : null;
        }

        @Override
        public final Builder networkFirewallMissingFirewallViolation(
                NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation) {
            this.networkFirewallMissingFirewallViolation = networkFirewallMissingFirewallViolation;
            return this;
        }

        public final void setNetworkFirewallMissingFirewallViolation(
                NetworkFirewallMissingFirewallViolation.BuilderImpl networkFirewallMissingFirewallViolation) {
            this.networkFirewallMissingFirewallViolation = networkFirewallMissingFirewallViolation != null ? networkFirewallMissingFirewallViolation
                    .build() : null;
        }

        public final NetworkFirewallMissingSubnetViolation.Builder getNetworkFirewallMissingSubnetViolation() {
            return networkFirewallMissingSubnetViolation != null ? networkFirewallMissingSubnetViolation.toBuilder() : null;
        }

        @Override
        public final Builder networkFirewallMissingSubnetViolation(
                NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation) {
            this.networkFirewallMissingSubnetViolation = networkFirewallMissingSubnetViolation;
            return this;
        }

        public final void setNetworkFirewallMissingSubnetViolation(
                NetworkFirewallMissingSubnetViolation.BuilderImpl networkFirewallMissingSubnetViolation) {
            this.networkFirewallMissingSubnetViolation = networkFirewallMissingSubnetViolation != null ? networkFirewallMissingSubnetViolation
                    .build() : null;
        }

        public final NetworkFirewallMissingExpectedRTViolation.Builder getNetworkFirewallMissingExpectedRTViolation() {
            return networkFirewallMissingExpectedRTViolation != null ? networkFirewallMissingExpectedRTViolation.toBuilder()
                    : null;
        }

        @Override
        public final Builder networkFirewallMissingExpectedRTViolation(
                NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation) {
            this.networkFirewallMissingExpectedRTViolation = networkFirewallMissingExpectedRTViolation;
            return this;
        }

        public final void setNetworkFirewallMissingExpectedRTViolation(
                NetworkFirewallMissingExpectedRTViolation.BuilderImpl networkFirewallMissingExpectedRTViolation) {
            this.networkFirewallMissingExpectedRTViolation = networkFirewallMissingExpectedRTViolation != null ? networkFirewallMissingExpectedRTViolation
                    .build() : null;
        }

        public final NetworkFirewallPolicyModifiedViolation.Builder getNetworkFirewallPolicyModifiedViolation() {
            return networkFirewallPolicyModifiedViolation != null ? networkFirewallPolicyModifiedViolation.toBuilder() : null;
        }

        @Override
        public final Builder networkFirewallPolicyModifiedViolation(
                NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation) {
            this.networkFirewallPolicyModifiedViolation = networkFirewallPolicyModifiedViolation;
            return this;
        }

        public final void setNetworkFirewallPolicyModifiedViolation(
                NetworkFirewallPolicyModifiedViolation.BuilderImpl networkFirewallPolicyModifiedViolation) {
            this.networkFirewallPolicyModifiedViolation = networkFirewallPolicyModifiedViolation != null ? networkFirewallPolicyModifiedViolation
                    .build() : null;
        }

        public final DnsRuleGroupPriorityConflictViolation.Builder getDnsRuleGroupPriorityConflictViolation() {
            return dnsRuleGroupPriorityConflictViolation != null ? dnsRuleGroupPriorityConflictViolation.toBuilder() : null;
        }

        @Override
        public final Builder dnsRuleGroupPriorityConflictViolation(
                DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation) {
            this.dnsRuleGroupPriorityConflictViolation = dnsRuleGroupPriorityConflictViolation;
            return this;
        }

        public final void setDnsRuleGroupPriorityConflictViolation(
                DnsRuleGroupPriorityConflictViolation.BuilderImpl dnsRuleGroupPriorityConflictViolation) {
            this.dnsRuleGroupPriorityConflictViolation = dnsRuleGroupPriorityConflictViolation != null ? dnsRuleGroupPriorityConflictViolation
                    .build() : null;
        }

        public final DnsDuplicateRuleGroupViolation.Builder getDnsDuplicateRuleGroupViolation() {
            return dnsDuplicateRuleGroupViolation != null ? dnsDuplicateRuleGroupViolation.toBuilder() : null;
        }

        @Override
        public final Builder dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation) {
            this.dnsDuplicateRuleGroupViolation = dnsDuplicateRuleGroupViolation;
            return this;
        }

        public final void setDnsDuplicateRuleGroupViolation(
                DnsDuplicateRuleGroupViolation.BuilderImpl dnsDuplicateRuleGroupViolation) {
            this.dnsDuplicateRuleGroupViolation = dnsDuplicateRuleGroupViolation != null ? dnsDuplicateRuleGroupViolation.build()
                    : null;
        }

        public final DnsRuleGroupLimitExceededViolation.Builder getDnsRuleGroupLimitExceededViolation() {
            return dnsRuleGroupLimitExceededViolation != null ? dnsRuleGroupLimitExceededViolation.toBuilder() : null;
        }

        @Override
        public final Builder dnsRuleGroupLimitExceededViolation(
                DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation) {
            this.dnsRuleGroupLimitExceededViolation = dnsRuleGroupLimitExceededViolation;
            return this;
        }

        public final void setDnsRuleGroupLimitExceededViolation(
                DnsRuleGroupLimitExceededViolation.BuilderImpl dnsRuleGroupLimitExceededViolation) {
            this.dnsRuleGroupLimitExceededViolation = dnsRuleGroupLimitExceededViolation != null ? dnsRuleGroupLimitExceededViolation
                    .build() : null;
        }

        @Override
        public ResourceViolation build() {
            return new ResourceViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
