/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the Firewall Manager applications list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppsListDataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AppsListDataSummary.Builder, AppsListDataSummary> {
    private static final SdkField<String> LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListArn").getter(getter(AppsListDataSummary::listArn)).setter(setter(Builder::listArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListArn").build()).build();

    private static final SdkField<String> LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ListId")
            .getter(getter(AppsListDataSummary::listId)).setter(setter(Builder::listId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()).build();

    private static final SdkField<String> LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListName").getter(getter(AppsListDataSummary::listName)).setter(setter(Builder::listName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()).build();

    private static final SdkField<List<App>> APPS_LIST_FIELD = SdkField
            .<List<App>> builder(MarshallingType.LIST)
            .memberName("AppsList")
            .getter(getter(AppsListDataSummary::appsList))
            .setter(setter(Builder::appsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<App> builder(MarshallingType.SDK_POJO)
                                            .constructor(App::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ARN_FIELD, LIST_ID_FIELD,
            LIST_NAME_FIELD, APPS_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String listArn;

    private final String listId;

    private final String listName;

    private final List<App> appsList;

    private AppsListDataSummary(BuilderImpl builder) {
        this.listArn = builder.listArn;
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.appsList = builder.appsList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the applications list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the applications list.
     */
    public final String listArn() {
        return listArn;
    }

    /**
     * <p>
     * The ID of the applications list.
     * </p>
     * 
     * @return The ID of the applications list.
     */
    public final String listId() {
        return listId;
    }

    /**
     * <p>
     * The name of the applications list.
     * </p>
     * 
     * @return The name of the applications list.
     */
    public final String listName() {
        return listName;
    }

    /**
     * Returns true if the AppsList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAppsList() {
        return appsList != null && !(appsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>App</code> objects in the Firewall Manager applications list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAppsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>App</code> objects in the Firewall Manager applications list.
     */
    public final List<App> appsList() {
        return appsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listArn());
        hashCode = 31 * hashCode + Objects.hashCode(listId());
        hashCode = 31 * hashCode + Objects.hashCode(listName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppsList() ? appsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppsListDataSummary)) {
            return false;
        }
        AppsListDataSummary other = (AppsListDataSummary) obj;
        return Objects.equals(listArn(), other.listArn()) && Objects.equals(listId(), other.listId())
                && Objects.equals(listName(), other.listName()) && hasAppsList() == other.hasAppsList()
                && Objects.equals(appsList(), other.appsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppsListDataSummary").add("ListArn", listArn()).add("ListId", listId())
                .add("ListName", listName()).add("AppsList", hasAppsList() ? appsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListArn":
            return Optional.ofNullable(clazz.cast(listArn()));
        case "ListId":
            return Optional.ofNullable(clazz.cast(listId()));
        case "ListName":
            return Optional.ofNullable(clazz.cast(listName()));
        case "AppsList":
            return Optional.ofNullable(clazz.cast(appsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppsListDataSummary, T> g) {
        return obj -> g.apply((AppsListDataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppsListDataSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the applications list.
         * </p>
         * 
         * @param listArn
         *        The Amazon Resource Name (ARN) of the applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listArn(String listArn);

        /**
         * <p>
         * The ID of the applications list.
         * </p>
         * 
         * @param listId
         *        The ID of the applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listId(String listId);

        /**
         * <p>
         * The name of the applications list.
         * </p>
         * 
         * @param listName
         *        The name of the applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listName(String listName);

        /**
         * <p>
         * An array of <code>App</code> objects in the Firewall Manager applications list.
         * </p>
         * 
         * @param appsList
         *        An array of <code>App</code> objects in the Firewall Manager applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsList(Collection<App> appsList);

        /**
         * <p>
         * An array of <code>App</code> objects in the Firewall Manager applications list.
         * </p>
         * 
         * @param appsList
         *        An array of <code>App</code> objects in the Firewall Manager applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsList(App... appsList);

        /**
         * <p>
         * An array of <code>App</code> objects in the Firewall Manager applications list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<App>.Builder} avoiding the need to create
         * one manually via {@link List<App>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<App>.Builder#build()} is called immediately and its result
         * is passed to {@link #appsList(List<App>)}.
         * 
         * @param appsList
         *        a consumer that will call methods on {@link List<App>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appsList(List<App>)
         */
        Builder appsList(Consumer<App.Builder>... appsList);
    }

    static final class BuilderImpl implements Builder {
        private String listArn;

        private String listId;

        private String listName;

        private List<App> appsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppsListDataSummary model) {
            listArn(model.listArn);
            listId(model.listId);
            listName(model.listName);
            appsList(model.appsList);
        }

        public final String getListArn() {
            return listArn;
        }

        @Override
        public final Builder listArn(String listArn) {
            this.listArn = listArn;
            return this;
        }

        public final void setListArn(String listArn) {
            this.listArn = listArn;
        }

        public final String getListId() {
            return listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        public final String getListName() {
            return listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        public final List<App.Builder> getAppsList() {
            List<App.Builder> result = AppsListCopier.copyToBuilder(this.appsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder appsList(Collection<App> appsList) {
            this.appsList = AppsListCopier.copy(appsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsList(App... appsList) {
            appsList(Arrays.asList(appsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsList(Consumer<App.Builder>... appsList) {
            appsList(Stream.of(appsList).map(c -> App.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAppsList(Collection<App.BuilderImpl> appsList) {
            this.appsList = AppsListCopier.copyFromBuilder(appsList);
        }

        @Override
        public AppsListDataSummary build() {
            return new AppsListDataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
