/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the ReplaceRouteTableAssociation action in Amazon EC2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2ReplaceRouteTableAssociationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2ReplaceRouteTableAssociationAction.Builder, EC2ReplaceRouteTableAssociationAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EC2ReplaceRouteTableAssociationAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ActionTarget> ASSOCIATION_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("AssociationId").getter(getter(EC2ReplaceRouteTableAssociationAction::associationId))
            .setter(setter(Builder::associationId)).constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<ActionTarget> ROUTE_TABLE_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("RouteTableId").getter(getter(EC2ReplaceRouteTableAssociationAction::routeTableId))
            .setter(setter(Builder::routeTableId)).constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ASSOCIATION_ID_FIELD, ROUTE_TABLE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final ActionTarget associationId;

    private final ActionTarget routeTableId;

    private EC2ReplaceRouteTableAssociationAction(BuilderImpl builder) {
        this.description = builder.description;
        this.associationId = builder.associationId;
        this.routeTableId = builder.routeTableId;
    }

    /**
     * <p>
     * A description of the ReplaceRouteTableAssociation action in Amazon EC2.
     * </p>
     * 
     * @return A description of the ReplaceRouteTableAssociation action in Amazon EC2.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the association ID.
     * </p>
     * 
     * @return Information about the association ID.
     */
    public final ActionTarget associationId() {
        return associationId;
    }

    /**
     * <p>
     * Information about the ID of the new route table to associate with the subnet.
     * </p>
     * 
     * @return Information about the ID of the new route table to associate with the subnet.
     */
    public final ActionTarget routeTableId() {
        return routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2ReplaceRouteTableAssociationAction)) {
            return false;
        }
        EC2ReplaceRouteTableAssociationAction other = (EC2ReplaceRouteTableAssociationAction) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(routeTableId(), other.routeTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2ReplaceRouteTableAssociationAction").add("Description", description())
                .add("AssociationId", associationId()).add("RouteTableId", routeTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2ReplaceRouteTableAssociationAction, T> g) {
        return obj -> g.apply((EC2ReplaceRouteTableAssociationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2ReplaceRouteTableAssociationAction> {
        /**
         * <p>
         * A description of the ReplaceRouteTableAssociation action in Amazon EC2.
         * </p>
         * 
         * @param description
         *        A description of the ReplaceRouteTableAssociation action in Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the association ID.
         * </p>
         * 
         * @param associationId
         *        Information about the association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(ActionTarget associationId);

        /**
         * <p>
         * Information about the association ID.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionTarget.Builder} avoiding the need to
         * create one manually via {@link ActionTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #associationId(ActionTarget)}.
         * 
         * @param associationId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationId(ActionTarget)
         */
        default Builder associationId(Consumer<ActionTarget.Builder> associationId) {
            return associationId(ActionTarget.builder().applyMutation(associationId).build());
        }

        /**
         * <p>
         * Information about the ID of the new route table to associate with the subnet.
         * </p>
         * 
         * @param routeTableId
         *        Information about the ID of the new route table to associate with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(ActionTarget routeTableId);

        /**
         * <p>
         * Information about the ID of the new route table to associate with the subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionTarget.Builder} avoiding the need to
         * create one manually via {@link ActionTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #routeTableId(ActionTarget)}.
         * 
         * @param routeTableId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTableId(ActionTarget)
         */
        default Builder routeTableId(Consumer<ActionTarget.Builder> routeTableId) {
            return routeTableId(ActionTarget.builder().applyMutation(routeTableId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private ActionTarget associationId;

        private ActionTarget routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2ReplaceRouteTableAssociationAction model) {
            description(model.description);
            associationId(model.associationId);
            routeTableId(model.routeTableId);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ActionTarget.Builder getAssociationId() {
            return associationId != null ? associationId.toBuilder() : null;
        }

        @Override
        public final Builder associationId(ActionTarget associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(ActionTarget.BuilderImpl associationId) {
            this.associationId = associationId != null ? associationId.build() : null;
        }

        public final ActionTarget.Builder getRouteTableId() {
            return routeTableId != null ? routeTableId.toBuilder() : null;
        }

        @Override
        public final Builder routeTableId(ActionTarget routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(ActionTarget.BuilderImpl routeTableId) {
            this.routeTableId = routeTableId != null ? routeTableId.build() : null;
        }

        @Override
        public EC2ReplaceRouteTableAssociationAction build() {
            return new EC2ReplaceRouteTableAssociationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
