/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for an expected route missing in Network Firewall.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallMissingExpectedRoutesViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFirewallMissingExpectedRoutesViolation.Builder, NetworkFirewallMissingExpectedRoutesViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(NetworkFirewallMissingExpectedRoutesViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<List<ExpectedRoute>> EXPECTED_ROUTES_FIELD = SdkField
            .<List<ExpectedRoute>> builder(MarshallingType.LIST)
            .memberName("ExpectedRoutes")
            .getter(getter(NetworkFirewallMissingExpectedRoutesViolation::expectedRoutes))
            .setter(setter(Builder::expectedRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(NetworkFirewallMissingExpectedRoutesViolation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            EXPECTED_ROUTES_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final List<ExpectedRoute> expectedRoutes;

    private final String vpcId;

    private NetworkFirewallMissingExpectedRoutesViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.expectedRoutes = builder.expectedRoutes;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The target of the violation.
     * </p>
     * 
     * @return The target of the violation.
     */
    public final String violationTarget() {
        return violationTarget;
    }

    /**
     * Returns true if the ExpectedRoutes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasExpectedRoutes() {
        return expectedRoutes != null && !(expectedRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The expected routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpectedRoutes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The expected routes.
     */
    public final List<ExpectedRoute> expectedRoutes() {
        return expectedRoutes;
    }

    /**
     * <p>
     * Information about the VPC ID.
     * </p>
     * 
     * @return Information about the VPC ID.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedRoutes() ? expectedRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallMissingExpectedRoutesViolation)) {
            return false;
        }
        NetworkFirewallMissingExpectedRoutesViolation other = (NetworkFirewallMissingExpectedRoutesViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget()) && hasExpectedRoutes() == other.hasExpectedRoutes()
                && Objects.equals(expectedRoutes(), other.expectedRoutes()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFirewallMissingExpectedRoutesViolation").add("ViolationTarget", violationTarget())
                .add("ExpectedRoutes", hasExpectedRoutes() ? expectedRoutes() : null).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "ExpectedRoutes":
            return Optional.ofNullable(clazz.cast(expectedRoutes()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallMissingExpectedRoutesViolation, T> g) {
        return obj -> g.apply((NetworkFirewallMissingExpectedRoutesViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallMissingExpectedRoutesViolation> {
        /**
         * <p>
         * The target of the violation.
         * </p>
         * 
         * @param violationTarget
         *        The target of the violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * The expected routes.
         * </p>
         * 
         * @param expectedRoutes
         *        The expected routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRoutes(Collection<ExpectedRoute> expectedRoutes);

        /**
         * <p>
         * The expected routes.
         * </p>
         * 
         * @param expectedRoutes
         *        The expected routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRoutes(ExpectedRoute... expectedRoutes);

        /**
         * <p>
         * The expected routes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExpectedRoute>.Builder} avoiding the need
         * to create one manually via {@link List<ExpectedRoute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExpectedRoute>.Builder#build()} is called immediately and
         * its result is passed to {@link #expectedRoutes(List<ExpectedRoute>)}.
         * 
         * @param expectedRoutes
         *        a consumer that will call methods on {@link List<ExpectedRoute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedRoutes(List<ExpectedRoute>)
         */
        Builder expectedRoutes(Consumer<ExpectedRoute.Builder>... expectedRoutes);

        /**
         * <p>
         * Information about the VPC ID.
         * </p>
         * 
         * @param vpcId
         *        Information about the VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private List<ExpectedRoute> expectedRoutes = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallMissingExpectedRoutesViolation model) {
            violationTarget(model.violationTarget);
            expectedRoutes(model.expectedRoutes);
            vpcId(model.vpcId);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        public final List<ExpectedRoute.Builder> getExpectedRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder expectedRoutes(Collection<ExpectedRoute> expectedRoutes) {
            this.expectedRoutes = ExpectedRoutesCopier.copy(expectedRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedRoutes(ExpectedRoute... expectedRoutes) {
            expectedRoutes(Arrays.asList(expectedRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedRoutes(Consumer<ExpectedRoute.Builder>... expectedRoutes) {
            expectedRoutes(Stream.of(expectedRoutes).map(c -> ExpectedRoute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExpectedRoutes(Collection<ExpectedRoute.BuilderImpl> expectedRoutes) {
            this.expectedRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedRoutes);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public NetworkFirewallMissingExpectedRoutesViolation build() {
            return new NetworkFirewallMissingExpectedRoutesViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
