/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of remediation actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PossibleRemediationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<PossibleRemediationAction.Builder, PossibleRemediationAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PossibleRemediationAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<RemediationActionWithOrder>> ORDERED_REMEDIATION_ACTIONS_FIELD = SdkField
            .<List<RemediationActionWithOrder>> builder(MarshallingType.LIST)
            .memberName("OrderedRemediationActions")
            .getter(getter(PossibleRemediationAction::orderedRemediationActions))
            .setter(setter(Builder::orderedRemediationActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedRemediationActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationActionWithOrder> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationActionWithOrder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_ACTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefaultAction").getter(getter(PossibleRemediationAction::isDefaultAction))
            .setter(setter(Builder::isDefaultAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ORDERED_REMEDIATION_ACTIONS_FIELD, IS_DEFAULT_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final List<RemediationActionWithOrder> orderedRemediationActions;

    private final Boolean isDefaultAction;

    private PossibleRemediationAction(BuilderImpl builder) {
        this.description = builder.description;
        this.orderedRemediationActions = builder.orderedRemediationActions;
        this.isDefaultAction = builder.isDefaultAction;
    }

    /**
     * <p>
     * A description of the list of remediation actions.
     * </p>
     * 
     * @return A description of the list of remediation actions.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the OrderedRemediationActions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOrderedRemediationActions() {
        return orderedRemediationActions != null && !(orderedRemediationActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ordered list of remediation actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrderedRemediationActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ordered list of remediation actions.
     */
    public final List<RemediationActionWithOrder> orderedRemediationActions() {
        return orderedRemediationActions;
    }

    /**
     * <p>
     * Information about whether an action is taken by default.
     * </p>
     * 
     * @return Information about whether an action is taken by default.
     */
    public final Boolean isDefaultAction() {
        return isDefaultAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderedRemediationActions() ? orderedRemediationActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PossibleRemediationAction)) {
            return false;
        }
        PossibleRemediationAction other = (PossibleRemediationAction) obj;
        return Objects.equals(description(), other.description())
                && hasOrderedRemediationActions() == other.hasOrderedRemediationActions()
                && Objects.equals(orderedRemediationActions(), other.orderedRemediationActions())
                && Objects.equals(isDefaultAction(), other.isDefaultAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PossibleRemediationAction").add("Description", description())
                .add("OrderedRemediationActions", hasOrderedRemediationActions() ? orderedRemediationActions() : null)
                .add("IsDefaultAction", isDefaultAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OrderedRemediationActions":
            return Optional.ofNullable(clazz.cast(orderedRemediationActions()));
        case "IsDefaultAction":
            return Optional.ofNullable(clazz.cast(isDefaultAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PossibleRemediationAction, T> g) {
        return obj -> g.apply((PossibleRemediationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PossibleRemediationAction> {
        /**
         * <p>
         * A description of the list of remediation actions.
         * </p>
         * 
         * @param description
         *        A description of the list of remediation actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ordered list of remediation actions.
         * </p>
         * 
         * @param orderedRemediationActions
         *        The ordered list of remediation actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedRemediationActions(Collection<RemediationActionWithOrder> orderedRemediationActions);

        /**
         * <p>
         * The ordered list of remediation actions.
         * </p>
         * 
         * @param orderedRemediationActions
         *        The ordered list of remediation actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedRemediationActions(RemediationActionWithOrder... orderedRemediationActions);

        /**
         * <p>
         * The ordered list of remediation actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemediationActionWithOrder>.Builder}
         * avoiding the need to create one manually via {@link List<RemediationActionWithOrder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemediationActionWithOrder>.Builder#build()} is called
         * immediately and its result is passed to {@link #orderedRemediationActions(List<RemediationActionWithOrder>)}.
         * 
         * @param orderedRemediationActions
         *        a consumer that will call methods on {@link List<RemediationActionWithOrder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderedRemediationActions(List<RemediationActionWithOrder>)
         */
        Builder orderedRemediationActions(Consumer<RemediationActionWithOrder.Builder>... orderedRemediationActions);

        /**
         * <p>
         * Information about whether an action is taken by default.
         * </p>
         * 
         * @param isDefaultAction
         *        Information about whether an action is taken by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultAction(Boolean isDefaultAction);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private List<RemediationActionWithOrder> orderedRemediationActions = DefaultSdkAutoConstructList.getInstance();

        private Boolean isDefaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(PossibleRemediationAction model) {
            description(model.description);
            orderedRemediationActions(model.orderedRemediationActions);
            isDefaultAction(model.isDefaultAction);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<RemediationActionWithOrder.Builder> getOrderedRemediationActions() {
            List<RemediationActionWithOrder.Builder> result = OrderedRemediationActionsCopier
                    .copyToBuilder(this.orderedRemediationActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder orderedRemediationActions(Collection<RemediationActionWithOrder> orderedRemediationActions) {
            this.orderedRemediationActions = OrderedRemediationActionsCopier.copy(orderedRemediationActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedRemediationActions(RemediationActionWithOrder... orderedRemediationActions) {
            orderedRemediationActions(Arrays.asList(orderedRemediationActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedRemediationActions(Consumer<RemediationActionWithOrder.Builder>... orderedRemediationActions) {
            orderedRemediationActions(Stream.of(orderedRemediationActions)
                    .map(c -> RemediationActionWithOrder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderedRemediationActions(
                Collection<RemediationActionWithOrder.BuilderImpl> orderedRemediationActions) {
            this.orderedRemediationActions = OrderedRemediationActionsCopier.copyFromBuilder(orderedRemediationActions);
        }

        public final Boolean getIsDefaultAction() {
            return isDefaultAction;
        }

        @Override
        public final Builder isDefaultAction(Boolean isDefaultAction) {
            this.isDefaultAction = isDefaultAction;
            return this;
        }

        public final void setIsDefaultAction(Boolean isDefaultAction) {
            this.isDefaultAction = isDefaultAction;
        }

        @Override
        public PossibleRemediationAction build() {
            return new PossibleRemediationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
