/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of possible remediation action lists. Each individual possible remediation action is a list of individual
 * remediation actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PossibleRemediationActions implements SdkPojo, Serializable,
        ToCopyableBuilder<PossibleRemediationActions.Builder, PossibleRemediationActions> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PossibleRemediationActions::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<PossibleRemediationAction>> ACTIONS_FIELD = SdkField
            .<List<PossibleRemediationAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(PossibleRemediationActions::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PossibleRemediationAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(PossibleRemediationAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final List<PossibleRemediationAction> actions;

    private PossibleRemediationActions(BuilderImpl builder) {
        this.description = builder.description;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * A description of the possible remediation actions list.
     * </p>
     * 
     * @return A description of the possible remediation actions list.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the actions.
     */
    public final List<PossibleRemediationAction> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PossibleRemediationActions)) {
            return false;
        }
        PossibleRemediationActions other = (PossibleRemediationActions) obj;
        return Objects.equals(description(), other.description()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PossibleRemediationActions").add("Description", description())
                .add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PossibleRemediationActions, T> g) {
        return obj -> g.apply((PossibleRemediationActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PossibleRemediationActions> {
        /**
         * <p>
         * A description of the possible remediation actions list.
         * </p>
         * 
         * @param description
         *        A description of the possible remediation actions list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the actions.
         * </p>
         * 
         * @param actions
         *        Information about the actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<PossibleRemediationAction> actions);

        /**
         * <p>
         * Information about the actions.
         * </p>
         * 
         * @param actions
         *        Information about the actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(PossibleRemediationAction... actions);

        /**
         * <p>
         * Information about the actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PossibleRemediationAction>.Builder}
         * avoiding the need to create one manually via {@link List<PossibleRemediationAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PossibleRemediationAction>.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<PossibleRemediationAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<PossibleRemediationAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<PossibleRemediationAction>)
         */
        Builder actions(Consumer<PossibleRemediationAction.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private List<PossibleRemediationAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PossibleRemediationActions model) {
            description(model.description);
            actions(model.actions);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<PossibleRemediationAction.Builder> getActions() {
            List<PossibleRemediationAction.Builder> result = PossibleRemediationActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder actions(Collection<PossibleRemediationAction> actions) {
            this.actions = PossibleRemediationActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(PossibleRemediationAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<PossibleRemediationAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> PossibleRemediationAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<PossibleRemediationAction.BuilderImpl> actions) {
            this.actions = PossibleRemediationActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public PossibleRemediationActions build() {
            return new PossibleRemediationActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
