/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an individual action you can take to remediate a violation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationAction.Builder, RemediationAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RemediationAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<EC2CreateRouteAction> EC2_CREATE_ROUTE_ACTION_FIELD = SdkField
            .<EC2CreateRouteAction> builder(MarshallingType.SDK_POJO).memberName("EC2CreateRouteAction")
            .getter(getter(RemediationAction::ec2CreateRouteAction)).setter(setter(Builder::ec2CreateRouteAction))
            .constructor(EC2CreateRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2CreateRouteAction").build())
            .build();

    private static final SdkField<EC2ReplaceRouteAction> EC2_REPLACE_ROUTE_ACTION_FIELD = SdkField
            .<EC2ReplaceRouteAction> builder(MarshallingType.SDK_POJO).memberName("EC2ReplaceRouteAction")
            .getter(getter(RemediationAction::ec2ReplaceRouteAction)).setter(setter(Builder::ec2ReplaceRouteAction))
            .constructor(EC2ReplaceRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ReplaceRouteAction").build())
            .build();

    private static final SdkField<EC2DeleteRouteAction> EC2_DELETE_ROUTE_ACTION_FIELD = SdkField
            .<EC2DeleteRouteAction> builder(MarshallingType.SDK_POJO).memberName("EC2DeleteRouteAction")
            .getter(getter(RemediationAction::ec2DeleteRouteAction)).setter(setter(Builder::ec2DeleteRouteAction))
            .constructor(EC2DeleteRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2DeleteRouteAction").build())
            .build();

    private static final SdkField<EC2CopyRouteTableAction> EC2_COPY_ROUTE_TABLE_ACTION_FIELD = SdkField
            .<EC2CopyRouteTableAction> builder(MarshallingType.SDK_POJO).memberName("EC2CopyRouteTableAction")
            .getter(getter(RemediationAction::ec2CopyRouteTableAction)).setter(setter(Builder::ec2CopyRouteTableAction))
            .constructor(EC2CopyRouteTableAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2CopyRouteTableAction").build())
            .build();

    private static final SdkField<EC2ReplaceRouteTableAssociationAction> EC2_REPLACE_ROUTE_TABLE_ASSOCIATION_ACTION_FIELD = SdkField
            .<EC2ReplaceRouteTableAssociationAction> builder(MarshallingType.SDK_POJO)
            .memberName("EC2ReplaceRouteTableAssociationAction")
            .getter(getter(RemediationAction::ec2ReplaceRouteTableAssociationAction))
            .setter(setter(Builder::ec2ReplaceRouteTableAssociationAction))
            .constructor(EC2ReplaceRouteTableAssociationAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EC2ReplaceRouteTableAssociationAction").build()).build();

    private static final SdkField<EC2AssociateRouteTableAction> EC2_ASSOCIATE_ROUTE_TABLE_ACTION_FIELD = SdkField
            .<EC2AssociateRouteTableAction> builder(MarshallingType.SDK_POJO)
            .memberName("EC2AssociateRouteTableAction")
            .getter(getter(RemediationAction::ec2AssociateRouteTableAction))
            .setter(setter(Builder::ec2AssociateRouteTableAction))
            .constructor(EC2AssociateRouteTableAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2AssociateRouteTableAction")
                    .build()).build();

    private static final SdkField<EC2CreateRouteTableAction> EC2_CREATE_ROUTE_TABLE_ACTION_FIELD = SdkField
            .<EC2CreateRouteTableAction> builder(MarshallingType.SDK_POJO).memberName("EC2CreateRouteTableAction")
            .getter(getter(RemediationAction::ec2CreateRouteTableAction)).setter(setter(Builder::ec2CreateRouteTableAction))
            .constructor(EC2CreateRouteTableAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2CreateRouteTableAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EC2_CREATE_ROUTE_ACTION_FIELD, EC2_REPLACE_ROUTE_ACTION_FIELD, EC2_DELETE_ROUTE_ACTION_FIELD,
            EC2_COPY_ROUTE_TABLE_ACTION_FIELD, EC2_REPLACE_ROUTE_TABLE_ASSOCIATION_ACTION_FIELD,
            EC2_ASSOCIATE_ROUTE_TABLE_ACTION_FIELD, EC2_CREATE_ROUTE_TABLE_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final EC2CreateRouteAction ec2CreateRouteAction;

    private final EC2ReplaceRouteAction ec2ReplaceRouteAction;

    private final EC2DeleteRouteAction ec2DeleteRouteAction;

    private final EC2CopyRouteTableAction ec2CopyRouteTableAction;

    private final EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction;

    private final EC2AssociateRouteTableAction ec2AssociateRouteTableAction;

    private final EC2CreateRouteTableAction ec2CreateRouteTableAction;

    private RemediationAction(BuilderImpl builder) {
        this.description = builder.description;
        this.ec2CreateRouteAction = builder.ec2CreateRouteAction;
        this.ec2ReplaceRouteAction = builder.ec2ReplaceRouteAction;
        this.ec2DeleteRouteAction = builder.ec2DeleteRouteAction;
        this.ec2CopyRouteTableAction = builder.ec2CopyRouteTableAction;
        this.ec2ReplaceRouteTableAssociationAction = builder.ec2ReplaceRouteTableAssociationAction;
        this.ec2AssociateRouteTableAction = builder.ec2AssociateRouteTableAction;
        this.ec2CreateRouteTableAction = builder.ec2CreateRouteTableAction;
    }

    /**
     * <p>
     * A description of a remediation action.
     * </p>
     * 
     * @return A description of a remediation action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the CreateRoute action in the Amazon EC2 API.
     * </p>
     * 
     * @return Information about the CreateRoute action in the Amazon EC2 API.
     */
    public final EC2CreateRouteAction ec2CreateRouteAction() {
        return ec2CreateRouteAction;
    }

    /**
     * <p>
     * Information about the ReplaceRoute action in the Amazon EC2 API.
     * </p>
     * 
     * @return Information about the ReplaceRoute action in the Amazon EC2 API.
     */
    public final EC2ReplaceRouteAction ec2ReplaceRouteAction() {
        return ec2ReplaceRouteAction;
    }

    /**
     * <p>
     * Information about the DeleteRoute action in the Amazon EC2 API.
     * </p>
     * 
     * @return Information about the DeleteRoute action in the Amazon EC2 API.
     */
    public final EC2DeleteRouteAction ec2DeleteRouteAction() {
        return ec2DeleteRouteAction;
    }

    /**
     * <p>
     * Information about the CopyRouteTable action in the Amazon EC2 API.
     * </p>
     * 
     * @return Information about the CopyRouteTable action in the Amazon EC2 API.
     */
    public final EC2CopyRouteTableAction ec2CopyRouteTableAction() {
        return ec2CopyRouteTableAction;
    }

    /**
     * <p>
     * Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.
     * </p>
     * 
     * @return Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.
     */
    public final EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction() {
        return ec2ReplaceRouteTableAssociationAction;
    }

    /**
     * <p>
     * Information about the AssociateRouteTable action in the Amazon EC2 API.
     * </p>
     * 
     * @return Information about the AssociateRouteTable action in the Amazon EC2 API.
     */
    public final EC2AssociateRouteTableAction ec2AssociateRouteTableAction() {
        return ec2AssociateRouteTableAction;
    }

    /**
     * <p>
     * Information about the CreateRouteTable action in the Amazon EC2 API.
     * </p>
     * 
     * @return Information about the CreateRouteTable action in the Amazon EC2 API.
     */
    public final EC2CreateRouteTableAction ec2CreateRouteTableAction() {
        return ec2CreateRouteTableAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ec2CreateRouteAction());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ReplaceRouteAction());
        hashCode = 31 * hashCode + Objects.hashCode(ec2DeleteRouteAction());
        hashCode = 31 * hashCode + Objects.hashCode(ec2CopyRouteTableAction());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ReplaceRouteTableAssociationAction());
        hashCode = 31 * hashCode + Objects.hashCode(ec2AssociateRouteTableAction());
        hashCode = 31 * hashCode + Objects.hashCode(ec2CreateRouteTableAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationAction)) {
            return false;
        }
        RemediationAction other = (RemediationAction) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(ec2CreateRouteAction(), other.ec2CreateRouteAction())
                && Objects.equals(ec2ReplaceRouteAction(), other.ec2ReplaceRouteAction())
                && Objects.equals(ec2DeleteRouteAction(), other.ec2DeleteRouteAction())
                && Objects.equals(ec2CopyRouteTableAction(), other.ec2CopyRouteTableAction())
                && Objects.equals(ec2ReplaceRouteTableAssociationAction(), other.ec2ReplaceRouteTableAssociationAction())
                && Objects.equals(ec2AssociateRouteTableAction(), other.ec2AssociateRouteTableAction())
                && Objects.equals(ec2CreateRouteTableAction(), other.ec2CreateRouteTableAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemediationAction").add("Description", description())
                .add("EC2CreateRouteAction", ec2CreateRouteAction()).add("EC2ReplaceRouteAction", ec2ReplaceRouteAction())
                .add("EC2DeleteRouteAction", ec2DeleteRouteAction()).add("EC2CopyRouteTableAction", ec2CopyRouteTableAction())
                .add("EC2ReplaceRouteTableAssociationAction", ec2ReplaceRouteTableAssociationAction())
                .add("EC2AssociateRouteTableAction", ec2AssociateRouteTableAction())
                .add("EC2CreateRouteTableAction", ec2CreateRouteTableAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EC2CreateRouteAction":
            return Optional.ofNullable(clazz.cast(ec2CreateRouteAction()));
        case "EC2ReplaceRouteAction":
            return Optional.ofNullable(clazz.cast(ec2ReplaceRouteAction()));
        case "EC2DeleteRouteAction":
            return Optional.ofNullable(clazz.cast(ec2DeleteRouteAction()));
        case "EC2CopyRouteTableAction":
            return Optional.ofNullable(clazz.cast(ec2CopyRouteTableAction()));
        case "EC2ReplaceRouteTableAssociationAction":
            return Optional.ofNullable(clazz.cast(ec2ReplaceRouteTableAssociationAction()));
        case "EC2AssociateRouteTableAction":
            return Optional.ofNullable(clazz.cast(ec2AssociateRouteTableAction()));
        case "EC2CreateRouteTableAction":
            return Optional.ofNullable(clazz.cast(ec2CreateRouteTableAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationAction, T> g) {
        return obj -> g.apply((RemediationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationAction> {
        /**
         * <p>
         * A description of a remediation action.
         * </p>
         * 
         * @param description
         *        A description of a remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the CreateRoute action in the Amazon EC2 API.
         * </p>
         * 
         * @param ec2CreateRouteAction
         *        Information about the CreateRoute action in the Amazon EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2CreateRouteAction(EC2CreateRouteAction ec2CreateRouteAction);

        /**
         * <p>
         * Information about the CreateRoute action in the Amazon EC2 API.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2CreateRouteAction.Builder} avoiding the need
         * to create one manually via {@link EC2CreateRouteAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2CreateRouteAction.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2CreateRouteAction(EC2CreateRouteAction)}.
         * 
         * @param ec2CreateRouteAction
         *        a consumer that will call methods on {@link EC2CreateRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2CreateRouteAction(EC2CreateRouteAction)
         */
        default Builder ec2CreateRouteAction(Consumer<EC2CreateRouteAction.Builder> ec2CreateRouteAction) {
            return ec2CreateRouteAction(EC2CreateRouteAction.builder().applyMutation(ec2CreateRouteAction).build());
        }

        /**
         * <p>
         * Information about the ReplaceRoute action in the Amazon EC2 API.
         * </p>
         * 
         * @param ec2ReplaceRouteAction
         *        Information about the ReplaceRoute action in the Amazon EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ReplaceRouteAction(EC2ReplaceRouteAction ec2ReplaceRouteAction);

        /**
         * <p>
         * Information about the ReplaceRoute action in the Amazon EC2 API.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2ReplaceRouteAction.Builder} avoiding the need
         * to create one manually via {@link EC2ReplaceRouteAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2ReplaceRouteAction.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2ReplaceRouteAction(EC2ReplaceRouteAction)}.
         * 
         * @param ec2ReplaceRouteAction
         *        a consumer that will call methods on {@link EC2ReplaceRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2ReplaceRouteAction(EC2ReplaceRouteAction)
         */
        default Builder ec2ReplaceRouteAction(Consumer<EC2ReplaceRouteAction.Builder> ec2ReplaceRouteAction) {
            return ec2ReplaceRouteAction(EC2ReplaceRouteAction.builder().applyMutation(ec2ReplaceRouteAction).build());
        }

        /**
         * <p>
         * Information about the DeleteRoute action in the Amazon EC2 API.
         * </p>
         * 
         * @param ec2DeleteRouteAction
         *        Information about the DeleteRoute action in the Amazon EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2DeleteRouteAction(EC2DeleteRouteAction ec2DeleteRouteAction);

        /**
         * <p>
         * Information about the DeleteRoute action in the Amazon EC2 API.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2DeleteRouteAction.Builder} avoiding the need
         * to create one manually via {@link EC2DeleteRouteAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2DeleteRouteAction.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2DeleteRouteAction(EC2DeleteRouteAction)}.
         * 
         * @param ec2DeleteRouteAction
         *        a consumer that will call methods on {@link EC2DeleteRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2DeleteRouteAction(EC2DeleteRouteAction)
         */
        default Builder ec2DeleteRouteAction(Consumer<EC2DeleteRouteAction.Builder> ec2DeleteRouteAction) {
            return ec2DeleteRouteAction(EC2DeleteRouteAction.builder().applyMutation(ec2DeleteRouteAction).build());
        }

        /**
         * <p>
         * Information about the CopyRouteTable action in the Amazon EC2 API.
         * </p>
         * 
         * @param ec2CopyRouteTableAction
         *        Information about the CopyRouteTable action in the Amazon EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2CopyRouteTableAction(EC2CopyRouteTableAction ec2CopyRouteTableAction);

        /**
         * <p>
         * Information about the CopyRouteTable action in the Amazon EC2 API.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2CopyRouteTableAction.Builder} avoiding the
         * need to create one manually via {@link EC2CopyRouteTableAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2CopyRouteTableAction.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2CopyRouteTableAction(EC2CopyRouteTableAction)}.
         * 
         * @param ec2CopyRouteTableAction
         *        a consumer that will call methods on {@link EC2CopyRouteTableAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2CopyRouteTableAction(EC2CopyRouteTableAction)
         */
        default Builder ec2CopyRouteTableAction(Consumer<EC2CopyRouteTableAction.Builder> ec2CopyRouteTableAction) {
            return ec2CopyRouteTableAction(EC2CopyRouteTableAction.builder().applyMutation(ec2CopyRouteTableAction).build());
        }

        /**
         * <p>
         * Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.
         * </p>
         * 
         * @param ec2ReplaceRouteTableAssociationAction
         *        Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ReplaceRouteTableAssociationAction(EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction);

        /**
         * <p>
         * Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2ReplaceRouteTableAssociationAction.Builder}
         * avoiding the need to create one manually via {@link EC2ReplaceRouteTableAssociationAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2ReplaceRouteTableAssociationAction.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #ec2ReplaceRouteTableAssociationAction(EC2ReplaceRouteTableAssociationAction)}.
         * 
         * @param ec2ReplaceRouteTableAssociationAction
         *        a consumer that will call methods on {@link EC2ReplaceRouteTableAssociationAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2ReplaceRouteTableAssociationAction(EC2ReplaceRouteTableAssociationAction)
         */
        default Builder ec2ReplaceRouteTableAssociationAction(
                Consumer<EC2ReplaceRouteTableAssociationAction.Builder> ec2ReplaceRouteTableAssociationAction) {
            return ec2ReplaceRouteTableAssociationAction(EC2ReplaceRouteTableAssociationAction.builder()
                    .applyMutation(ec2ReplaceRouteTableAssociationAction).build());
        }

        /**
         * <p>
         * Information about the AssociateRouteTable action in the Amazon EC2 API.
         * </p>
         * 
         * @param ec2AssociateRouteTableAction
         *        Information about the AssociateRouteTable action in the Amazon EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2AssociateRouteTableAction(EC2AssociateRouteTableAction ec2AssociateRouteTableAction);

        /**
         * <p>
         * Information about the AssociateRouteTable action in the Amazon EC2 API.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2AssociateRouteTableAction.Builder} avoiding
         * the need to create one manually via {@link EC2AssociateRouteTableAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2AssociateRouteTableAction.Builder#build()} is called
         * immediately and its result is passed to {@link #ec2AssociateRouteTableAction(EC2AssociateRouteTableAction)}.
         * 
         * @param ec2AssociateRouteTableAction
         *        a consumer that will call methods on {@link EC2AssociateRouteTableAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2AssociateRouteTableAction(EC2AssociateRouteTableAction)
         */
        default Builder ec2AssociateRouteTableAction(Consumer<EC2AssociateRouteTableAction.Builder> ec2AssociateRouteTableAction) {
            return ec2AssociateRouteTableAction(EC2AssociateRouteTableAction.builder()
                    .applyMutation(ec2AssociateRouteTableAction).build());
        }

        /**
         * <p>
         * Information about the CreateRouteTable action in the Amazon EC2 API.
         * </p>
         * 
         * @param ec2CreateRouteTableAction
         *        Information about the CreateRouteTable action in the Amazon EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2CreateRouteTableAction(EC2CreateRouteTableAction ec2CreateRouteTableAction);

        /**
         * <p>
         * Information about the CreateRouteTable action in the Amazon EC2 API.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2CreateRouteTableAction.Builder} avoiding the
         * need to create one manually via {@link EC2CreateRouteTableAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2CreateRouteTableAction.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2CreateRouteTableAction(EC2CreateRouteTableAction)}.
         * 
         * @param ec2CreateRouteTableAction
         *        a consumer that will call methods on {@link EC2CreateRouteTableAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2CreateRouteTableAction(EC2CreateRouteTableAction)
         */
        default Builder ec2CreateRouteTableAction(Consumer<EC2CreateRouteTableAction.Builder> ec2CreateRouteTableAction) {
            return ec2CreateRouteTableAction(EC2CreateRouteTableAction.builder().applyMutation(ec2CreateRouteTableAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private EC2CreateRouteAction ec2CreateRouteAction;

        private EC2ReplaceRouteAction ec2ReplaceRouteAction;

        private EC2DeleteRouteAction ec2DeleteRouteAction;

        private EC2CopyRouteTableAction ec2CopyRouteTableAction;

        private EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction;

        private EC2AssociateRouteTableAction ec2AssociateRouteTableAction;

        private EC2CreateRouteTableAction ec2CreateRouteTableAction;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationAction model) {
            description(model.description);
            ec2CreateRouteAction(model.ec2CreateRouteAction);
            ec2ReplaceRouteAction(model.ec2ReplaceRouteAction);
            ec2DeleteRouteAction(model.ec2DeleteRouteAction);
            ec2CopyRouteTableAction(model.ec2CopyRouteTableAction);
            ec2ReplaceRouteTableAssociationAction(model.ec2ReplaceRouteTableAssociationAction);
            ec2AssociateRouteTableAction(model.ec2AssociateRouteTableAction);
            ec2CreateRouteTableAction(model.ec2CreateRouteTableAction);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final EC2CreateRouteAction.Builder getEc2CreateRouteAction() {
            return ec2CreateRouteAction != null ? ec2CreateRouteAction.toBuilder() : null;
        }

        @Override
        public final Builder ec2CreateRouteAction(EC2CreateRouteAction ec2CreateRouteAction) {
            this.ec2CreateRouteAction = ec2CreateRouteAction;
            return this;
        }

        public final void setEc2CreateRouteAction(EC2CreateRouteAction.BuilderImpl ec2CreateRouteAction) {
            this.ec2CreateRouteAction = ec2CreateRouteAction != null ? ec2CreateRouteAction.build() : null;
        }

        public final EC2ReplaceRouteAction.Builder getEc2ReplaceRouteAction() {
            return ec2ReplaceRouteAction != null ? ec2ReplaceRouteAction.toBuilder() : null;
        }

        @Override
        public final Builder ec2ReplaceRouteAction(EC2ReplaceRouteAction ec2ReplaceRouteAction) {
            this.ec2ReplaceRouteAction = ec2ReplaceRouteAction;
            return this;
        }

        public final void setEc2ReplaceRouteAction(EC2ReplaceRouteAction.BuilderImpl ec2ReplaceRouteAction) {
            this.ec2ReplaceRouteAction = ec2ReplaceRouteAction != null ? ec2ReplaceRouteAction.build() : null;
        }

        public final EC2DeleteRouteAction.Builder getEc2DeleteRouteAction() {
            return ec2DeleteRouteAction != null ? ec2DeleteRouteAction.toBuilder() : null;
        }

        @Override
        public final Builder ec2DeleteRouteAction(EC2DeleteRouteAction ec2DeleteRouteAction) {
            this.ec2DeleteRouteAction = ec2DeleteRouteAction;
            return this;
        }

        public final void setEc2DeleteRouteAction(EC2DeleteRouteAction.BuilderImpl ec2DeleteRouteAction) {
            this.ec2DeleteRouteAction = ec2DeleteRouteAction != null ? ec2DeleteRouteAction.build() : null;
        }

        public final EC2CopyRouteTableAction.Builder getEc2CopyRouteTableAction() {
            return ec2CopyRouteTableAction != null ? ec2CopyRouteTableAction.toBuilder() : null;
        }

        @Override
        public final Builder ec2CopyRouteTableAction(EC2CopyRouteTableAction ec2CopyRouteTableAction) {
            this.ec2CopyRouteTableAction = ec2CopyRouteTableAction;
            return this;
        }

        public final void setEc2CopyRouteTableAction(EC2CopyRouteTableAction.BuilderImpl ec2CopyRouteTableAction) {
            this.ec2CopyRouteTableAction = ec2CopyRouteTableAction != null ? ec2CopyRouteTableAction.build() : null;
        }

        public final EC2ReplaceRouteTableAssociationAction.Builder getEc2ReplaceRouteTableAssociationAction() {
            return ec2ReplaceRouteTableAssociationAction != null ? ec2ReplaceRouteTableAssociationAction.toBuilder() : null;
        }

        @Override
        public final Builder ec2ReplaceRouteTableAssociationAction(
                EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction) {
            this.ec2ReplaceRouteTableAssociationAction = ec2ReplaceRouteTableAssociationAction;
            return this;
        }

        public final void setEc2ReplaceRouteTableAssociationAction(
                EC2ReplaceRouteTableAssociationAction.BuilderImpl ec2ReplaceRouteTableAssociationAction) {
            this.ec2ReplaceRouteTableAssociationAction = ec2ReplaceRouteTableAssociationAction != null ? ec2ReplaceRouteTableAssociationAction
                    .build() : null;
        }

        public final EC2AssociateRouteTableAction.Builder getEc2AssociateRouteTableAction() {
            return ec2AssociateRouteTableAction != null ? ec2AssociateRouteTableAction.toBuilder() : null;
        }

        @Override
        public final Builder ec2AssociateRouteTableAction(EC2AssociateRouteTableAction ec2AssociateRouteTableAction) {
            this.ec2AssociateRouteTableAction = ec2AssociateRouteTableAction;
            return this;
        }

        public final void setEc2AssociateRouteTableAction(EC2AssociateRouteTableAction.BuilderImpl ec2AssociateRouteTableAction) {
            this.ec2AssociateRouteTableAction = ec2AssociateRouteTableAction != null ? ec2AssociateRouteTableAction.build()
                    : null;
        }

        public final EC2CreateRouteTableAction.Builder getEc2CreateRouteTableAction() {
            return ec2CreateRouteTableAction != null ? ec2CreateRouteTableAction.toBuilder() : null;
        }

        @Override
        public final Builder ec2CreateRouteTableAction(EC2CreateRouteTableAction ec2CreateRouteTableAction) {
            this.ec2CreateRouteTableAction = ec2CreateRouteTableAction;
            return this;
        }

        public final void setEc2CreateRouteTableAction(EC2CreateRouteTableAction.BuilderImpl ec2CreateRouteTableAction) {
            this.ec2CreateRouteTableAction = ec2CreateRouteTableAction != null ? ec2CreateRouteTableAction.build() : null;
        }

        @Override
        public RemediationAction build() {
            return new RemediationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
