/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An ordered list of actions you can take to remediate a violation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationActionWithOrder implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationActionWithOrder.Builder, RemediationActionWithOrder> {
    private static final SdkField<RemediationAction> REMEDIATION_ACTION_FIELD = SdkField
            .<RemediationAction> builder(MarshallingType.SDK_POJO).memberName("RemediationAction")
            .getter(getter(RemediationActionWithOrder::remediationAction)).setter(setter(Builder::remediationAction))
            .constructor(RemediationAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationAction").build()).build();

    private static final SdkField<Integer> ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Order")
            .getter(getter(RemediationActionWithOrder::order)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMEDIATION_ACTION_FIELD,
            ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final RemediationAction remediationAction;

    private final Integer order;

    private RemediationActionWithOrder(BuilderImpl builder) {
        this.remediationAction = builder.remediationAction;
        this.order = builder.order;
    }

    /**
     * <p>
     * Information about an action you can take to remediate a violation.
     * </p>
     * 
     * @return Information about an action you can take to remediate a violation.
     */
    public final RemediationAction remediationAction() {
        return remediationAction;
    }

    /**
     * <p>
     * The order of the remediation actions in the list.
     * </p>
     * 
     * @return The order of the remediation actions in the list.
     */
    public final Integer order() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(remediationAction());
        hashCode = 31 * hashCode + Objects.hashCode(order());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationActionWithOrder)) {
            return false;
        }
        RemediationActionWithOrder other = (RemediationActionWithOrder) obj;
        return Objects.equals(remediationAction(), other.remediationAction()) && Objects.equals(order(), other.order());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemediationActionWithOrder").add("RemediationAction", remediationAction()).add("Order", order())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemediationAction":
            return Optional.ofNullable(clazz.cast(remediationAction()));
        case "Order":
            return Optional.ofNullable(clazz.cast(order()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationActionWithOrder, T> g) {
        return obj -> g.apply((RemediationActionWithOrder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationActionWithOrder> {
        /**
         * <p>
         * Information about an action you can take to remediate a violation.
         * </p>
         * 
         * @param remediationAction
         *        Information about an action you can take to remediate a violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationAction(RemediationAction remediationAction);

        /**
         * <p>
         * Information about an action you can take to remediate a violation.
         * </p>
         * This is a convenience that creates an instance of the {@link RemediationAction.Builder} avoiding the need to
         * create one manually via {@link RemediationAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link RemediationAction.Builder#build()} is called immediately and its
         * result is passed to {@link #remediationAction(RemediationAction)}.
         * 
         * @param remediationAction
         *        a consumer that will call methods on {@link RemediationAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediationAction(RemediationAction)
         */
        default Builder remediationAction(Consumer<RemediationAction.Builder> remediationAction) {
            return remediationAction(RemediationAction.builder().applyMutation(remediationAction).build());
        }

        /**
         * <p>
         * The order of the remediation actions in the list.
         * </p>
         * 
         * @param order
         *        The order of the remediation actions in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Integer order);
    }

    static final class BuilderImpl implements Builder {
        private RemediationAction remediationAction;

        private Integer order;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationActionWithOrder model) {
            remediationAction(model.remediationAction);
            order(model.order);
        }

        public final RemediationAction.Builder getRemediationAction() {
            return remediationAction != null ? remediationAction.toBuilder() : null;
        }

        @Override
        public final Builder remediationAction(RemediationAction remediationAction) {
            this.remediationAction = remediationAction;
            return this;
        }

        public final void setRemediationAction(RemediationAction.BuilderImpl remediationAction) {
            this.remediationAction = remediationAction != null ? remediationAction.build() : null;
        }

        public final Integer getOrder() {
            return order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public RemediationActionWithOrder build() {
            return new RemediationActionWithOrder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
