/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the Network Firewall firewall policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallPolicyDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFirewallPolicyDescription.Builder, NetworkFirewallPolicyDescription> {
    private static final SdkField<List<StatelessRuleGroup>> STATELESS_RULE_GROUPS_FIELD = SdkField
            .<List<StatelessRuleGroup>> builder(MarshallingType.LIST)
            .memberName("StatelessRuleGroups")
            .getter(getter(NetworkFirewallPolicyDescription::statelessRuleGroups))
            .setter(setter(Builder::statelessRuleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRuleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatelessRuleGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatelessRuleGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessDefaultActions")
            .getter(getter(NetworkFirewallPolicyDescription::statelessDefaultActions))
            .setter(setter(Builder::statelessDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessDefaultActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessFragmentDefaultActions")
            .getter(getter(NetworkFirewallPolicyDescription::statelessFragmentDefaultActions))
            .setter(setter(Builder::statelessFragmentDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessFragmentDefaultActions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_CUSTOM_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessCustomActions")
            .getter(getter(NetworkFirewallPolicyDescription::statelessCustomActions))
            .setter(setter(Builder::statelessCustomActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessCustomActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StatefulRuleGroup>> STATEFUL_RULE_GROUPS_FIELD = SdkField
            .<List<StatefulRuleGroup>> builder(MarshallingType.LIST)
            .memberName("StatefulRuleGroups")
            .getter(getter(NetworkFirewallPolicyDescription::statefulRuleGroups))
            .setter(setter(Builder::statefulRuleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatefulRuleGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatefulRuleGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATELESS_RULE_GROUPS_FIELD,
            STATELESS_DEFAULT_ACTIONS_FIELD, STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD, STATELESS_CUSTOM_ACTIONS_FIELD,
            STATEFUL_RULE_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StatelessRuleGroup> statelessRuleGroups;

    private final List<String> statelessDefaultActions;

    private final List<String> statelessFragmentDefaultActions;

    private final List<String> statelessCustomActions;

    private final List<StatefulRuleGroup> statefulRuleGroups;

    private NetworkFirewallPolicyDescription(BuilderImpl builder) {
        this.statelessRuleGroups = builder.statelessRuleGroups;
        this.statelessDefaultActions = builder.statelessDefaultActions;
        this.statelessFragmentDefaultActions = builder.statelessFragmentDefaultActions;
        this.statelessCustomActions = builder.statelessCustomActions;
        this.statefulRuleGroups = builder.statefulRuleGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessRuleGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatelessRuleGroups() {
        return statelessRuleGroups != null && !(statelessRuleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stateless rule groups that are used in the Network Firewall firewall policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessRuleGroups} method.
     * </p>
     * 
     * @return The stateless rule groups that are used in the Network Firewall firewall policy.
     */
    public final List<StatelessRuleGroup> statelessRuleGroups() {
        return statelessRuleGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessDefaultActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatelessDefaultActions() {
        return statelessDefaultActions != null && !(statelessDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on packets that don't match any of the stateless rule groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessDefaultActions} method.
     * </p>
     * 
     * @return The actions to take on packets that don't match any of the stateless rule groups.
     */
    public final List<String> statelessDefaultActions() {
        return statelessDefaultActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessFragmentDefaultActions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasStatelessFragmentDefaultActions() {
        return statelessFragmentDefaultActions != null && !(statelessFragmentDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on packet fragments that don't match any of the stateless rule groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessFragmentDefaultActions}
     * method.
     * </p>
     * 
     * @return The actions to take on packet fragments that don't match any of the stateless rule groups.
     */
    public final List<String> statelessFragmentDefaultActions() {
        return statelessFragmentDefaultActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessCustomActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatelessCustomActions() {
        return statelessCustomActions != null && !(statelessCustomActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Names of custom actions that are available for use in the stateless default actions settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessCustomActions} method.
     * </p>
     * 
     * @return Names of custom actions that are available for use in the stateless default actions settings.
     */
    public final List<String> statelessCustomActions() {
        return statelessCustomActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatefulRuleGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatefulRuleGroups() {
        return statefulRuleGroups != null && !(statefulRuleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stateful rule groups that are used in the Network Firewall firewall policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatefulRuleGroups} method.
     * </p>
     * 
     * @return The stateful rule groups that are used in the Network Firewall firewall policy.
     */
    public final List<StatefulRuleGroup> statefulRuleGroups() {
        return statefulRuleGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessRuleGroups() ? statelessRuleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessDefaultActions() ? statelessDefaultActions() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasStatelessFragmentDefaultActions() ? statelessFragmentDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessCustomActions() ? statelessCustomActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatefulRuleGroups() ? statefulRuleGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallPolicyDescription)) {
            return false;
        }
        NetworkFirewallPolicyDescription other = (NetworkFirewallPolicyDescription) obj;
        return hasStatelessRuleGroups() == other.hasStatelessRuleGroups()
                && Objects.equals(statelessRuleGroups(), other.statelessRuleGroups())
                && hasStatelessDefaultActions() == other.hasStatelessDefaultActions()
                && Objects.equals(statelessDefaultActions(), other.statelessDefaultActions())
                && hasStatelessFragmentDefaultActions() == other.hasStatelessFragmentDefaultActions()
                && Objects.equals(statelessFragmentDefaultActions(), other.statelessFragmentDefaultActions())
                && hasStatelessCustomActions() == other.hasStatelessCustomActions()
                && Objects.equals(statelessCustomActions(), other.statelessCustomActions())
                && hasStatefulRuleGroups() == other.hasStatefulRuleGroups()
                && Objects.equals(statefulRuleGroups(), other.statefulRuleGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("NetworkFirewallPolicyDescription")
                .add("StatelessRuleGroups", hasStatelessRuleGroups() ? statelessRuleGroups() : null)
                .add("StatelessDefaultActions", hasStatelessDefaultActions() ? statelessDefaultActions() : null)
                .add("StatelessFragmentDefaultActions",
                        hasStatelessFragmentDefaultActions() ? statelessFragmentDefaultActions() : null)
                .add("StatelessCustomActions", hasStatelessCustomActions() ? statelessCustomActions() : null)
                .add("StatefulRuleGroups", hasStatefulRuleGroups() ? statefulRuleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatelessRuleGroups":
            return Optional.ofNullable(clazz.cast(statelessRuleGroups()));
        case "StatelessDefaultActions":
            return Optional.ofNullable(clazz.cast(statelessDefaultActions()));
        case "StatelessFragmentDefaultActions":
            return Optional.ofNullable(clazz.cast(statelessFragmentDefaultActions()));
        case "StatelessCustomActions":
            return Optional.ofNullable(clazz.cast(statelessCustomActions()));
        case "StatefulRuleGroups":
            return Optional.ofNullable(clazz.cast(statefulRuleGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallPolicyDescription, T> g) {
        return obj -> g.apply((NetworkFirewallPolicyDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallPolicyDescription> {
        /**
         * <p>
         * The stateless rule groups that are used in the Network Firewall firewall policy.
         * </p>
         * 
         * @param statelessRuleGroups
         *        The stateless rule groups that are used in the Network Firewall firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRuleGroups(Collection<StatelessRuleGroup> statelessRuleGroups);

        /**
         * <p>
         * The stateless rule groups that are used in the Network Firewall firewall policy.
         * </p>
         * 
         * @param statelessRuleGroups
         *        The stateless rule groups that are used in the Network Firewall firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRuleGroups(StatelessRuleGroup... statelessRuleGroups);

        /**
         * <p>
         * The stateless rule groups that are used in the Network Firewall firewall policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StatelessRuleGroup>.Builder} avoiding the
         * need to create one manually via {@link List<StatelessRuleGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatelessRuleGroup>.Builder#build()} is called immediately
         * and its result is passed to {@link #statelessRuleGroups(List<StatelessRuleGroup>)}.
         * 
         * @param statelessRuleGroups
         *        a consumer that will call methods on {@link List<StatelessRuleGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessRuleGroups(List<StatelessRuleGroup>)
         */
        Builder statelessRuleGroups(Consumer<StatelessRuleGroup.Builder>... statelessRuleGroups);

        /**
         * <p>
         * The actions to take on packets that don't match any of the stateless rule groups.
         * </p>
         * 
         * @param statelessDefaultActions
         *        The actions to take on packets that don't match any of the stateless rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessDefaultActions(Collection<String> statelessDefaultActions);

        /**
         * <p>
         * The actions to take on packets that don't match any of the stateless rule groups.
         * </p>
         * 
         * @param statelessDefaultActions
         *        The actions to take on packets that don't match any of the stateless rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessDefaultActions(String... statelessDefaultActions);

        /**
         * <p>
         * The actions to take on packet fragments that don't match any of the stateless rule groups.
         * </p>
         * 
         * @param statelessFragmentDefaultActions
         *        The actions to take on packet fragments that don't match any of the stateless rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions);

        /**
         * <p>
         * The actions to take on packet fragments that don't match any of the stateless rule groups.
         * </p>
         * 
         * @param statelessFragmentDefaultActions
         *        The actions to take on packet fragments that don't match any of the stateless rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessFragmentDefaultActions(String... statelessFragmentDefaultActions);

        /**
         * <p>
         * Names of custom actions that are available for use in the stateless default actions settings.
         * </p>
         * 
         * @param statelessCustomActions
         *        Names of custom actions that are available for use in the stateless default actions settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessCustomActions(Collection<String> statelessCustomActions);

        /**
         * <p>
         * Names of custom actions that are available for use in the stateless default actions settings.
         * </p>
         * 
         * @param statelessCustomActions
         *        Names of custom actions that are available for use in the stateless default actions settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessCustomActions(String... statelessCustomActions);

        /**
         * <p>
         * The stateful rule groups that are used in the Network Firewall firewall policy.
         * </p>
         * 
         * @param statefulRuleGroups
         *        The stateful rule groups that are used in the Network Firewall firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleGroups(Collection<StatefulRuleGroup> statefulRuleGroups);

        /**
         * <p>
         * The stateful rule groups that are used in the Network Firewall firewall policy.
         * </p>
         * 
         * @param statefulRuleGroups
         *        The stateful rule groups that are used in the Network Firewall firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleGroups(StatefulRuleGroup... statefulRuleGroups);

        /**
         * <p>
         * The stateful rule groups that are used in the Network Firewall firewall policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StatefulRuleGroup>.Builder} avoiding the
         * need to create one manually via {@link List<StatefulRuleGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatefulRuleGroup>.Builder#build()} is called immediately
         * and its result is passed to {@link #statefulRuleGroups(List<StatefulRuleGroup>)}.
         * 
         * @param statefulRuleGroups
         *        a consumer that will call methods on {@link List<StatefulRuleGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulRuleGroups(List<StatefulRuleGroup>)
         */
        Builder statefulRuleGroups(Consumer<StatefulRuleGroup.Builder>... statefulRuleGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<StatelessRuleGroup> statelessRuleGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> statelessDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> statelessFragmentDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> statelessCustomActions = DefaultSdkAutoConstructList.getInstance();

        private List<StatefulRuleGroup> statefulRuleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallPolicyDescription model) {
            statelessRuleGroups(model.statelessRuleGroups);
            statelessDefaultActions(model.statelessDefaultActions);
            statelessFragmentDefaultActions(model.statelessFragmentDefaultActions);
            statelessCustomActions(model.statelessCustomActions);
            statefulRuleGroups(model.statefulRuleGroups);
        }

        public final List<StatelessRuleGroup.Builder> getStatelessRuleGroups() {
            List<StatelessRuleGroup.Builder> result = StatelessRuleGroupListCopier.copyToBuilder(this.statelessRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessRuleGroups(Collection<StatelessRuleGroup.BuilderImpl> statelessRuleGroups) {
            this.statelessRuleGroups = StatelessRuleGroupListCopier.copyFromBuilder(statelessRuleGroups);
        }

        @Override
        @Transient
        public final Builder statelessRuleGroups(Collection<StatelessRuleGroup> statelessRuleGroups) {
            this.statelessRuleGroups = StatelessRuleGroupListCopier.copy(statelessRuleGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statelessRuleGroups(StatelessRuleGroup... statelessRuleGroups) {
            statelessRuleGroups(Arrays.asList(statelessRuleGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statelessRuleGroups(Consumer<StatelessRuleGroup.Builder>... statelessRuleGroups) {
            statelessRuleGroups(Stream.of(statelessRuleGroups).map(c -> StatelessRuleGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStatelessDefaultActions() {
            if (statelessDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessDefaultActions;
        }

        public final void setStatelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = NetworkFirewallActionListCopier.copy(statelessDefaultActions);
        }

        @Override
        @Transient
        public final Builder statelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = NetworkFirewallActionListCopier.copy(statelessDefaultActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statelessDefaultActions(String... statelessDefaultActions) {
            statelessDefaultActions(Arrays.asList(statelessDefaultActions));
            return this;
        }

        public final Collection<String> getStatelessFragmentDefaultActions() {
            if (statelessFragmentDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessFragmentDefaultActions;
        }

        public final void setStatelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = NetworkFirewallActionListCopier.copy(statelessFragmentDefaultActions);
        }

        @Override
        @Transient
        public final Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = NetworkFirewallActionListCopier.copy(statelessFragmentDefaultActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statelessFragmentDefaultActions(String... statelessFragmentDefaultActions) {
            statelessFragmentDefaultActions(Arrays.asList(statelessFragmentDefaultActions));
            return this;
        }

        public final Collection<String> getStatelessCustomActions() {
            if (statelessCustomActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessCustomActions;
        }

        public final void setStatelessCustomActions(Collection<String> statelessCustomActions) {
            this.statelessCustomActions = NetworkFirewallActionListCopier.copy(statelessCustomActions);
        }

        @Override
        @Transient
        public final Builder statelessCustomActions(Collection<String> statelessCustomActions) {
            this.statelessCustomActions = NetworkFirewallActionListCopier.copy(statelessCustomActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statelessCustomActions(String... statelessCustomActions) {
            statelessCustomActions(Arrays.asList(statelessCustomActions));
            return this;
        }

        public final List<StatefulRuleGroup.Builder> getStatefulRuleGroups() {
            List<StatefulRuleGroup.Builder> result = StatefulRuleGroupListCopier.copyToBuilder(this.statefulRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRuleGroups(Collection<StatefulRuleGroup.BuilderImpl> statefulRuleGroups) {
            this.statefulRuleGroups = StatefulRuleGroupListCopier.copyFromBuilder(statefulRuleGroups);
        }

        @Override
        @Transient
        public final Builder statefulRuleGroups(Collection<StatefulRuleGroup> statefulRuleGroups) {
            this.statefulRuleGroups = StatefulRuleGroupListCopier.copy(statefulRuleGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statefulRuleGroups(StatefulRuleGroup... statefulRuleGroups) {
            statefulRuleGroups(Arrays.asList(statefulRuleGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statefulRuleGroups(Consumer<StatefulRuleGroup.Builder>... statefulRuleGroups) {
            statefulRuleGroups(Stream.of(statefulRuleGroups).map(c -> StatefulRuleGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public NetworkFirewallPolicyDescription build() {
            return new NetworkFirewallPolicyDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
