/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail based on resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceViolation.Builder, ResourceViolation> {
    private static final SdkField<AwsVPCSecurityGroupViolation> AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD = SdkField
            .<AwsVPCSecurityGroupViolation> builder(MarshallingType.SDK_POJO)
            .memberName("AwsVPCSecurityGroupViolation")
            .getter(getter(ResourceViolation::awsVPCSecurityGroupViolation))
            .setter(setter(Builder::awsVPCSecurityGroupViolation))
            .constructor(AwsVPCSecurityGroupViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsVPCSecurityGroupViolation")
                    .build()).build();

    private static final SdkField<AwsEc2NetworkInterfaceViolation> AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD = SdkField
            .<AwsEc2NetworkInterfaceViolation> builder(MarshallingType.SDK_POJO)
            .memberName("AwsEc2NetworkInterfaceViolation")
            .getter(getter(ResourceViolation::awsEc2NetworkInterfaceViolation))
            .setter(setter(Builder::awsEc2NetworkInterfaceViolation))
            .constructor(AwsEc2NetworkInterfaceViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterfaceViolation")
                    .build()).build();

    private static final SdkField<AwsEc2InstanceViolation> AWS_EC2_INSTANCE_VIOLATION_FIELD = SdkField
            .<AwsEc2InstanceViolation> builder(MarshallingType.SDK_POJO).memberName("AwsEc2InstanceViolation")
            .getter(getter(ResourceViolation::awsEc2InstanceViolation)).setter(setter(Builder::awsEc2InstanceViolation))
            .constructor(AwsEc2InstanceViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2InstanceViolation").build())
            .build();

    private static final SdkField<NetworkFirewallMissingFirewallViolation> NETWORK_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD = SdkField
            .<NetworkFirewallMissingFirewallViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallMissingFirewallViolation")
            .getter(getter(ResourceViolation::networkFirewallMissingFirewallViolation))
            .setter(setter(Builder::networkFirewallMissingFirewallViolation))
            .constructor(NetworkFirewallMissingFirewallViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallMissingFirewallViolation").build()).build();

    private static final SdkField<NetworkFirewallMissingSubnetViolation> NETWORK_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD = SdkField
            .<NetworkFirewallMissingSubnetViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallMissingSubnetViolation")
            .getter(getter(ResourceViolation::networkFirewallMissingSubnetViolation))
            .setter(setter(Builder::networkFirewallMissingSubnetViolation))
            .constructor(NetworkFirewallMissingSubnetViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallMissingSubnetViolation").build()).build();

    private static final SdkField<NetworkFirewallMissingExpectedRTViolation> NETWORK_FIREWALL_MISSING_EXPECTED_RT_VIOLATION_FIELD = SdkField
            .<NetworkFirewallMissingExpectedRTViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallMissingExpectedRTViolation")
            .getter(getter(ResourceViolation::networkFirewallMissingExpectedRTViolation))
            .setter(setter(Builder::networkFirewallMissingExpectedRTViolation))
            .constructor(NetworkFirewallMissingExpectedRTViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallMissingExpectedRTViolation").build()).build();

    private static final SdkField<NetworkFirewallPolicyModifiedViolation> NETWORK_FIREWALL_POLICY_MODIFIED_VIOLATION_FIELD = SdkField
            .<NetworkFirewallPolicyModifiedViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallPolicyModifiedViolation")
            .getter(getter(ResourceViolation::networkFirewallPolicyModifiedViolation))
            .setter(setter(Builder::networkFirewallPolicyModifiedViolation))
            .constructor(NetworkFirewallPolicyModifiedViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallPolicyModifiedViolation").build()).build();

    private static final SdkField<NetworkFirewallInternetTrafficNotInspectedViolation> NETWORK_FIREWALL_INTERNET_TRAFFIC_NOT_INSPECTED_VIOLATION_FIELD = SdkField
            .<NetworkFirewallInternetTrafficNotInspectedViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallInternetTrafficNotInspectedViolation")
            .getter(getter(ResourceViolation::networkFirewallInternetTrafficNotInspectedViolation))
            .setter(setter(Builder::networkFirewallInternetTrafficNotInspectedViolation))
            .constructor(NetworkFirewallInternetTrafficNotInspectedViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallInternetTrafficNotInspectedViolation").build()).build();

    private static final SdkField<NetworkFirewallInvalidRouteConfigurationViolation> NETWORK_FIREWALL_INVALID_ROUTE_CONFIGURATION_VIOLATION_FIELD = SdkField
            .<NetworkFirewallInvalidRouteConfigurationViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallInvalidRouteConfigurationViolation")
            .getter(getter(ResourceViolation::networkFirewallInvalidRouteConfigurationViolation))
            .setter(setter(Builder::networkFirewallInvalidRouteConfigurationViolation))
            .constructor(NetworkFirewallInvalidRouteConfigurationViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallInvalidRouteConfigurationViolation").build()).build();

    private static final SdkField<NetworkFirewallBlackHoleRouteDetectedViolation> NETWORK_FIREWALL_BLACK_HOLE_ROUTE_DETECTED_VIOLATION_FIELD = SdkField
            .<NetworkFirewallBlackHoleRouteDetectedViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallBlackHoleRouteDetectedViolation")
            .getter(getter(ResourceViolation::networkFirewallBlackHoleRouteDetectedViolation))
            .setter(setter(Builder::networkFirewallBlackHoleRouteDetectedViolation))
            .constructor(NetworkFirewallBlackHoleRouteDetectedViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallBlackHoleRouteDetectedViolation").build()).build();

    private static final SdkField<NetworkFirewallUnexpectedFirewallRoutesViolation> NETWORK_FIREWALL_UNEXPECTED_FIREWALL_ROUTES_VIOLATION_FIELD = SdkField
            .<NetworkFirewallUnexpectedFirewallRoutesViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallUnexpectedFirewallRoutesViolation")
            .getter(getter(ResourceViolation::networkFirewallUnexpectedFirewallRoutesViolation))
            .setter(setter(Builder::networkFirewallUnexpectedFirewallRoutesViolation))
            .constructor(NetworkFirewallUnexpectedFirewallRoutesViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallUnexpectedFirewallRoutesViolation").build()).build();

    private static final SdkField<NetworkFirewallUnexpectedGatewayRoutesViolation> NETWORK_FIREWALL_UNEXPECTED_GATEWAY_ROUTES_VIOLATION_FIELD = SdkField
            .<NetworkFirewallUnexpectedGatewayRoutesViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallUnexpectedGatewayRoutesViolation")
            .getter(getter(ResourceViolation::networkFirewallUnexpectedGatewayRoutesViolation))
            .setter(setter(Builder::networkFirewallUnexpectedGatewayRoutesViolation))
            .constructor(NetworkFirewallUnexpectedGatewayRoutesViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallUnexpectedGatewayRoutesViolation").build()).build();

    private static final SdkField<NetworkFirewallMissingExpectedRoutesViolation> NETWORK_FIREWALL_MISSING_EXPECTED_ROUTES_VIOLATION_FIELD = SdkField
            .<NetworkFirewallMissingExpectedRoutesViolation> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkFirewallMissingExpectedRoutesViolation")
            .getter(getter(ResourceViolation::networkFirewallMissingExpectedRoutesViolation))
            .setter(setter(Builder::networkFirewallMissingExpectedRoutesViolation))
            .constructor(NetworkFirewallMissingExpectedRoutesViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkFirewallMissingExpectedRoutesViolation").build()).build();

    private static final SdkField<DnsRuleGroupPriorityConflictViolation> DNS_RULE_GROUP_PRIORITY_CONFLICT_VIOLATION_FIELD = SdkField
            .<DnsRuleGroupPriorityConflictViolation> builder(MarshallingType.SDK_POJO)
            .memberName("DnsRuleGroupPriorityConflictViolation")
            .getter(getter(ResourceViolation::dnsRuleGroupPriorityConflictViolation))
            .setter(setter(Builder::dnsRuleGroupPriorityConflictViolation))
            .constructor(DnsRuleGroupPriorityConflictViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DnsRuleGroupPriorityConflictViolation").build()).build();

    private static final SdkField<DnsDuplicateRuleGroupViolation> DNS_DUPLICATE_RULE_GROUP_VIOLATION_FIELD = SdkField
            .<DnsDuplicateRuleGroupViolation> builder(MarshallingType.SDK_POJO)
            .memberName("DnsDuplicateRuleGroupViolation")
            .getter(getter(ResourceViolation::dnsDuplicateRuleGroupViolation))
            .setter(setter(Builder::dnsDuplicateRuleGroupViolation))
            .constructor(DnsDuplicateRuleGroupViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsDuplicateRuleGroupViolation")
                    .build()).build();

    private static final SdkField<DnsRuleGroupLimitExceededViolation> DNS_RULE_GROUP_LIMIT_EXCEEDED_VIOLATION_FIELD = SdkField
            .<DnsRuleGroupLimitExceededViolation> builder(MarshallingType.SDK_POJO)
            .memberName("DnsRuleGroupLimitExceededViolation")
            .getter(getter(ResourceViolation::dnsRuleGroupLimitExceededViolation))
            .setter(setter(Builder::dnsRuleGroupLimitExceededViolation))
            .constructor(DnsRuleGroupLimitExceededViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRuleGroupLimitExceededViolation")
                    .build()).build();

    private static final SdkField<PossibleRemediationActions> POSSIBLE_REMEDIATION_ACTIONS_FIELD = SdkField
            .<PossibleRemediationActions> builder(MarshallingType.SDK_POJO)
            .memberName("PossibleRemediationActions")
            .getter(getter(ResourceViolation::possibleRemediationActions))
            .setter(setter(Builder::possibleRemediationActions))
            .constructor(PossibleRemediationActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PossibleRemediationActions").build())
            .build();

    private static final SdkField<FirewallSubnetIsOutOfScopeViolation> FIREWALL_SUBNET_IS_OUT_OF_SCOPE_VIOLATION_FIELD = SdkField
            .<FirewallSubnetIsOutOfScopeViolation> builder(MarshallingType.SDK_POJO)
            .memberName("FirewallSubnetIsOutOfScopeViolation")
            .getter(getter(ResourceViolation::firewallSubnetIsOutOfScopeViolation))
            .setter(setter(Builder::firewallSubnetIsOutOfScopeViolation))
            .constructor(FirewallSubnetIsOutOfScopeViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("FirewallSubnetIsOutOfScopeViolation").build()).build();

    private static final SdkField<RouteHasOutOfScopeEndpointViolation> ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT_VIOLATION_FIELD = SdkField
            .<RouteHasOutOfScopeEndpointViolation> builder(MarshallingType.SDK_POJO)
            .memberName("RouteHasOutOfScopeEndpointViolation")
            .getter(getter(ResourceViolation::routeHasOutOfScopeEndpointViolation))
            .setter(setter(Builder::routeHasOutOfScopeEndpointViolation))
            .constructor(RouteHasOutOfScopeEndpointViolation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RouteHasOutOfScopeEndpointViolation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD, AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD, AWS_EC2_INSTANCE_VIOLATION_FIELD,
            NETWORK_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD,
            NETWORK_FIREWALL_MISSING_EXPECTED_RT_VIOLATION_FIELD, NETWORK_FIREWALL_POLICY_MODIFIED_VIOLATION_FIELD,
            NETWORK_FIREWALL_INTERNET_TRAFFIC_NOT_INSPECTED_VIOLATION_FIELD,
            NETWORK_FIREWALL_INVALID_ROUTE_CONFIGURATION_VIOLATION_FIELD,
            NETWORK_FIREWALL_BLACK_HOLE_ROUTE_DETECTED_VIOLATION_FIELD,
            NETWORK_FIREWALL_UNEXPECTED_FIREWALL_ROUTES_VIOLATION_FIELD,
            NETWORK_FIREWALL_UNEXPECTED_GATEWAY_ROUTES_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_EXPECTED_ROUTES_VIOLATION_FIELD,
            DNS_RULE_GROUP_PRIORITY_CONFLICT_VIOLATION_FIELD, DNS_DUPLICATE_RULE_GROUP_VIOLATION_FIELD,
            DNS_RULE_GROUP_LIMIT_EXCEEDED_VIOLATION_FIELD, POSSIBLE_REMEDIATION_ACTIONS_FIELD,
            FIREWALL_SUBNET_IS_OUT_OF_SCOPE_VIOLATION_FIELD, ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT_VIOLATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;

    private final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;

    private final AwsEc2InstanceViolation awsEc2InstanceViolation;

    private final NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation;

    private final NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation;

    private final NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation;

    private final NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation;

    private final NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation;

    private final NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation;

    private final NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation;

    private final NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation;

    private final NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation;

    private final NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation;

    private final DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation;

    private final DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation;

    private final DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation;

    private final PossibleRemediationActions possibleRemediationActions;

    private final FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation;

    private final RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation;

    private ResourceViolation(BuilderImpl builder) {
        this.awsVPCSecurityGroupViolation = builder.awsVPCSecurityGroupViolation;
        this.awsEc2NetworkInterfaceViolation = builder.awsEc2NetworkInterfaceViolation;
        this.awsEc2InstanceViolation = builder.awsEc2InstanceViolation;
        this.networkFirewallMissingFirewallViolation = builder.networkFirewallMissingFirewallViolation;
        this.networkFirewallMissingSubnetViolation = builder.networkFirewallMissingSubnetViolation;
        this.networkFirewallMissingExpectedRTViolation = builder.networkFirewallMissingExpectedRTViolation;
        this.networkFirewallPolicyModifiedViolation = builder.networkFirewallPolicyModifiedViolation;
        this.networkFirewallInternetTrafficNotInspectedViolation = builder.networkFirewallInternetTrafficNotInspectedViolation;
        this.networkFirewallInvalidRouteConfigurationViolation = builder.networkFirewallInvalidRouteConfigurationViolation;
        this.networkFirewallBlackHoleRouteDetectedViolation = builder.networkFirewallBlackHoleRouteDetectedViolation;
        this.networkFirewallUnexpectedFirewallRoutesViolation = builder.networkFirewallUnexpectedFirewallRoutesViolation;
        this.networkFirewallUnexpectedGatewayRoutesViolation = builder.networkFirewallUnexpectedGatewayRoutesViolation;
        this.networkFirewallMissingExpectedRoutesViolation = builder.networkFirewallMissingExpectedRoutesViolation;
        this.dnsRuleGroupPriorityConflictViolation = builder.dnsRuleGroupPriorityConflictViolation;
        this.dnsDuplicateRuleGroupViolation = builder.dnsDuplicateRuleGroupViolation;
        this.dnsRuleGroupLimitExceededViolation = builder.dnsRuleGroupLimitExceededViolation;
        this.possibleRemediationActions = builder.possibleRemediationActions;
        this.firewallSubnetIsOutOfScopeViolation = builder.firewallSubnetIsOutOfScopeViolation;
        this.routeHasOutOfScopeEndpointViolation = builder.routeHasOutOfScopeEndpointViolation;
    }

    /**
     * <p>
     * Violation detail for security groups.
     * </p>
     * 
     * @return Violation detail for security groups.
     */
    public final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation() {
        return awsVPCSecurityGroupViolation;
    }

    /**
     * <p>
     * Violation detail for a network interface.
     * </p>
     * 
     * @return Violation detail for a network interface.
     */
    public final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation() {
        return awsEc2NetworkInterfaceViolation;
    }

    /**
     * <p>
     * Violation detail for an EC2 instance.
     * </p>
     * 
     * @return Violation detail for an EC2 instance.
     */
    public final AwsEc2InstanceViolation awsEc2InstanceViolation() {
        return awsEc2InstanceViolation;
    }

    /**
     * <p>
     * Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed
     * firewall in its VPC.
     * </p>
     * 
     * @return Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager
     *         managed firewall in its VPC.
     */
    public final NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation() {
        return networkFirewallMissingFirewallViolation;
    }

    /**
     * <p>
     * Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the expected
     * Firewall Manager managed subnet.
     * </p>
     * 
     * @return Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the
     *         expected Firewall Manager managed subnet.
     */
    public final NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation() {
        return networkFirewallMissingSubnetViolation;
    }

    /**
     * <p>
     * Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the expected
     * Firewall Manager managed route table.
     * </p>
     * 
     * @return Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the
     *         expected Firewall Manager managed route table.
     */
    public final NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation() {
        return networkFirewallMissingExpectedRTViolation;
    }

    /**
     * <p>
     * Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual account
     * has been modified in a way that makes it noncompliant. For example, the individual account owner might have
     * deleted a rule group, changed the priority of a stateless rule group, or changed a policy default action.
     * </p>
     * 
     * @return Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual
     *         account has been modified in a way that makes it noncompliant. For example, the individual account owner
     *         might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy
     *         default action.
     */
    public final NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation() {
        return networkFirewallPolicyModifiedViolation;
    }

    /**
     * <p>
     * Violation detail for the subnet for which internet traffic hasn't been inspected.
     * </p>
     * 
     * @return Violation detail for the subnet for which internet traffic hasn't been inspected.
     */
    public final NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation() {
        return networkFirewallInternetTrafficNotInspectedViolation;
    }

    /**
     * <p>
     * The route configuration is invalid.
     * </p>
     * 
     * @return The route configuration is invalid.
     */
    public final NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation() {
        return networkFirewallInvalidRouteConfigurationViolation;
    }

    /**
     * Returns the value of the NetworkFirewallBlackHoleRouteDetectedViolation property for this object.
     * 
     * @return The value of the NetworkFirewallBlackHoleRouteDetectedViolation property for this object.
     */
    public final NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation() {
        return networkFirewallBlackHoleRouteDetectedViolation;
    }

    /**
     * <p>
     * There's an unexpected firewall route.
     * </p>
     * 
     * @return There's an unexpected firewall route.
     */
    public final NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation() {
        return networkFirewallUnexpectedFirewallRoutesViolation;
    }

    /**
     * <p>
     * There's an unexpected gateway route.
     * </p>
     * 
     * @return There's an unexpected gateway route.
     */
    public final NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation() {
        return networkFirewallUnexpectedGatewayRoutesViolation;
    }

    /**
     * <p>
     * Expected routes are missing from Network Firewall.
     * </p>
     * 
     * @return Expected routes are missing from Network Firewall.
     */
    public final NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation() {
        return networkFirewallMissingExpectedRoutesViolation;
    }

    /**
     * <p>
     * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
     * associate with a VPC has the same priority as a rule group that's already associated.
     * </p>
     * 
     * @return Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried
     *         to associate with a VPC has the same priority as a rule group that's already associated.
     */
    public final DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation() {
        return dnsRuleGroupPriorityConflictViolation;
    }

    /**
     * <p>
     * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
     * associate with a VPC is already associated with the VPC and can't be associated again.
     * </p>
     * 
     * @return Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried
     *         to associate with a VPC is already associated with the VPC and can't be associated again.
     */
    public final DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation() {
        return dnsDuplicateRuleGroupViolation;
    }

    /**
     * <p>
     * Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS
     * Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed.
     * </p>
     * 
     * @return Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated
     *         DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed.
     */
    public final DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation() {
        return dnsRuleGroupLimitExceededViolation;
    }

    /**
     * <p>
     * A list of possible remediation action lists. Each individual possible remediation action is a list of individual
     * remediation actions.
     * </p>
     * 
     * @return A list of possible remediation action lists. Each individual possible remediation action is a list of
     *         individual remediation actions.
     */
    public final PossibleRemediationActions possibleRemediationActions() {
        return possibleRemediationActions;
    }

    /**
     * <p>
     * Contains details about the firewall subnet that violates the policy scope.
     * </p>
     * 
     * @return Contains details about the firewall subnet that violates the policy scope.
     */
    public final FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation() {
        return firewallSubnetIsOutOfScopeViolation;
    }

    /**
     * <p>
     * Contains details about the route endpoint that violates the policy scope.
     * </p>
     * 
     * @return Contains details about the route endpoint that violates the policy scope.
     */
    public final RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation() {
        return routeHasOutOfScopeEndpointViolation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsVPCSecurityGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2NetworkInterfaceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2InstanceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallMissingFirewallViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallMissingSubnetViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallMissingExpectedRTViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallPolicyModifiedViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallInternetTrafficNotInspectedViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallInvalidRouteConfigurationViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallBlackHoleRouteDetectedViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallUnexpectedFirewallRoutesViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallUnexpectedGatewayRoutesViolation());
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallMissingExpectedRoutesViolation());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRuleGroupPriorityConflictViolation());
        hashCode = 31 * hashCode + Objects.hashCode(dnsDuplicateRuleGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRuleGroupLimitExceededViolation());
        hashCode = 31 * hashCode + Objects.hashCode(possibleRemediationActions());
        hashCode = 31 * hashCode + Objects.hashCode(firewallSubnetIsOutOfScopeViolation());
        hashCode = 31 * hashCode + Objects.hashCode(routeHasOutOfScopeEndpointViolation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceViolation)) {
            return false;
        }
        ResourceViolation other = (ResourceViolation) obj;
        return Objects.equals(awsVPCSecurityGroupViolation(), other.awsVPCSecurityGroupViolation())
                && Objects.equals(awsEc2NetworkInterfaceViolation(), other.awsEc2NetworkInterfaceViolation())
                && Objects.equals(awsEc2InstanceViolation(), other.awsEc2InstanceViolation())
                && Objects.equals(networkFirewallMissingFirewallViolation(), other.networkFirewallMissingFirewallViolation())
                && Objects.equals(networkFirewallMissingSubnetViolation(), other.networkFirewallMissingSubnetViolation())
                && Objects.equals(networkFirewallMissingExpectedRTViolation(), other.networkFirewallMissingExpectedRTViolation())
                && Objects.equals(networkFirewallPolicyModifiedViolation(), other.networkFirewallPolicyModifiedViolation())
                && Objects.equals(networkFirewallInternetTrafficNotInspectedViolation(),
                        other.networkFirewallInternetTrafficNotInspectedViolation())
                && Objects.equals(networkFirewallInvalidRouteConfigurationViolation(),
                        other.networkFirewallInvalidRouteConfigurationViolation())
                && Objects.equals(networkFirewallBlackHoleRouteDetectedViolation(),
                        other.networkFirewallBlackHoleRouteDetectedViolation())
                && Objects.equals(networkFirewallUnexpectedFirewallRoutesViolation(),
                        other.networkFirewallUnexpectedFirewallRoutesViolation())
                && Objects.equals(networkFirewallUnexpectedGatewayRoutesViolation(),
                        other.networkFirewallUnexpectedGatewayRoutesViolation())
                && Objects.equals(networkFirewallMissingExpectedRoutesViolation(),
                        other.networkFirewallMissingExpectedRoutesViolation())
                && Objects.equals(dnsRuleGroupPriorityConflictViolation(), other.dnsRuleGroupPriorityConflictViolation())
                && Objects.equals(dnsDuplicateRuleGroupViolation(), other.dnsDuplicateRuleGroupViolation())
                && Objects.equals(dnsRuleGroupLimitExceededViolation(), other.dnsRuleGroupLimitExceededViolation())
                && Objects.equals(possibleRemediationActions(), other.possibleRemediationActions())
                && Objects.equals(firewallSubnetIsOutOfScopeViolation(), other.firewallSubnetIsOutOfScopeViolation())
                && Objects.equals(routeHasOutOfScopeEndpointViolation(), other.routeHasOutOfScopeEndpointViolation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ResourceViolation")
                .add("AwsVPCSecurityGroupViolation", awsVPCSecurityGroupViolation())
                .add("AwsEc2NetworkInterfaceViolation", awsEc2NetworkInterfaceViolation())
                .add("AwsEc2InstanceViolation", awsEc2InstanceViolation())
                .add("NetworkFirewallMissingFirewallViolation", networkFirewallMissingFirewallViolation())
                .add("NetworkFirewallMissingSubnetViolation", networkFirewallMissingSubnetViolation())
                .add("NetworkFirewallMissingExpectedRTViolation", networkFirewallMissingExpectedRTViolation())
                .add("NetworkFirewallPolicyModifiedViolation", networkFirewallPolicyModifiedViolation())
                .add("NetworkFirewallInternetTrafficNotInspectedViolation", networkFirewallInternetTrafficNotInspectedViolation())
                .add("NetworkFirewallInvalidRouteConfigurationViolation", networkFirewallInvalidRouteConfigurationViolation())
                .add("NetworkFirewallBlackHoleRouteDetectedViolation", networkFirewallBlackHoleRouteDetectedViolation())
                .add("NetworkFirewallUnexpectedFirewallRoutesViolation", networkFirewallUnexpectedFirewallRoutesViolation())
                .add("NetworkFirewallUnexpectedGatewayRoutesViolation", networkFirewallUnexpectedGatewayRoutesViolation())
                .add("NetworkFirewallMissingExpectedRoutesViolation", networkFirewallMissingExpectedRoutesViolation())
                .add("DnsRuleGroupPriorityConflictViolation", dnsRuleGroupPriorityConflictViolation())
                .add("DnsDuplicateRuleGroupViolation", dnsDuplicateRuleGroupViolation())
                .add("DnsRuleGroupLimitExceededViolation", dnsRuleGroupLimitExceededViolation())
                .add("PossibleRemediationActions", possibleRemediationActions())
                .add("FirewallSubnetIsOutOfScopeViolation", firewallSubnetIsOutOfScopeViolation())
                .add("RouteHasOutOfScopeEndpointViolation", routeHasOutOfScopeEndpointViolation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsVPCSecurityGroupViolation":
            return Optional.ofNullable(clazz.cast(awsVPCSecurityGroupViolation()));
        case "AwsEc2NetworkInterfaceViolation":
            return Optional.ofNullable(clazz.cast(awsEc2NetworkInterfaceViolation()));
        case "AwsEc2InstanceViolation":
            return Optional.ofNullable(clazz.cast(awsEc2InstanceViolation()));
        case "NetworkFirewallMissingFirewallViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallMissingFirewallViolation()));
        case "NetworkFirewallMissingSubnetViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallMissingSubnetViolation()));
        case "NetworkFirewallMissingExpectedRTViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallMissingExpectedRTViolation()));
        case "NetworkFirewallPolicyModifiedViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallPolicyModifiedViolation()));
        case "NetworkFirewallInternetTrafficNotInspectedViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallInternetTrafficNotInspectedViolation()));
        case "NetworkFirewallInvalidRouteConfigurationViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallInvalidRouteConfigurationViolation()));
        case "NetworkFirewallBlackHoleRouteDetectedViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallBlackHoleRouteDetectedViolation()));
        case "NetworkFirewallUnexpectedFirewallRoutesViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallUnexpectedFirewallRoutesViolation()));
        case "NetworkFirewallUnexpectedGatewayRoutesViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallUnexpectedGatewayRoutesViolation()));
        case "NetworkFirewallMissingExpectedRoutesViolation":
            return Optional.ofNullable(clazz.cast(networkFirewallMissingExpectedRoutesViolation()));
        case "DnsRuleGroupPriorityConflictViolation":
            return Optional.ofNullable(clazz.cast(dnsRuleGroupPriorityConflictViolation()));
        case "DnsDuplicateRuleGroupViolation":
            return Optional.ofNullable(clazz.cast(dnsDuplicateRuleGroupViolation()));
        case "DnsRuleGroupLimitExceededViolation":
            return Optional.ofNullable(clazz.cast(dnsRuleGroupLimitExceededViolation()));
        case "PossibleRemediationActions":
            return Optional.ofNullable(clazz.cast(possibleRemediationActions()));
        case "FirewallSubnetIsOutOfScopeViolation":
            return Optional.ofNullable(clazz.cast(firewallSubnetIsOutOfScopeViolation()));
        case "RouteHasOutOfScopeEndpointViolation":
            return Optional.ofNullable(clazz.cast(routeHasOutOfScopeEndpointViolation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceViolation, T> g) {
        return obj -> g.apply((ResourceViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceViolation> {
        /**
         * <p>
         * Violation detail for security groups.
         * </p>
         * 
         * @param awsVPCSecurityGroupViolation
         *        Violation detail for security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation);

        /**
         * <p>
         * Violation detail for security groups.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsVPCSecurityGroupViolation.Builder} avoiding
         * the need to create one manually via {@link AwsVPCSecurityGroupViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsVPCSecurityGroupViolation.Builder#build()} is called
         * immediately and its result is passed to {@link #awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation)}.
         * 
         * @param awsVPCSecurityGroupViolation
         *        a consumer that will call methods on {@link AwsVPCSecurityGroupViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation)
         */
        default Builder awsVPCSecurityGroupViolation(Consumer<AwsVPCSecurityGroupViolation.Builder> awsVPCSecurityGroupViolation) {
            return awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.builder()
                    .applyMutation(awsVPCSecurityGroupViolation).build());
        }

        /**
         * <p>
         * Violation detail for a network interface.
         * </p>
         * 
         * @param awsEc2NetworkInterfaceViolation
         *        Violation detail for a network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation);

        /**
         * <p>
         * Violation detail for a network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2NetworkInterfaceViolation.Builder}
         * avoiding the need to create one manually via {@link AwsEc2NetworkInterfaceViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2NetworkInterfaceViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation)}.
         * 
         * @param awsEc2NetworkInterfaceViolation
         *        a consumer that will call methods on {@link AwsEc2NetworkInterfaceViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation)
         */
        default Builder awsEc2NetworkInterfaceViolation(
                Consumer<AwsEc2NetworkInterfaceViolation.Builder> awsEc2NetworkInterfaceViolation) {
            return awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation.builder()
                    .applyMutation(awsEc2NetworkInterfaceViolation).build());
        }

        /**
         * <p>
         * Violation detail for an EC2 instance.
         * </p>
         * 
         * @param awsEc2InstanceViolation
         *        Violation detail for an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation);

        /**
         * <p>
         * Violation detail for an EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2InstanceViolation.Builder} avoiding the
         * need to create one manually via {@link AwsEc2InstanceViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2InstanceViolation.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEc2InstanceViolation(AwsEc2InstanceViolation)}.
         * 
         * @param awsEc2InstanceViolation
         *        a consumer that will call methods on {@link AwsEc2InstanceViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2InstanceViolation(AwsEc2InstanceViolation)
         */
        default Builder awsEc2InstanceViolation(Consumer<AwsEc2InstanceViolation.Builder> awsEc2InstanceViolation) {
            return awsEc2InstanceViolation(AwsEc2InstanceViolation.builder().applyMutation(awsEc2InstanceViolation).build());
        }

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed
         * firewall in its VPC.
         * </p>
         * 
         * @param networkFirewallMissingFirewallViolation
         *        Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager
         *        managed firewall in its VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallMissingFirewallViolation(
                NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation);

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed
         * firewall in its VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkFirewallMissingFirewallViolation.Builder}
         * avoiding the need to create one manually via {@link NetworkFirewallMissingFirewallViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallMissingFirewallViolation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation)}.
         * 
         * @param networkFirewallMissingFirewallViolation
         *        a consumer that will call methods on {@link NetworkFirewallMissingFirewallViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation)
         */
        default Builder networkFirewallMissingFirewallViolation(
                Consumer<NetworkFirewallMissingFirewallViolation.Builder> networkFirewallMissingFirewallViolation) {
            return networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation.builder()
                    .applyMutation(networkFirewallMissingFirewallViolation).build());
        }

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the
         * expected Firewall Manager managed subnet.
         * </p>
         * 
         * @param networkFirewallMissingSubnetViolation
         *        Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing
         *        the expected Firewall Manager managed subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation);

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the
         * expected Firewall Manager managed subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkFirewallMissingSubnetViolation.Builder}
         * avoiding the need to create one manually via {@link NetworkFirewallMissingSubnetViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallMissingSubnetViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation)}.
         * 
         * @param networkFirewallMissingSubnetViolation
         *        a consumer that will call methods on {@link NetworkFirewallMissingSubnetViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation)
         */
        default Builder networkFirewallMissingSubnetViolation(
                Consumer<NetworkFirewallMissingSubnetViolation.Builder> networkFirewallMissingSubnetViolation) {
            return networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation.builder()
                    .applyMutation(networkFirewallMissingSubnetViolation).build());
        }

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the
         * expected Firewall Manager managed route table.
         * </p>
         * 
         * @param networkFirewallMissingExpectedRTViolation
         *        Violation detail for an Network Firewall policy that indicates that a subnet is not associated with
         *        the expected Firewall Manager managed route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallMissingExpectedRTViolation(
                NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation);

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the
         * expected Firewall Manager managed route table.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link NetworkFirewallMissingExpectedRTViolation.Builder} avoiding the need to create one manually via
         * {@link NetworkFirewallMissingExpectedRTViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallMissingExpectedRTViolation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation)}.
         * 
         * @param networkFirewallMissingExpectedRTViolation
         *        a consumer that will call methods on {@link NetworkFirewallMissingExpectedRTViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation)
         */
        default Builder networkFirewallMissingExpectedRTViolation(
                Consumer<NetworkFirewallMissingExpectedRTViolation.Builder> networkFirewallMissingExpectedRTViolation) {
            return networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation.builder()
                    .applyMutation(networkFirewallMissingExpectedRTViolation).build());
        }

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual
         * account has been modified in a way that makes it noncompliant. For example, the individual account owner
         * might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default
         * action.
         * </p>
         * 
         * @param networkFirewallPolicyModifiedViolation
         *        Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual
         *        account has been modified in a way that makes it noncompliant. For example, the individual account
         *        owner might have deleted a rule group, changed the priority of a stateless rule group, or changed a
         *        policy default action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallPolicyModifiedViolation(
                NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation);

        /**
         * <p>
         * Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual
         * account has been modified in a way that makes it noncompliant. For example, the individual account owner
         * might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default
         * action.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkFirewallPolicyModifiedViolation.Builder}
         * avoiding the need to create one manually via {@link NetworkFirewallPolicyModifiedViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallPolicyModifiedViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation)}.
         * 
         * @param networkFirewallPolicyModifiedViolation
         *        a consumer that will call methods on {@link NetworkFirewallPolicyModifiedViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation)
         */
        default Builder networkFirewallPolicyModifiedViolation(
                Consumer<NetworkFirewallPolicyModifiedViolation.Builder> networkFirewallPolicyModifiedViolation) {
            return networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation.builder()
                    .applyMutation(networkFirewallPolicyModifiedViolation).build());
        }

        /**
         * <p>
         * Violation detail for the subnet for which internet traffic hasn't been inspected.
         * </p>
         * 
         * @param networkFirewallInternetTrafficNotInspectedViolation
         *        Violation detail for the subnet for which internet traffic hasn't been inspected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallInternetTrafficNotInspectedViolation(
                NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation);

        /**
         * <p>
         * Violation detail for the subnet for which internet traffic hasn't been inspected.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link NetworkFirewallInternetTrafficNotInspectedViolation.Builder} avoiding the need to create one manually
         * via {@link NetworkFirewallInternetTrafficNotInspectedViolation#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link NetworkFirewallInternetTrafficNotInspectedViolation.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #networkFirewallInternetTrafficNotInspectedViolation(NetworkFirewallInternetTrafficNotInspectedViolation)}
         * .
         * 
         * @param networkFirewallInternetTrafficNotInspectedViolation
         *        a consumer that will call methods on
         *        {@link NetworkFirewallInternetTrafficNotInspectedViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallInternetTrafficNotInspectedViolation(NetworkFirewallInternetTrafficNotInspectedViolation)
         */
        default Builder networkFirewallInternetTrafficNotInspectedViolation(
                Consumer<NetworkFirewallInternetTrafficNotInspectedViolation.Builder> networkFirewallInternetTrafficNotInspectedViolation) {
            return networkFirewallInternetTrafficNotInspectedViolation(NetworkFirewallInternetTrafficNotInspectedViolation
                    .builder().applyMutation(networkFirewallInternetTrafficNotInspectedViolation).build());
        }

        /**
         * <p>
         * The route configuration is invalid.
         * </p>
         * 
         * @param networkFirewallInvalidRouteConfigurationViolation
         *        The route configuration is invalid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallInvalidRouteConfigurationViolation(
                NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation);

        /**
         * <p>
         * The route configuration is invalid.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link NetworkFirewallInvalidRouteConfigurationViolation.Builder} avoiding the need to create one manually
         * via {@link NetworkFirewallInvalidRouteConfigurationViolation#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link NetworkFirewallInvalidRouteConfigurationViolation.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #networkFirewallInvalidRouteConfigurationViolation(NetworkFirewallInvalidRouteConfigurationViolation)}
         * .
         * 
         * @param networkFirewallInvalidRouteConfigurationViolation
         *        a consumer that will call methods on {@link NetworkFirewallInvalidRouteConfigurationViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallInvalidRouteConfigurationViolation(NetworkFirewallInvalidRouteConfigurationViolation)
         */
        default Builder networkFirewallInvalidRouteConfigurationViolation(
                Consumer<NetworkFirewallInvalidRouteConfigurationViolation.Builder> networkFirewallInvalidRouteConfigurationViolation) {
            return networkFirewallInvalidRouteConfigurationViolation(NetworkFirewallInvalidRouteConfigurationViolation.builder()
                    .applyMutation(networkFirewallInvalidRouteConfigurationViolation).build());
        }

        /**
         * Sets the value of the NetworkFirewallBlackHoleRouteDetectedViolation property for this object.
         *
         * @param networkFirewallBlackHoleRouteDetectedViolation
         *        The new value for the NetworkFirewallBlackHoleRouteDetectedViolation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallBlackHoleRouteDetectedViolation(
                NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation);

        /**
         * Sets the value of the NetworkFirewallBlackHoleRouteDetectedViolation property for this object.
         *
         * This is a convenience that creates an instance of the
         * {@link NetworkFirewallBlackHoleRouteDetectedViolation.Builder} avoiding the need to create one manually via
         * {@link NetworkFirewallBlackHoleRouteDetectedViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallBlackHoleRouteDetectedViolation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #networkFirewallBlackHoleRouteDetectedViolation(NetworkFirewallBlackHoleRouteDetectedViolation)}.
         * 
         * @param networkFirewallBlackHoleRouteDetectedViolation
         *        a consumer that will call methods on {@link NetworkFirewallBlackHoleRouteDetectedViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallBlackHoleRouteDetectedViolation(NetworkFirewallBlackHoleRouteDetectedViolation)
         */
        default Builder networkFirewallBlackHoleRouteDetectedViolation(
                Consumer<NetworkFirewallBlackHoleRouteDetectedViolation.Builder> networkFirewallBlackHoleRouteDetectedViolation) {
            return networkFirewallBlackHoleRouteDetectedViolation(NetworkFirewallBlackHoleRouteDetectedViolation.builder()
                    .applyMutation(networkFirewallBlackHoleRouteDetectedViolation).build());
        }

        /**
         * <p>
         * There's an unexpected firewall route.
         * </p>
         * 
         * @param networkFirewallUnexpectedFirewallRoutesViolation
         *        There's an unexpected firewall route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallUnexpectedFirewallRoutesViolation(
                NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation);

        /**
         * <p>
         * There's an unexpected firewall route.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link NetworkFirewallUnexpectedFirewallRoutesViolation.Builder} avoiding the need to create one manually via
         * {@link NetworkFirewallUnexpectedFirewallRoutesViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallUnexpectedFirewallRoutesViolation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #networkFirewallUnexpectedFirewallRoutesViolation(NetworkFirewallUnexpectedFirewallRoutesViolation)}.
         * 
         * @param networkFirewallUnexpectedFirewallRoutesViolation
         *        a consumer that will call methods on {@link NetworkFirewallUnexpectedFirewallRoutesViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallUnexpectedFirewallRoutesViolation(NetworkFirewallUnexpectedFirewallRoutesViolation)
         */
        default Builder networkFirewallUnexpectedFirewallRoutesViolation(
                Consumer<NetworkFirewallUnexpectedFirewallRoutesViolation.Builder> networkFirewallUnexpectedFirewallRoutesViolation) {
            return networkFirewallUnexpectedFirewallRoutesViolation(NetworkFirewallUnexpectedFirewallRoutesViolation.builder()
                    .applyMutation(networkFirewallUnexpectedFirewallRoutesViolation).build());
        }

        /**
         * <p>
         * There's an unexpected gateway route.
         * </p>
         * 
         * @param networkFirewallUnexpectedGatewayRoutesViolation
         *        There's an unexpected gateway route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallUnexpectedGatewayRoutesViolation(
                NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation);

        /**
         * <p>
         * There's an unexpected gateway route.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link NetworkFirewallUnexpectedGatewayRoutesViolation.Builder} avoiding the need to create one manually via
         * {@link NetworkFirewallUnexpectedGatewayRoutesViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallUnexpectedGatewayRoutesViolation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #networkFirewallUnexpectedGatewayRoutesViolation(NetworkFirewallUnexpectedGatewayRoutesViolation)}.
         * 
         * @param networkFirewallUnexpectedGatewayRoutesViolation
         *        a consumer that will call methods on {@link NetworkFirewallUnexpectedGatewayRoutesViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallUnexpectedGatewayRoutesViolation(NetworkFirewallUnexpectedGatewayRoutesViolation)
         */
        default Builder networkFirewallUnexpectedGatewayRoutesViolation(
                Consumer<NetworkFirewallUnexpectedGatewayRoutesViolation.Builder> networkFirewallUnexpectedGatewayRoutesViolation) {
            return networkFirewallUnexpectedGatewayRoutesViolation(NetworkFirewallUnexpectedGatewayRoutesViolation.builder()
                    .applyMutation(networkFirewallUnexpectedGatewayRoutesViolation).build());
        }

        /**
         * <p>
         * Expected routes are missing from Network Firewall.
         * </p>
         * 
         * @param networkFirewallMissingExpectedRoutesViolation
         *        Expected routes are missing from Network Firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallMissingExpectedRoutesViolation(
                NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation);

        /**
         * <p>
         * Expected routes are missing from Network Firewall.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link NetworkFirewallMissingExpectedRoutesViolation.Builder} avoiding the need to create one manually via
         * {@link NetworkFirewallMissingExpectedRoutesViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallMissingExpectedRoutesViolation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkFirewallMissingExpectedRoutesViolation(NetworkFirewallMissingExpectedRoutesViolation)}.
         * 
         * @param networkFirewallMissingExpectedRoutesViolation
         *        a consumer that will call methods on {@link NetworkFirewallMissingExpectedRoutesViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallMissingExpectedRoutesViolation(NetworkFirewallMissingExpectedRoutesViolation)
         */
        default Builder networkFirewallMissingExpectedRoutesViolation(
                Consumer<NetworkFirewallMissingExpectedRoutesViolation.Builder> networkFirewallMissingExpectedRoutesViolation) {
            return networkFirewallMissingExpectedRoutesViolation(NetworkFirewallMissingExpectedRoutesViolation.builder()
                    .applyMutation(networkFirewallMissingExpectedRoutesViolation).build());
        }

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
         * associate with a VPC has the same priority as a rule group that's already associated.
         * </p>
         * 
         * @param dnsRuleGroupPriorityConflictViolation
         *        Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager
         *        tried to associate with a VPC has the same priority as a rule group that's already associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation);

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
         * associate with a VPC has the same priority as a rule group that's already associated.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsRuleGroupPriorityConflictViolation.Builder}
         * avoiding the need to create one manually via {@link DnsRuleGroupPriorityConflictViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsRuleGroupPriorityConflictViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation)}.
         * 
         * @param dnsRuleGroupPriorityConflictViolation
         *        a consumer that will call methods on {@link DnsRuleGroupPriorityConflictViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation)
         */
        default Builder dnsRuleGroupPriorityConflictViolation(
                Consumer<DnsRuleGroupPriorityConflictViolation.Builder> dnsRuleGroupPriorityConflictViolation) {
            return dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation.builder()
                    .applyMutation(dnsRuleGroupPriorityConflictViolation).build());
        }

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
         * associate with a VPC is already associated with the VPC and can't be associated again.
         * </p>
         * 
         * @param dnsDuplicateRuleGroupViolation
         *        Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager
         *        tried to associate with a VPC is already associated with the VPC and can't be associated again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation);

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to
         * associate with a VPC is already associated with the VPC and can't be associated again.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsDuplicateRuleGroupViolation.Builder} avoiding
         * the need to create one manually via {@link DnsDuplicateRuleGroupViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsDuplicateRuleGroupViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation)}.
         * 
         * @param dnsDuplicateRuleGroupViolation
         *        a consumer that will call methods on {@link DnsDuplicateRuleGroupViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation)
         */
        default Builder dnsDuplicateRuleGroupViolation(
                Consumer<DnsDuplicateRuleGroupViolation.Builder> dnsDuplicateRuleGroupViolation) {
            return dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation.builder()
                    .applyMutation(dnsDuplicateRuleGroupViolation).build());
        }

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS
         * Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed.
         * </p>
         * 
         * @param dnsRuleGroupLimitExceededViolation
         *        Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for
         *        associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the
         *        VPC and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation);

        /**
         * <p>
         * Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS
         * Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsRuleGroupLimitExceededViolation.Builder}
         * avoiding the need to create one manually via {@link DnsRuleGroupLimitExceededViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsRuleGroupLimitExceededViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation)}.
         * 
         * @param dnsRuleGroupLimitExceededViolation
         *        a consumer that will call methods on {@link DnsRuleGroupLimitExceededViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation)
         */
        default Builder dnsRuleGroupLimitExceededViolation(
                Consumer<DnsRuleGroupLimitExceededViolation.Builder> dnsRuleGroupLimitExceededViolation) {
            return dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation.builder()
                    .applyMutation(dnsRuleGroupLimitExceededViolation).build());
        }

        /**
         * <p>
         * A list of possible remediation action lists. Each individual possible remediation action is a list of
         * individual remediation actions.
         * </p>
         * 
         * @param possibleRemediationActions
         *        A list of possible remediation action lists. Each individual possible remediation action is a list of
         *        individual remediation actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder possibleRemediationActions(PossibleRemediationActions possibleRemediationActions);

        /**
         * <p>
         * A list of possible remediation action lists. Each individual possible remediation action is a list of
         * individual remediation actions.
         * </p>
         * This is a convenience that creates an instance of the {@link PossibleRemediationActions.Builder} avoiding the
         * need to create one manually via {@link PossibleRemediationActions#builder()}.
         *
         * When the {@link Consumer} completes, {@link PossibleRemediationActions.Builder#build()} is called immediately
         * and its result is passed to {@link #possibleRemediationActions(PossibleRemediationActions)}.
         * 
         * @param possibleRemediationActions
         *        a consumer that will call methods on {@link PossibleRemediationActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #possibleRemediationActions(PossibleRemediationActions)
         */
        default Builder possibleRemediationActions(Consumer<PossibleRemediationActions.Builder> possibleRemediationActions) {
            return possibleRemediationActions(PossibleRemediationActions.builder().applyMutation(possibleRemediationActions)
                    .build());
        }

        /**
         * <p>
         * Contains details about the firewall subnet that violates the policy scope.
         * </p>
         * 
         * @param firewallSubnetIsOutOfScopeViolation
         *        Contains details about the firewall subnet that violates the policy scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallSubnetIsOutOfScopeViolation(FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation);

        /**
         * <p>
         * Contains details about the firewall subnet that violates the policy scope.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallSubnetIsOutOfScopeViolation.Builder}
         * avoiding the need to create one manually via {@link FirewallSubnetIsOutOfScopeViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallSubnetIsOutOfScopeViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #firewallSubnetIsOutOfScopeViolation(FirewallSubnetIsOutOfScopeViolation)}.
         * 
         * @param firewallSubnetIsOutOfScopeViolation
         *        a consumer that will call methods on {@link FirewallSubnetIsOutOfScopeViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallSubnetIsOutOfScopeViolation(FirewallSubnetIsOutOfScopeViolation)
         */
        default Builder firewallSubnetIsOutOfScopeViolation(
                Consumer<FirewallSubnetIsOutOfScopeViolation.Builder> firewallSubnetIsOutOfScopeViolation) {
            return firewallSubnetIsOutOfScopeViolation(FirewallSubnetIsOutOfScopeViolation.builder()
                    .applyMutation(firewallSubnetIsOutOfScopeViolation).build());
        }

        /**
         * <p>
         * Contains details about the route endpoint that violates the policy scope.
         * </p>
         * 
         * @param routeHasOutOfScopeEndpointViolation
         *        Contains details about the route endpoint that violates the policy scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeHasOutOfScopeEndpointViolation(RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation);

        /**
         * <p>
         * Contains details about the route endpoint that violates the policy scope.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteHasOutOfScopeEndpointViolation.Builder}
         * avoiding the need to create one manually via {@link RouteHasOutOfScopeEndpointViolation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteHasOutOfScopeEndpointViolation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #routeHasOutOfScopeEndpointViolation(RouteHasOutOfScopeEndpointViolation)}.
         * 
         * @param routeHasOutOfScopeEndpointViolation
         *        a consumer that will call methods on {@link RouteHasOutOfScopeEndpointViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeHasOutOfScopeEndpointViolation(RouteHasOutOfScopeEndpointViolation)
         */
        default Builder routeHasOutOfScopeEndpointViolation(
                Consumer<RouteHasOutOfScopeEndpointViolation.Builder> routeHasOutOfScopeEndpointViolation) {
            return routeHasOutOfScopeEndpointViolation(RouteHasOutOfScopeEndpointViolation.builder()
                    .applyMutation(routeHasOutOfScopeEndpointViolation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;

        private AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;

        private AwsEc2InstanceViolation awsEc2InstanceViolation;

        private NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation;

        private NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation;

        private NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation;

        private NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation;

        private NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation;

        private NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation;

        private NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation;

        private NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation;

        private NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation;

        private NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation;

        private DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation;

        private DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation;

        private DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation;

        private PossibleRemediationActions possibleRemediationActions;

        private FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation;

        private RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceViolation model) {
            awsVPCSecurityGroupViolation(model.awsVPCSecurityGroupViolation);
            awsEc2NetworkInterfaceViolation(model.awsEc2NetworkInterfaceViolation);
            awsEc2InstanceViolation(model.awsEc2InstanceViolation);
            networkFirewallMissingFirewallViolation(model.networkFirewallMissingFirewallViolation);
            networkFirewallMissingSubnetViolation(model.networkFirewallMissingSubnetViolation);
            networkFirewallMissingExpectedRTViolation(model.networkFirewallMissingExpectedRTViolation);
            networkFirewallPolicyModifiedViolation(model.networkFirewallPolicyModifiedViolation);
            networkFirewallInternetTrafficNotInspectedViolation(model.networkFirewallInternetTrafficNotInspectedViolation);
            networkFirewallInvalidRouteConfigurationViolation(model.networkFirewallInvalidRouteConfigurationViolation);
            networkFirewallBlackHoleRouteDetectedViolation(model.networkFirewallBlackHoleRouteDetectedViolation);
            networkFirewallUnexpectedFirewallRoutesViolation(model.networkFirewallUnexpectedFirewallRoutesViolation);
            networkFirewallUnexpectedGatewayRoutesViolation(model.networkFirewallUnexpectedGatewayRoutesViolation);
            networkFirewallMissingExpectedRoutesViolation(model.networkFirewallMissingExpectedRoutesViolation);
            dnsRuleGroupPriorityConflictViolation(model.dnsRuleGroupPriorityConflictViolation);
            dnsDuplicateRuleGroupViolation(model.dnsDuplicateRuleGroupViolation);
            dnsRuleGroupLimitExceededViolation(model.dnsRuleGroupLimitExceededViolation);
            possibleRemediationActions(model.possibleRemediationActions);
            firewallSubnetIsOutOfScopeViolation(model.firewallSubnetIsOutOfScopeViolation);
            routeHasOutOfScopeEndpointViolation(model.routeHasOutOfScopeEndpointViolation);
        }

        public final AwsVPCSecurityGroupViolation.Builder getAwsVPCSecurityGroupViolation() {
            return awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.toBuilder() : null;
        }

        public final void setAwsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.BuilderImpl awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation;
            return this;
        }

        public final AwsEc2NetworkInterfaceViolation.Builder getAwsEc2NetworkInterfaceViolation() {
            return awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation.toBuilder() : null;
        }

        public final void setAwsEc2NetworkInterfaceViolation(
                AwsEc2NetworkInterfaceViolation.BuilderImpl awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation;
            return this;
        }

        public final AwsEc2InstanceViolation.Builder getAwsEc2InstanceViolation() {
            return awsEc2InstanceViolation != null ? awsEc2InstanceViolation.toBuilder() : null;
        }

        public final void setAwsEc2InstanceViolation(AwsEc2InstanceViolation.BuilderImpl awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation != null ? awsEc2InstanceViolation.build() : null;
        }

        @Override
        @Transient
        public final Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation;
            return this;
        }

        public final NetworkFirewallMissingFirewallViolation.Builder getNetworkFirewallMissingFirewallViolation() {
            return networkFirewallMissingFirewallViolation != null ? networkFirewallMissingFirewallViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallMissingFirewallViolation(
                NetworkFirewallMissingFirewallViolation.BuilderImpl networkFirewallMissingFirewallViolation) {
            this.networkFirewallMissingFirewallViolation = networkFirewallMissingFirewallViolation != null ? networkFirewallMissingFirewallViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallMissingFirewallViolation(
                NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation) {
            this.networkFirewallMissingFirewallViolation = networkFirewallMissingFirewallViolation;
            return this;
        }

        public final NetworkFirewallMissingSubnetViolation.Builder getNetworkFirewallMissingSubnetViolation() {
            return networkFirewallMissingSubnetViolation != null ? networkFirewallMissingSubnetViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallMissingSubnetViolation(
                NetworkFirewallMissingSubnetViolation.BuilderImpl networkFirewallMissingSubnetViolation) {
            this.networkFirewallMissingSubnetViolation = networkFirewallMissingSubnetViolation != null ? networkFirewallMissingSubnetViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallMissingSubnetViolation(
                NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation) {
            this.networkFirewallMissingSubnetViolation = networkFirewallMissingSubnetViolation;
            return this;
        }

        public final NetworkFirewallMissingExpectedRTViolation.Builder getNetworkFirewallMissingExpectedRTViolation() {
            return networkFirewallMissingExpectedRTViolation != null ? networkFirewallMissingExpectedRTViolation.toBuilder()
                    : null;
        }

        public final void setNetworkFirewallMissingExpectedRTViolation(
                NetworkFirewallMissingExpectedRTViolation.BuilderImpl networkFirewallMissingExpectedRTViolation) {
            this.networkFirewallMissingExpectedRTViolation = networkFirewallMissingExpectedRTViolation != null ? networkFirewallMissingExpectedRTViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallMissingExpectedRTViolation(
                NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation) {
            this.networkFirewallMissingExpectedRTViolation = networkFirewallMissingExpectedRTViolation;
            return this;
        }

        public final NetworkFirewallPolicyModifiedViolation.Builder getNetworkFirewallPolicyModifiedViolation() {
            return networkFirewallPolicyModifiedViolation != null ? networkFirewallPolicyModifiedViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallPolicyModifiedViolation(
                NetworkFirewallPolicyModifiedViolation.BuilderImpl networkFirewallPolicyModifiedViolation) {
            this.networkFirewallPolicyModifiedViolation = networkFirewallPolicyModifiedViolation != null ? networkFirewallPolicyModifiedViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallPolicyModifiedViolation(
                NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation) {
            this.networkFirewallPolicyModifiedViolation = networkFirewallPolicyModifiedViolation;
            return this;
        }

        public final NetworkFirewallInternetTrafficNotInspectedViolation.Builder getNetworkFirewallInternetTrafficNotInspectedViolation() {
            return networkFirewallInternetTrafficNotInspectedViolation != null ? networkFirewallInternetTrafficNotInspectedViolation
                    .toBuilder() : null;
        }

        public final void setNetworkFirewallInternetTrafficNotInspectedViolation(
                NetworkFirewallInternetTrafficNotInspectedViolation.BuilderImpl networkFirewallInternetTrafficNotInspectedViolation) {
            this.networkFirewallInternetTrafficNotInspectedViolation = networkFirewallInternetTrafficNotInspectedViolation != null ? networkFirewallInternetTrafficNotInspectedViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallInternetTrafficNotInspectedViolation(
                NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation) {
            this.networkFirewallInternetTrafficNotInspectedViolation = networkFirewallInternetTrafficNotInspectedViolation;
            return this;
        }

        public final NetworkFirewallInvalidRouteConfigurationViolation.Builder getNetworkFirewallInvalidRouteConfigurationViolation() {
            return networkFirewallInvalidRouteConfigurationViolation != null ? networkFirewallInvalidRouteConfigurationViolation
                    .toBuilder() : null;
        }

        public final void setNetworkFirewallInvalidRouteConfigurationViolation(
                NetworkFirewallInvalidRouteConfigurationViolation.BuilderImpl networkFirewallInvalidRouteConfigurationViolation) {
            this.networkFirewallInvalidRouteConfigurationViolation = networkFirewallInvalidRouteConfigurationViolation != null ? networkFirewallInvalidRouteConfigurationViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallInvalidRouteConfigurationViolation(
                NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation) {
            this.networkFirewallInvalidRouteConfigurationViolation = networkFirewallInvalidRouteConfigurationViolation;
            return this;
        }

        public final NetworkFirewallBlackHoleRouteDetectedViolation.Builder getNetworkFirewallBlackHoleRouteDetectedViolation() {
            return networkFirewallBlackHoleRouteDetectedViolation != null ? networkFirewallBlackHoleRouteDetectedViolation
                    .toBuilder() : null;
        }

        public final void setNetworkFirewallBlackHoleRouteDetectedViolation(
                NetworkFirewallBlackHoleRouteDetectedViolation.BuilderImpl networkFirewallBlackHoleRouteDetectedViolation) {
            this.networkFirewallBlackHoleRouteDetectedViolation = networkFirewallBlackHoleRouteDetectedViolation != null ? networkFirewallBlackHoleRouteDetectedViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallBlackHoleRouteDetectedViolation(
                NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation) {
            this.networkFirewallBlackHoleRouteDetectedViolation = networkFirewallBlackHoleRouteDetectedViolation;
            return this;
        }

        public final NetworkFirewallUnexpectedFirewallRoutesViolation.Builder getNetworkFirewallUnexpectedFirewallRoutesViolation() {
            return networkFirewallUnexpectedFirewallRoutesViolation != null ? networkFirewallUnexpectedFirewallRoutesViolation
                    .toBuilder() : null;
        }

        public final void setNetworkFirewallUnexpectedFirewallRoutesViolation(
                NetworkFirewallUnexpectedFirewallRoutesViolation.BuilderImpl networkFirewallUnexpectedFirewallRoutesViolation) {
            this.networkFirewallUnexpectedFirewallRoutesViolation = networkFirewallUnexpectedFirewallRoutesViolation != null ? networkFirewallUnexpectedFirewallRoutesViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallUnexpectedFirewallRoutesViolation(
                NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation) {
            this.networkFirewallUnexpectedFirewallRoutesViolation = networkFirewallUnexpectedFirewallRoutesViolation;
            return this;
        }

        public final NetworkFirewallUnexpectedGatewayRoutesViolation.Builder getNetworkFirewallUnexpectedGatewayRoutesViolation() {
            return networkFirewallUnexpectedGatewayRoutesViolation != null ? networkFirewallUnexpectedGatewayRoutesViolation
                    .toBuilder() : null;
        }

        public final void setNetworkFirewallUnexpectedGatewayRoutesViolation(
                NetworkFirewallUnexpectedGatewayRoutesViolation.BuilderImpl networkFirewallUnexpectedGatewayRoutesViolation) {
            this.networkFirewallUnexpectedGatewayRoutesViolation = networkFirewallUnexpectedGatewayRoutesViolation != null ? networkFirewallUnexpectedGatewayRoutesViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallUnexpectedGatewayRoutesViolation(
                NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation) {
            this.networkFirewallUnexpectedGatewayRoutesViolation = networkFirewallUnexpectedGatewayRoutesViolation;
            return this;
        }

        public final NetworkFirewallMissingExpectedRoutesViolation.Builder getNetworkFirewallMissingExpectedRoutesViolation() {
            return networkFirewallMissingExpectedRoutesViolation != null ? networkFirewallMissingExpectedRoutesViolation
                    .toBuilder() : null;
        }

        public final void setNetworkFirewallMissingExpectedRoutesViolation(
                NetworkFirewallMissingExpectedRoutesViolation.BuilderImpl networkFirewallMissingExpectedRoutesViolation) {
            this.networkFirewallMissingExpectedRoutesViolation = networkFirewallMissingExpectedRoutesViolation != null ? networkFirewallMissingExpectedRoutesViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkFirewallMissingExpectedRoutesViolation(
                NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation) {
            this.networkFirewallMissingExpectedRoutesViolation = networkFirewallMissingExpectedRoutesViolation;
            return this;
        }

        public final DnsRuleGroupPriorityConflictViolation.Builder getDnsRuleGroupPriorityConflictViolation() {
            return dnsRuleGroupPriorityConflictViolation != null ? dnsRuleGroupPriorityConflictViolation.toBuilder() : null;
        }

        public final void setDnsRuleGroupPriorityConflictViolation(
                DnsRuleGroupPriorityConflictViolation.BuilderImpl dnsRuleGroupPriorityConflictViolation) {
            this.dnsRuleGroupPriorityConflictViolation = dnsRuleGroupPriorityConflictViolation != null ? dnsRuleGroupPriorityConflictViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder dnsRuleGroupPriorityConflictViolation(
                DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation) {
            this.dnsRuleGroupPriorityConflictViolation = dnsRuleGroupPriorityConflictViolation;
            return this;
        }

        public final DnsDuplicateRuleGroupViolation.Builder getDnsDuplicateRuleGroupViolation() {
            return dnsDuplicateRuleGroupViolation != null ? dnsDuplicateRuleGroupViolation.toBuilder() : null;
        }

        public final void setDnsDuplicateRuleGroupViolation(
                DnsDuplicateRuleGroupViolation.BuilderImpl dnsDuplicateRuleGroupViolation) {
            this.dnsDuplicateRuleGroupViolation = dnsDuplicateRuleGroupViolation != null ? dnsDuplicateRuleGroupViolation.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation) {
            this.dnsDuplicateRuleGroupViolation = dnsDuplicateRuleGroupViolation;
            return this;
        }

        public final DnsRuleGroupLimitExceededViolation.Builder getDnsRuleGroupLimitExceededViolation() {
            return dnsRuleGroupLimitExceededViolation != null ? dnsRuleGroupLimitExceededViolation.toBuilder() : null;
        }

        public final void setDnsRuleGroupLimitExceededViolation(
                DnsRuleGroupLimitExceededViolation.BuilderImpl dnsRuleGroupLimitExceededViolation) {
            this.dnsRuleGroupLimitExceededViolation = dnsRuleGroupLimitExceededViolation != null ? dnsRuleGroupLimitExceededViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder dnsRuleGroupLimitExceededViolation(
                DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation) {
            this.dnsRuleGroupLimitExceededViolation = dnsRuleGroupLimitExceededViolation;
            return this;
        }

        public final PossibleRemediationActions.Builder getPossibleRemediationActions() {
            return possibleRemediationActions != null ? possibleRemediationActions.toBuilder() : null;
        }

        public final void setPossibleRemediationActions(PossibleRemediationActions.BuilderImpl possibleRemediationActions) {
            this.possibleRemediationActions = possibleRemediationActions != null ? possibleRemediationActions.build() : null;
        }

        @Override
        @Transient
        public final Builder possibleRemediationActions(PossibleRemediationActions possibleRemediationActions) {
            this.possibleRemediationActions = possibleRemediationActions;
            return this;
        }

        public final FirewallSubnetIsOutOfScopeViolation.Builder getFirewallSubnetIsOutOfScopeViolation() {
            return firewallSubnetIsOutOfScopeViolation != null ? firewallSubnetIsOutOfScopeViolation.toBuilder() : null;
        }

        public final void setFirewallSubnetIsOutOfScopeViolation(
                FirewallSubnetIsOutOfScopeViolation.BuilderImpl firewallSubnetIsOutOfScopeViolation) {
            this.firewallSubnetIsOutOfScopeViolation = firewallSubnetIsOutOfScopeViolation != null ? firewallSubnetIsOutOfScopeViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder firewallSubnetIsOutOfScopeViolation(
                FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation) {
            this.firewallSubnetIsOutOfScopeViolation = firewallSubnetIsOutOfScopeViolation;
            return this;
        }

        public final RouteHasOutOfScopeEndpointViolation.Builder getRouteHasOutOfScopeEndpointViolation() {
            return routeHasOutOfScopeEndpointViolation != null ? routeHasOutOfScopeEndpointViolation.toBuilder() : null;
        }

        public final void setRouteHasOutOfScopeEndpointViolation(
                RouteHasOutOfScopeEndpointViolation.BuilderImpl routeHasOutOfScopeEndpointViolation) {
            this.routeHasOutOfScopeEndpointViolation = routeHasOutOfScopeEndpointViolation != null ? routeHasOutOfScopeEndpointViolation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder routeHasOutOfScopeEndpointViolation(
                RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation) {
            this.routeHasOutOfScopeEndpointViolation = routeHasOutOfScopeEndpointViolation;
            return this;
        }

        @Override
        public ResourceViolation build() {
            return new ResourceViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
