/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the firewall policy deployment model for a third-party firewall. The deployment model can either be
 * distributed or centralized.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThirdPartyFirewallFirewallPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<ThirdPartyFirewallFirewallPolicy.Builder, ThirdPartyFirewallFirewallPolicy> {
    private static final SdkField<String> FIREWALL_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyId").getter(getter(ThirdPartyFirewallFirewallPolicy::firewallPolicyId))
            .setter(setter(Builder::firewallPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyId").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyName").getter(getter(ThirdPartyFirewallFirewallPolicy::firewallPolicyName))
            .setter(setter(Builder::firewallPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_POLICY_ID_FIELD,
            FIREWALL_POLICY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String firewallPolicyId;

    private final String firewallPolicyName;

    private ThirdPartyFirewallFirewallPolicy(BuilderImpl builder) {
        this.firewallPolicyId = builder.firewallPolicyId;
        this.firewallPolicyName = builder.firewallPolicyName;
    }

    /**
     * <p>
     * The ID of the specified firewall policy.
     * </p>
     * 
     * @return The ID of the specified firewall policy.
     */
    public final String firewallPolicyId() {
        return firewallPolicyId;
    }

    /**
     * <p>
     * The name of the specified firewall policy.
     * </p>
     * 
     * @return The name of the specified firewall policy.
     */
    public final String firewallPolicyName() {
        return firewallPolicyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThirdPartyFirewallFirewallPolicy)) {
            return false;
        }
        ThirdPartyFirewallFirewallPolicy other = (ThirdPartyFirewallFirewallPolicy) obj;
        return Objects.equals(firewallPolicyId(), other.firewallPolicyId())
                && Objects.equals(firewallPolicyName(), other.firewallPolicyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThirdPartyFirewallFirewallPolicy").add("FirewallPolicyId", firewallPolicyId())
                .add("FirewallPolicyName", firewallPolicyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallPolicyId":
            return Optional.ofNullable(clazz.cast(firewallPolicyId()));
        case "FirewallPolicyName":
            return Optional.ofNullable(clazz.cast(firewallPolicyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThirdPartyFirewallFirewallPolicy, T> g) {
        return obj -> g.apply((ThirdPartyFirewallFirewallPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThirdPartyFirewallFirewallPolicy> {
        /**
         * <p>
         * The ID of the specified firewall policy.
         * </p>
         * 
         * @param firewallPolicyId
         *        The ID of the specified firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyId(String firewallPolicyId);

        /**
         * <p>
         * The name of the specified firewall policy.
         * </p>
         * 
         * @param firewallPolicyName
         *        The name of the specified firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyName(String firewallPolicyName);
    }

    static final class BuilderImpl implements Builder {
        private String firewallPolicyId;

        private String firewallPolicyName;

        private BuilderImpl() {
        }

        private BuilderImpl(ThirdPartyFirewallFirewallPolicy model) {
            firewallPolicyId(model.firewallPolicyId);
            firewallPolicyName(model.firewallPolicyName);
        }

        public final String getFirewallPolicyId() {
            return firewallPolicyId;
        }

        public final void setFirewallPolicyId(String firewallPolicyId) {
            this.firewallPolicyId = firewallPolicyId;
        }

        @Override
        public final Builder firewallPolicyId(String firewallPolicyId) {
            this.firewallPolicyId = firewallPolicyId;
            return this;
        }

        public final String getFirewallPolicyName() {
            return firewallPolicyName;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        @Override
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        @Override
        public ThirdPartyFirewallFirewallPolicy build() {
            return new ThirdPartyFirewallFirewallPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
