/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the DeleteRoute action in Amazon EC2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2DeleteRouteAction implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2DeleteRouteAction.Builder, EC2DeleteRouteAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EC2DeleteRouteAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock").getter(getter(EC2DeleteRouteAction::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").build())
            .build();

    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPrefixListId").getter(getter(EC2DeleteRouteAction::destinationPrefixListId))
            .setter(setter(Builder::destinationPrefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").build())
            .build();

    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIpv6CidrBlock").getter(getter(EC2DeleteRouteAction::destinationIpv6CidrBlock))
            .setter(setter(Builder::destinationIpv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").build())
            .build();

    private static final SdkField<ActionTarget> ROUTE_TABLE_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("RouteTableId").getter(getter(EC2DeleteRouteAction::routeTableId)).setter(setter(Builder::routeTableId))
            .constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD,
            ROUTE_TABLE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String destinationCidrBlock;

    private final String destinationPrefixListId;

    private final String destinationIpv6CidrBlock;

    private final ActionTarget routeTableId;

    private EC2DeleteRouteAction(BuilderImpl builder) {
        this.description = builder.description;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.routeTableId = builder.routeTableId;
    }

    /**
     * <p>
     * A description of the DeleteRoute action.
     * </p>
     * 
     * @return A description of the DeleteRoute action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the route
     * exactly.
     * </p>
     * 
     * @return Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the
     *         route exactly.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * Information about the ID of the prefix list for the route.
     * </p>
     * 
     * @return Information about the ID of the prefix list for the route.
     */
    public final String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the route
     * exactly.
     * </p>
     * 
     * @return Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the
     *         route exactly.
     */
    public final String destinationIpv6CidrBlock() {
        return destinationIpv6CidrBlock;
    }

    /**
     * <p>
     * Information about the ID of the route table.
     * </p>
     * 
     * @return Information about the ID of the route table.
     */
    public final ActionTarget routeTableId() {
        return routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2DeleteRouteAction)) {
            return false;
        }
        EC2DeleteRouteAction other = (EC2DeleteRouteAction) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationPrefixListId(), other.destinationPrefixListId())
                && Objects.equals(destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock())
                && Objects.equals(routeTableId(), other.routeTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2DeleteRouteAction").add("Description", description())
                .add("DestinationCidrBlock", destinationCidrBlock()).add("DestinationPrefixListId", destinationPrefixListId())
                .add("DestinationIpv6CidrBlock", destinationIpv6CidrBlock()).add("RouteTableId", routeTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "DestinationPrefixListId":
            return Optional.ofNullable(clazz.cast(destinationPrefixListId()));
        case "DestinationIpv6CidrBlock":
            return Optional.ofNullable(clazz.cast(destinationIpv6CidrBlock()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2DeleteRouteAction, T> g) {
        return obj -> g.apply((EC2DeleteRouteAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2DeleteRouteAction> {
        /**
         * <p>
         * A description of the DeleteRoute action.
         * </p>
         * 
         * @param description
         *        A description of the DeleteRoute action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the route
         * exactly.
         * </p>
         * 
         * @param destinationCidrBlock
         *        Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the
         *        route exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * Information about the ID of the prefix list for the route.
         * </p>
         * 
         * @param destinationPrefixListId
         *        Information about the ID of the prefix list for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        /**
         * <p>
         * Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the route
         * exactly.
         * </p>
         * 
         * @param destinationIpv6CidrBlock
         *        Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the
         *        route exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock);

        /**
         * <p>
         * Information about the ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        Information about the ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(ActionTarget routeTableId);

        /**
         * <p>
         * Information about the ID of the route table.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #routeTableId(ActionTarget)}.
         * 
         * @param routeTableId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTableId(ActionTarget)
         */
        default Builder routeTableId(Consumer<ActionTarget.Builder> routeTableId) {
            return routeTableId(ActionTarget.builder().applyMutation(routeTableId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String destinationCidrBlock;

        private String destinationPrefixListId;

        private String destinationIpv6CidrBlock;

        private ActionTarget routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2DeleteRouteAction model) {
            description(model.description);
            destinationCidrBlock(model.destinationCidrBlock);
            destinationPrefixListId(model.destinationPrefixListId);
            destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            routeTableId(model.routeTableId);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final String getDestinationIpv6CidrBlock() {
            return destinationIpv6CidrBlock;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final ActionTarget.Builder getRouteTableId() {
            return routeTableId != null ? routeTableId.toBuilder() : null;
        }

        public final void setRouteTableId(ActionTarget.BuilderImpl routeTableId) {
            this.routeTableId = routeTableId != null ? routeTableId.build() : null;
        }

        @Override
        public final Builder routeTableId(ActionTarget routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        @Override
        public EC2DeleteRouteAction build() {
            return new EC2DeleteRouteAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
