/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Network Firewall firewall policy options to configure the policy's deployment model and third-party
 * firewall policy settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyOption implements SdkPojo, Serializable, ToCopyableBuilder<PolicyOption.Builder, PolicyOption> {
    private static final SdkField<NetworkFirewallPolicy> NETWORK_FIREWALL_POLICY_FIELD = SdkField
            .<NetworkFirewallPolicy> builder(MarshallingType.SDK_POJO).memberName("NetworkFirewallPolicy")
            .getter(getter(PolicyOption::networkFirewallPolicy)).setter(setter(Builder::networkFirewallPolicy))
            .constructor(NetworkFirewallPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallPolicy").build())
            .build();

    private static final SdkField<ThirdPartyFirewallPolicy> THIRD_PARTY_FIREWALL_POLICY_FIELD = SdkField
            .<ThirdPartyFirewallPolicy> builder(MarshallingType.SDK_POJO).memberName("ThirdPartyFirewallPolicy")
            .getter(getter(PolicyOption::thirdPartyFirewallPolicy)).setter(setter(Builder::thirdPartyFirewallPolicy))
            .constructor(ThirdPartyFirewallPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIREWALL_POLICY_FIELD,
            THIRD_PARTY_FIREWALL_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final NetworkFirewallPolicy networkFirewallPolicy;

    private final ThirdPartyFirewallPolicy thirdPartyFirewallPolicy;

    private PolicyOption(BuilderImpl builder) {
        this.networkFirewallPolicy = builder.networkFirewallPolicy;
        this.thirdPartyFirewallPolicy = builder.thirdPartyFirewallPolicy;
    }

    /**
     * <p>
     * Defines the deployment model to use for the firewall policy.
     * </p>
     * 
     * @return Defines the deployment model to use for the firewall policy.
     */
    public final NetworkFirewallPolicy networkFirewallPolicy() {
        return networkFirewallPolicy;
    }

    /**
     * <p>
     * Defines the policy options for a third-party firewall policy.
     * </p>
     * 
     * @return Defines the policy options for a third-party firewall policy.
     */
    public final ThirdPartyFirewallPolicy thirdPartyFirewallPolicy() {
        return thirdPartyFirewallPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkFirewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(thirdPartyFirewallPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyOption)) {
            return false;
        }
        PolicyOption other = (PolicyOption) obj;
        return Objects.equals(networkFirewallPolicy(), other.networkFirewallPolicy())
                && Objects.equals(thirdPartyFirewallPolicy(), other.thirdPartyFirewallPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyOption").add("NetworkFirewallPolicy", networkFirewallPolicy())
                .add("ThirdPartyFirewallPolicy", thirdPartyFirewallPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkFirewallPolicy":
            return Optional.ofNullable(clazz.cast(networkFirewallPolicy()));
        case "ThirdPartyFirewallPolicy":
            return Optional.ofNullable(clazz.cast(thirdPartyFirewallPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyOption, T> g) {
        return obj -> g.apply((PolicyOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyOption> {
        /**
         * <p>
         * Defines the deployment model to use for the firewall policy.
         * </p>
         * 
         * @param networkFirewallPolicy
         *        Defines the deployment model to use for the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFirewallPolicy(NetworkFirewallPolicy networkFirewallPolicy);

        /**
         * <p>
         * Defines the deployment model to use for the firewall policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkFirewallPolicy.Builder} avoiding
         * the need to create one manually via {@link NetworkFirewallPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFirewallPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #networkFirewallPolicy(NetworkFirewallPolicy)}.
         * 
         * @param networkFirewallPolicy
         *        a consumer that will call methods on {@link NetworkFirewallPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFirewallPolicy(NetworkFirewallPolicy)
         */
        default Builder networkFirewallPolicy(Consumer<NetworkFirewallPolicy.Builder> networkFirewallPolicy) {
            return networkFirewallPolicy(NetworkFirewallPolicy.builder().applyMutation(networkFirewallPolicy).build());
        }

        /**
         * <p>
         * Defines the policy options for a third-party firewall policy.
         * </p>
         * 
         * @param thirdPartyFirewallPolicy
         *        Defines the policy options for a third-party firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thirdPartyFirewallPolicy(ThirdPartyFirewallPolicy thirdPartyFirewallPolicy);

        /**
         * <p>
         * Defines the policy options for a third-party firewall policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThirdPartyFirewallPolicy.Builder}
         * avoiding the need to create one manually via {@link ThirdPartyFirewallPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThirdPartyFirewallPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #thirdPartyFirewallPolicy(ThirdPartyFirewallPolicy)}.
         * 
         * @param thirdPartyFirewallPolicy
         *        a consumer that will call methods on {@link ThirdPartyFirewallPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thirdPartyFirewallPolicy(ThirdPartyFirewallPolicy)
         */
        default Builder thirdPartyFirewallPolicy(Consumer<ThirdPartyFirewallPolicy.Builder> thirdPartyFirewallPolicy) {
            return thirdPartyFirewallPolicy(ThirdPartyFirewallPolicy.builder().applyMutation(thirdPartyFirewallPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NetworkFirewallPolicy networkFirewallPolicy;

        private ThirdPartyFirewallPolicy thirdPartyFirewallPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyOption model) {
            networkFirewallPolicy(model.networkFirewallPolicy);
            thirdPartyFirewallPolicy(model.thirdPartyFirewallPolicy);
        }

        public final NetworkFirewallPolicy.Builder getNetworkFirewallPolicy() {
            return networkFirewallPolicy != null ? networkFirewallPolicy.toBuilder() : null;
        }

        public final void setNetworkFirewallPolicy(NetworkFirewallPolicy.BuilderImpl networkFirewallPolicy) {
            this.networkFirewallPolicy = networkFirewallPolicy != null ? networkFirewallPolicy.build() : null;
        }

        @Override
        public final Builder networkFirewallPolicy(NetworkFirewallPolicy networkFirewallPolicy) {
            this.networkFirewallPolicy = networkFirewallPolicy;
            return this;
        }

        public final ThirdPartyFirewallPolicy.Builder getThirdPartyFirewallPolicy() {
            return thirdPartyFirewallPolicy != null ? thirdPartyFirewallPolicy.toBuilder() : null;
        }

        public final void setThirdPartyFirewallPolicy(ThirdPartyFirewallPolicy.BuilderImpl thirdPartyFirewallPolicy) {
            this.thirdPartyFirewallPolicy = thirdPartyFirewallPolicy != null ? thirdPartyFirewallPolicy.build() : null;
        }

        @Override
        public final Builder thirdPartyFirewallPolicy(ThirdPartyFirewallPolicy thirdPartyFirewallPolicy) {
            this.thirdPartyFirewallPolicy = thirdPartyFirewallPolicy;
            return this;
        }

        @Override
        public PolicyOption build() {
            return new PolicyOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
