/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.fms.model.AssociateAdminAccountRequest;
import software.amazon.awssdk.services.fms.model.AssociateAdminAccountResponse;
import software.amazon.awssdk.services.fms.model.AssociateThirdPartyFirewallRequest;
import software.amazon.awssdk.services.fms.model.AssociateThirdPartyFirewallResponse;
import software.amazon.awssdk.services.fms.model.DeleteAppsListRequest;
import software.amazon.awssdk.services.fms.model.DeleteAppsListResponse;
import software.amazon.awssdk.services.fms.model.DeleteNotificationChannelRequest;
import software.amazon.awssdk.services.fms.model.DeleteNotificationChannelResponse;
import software.amazon.awssdk.services.fms.model.DeletePolicyRequest;
import software.amazon.awssdk.services.fms.model.DeletePolicyResponse;
import software.amazon.awssdk.services.fms.model.DeleteProtocolsListRequest;
import software.amazon.awssdk.services.fms.model.DeleteProtocolsListResponse;
import software.amazon.awssdk.services.fms.model.DisassociateAdminAccountRequest;
import software.amazon.awssdk.services.fms.model.DisassociateAdminAccountResponse;
import software.amazon.awssdk.services.fms.model.DisassociateThirdPartyFirewallRequest;
import software.amazon.awssdk.services.fms.model.DisassociateThirdPartyFirewallResponse;
import software.amazon.awssdk.services.fms.model.GetAdminAccountRequest;
import software.amazon.awssdk.services.fms.model.GetAdminAccountResponse;
import software.amazon.awssdk.services.fms.model.GetAppsListRequest;
import software.amazon.awssdk.services.fms.model.GetAppsListResponse;
import software.amazon.awssdk.services.fms.model.GetComplianceDetailRequest;
import software.amazon.awssdk.services.fms.model.GetComplianceDetailResponse;
import software.amazon.awssdk.services.fms.model.GetNotificationChannelRequest;
import software.amazon.awssdk.services.fms.model.GetNotificationChannelResponse;
import software.amazon.awssdk.services.fms.model.GetPolicyRequest;
import software.amazon.awssdk.services.fms.model.GetPolicyResponse;
import software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest;
import software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse;
import software.amazon.awssdk.services.fms.model.GetProtocolsListRequest;
import software.amazon.awssdk.services.fms.model.GetProtocolsListResponse;
import software.amazon.awssdk.services.fms.model.GetThirdPartyFirewallAssociationStatusRequest;
import software.amazon.awssdk.services.fms.model.GetThirdPartyFirewallAssociationStatusResponse;
import software.amazon.awssdk.services.fms.model.GetViolationDetailsRequest;
import software.amazon.awssdk.services.fms.model.GetViolationDetailsResponse;
import software.amazon.awssdk.services.fms.model.ListAppsListsRequest;
import software.amazon.awssdk.services.fms.model.ListAppsListsResponse;
import software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest;
import software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse;
import software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse;
import software.amazon.awssdk.services.fms.model.ListPoliciesRequest;
import software.amazon.awssdk.services.fms.model.ListPoliciesResponse;
import software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest;
import software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse;
import software.amazon.awssdk.services.fms.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fms.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest;
import software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse;
import software.amazon.awssdk.services.fms.model.PutAppsListRequest;
import software.amazon.awssdk.services.fms.model.PutAppsListResponse;
import software.amazon.awssdk.services.fms.model.PutNotificationChannelRequest;
import software.amazon.awssdk.services.fms.model.PutNotificationChannelResponse;
import software.amazon.awssdk.services.fms.model.PutPolicyRequest;
import software.amazon.awssdk.services.fms.model.PutPolicyResponse;
import software.amazon.awssdk.services.fms.model.PutProtocolsListRequest;
import software.amazon.awssdk.services.fms.model.PutProtocolsListResponse;
import software.amazon.awssdk.services.fms.model.TagResourceRequest;
import software.amazon.awssdk.services.fms.model.TagResourceResponse;
import software.amazon.awssdk.services.fms.model.UntagResourceRequest;
import software.amazon.awssdk.services.fms.model.UntagResourceResponse;
import software.amazon.awssdk.services.fms.paginators.ListAppsListsPublisher;
import software.amazon.awssdk.services.fms.paginators.ListComplianceStatusPublisher;
import software.amazon.awssdk.services.fms.paginators.ListMemberAccountsPublisher;
import software.amazon.awssdk.services.fms.paginators.ListPoliciesPublisher;
import software.amazon.awssdk.services.fms.paginators.ListProtocolsListsPublisher;
import software.amazon.awssdk.services.fms.paginators.ListThirdPartyFirewallFirewallPoliciesPublisher;

/**
 * Service client for accessing FMS asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the <i>Firewall Manager API Reference</i>. This guide is for developers who need detailed information about
 * the Firewall Manager API actions, data types, and errors. For detailed information about Firewall Manager features,
 * see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-chapter.html">Firewall Manager Developer
 * Guide</a>.
 * </p>
 * <p>
 * Some API actions require explicit resource permissions. For information, see the developer guide topic <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html">Firewall Manager required
 * permissions for API actions</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface FmsAsyncClient extends SdkClient {
    String SERVICE_NAME = "fms";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "fms";

    /**
     * Create a {@link FmsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FmsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FmsAsyncClient}.
     */
    static FmsAsyncClientBuilder builder() {
        return new DefaultFmsAsyncClientBuilder();
    }

    /**
     * <p>
     * Sets the Firewall Manager administrator account. The account must be a member of the organization in
     * Organizations whose resources you want to protect. Firewall Manager sets the permissions that allow the account
     * to administer your Firewall Manager policies.
     * </p>
     * <p>
     * The account that you associate with Firewall Manager is called the Firewall Manager administrator account.
     * </p>
     *
     * @param associateAdminAccountRequest
     * @return A Java Future containing the result of the AssociateAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.AssociateAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateAdminAccountResponse> associateAdminAccount(
            AssociateAdminAccountRequest associateAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the Firewall Manager administrator account. The account must be a member of the organization in
     * Organizations whose resources you want to protect. Firewall Manager sets the permissions that allow the account
     * to administer your Firewall Manager policies.
     * </p>
     * <p>
     * The account that you associate with Firewall Manager is called the Firewall Manager administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAdminAccountRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateAdminAccountRequest#builder()}
     * </p>
     *
     * @param associateAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAdminAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.AssociateAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateAdminAccountResponse> associateAdminAccount(
            Consumer<AssociateAdminAccountRequest.Builder> associateAdminAccountRequest) {
        return associateAdminAccount(AssociateAdminAccountRequest.builder().applyMutation(associateAdminAccountRequest).build());
    }

    /**
     * <p>
     * Sets the Firewall Manager policy administrator as a tenant administrator of a third-party firewall service. A
     * tenant is an instance of the third-party firewall service that's associated with your Amazon Web Services
     * customer account.
     * </p>
     *
     * @param associateThirdPartyFirewallRequest
     * @return A Java Future containing the result of the AssociateThirdPartyFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.AssociateThirdPartyFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateThirdPartyFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateThirdPartyFirewallResponse> associateThirdPartyFirewall(
            AssociateThirdPartyFirewallRequest associateThirdPartyFirewallRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the Firewall Manager policy administrator as a tenant administrator of a third-party firewall service. A
     * tenant is an instance of the third-party firewall service that's associated with your Amazon Web Services
     * customer account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateThirdPartyFirewallRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateThirdPartyFirewallRequest#builder()}
     * </p>
     *
     * @param associateThirdPartyFirewallRequest
     *        A {@link Consumer} that will call methods on {@link AssociateThirdPartyFirewallRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateThirdPartyFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.AssociateThirdPartyFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateThirdPartyFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateThirdPartyFirewallResponse> associateThirdPartyFirewall(
            Consumer<AssociateThirdPartyFirewallRequest.Builder> associateThirdPartyFirewallRequest) {
        return associateThirdPartyFirewall(AssociateThirdPartyFirewallRequest.builder()
                .applyMutation(associateThirdPartyFirewallRequest).build());
    }

    /**
     * <p>
     * Permanently deletes an Firewall Manager applications list.
     * </p>
     *
     * @param deleteAppsListRequest
     * @return A Java Future containing the result of the DeleteAppsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DeleteAppsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteAppsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppsListResponse> deleteAppsList(DeleteAppsListRequest deleteAppsListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes an Firewall Manager applications list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppsListRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppsListRequest#builder()}
     * </p>
     *
     * @param deleteAppsListRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppsListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAppsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DeleteAppsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteAppsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppsListResponse> deleteAppsList(Consumer<DeleteAppsListRequest.Builder> deleteAppsListRequest) {
        return deleteAppsList(DeleteAppsListRequest.builder().applyMutation(deleteAppsListRequest).build());
    }

    /**
     * <p>
     * Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic
     * that is used to record Firewall Manager SNS logs.
     * </p>
     *
     * @param deleteNotificationChannelRequest
     * @return A Java Future containing the result of the DeleteNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DeleteNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationChannelResponse> deleteNotificationChannel(
            DeleteNotificationChannelRequest deleteNotificationChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic
     * that is used to record Firewall Manager SNS logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationChannelRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteNotificationChannelRequest#builder()}
     * </p>
     *
     * @param deleteNotificationChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNotificationChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DeleteNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationChannelResponse> deleteNotificationChannel(
            Consumer<DeleteNotificationChannelRequest.Builder> deleteNotificationChannelRequest) {
        return deleteNotificationChannel(DeleteNotificationChannelRequest.builder()
                .applyMutation(deleteNotificationChannelRequest).build());
    }

    /**
     * <p>
     * Permanently deletes an Firewall Manager policy.
     * </p>
     *
     * @param deletePolicyRequest
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes an Firewall Manager policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest) {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Permanently deletes an Firewall Manager protocols list.
     * </p>
     *
     * @param deleteProtocolsListRequest
     * @return A Java Future containing the result of the DeleteProtocolsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DeleteProtocolsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteProtocolsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProtocolsListResponse> deleteProtocolsList(
            DeleteProtocolsListRequest deleteProtocolsListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes an Firewall Manager protocols list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProtocolsListRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProtocolsListRequest#builder()}
     * </p>
     *
     * @param deleteProtocolsListRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProtocolsListRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProtocolsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DeleteProtocolsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteProtocolsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProtocolsListResponse> deleteProtocolsList(
            Consumer<DeleteProtocolsListRequest.Builder> deleteProtocolsListRequest) {
        return deleteProtocolsList(DeleteProtocolsListRequest.builder().applyMutation(deleteProtocolsListRequest).build());
    }

    /**
     * <p>
     * Disassociates the account that has been set as the Firewall Manager administrator account. To set a different
     * account as the administrator account, you must submit an <code>AssociateAdminAccount</code> request.
     * </p>
     *
     * @param disassociateAdminAccountRequest
     * @return A Java Future containing the result of the DisassociateAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DisassociateAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateAdminAccountResponse> disassociateAdminAccount(
            DisassociateAdminAccountRequest disassociateAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the account that has been set as the Firewall Manager administrator account. To set a different
     * account as the administrator account, you must submit an <code>AssociateAdminAccount</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAdminAccountRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateAdminAccountRequest#builder()}
     * </p>
     *
     * @param disassociateAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateAdminAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DisassociateAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateAdminAccountResponse> disassociateAdminAccount(
            Consumer<DisassociateAdminAccountRequest.Builder> disassociateAdminAccountRequest) {
        return disassociateAdminAccount(DisassociateAdminAccountRequest.builder().applyMutation(disassociateAdminAccountRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates a Firewall Manager policy administrator from a third-party firewall tenant. When you call
     * <code>DisassociateThirdPartyFirewall</code>, the third-party firewall vendor deletes all of the firewalls that
     * are associated with the account.
     * </p>
     *
     * @param disassociateThirdPartyFirewallRequest
     * @return A Java Future containing the result of the DisassociateThirdPartyFirewall operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DisassociateThirdPartyFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateThirdPartyFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateThirdPartyFirewallResponse> disassociateThirdPartyFirewall(
            DisassociateThirdPartyFirewallRequest disassociateThirdPartyFirewallRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Firewall Manager policy administrator from a third-party firewall tenant. When you call
     * <code>DisassociateThirdPartyFirewall</code>, the third-party firewall vendor deletes all of the firewalls that
     * are associated with the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateThirdPartyFirewallRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateThirdPartyFirewallRequest#builder()}
     * </p>
     *
     * @param disassociateThirdPartyFirewallRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateThirdPartyFirewallRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateThirdPartyFirewall operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.DisassociateThirdPartyFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateThirdPartyFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateThirdPartyFirewallResponse> disassociateThirdPartyFirewall(
            Consumer<DisassociateThirdPartyFirewallRequest.Builder> disassociateThirdPartyFirewallRequest) {
        return disassociateThirdPartyFirewall(DisassociateThirdPartyFirewallRequest.builder()
                .applyMutation(disassociateThirdPartyFirewallRequest).build());
    }

    /**
     * <p>
     * Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager administrator.
     * </p>
     *
     * @param getAdminAccountRequest
     * @return A Java Future containing the result of the GetAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAdminAccountResponse> getAdminAccount(GetAdminAccountRequest getAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdminAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetAdminAccountRequest#builder()}
     * </p>
     *
     * @param getAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAdminAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAdminAccountResponse> getAdminAccount(
            Consumer<GetAdminAccountRequest.Builder> getAdminAccountRequest) {
        return getAdminAccount(GetAdminAccountRequest.builder().applyMutation(getAdminAccountRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Firewall Manager applications list.
     * </p>
     *
     * @param getAppsListRequest
     * @return A Java Future containing the result of the GetAppsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetAppsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAppsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppsListResponse> getAppsList(GetAppsListRequest getAppsListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Firewall Manager applications list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppsListRequest.Builder} avoiding the need to
     * create one manually via {@link GetAppsListRequest#builder()}
     * </p>
     *
     * @param getAppsListRequest
     *        A {@link Consumer} that will call methods on {@link GetAppsListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAppsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetAppsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAppsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppsListResponse> getAppsList(Consumer<GetAppsListRequest.Builder> getAppsListRequest) {
        return getAppsList(GetAppsListRequest.builder().applyMutation(getAppsListRequest).build());
    }

    /**
     * <p>
     * Returns detailed compliance information about the specified member account. Details include resources that are in
     * and out of compliance with the specified policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Resources are considered noncompliant for WAF and Shield Advanced policies if the specified policy has not been
     * applied to them.
     * </p>
     * </li>
     * <li>
     * <p>
     * Resources are considered noncompliant for security group policies if they are in scope of the policy, they
     * violate one or more of the policy rules, and remediation is disabled or not possible.
     * </p>
     * </li>
     * <li>
     * <p>
     * Resources are considered noncompliant for Network Firewall policies if a firewall is missing in the VPC, if the
     * firewall endpoint isn't set up in an expected Availability Zone and subnet, if a subnet created by the Firewall
     * Manager doesn't have the expected route table, and for modifications to a firewall policy that violate the
     * Firewall Manager policy's rules.
     * </p>
     * </li>
     * <li>
     * <p>
     * Resources are considered noncompliant for DNS Firewall policies if a DNS Firewall rule group is missing from the
     * rule group associations for the VPC.
     * </p>
     * </li>
     * </ul>
     *
     * @param getComplianceDetailRequest
     * @return A Java Future containing the result of the GetComplianceDetail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetComplianceDetail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailResponse> getComplianceDetail(
            GetComplianceDetailRequest getComplianceDetailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed compliance information about the specified member account. Details include resources that are in
     * and out of compliance with the specified policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Resources are considered noncompliant for WAF and Shield Advanced policies if the specified policy has not been
     * applied to them.
     * </p>
     * </li>
     * <li>
     * <p>
     * Resources are considered noncompliant for security group policies if they are in scope of the policy, they
     * violate one or more of the policy rules, and remediation is disabled or not possible.
     * </p>
     * </li>
     * <li>
     * <p>
     * Resources are considered noncompliant for Network Firewall policies if a firewall is missing in the VPC, if the
     * firewall endpoint isn't set up in an expected Availability Zone and subnet, if a subnet created by the Firewall
     * Manager doesn't have the expected route table, and for modifications to a firewall policy that violate the
     * Firewall Manager policy's rules.
     * </p>
     * </li>
     * <li>
     * <p>
     * Resources are considered noncompliant for DNS Firewall policies if a DNS Firewall rule group is missing from the
     * rule group associations for the VPC.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailRequest.Builder} avoiding the
     * need to create one manually via {@link GetComplianceDetailRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailRequest
     *        A {@link Consumer} that will call methods on {@link GetComplianceDetailRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetComplianceDetail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetComplianceDetail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailResponse> getComplianceDetail(
            Consumer<GetComplianceDetailRequest.Builder> getComplianceDetailRequest) {
        return getComplianceDetail(GetComplianceDetailRequest.builder().applyMutation(getComplianceDetailRequest).build());
    }

    /**
     * <p>
     * Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS
     * logs.
     * </p>
     *
     * @param getNotificationChannelRequest
     * @return A Java Future containing the result of the GetNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNotificationChannelResponse> getNotificationChannel(
            GetNotificationChannelRequest getNotificationChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS
     * logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationChannelRequest.Builder} avoiding the
     * need to create one manually via {@link GetNotificationChannelRequest#builder()}
     * </p>
     *
     * @param getNotificationChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetNotificationChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNotificationChannelResponse> getNotificationChannel(
            Consumer<GetNotificationChannelRequest.Builder> getNotificationChannelRequest) {
        return getNotificationChannel(GetNotificationChannelRequest.builder().applyMutation(getNotificationChannelRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the specified Firewall Manager policy.
     * </p>
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidTypeException The value of the <code>Type</code> parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Firewall Manager policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidTypeException The value of the <code>Type</code> parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a
     * potential DDoS attack. Other policy types are currently unsupported.
     * </p>
     *
     * @param getProtectionStatusRequest
     * @return A Java Future containing the result of the GetProtectionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetProtectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProtectionStatusResponse> getProtectionStatus(
            GetProtectionStatusRequest getProtectionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a
     * potential DDoS attack. Other policy types are currently unsupported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProtectionStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetProtectionStatusRequest#builder()}
     * </p>
     *
     * @param getProtectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetProtectionStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetProtectionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetProtectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProtectionStatusResponse> getProtectionStatus(
            Consumer<GetProtectionStatusRequest.Builder> getProtectionStatusRequest) {
        return getProtectionStatus(GetProtectionStatusRequest.builder().applyMutation(getProtectionStatusRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Firewall Manager protocols list.
     * </p>
     *
     * @param getProtocolsListRequest
     * @return A Java Future containing the result of the GetProtocolsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetProtocolsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtocolsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProtocolsListResponse> getProtocolsList(GetProtocolsListRequest getProtocolsListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Firewall Manager protocols list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProtocolsListRequest.Builder} avoiding the need
     * to create one manually via {@link GetProtocolsListRequest#builder()}
     * </p>
     *
     * @param getProtocolsListRequest
     *        A {@link Consumer} that will call methods on {@link GetProtocolsListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetProtocolsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetProtocolsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtocolsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProtocolsListResponse> getProtocolsList(
            Consumer<GetProtocolsListRequest.Builder> getProtocolsListRequest) {
        return getProtocolsList(GetProtocolsListRequest.builder().applyMutation(getProtocolsListRequest).build());
    }

    /**
     * <p>
     * The onboarding status of a Firewall Manager admin account to third-party firewall vendor tenant.
     * </p>
     *
     * @param getThirdPartyFirewallAssociationStatusRequest
     * @return A Java Future containing the result of the GetThirdPartyFirewallAssociationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetThirdPartyFirewallAssociationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetThirdPartyFirewallAssociationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetThirdPartyFirewallAssociationStatusResponse> getThirdPartyFirewallAssociationStatus(
            GetThirdPartyFirewallAssociationStatusRequest getThirdPartyFirewallAssociationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The onboarding status of a Firewall Manager admin account to third-party firewall vendor tenant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetThirdPartyFirewallAssociationStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetThirdPartyFirewallAssociationStatusRequest#builder()}
     * </p>
     *
     * @param getThirdPartyFirewallAssociationStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetThirdPartyFirewallAssociationStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetThirdPartyFirewallAssociationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetThirdPartyFirewallAssociationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetThirdPartyFirewallAssociationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetThirdPartyFirewallAssociationStatusResponse> getThirdPartyFirewallAssociationStatus(
            Consumer<GetThirdPartyFirewallAssociationStatusRequest.Builder> getThirdPartyFirewallAssociationStatusRequest) {
        return getThirdPartyFirewallAssociationStatus(GetThirdPartyFirewallAssociationStatusRequest.builder()
                .applyMutation(getThirdPartyFirewallAssociationStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services
     * account.
     * </p>
     *
     * @param getViolationDetailsRequest
     * @return A Java Future containing the result of the GetViolationDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetViolationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetViolationDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetViolationDetailsResponse> getViolationDetails(
            GetViolationDetailsRequest getViolationDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetViolationDetailsRequest.Builder} avoiding the
     * need to create one manually via {@link GetViolationDetailsRequest#builder()}
     * </p>
     *
     * @param getViolationDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetViolationDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetViolationDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.GetViolationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetViolationDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetViolationDetailsResponse> getViolationDetails(
            Consumer<GetViolationDetailsRequest.Builder> getViolationDetailsRequest) {
        return getViolationDetails(GetViolationDetailsRequest.builder().applyMutation(getViolationDetailsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>AppsListDataSummary</code> objects.
     * </p>
     *
     * @param listAppsListsRequest
     * @return A Java Future containing the result of the ListAppsLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListAppsLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAppsLists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppsListsResponse> listAppsLists(ListAppsListsRequest listAppsListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>AppsListDataSummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsListsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsListsRequest#builder()}
     * </p>
     *
     * @param listAppsListsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsListsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAppsLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListAppsLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAppsLists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppsListsResponse> listAppsLists(Consumer<ListAppsListsRequest.Builder> listAppsListsRequest) {
        return listAppsLists(ListAppsListsRequest.builder().applyMutation(listAppsListsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>AppsListDataSummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAppsLists(software.amazon.awssdk.services.fms.model.ListAppsListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListAppsListsPublisher publisher = client.listAppsListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListAppsListsPublisher publisher = client.listAppsListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListAppsListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListAppsListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppsLists(software.amazon.awssdk.services.fms.model.ListAppsListsRequest)} operation.</b>
     * </p>
     *
     * @param listAppsListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListAppsLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAppsLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsListsPublisher listAppsListsPaginator(ListAppsListsRequest listAppsListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>AppsListDataSummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAppsLists(software.amazon.awssdk.services.fms.model.ListAppsListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListAppsListsPublisher publisher = client.listAppsListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListAppsListsPublisher publisher = client.listAppsListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListAppsListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListAppsListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppsLists(software.amazon.awssdk.services.fms.model.ListAppsListsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsListsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsListsRequest#builder()}
     * </p>
     *
     * @param listAppsListsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsListsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListAppsLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAppsLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsListsPublisher listAppsListsPaginator(Consumer<ListAppsListsRequest.Builder> listAppsListsRequest) {
        return listAppsListsPaginator(ListAppsListsRequest.builder().applyMutation(listAppsListsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>PolicyComplianceStatus</code> objects. Use <code>PolicyComplianceStatus</code> to get a
     * summary of which member accounts are protected by the specified policy.
     * </p>
     *
     * @param listComplianceStatusRequest
     * @return A Java Future containing the result of the ListComplianceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListComplianceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComplianceStatusResponse> listComplianceStatus(
            ListComplianceStatusRequest listComplianceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>PolicyComplianceStatus</code> objects. Use <code>PolicyComplianceStatus</code> to get a
     * summary of which member accounts are protected by the specified policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceStatusRequest#builder()}
     * </p>
     *
     * @param listComplianceStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComplianceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListComplianceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComplianceStatusResponse> listComplianceStatus(
            Consumer<ListComplianceStatusRequest.Builder> listComplianceStatusRequest) {
        return listComplianceStatus(ListComplianceStatusRequest.builder().applyMutation(listComplianceStatusRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>PolicyComplianceStatus</code> objects. Use <code>PolicyComplianceStatus</code> to get a
     * summary of which member accounts are protected by the specified policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceStatus(software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListComplianceStatusPublisher publisher = client.listComplianceStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListComplianceStatusPublisher publisher = client.listComplianceStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceStatus(software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComplianceStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListComplianceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceStatusPublisher listComplianceStatusPaginator(ListComplianceStatusRequest listComplianceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>PolicyComplianceStatus</code> objects. Use <code>PolicyComplianceStatus</code> to get a
     * summary of which member accounts are protected by the specified policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceStatus(software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListComplianceStatusPublisher publisher = client.listComplianceStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListComplianceStatusPublisher publisher = client.listComplianceStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceStatus(software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceStatusRequest#builder()}
     * </p>
     *
     * @param listComplianceStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceStatusRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListComplianceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceStatusPublisher listComplianceStatusPaginator(
            Consumer<ListComplianceStatusRequest.Builder> listComplianceStatusRequest) {
        return listComplianceStatusPaginator(ListComplianceStatusRequest.builder().applyMutation(listComplianceStatusRequest)
                .build());
    }

    /**
     * <p>
     * Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's Amazon Web
     * Services organization.
     * </p>
     * <p>
     * The <code>ListMemberAccounts</code> must be submitted by the account that is set as the Firewall Manager
     * administrator.
     * </p>
     *
     * @param listMemberAccountsRequest
     * @return A Java Future containing the result of the ListMemberAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListMemberAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMemberAccountsResponse> listMemberAccounts(ListMemberAccountsRequest listMemberAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's Amazon Web
     * Services organization.
     * </p>
     * <p>
     * The <code>ListMemberAccounts</code> must be submitted by the account that is set as the Firewall Manager
     * administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemberAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMemberAccountsRequest#builder()}
     * </p>
     *
     * @param listMemberAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListMemberAccountsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMemberAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListMemberAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMemberAccountsResponse> listMemberAccounts(
            Consumer<ListMemberAccountsRequest.Builder> listMemberAccountsRequest) {
        return listMemberAccounts(ListMemberAccountsRequest.builder().applyMutation(listMemberAccountsRequest).build());
    }

    /**
     * <p>
     * Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's Amazon Web
     * Services organization.
     * </p>
     * <p>
     * The <code>ListMemberAccounts</code> must be submitted by the account that is set as the Firewall Manager
     * administrator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMemberAccounts(software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberAccounts(software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest)} operation.</b>
     * </p>
     *
     * @param listMemberAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListMemberAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMemberAccountsPublisher listMemberAccountsPaginator(ListMemberAccountsRequest listMemberAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's Amazon Web
     * Services organization.
     * </p>
     * <p>
     * The <code>ListMemberAccounts</code> must be submitted by the account that is set as the Firewall Manager
     * administrator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMemberAccounts(software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberAccounts(software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemberAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMemberAccountsRequest#builder()}
     * </p>
     *
     * @param listMemberAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListMemberAccountsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListMemberAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMemberAccountsPublisher listMemberAccountsPaginator(
            Consumer<ListMemberAccountsRequest.Builder> listMemberAccountsRequest) {
        return listMemberAccountsPaginator(ListMemberAccountsRequest.builder().applyMutation(listMemberAccountsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>PolicySummary</code> objects.
     * </p>
     *
     * @param listPoliciesRequest
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>PolicySummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListPoliciesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest) {
        return listPolicies(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>PolicySummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.fms.model.ListPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.fms.model.ListPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesPublisher listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>PolicySummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.fms.model.ListPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.fms.model.ListPoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListPoliciesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesPublisher listPoliciesPaginator(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest) {
        return listPoliciesPaginator(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>ProtocolsListDataSummary</code> objects.
     * </p>
     *
     * @param listProtocolsListsRequest
     * @return A Java Future containing the result of the ListProtocolsLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListProtocolsLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListProtocolsLists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProtocolsListsResponse> listProtocolsLists(ListProtocolsListsRequest listProtocolsListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>ProtocolsListDataSummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtocolsListsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtocolsListsRequest#builder()}
     * </p>
     *
     * @param listProtocolsListsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtocolsListsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProtocolsLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListProtocolsLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListProtocolsLists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProtocolsListsResponse> listProtocolsLists(
            Consumer<ListProtocolsListsRequest.Builder> listProtocolsListsRequest) {
        return listProtocolsLists(ListProtocolsListsRequest.builder().applyMutation(listProtocolsListsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>ProtocolsListDataSummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtocolsLists(software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListProtocolsListsPublisher publisher = client.listProtocolsListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListProtocolsListsPublisher publisher = client.listProtocolsListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtocolsLists(software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest)} operation.</b>
     * </p>
     *
     * @param listProtocolsListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListProtocolsLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListProtocolsLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtocolsListsPublisher listProtocolsListsPaginator(ListProtocolsListsRequest listProtocolsListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>ProtocolsListDataSummary</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtocolsLists(software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListProtocolsListsPublisher publisher = client.listProtocolsListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListProtocolsListsPublisher publisher = client.listProtocolsListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtocolsLists(software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtocolsListsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtocolsListsRequest#builder()}
     * </p>
     *
     * @param listProtocolsListsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtocolsListsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListProtocolsLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListProtocolsLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtocolsListsPublisher listProtocolsListsPaginator(
            Consumer<ListProtocolsListsRequest.Builder> listProtocolsListsRequest) {
        return listProtocolsListsPaginator(ListProtocolsListsRequest.builder().applyMutation(listProtocolsListsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of tags for the specified Amazon Web Services resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of tags for the specified Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall
     * administrator's account.
     * </p>
     *
     * @param listThirdPartyFirewallFirewallPoliciesRequest
     * @return A Java Future containing the result of the ListThirdPartyFirewallFirewallPolicies operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListThirdPartyFirewallFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListThirdPartyFirewallFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListThirdPartyFirewallFirewallPoliciesResponse> listThirdPartyFirewallFirewallPolicies(
            ListThirdPartyFirewallFirewallPoliciesRequest listThirdPartyFirewallFirewallPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall
     * administrator's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListThirdPartyFirewallFirewallPoliciesRequest.Builder} avoiding the need to create one manually via
     * {@link ListThirdPartyFirewallFirewallPoliciesRequest#builder()}
     * </p>
     *
     * @param listThirdPartyFirewallFirewallPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListThirdPartyFirewallFirewallPoliciesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListThirdPartyFirewallFirewallPolicies operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListThirdPartyFirewallFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListThirdPartyFirewallFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListThirdPartyFirewallFirewallPoliciesResponse> listThirdPartyFirewallFirewallPolicies(
            Consumer<ListThirdPartyFirewallFirewallPoliciesRequest.Builder> listThirdPartyFirewallFirewallPoliciesRequest) {
        return listThirdPartyFirewallFirewallPolicies(ListThirdPartyFirewallFirewallPoliciesRequest.builder()
                .applyMutation(listThirdPartyFirewallFirewallPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall
     * administrator's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThirdPartyFirewallFirewallPolicies(software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListThirdPartyFirewallFirewallPoliciesPublisher publisher = client.listThirdPartyFirewallFirewallPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListThirdPartyFirewallFirewallPoliciesPublisher publisher = client.listThirdPartyFirewallFirewallPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThirdPartyFirewallFirewallPolicies(software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listThirdPartyFirewallFirewallPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListThirdPartyFirewallFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListThirdPartyFirewallFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListThirdPartyFirewallFirewallPoliciesPublisher listThirdPartyFirewallFirewallPoliciesPaginator(
            ListThirdPartyFirewallFirewallPoliciesRequest listThirdPartyFirewallFirewallPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall
     * administrator's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThirdPartyFirewallFirewallPolicies(software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListThirdPartyFirewallFirewallPoliciesPublisher publisher = client.listThirdPartyFirewallFirewallPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListThirdPartyFirewallFirewallPoliciesPublisher publisher = client.listThirdPartyFirewallFirewallPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThirdPartyFirewallFirewallPolicies(software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListThirdPartyFirewallFirewallPoliciesRequest.Builder} avoiding the need to create one manually via
     * {@link ListThirdPartyFirewallFirewallPoliciesRequest#builder()}
     * </p>
     *
     * @param listThirdPartyFirewallFirewallPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListThirdPartyFirewallFirewallPoliciesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.ListThirdPartyFirewallFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListThirdPartyFirewallFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListThirdPartyFirewallFirewallPoliciesPublisher listThirdPartyFirewallFirewallPoliciesPaginator(
            Consumer<ListThirdPartyFirewallFirewallPoliciesRequest.Builder> listThirdPartyFirewallFirewallPoliciesRequest) {
        return listThirdPartyFirewallFirewallPoliciesPaginator(ListThirdPartyFirewallFirewallPoliciesRequest.builder()
                .applyMutation(listThirdPartyFirewallFirewallPoliciesRequest).build());
    }

    /**
     * <p>
     * Creates an Firewall Manager applications list.
     * </p>
     *
     * @param putAppsListRequest
     * @return A Java Future containing the result of the PutAppsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.PutAppsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutAppsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAppsListResponse> putAppsList(PutAppsListRequest putAppsListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Firewall Manager applications list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAppsListRequest.Builder} avoiding the need to
     * create one manually via {@link PutAppsListRequest#builder()}
     * </p>
     *
     * @param putAppsListRequest
     *        A {@link Consumer} that will call methods on {@link PutAppsListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutAppsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.PutAppsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutAppsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAppsListResponse> putAppsList(Consumer<PutAppsListRequest.Builder> putAppsListRequest) {
        return putAppsList(PutAppsListRequest.builder().applyMutation(putAppsListRequest).build());
    }

    /**
     * <p>
     * Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record
     * SNS logs.
     * </p>
     * <p>
     * To perform this action outside of the console, you must configure the SNS topic to allow the Firewall Manager
     * role <code>AWSServiceRoleForFMS</code> to publish SNS logs. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html">Firewall Manager
     * required permissions for API actions</a> in the <i>Firewall Manager Developer Guide</i>.
     * </p>
     *
     * @param putNotificationChannelRequest
     * @return A Java Future containing the result of the PutNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.PutNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutNotificationChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutNotificationChannelResponse> putNotificationChannel(
            PutNotificationChannelRequest putNotificationChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record
     * SNS logs.
     * </p>
     * <p>
     * To perform this action outside of the console, you must configure the SNS topic to allow the Firewall Manager
     * role <code>AWSServiceRoleForFMS</code> to publish SNS logs. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html">Firewall Manager
     * required permissions for API actions</a> in the <i>Firewall Manager Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutNotificationChannelRequest.Builder} avoiding the
     * need to create one manually via {@link PutNotificationChannelRequest#builder()}
     * </p>
     *
     * @param putNotificationChannelRequest
     *        A {@link Consumer} that will call methods on {@link PutNotificationChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.PutNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutNotificationChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutNotificationChannelResponse> putNotificationChannel(
            Consumer<PutNotificationChannelRequest.Builder> putNotificationChannelRequest) {
        return putNotificationChannel(PutNotificationChannelRequest.builder().applyMutation(putNotificationChannelRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Firewall Manager policy.
     * </p>
     * <p>
     * Firewall Manager provides the following types of policies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An WAF policy (type WAFV2), which defines rule groups to run first in the corresponding WAF web ACL and rule
     * groups to run last in the web ACL.
     * </p>
     * </li>
     * <li>
     * <p>
     * An WAF Classic policy (type WAF), which defines a rule group.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * A security group policy, which manages VPC security groups across your Amazon Web Services organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
     * </p>
     * </li>
     * <li>
     * <p>
     * A DNS Firewall policy, which provides Route 53 Resolver DNS Firewall rules to filter DNS queries for specified
     * VPCs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts,
     * create multiple policies. You can create multiple policies for each type.
     * </p>
     * <p>
     * You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about
     * subscribing to Shield Advanced, see <a
     * href="https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html"
     * >CreateSubscription</a>.
     * </p>
     *
     * @param putPolicyRequest
     * @return A Java Future containing the result of the PutPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidTypeException The value of the <code>Type</code> parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.PutPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPolicyResponse> putPolicy(PutPolicyRequest putPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Firewall Manager policy.
     * </p>
     * <p>
     * Firewall Manager provides the following types of policies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An WAF policy (type WAFV2), which defines rule groups to run first in the corresponding WAF web ACL and rule
     * groups to run last in the web ACL.
     * </p>
     * </li>
     * <li>
     * <p>
     * An WAF Classic policy (type WAF), which defines a rule group.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * A security group policy, which manages VPC security groups across your Amazon Web Services organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
     * </p>
     * </li>
     * <li>
     * <p>
     * A DNS Firewall policy, which provides Route 53 Resolver DNS Firewall rules to filter DNS queries for specified
     * VPCs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts,
     * create multiple policies. You can create multiple policies for each type.
     * </p>
     * <p>
     * You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about
     * subscribing to Shield Advanced, see <a
     * href="https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html"
     * >CreateSubscription</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutPolicyRequest#builder()}
     * </p>
     *
     * @param putPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidTypeException The value of the <code>Type</code> parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.PutPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPolicyResponse> putPolicy(Consumer<PutPolicyRequest.Builder> putPolicyRequest) {
        return putPolicy(PutPolicyRequest.builder().applyMutation(putPolicyRequest).build());
    }

    /**
     * <p>
     * Creates an Firewall Manager protocols list.
     * </p>
     *
     * @param putProtocolsListRequest
     * @return A Java Future containing the result of the PutProtocolsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.PutProtocolsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutProtocolsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutProtocolsListResponse> putProtocolsList(PutProtocolsListRequest putProtocolsListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Firewall Manager protocols list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProtocolsListRequest.Builder} avoiding the need
     * to create one manually via {@link PutProtocolsListRequest#builder()}
     * </p>
     *
     * @param putProtocolsListRequest
     *        A {@link Consumer} that will call methods on {@link PutProtocolsListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutProtocolsList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.PutProtocolsList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutProtocolsList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutProtocolsListResponse> putProtocolsList(
            Consumer<PutProtocolsListRequest.Builder> putProtocolsListRequest) {
        return putProtocolsList(PutProtocolsListRequest.builder().applyMutation(putProtocolsListRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to an Amazon Web Services resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>LimitExceededException The operation exceeds a resource limit, for example, the maximum number of
     *         <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
     *         see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager
     *         Limits</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from an Amazon Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidOperationException The operation failed because there was nothing to do or the operation
     *         wasn't possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for
     *         an account ID that was already set as the Firewall Manager administrator. Or you might have tried to
     *         access a Region that's disabled by default, and that you need to enable for the Firewall Manager
     *         administrator account and for Organizations before you can access it.</li>
     *         <li>InternalErrorException The operation failed because of a system problem, even though the request was
     *         valid. Retry your request.</li>
     *         <li>InvalidInputException The parameters of the request were invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FmsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }
}
