/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for the improperly configured subnet route. It's possible there is a missing route table route, or a
 * configuration that causes traffic to cross an Availability Zone boundary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallInvalidRouteConfigurationViolation
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<NetworkFirewallInvalidRouteConfigurationViolation.Builder, NetworkFirewallInvalidRouteConfigurationViolation> {
    private static final SdkField<List<String>> AFFECTED_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AffectedSubnets")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::affectedSubnets))
            .setter(setter(Builder::affectedSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId").getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final SdkField<Boolean> IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRouteTableUsedInDifferentAZ")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::isRouteTableUsedInDifferentAZ))
            .setter(setter(Builder::isRouteTableUsedInDifferentAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRouteTableUsedInDifferentAZ")
                    .build()).build();

    private static final SdkField<Route> VIOLATING_ROUTE_FIELD = SdkField.<Route> builder(MarshallingType.SDK_POJO)
            .memberName("ViolatingRoute").getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::violatingRoute))
            .setter(setter(Builder::violatingRoute)).constructor(Route::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoute").build()).build();

    private static final SdkField<String> CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentFirewallSubnetRouteTable")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::currentFirewallSubnetRouteTable))
            .setter(setter(Builder::currentFirewallSubnetRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFirewallSubnetRouteTable")
                    .build()).build();

    private static final SdkField<String> EXPECTED_FIREWALL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedFirewallEndpoint")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::expectedFirewallEndpoint))
            .setter(setter(Builder::expectedFirewallEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallEndpoint").build())
            .build();

    private static final SdkField<String> ACTUAL_FIREWALL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActualFirewallEndpoint")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::actualFirewallEndpoint))
            .setter(setter(Builder::actualFirewallEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualFirewallEndpoint").build())
            .build();

    private static final SdkField<String> EXPECTED_FIREWALL_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedFirewallSubnetId")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::expectedFirewallSubnetId))
            .setter(setter(Builder::expectedFirewallSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallSubnetId").build())
            .build();

    private static final SdkField<String> ACTUAL_FIREWALL_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActualFirewallSubnetId")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::actualFirewallSubnetId))
            .setter(setter(Builder::actualFirewallSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualFirewallSubnetId").build())
            .build();

    private static final SdkField<List<ExpectedRoute>> EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD = SdkField
            .<List<ExpectedRoute>> builder(MarshallingType.LIST)
            .memberName("ExpectedFirewallSubnetRoutes")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::expectedFirewallSubnetRoutes))
            .setter(setter(Builder::expectedFirewallSubnetRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallSubnetRoutes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Route>> ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("ActualFirewallSubnetRoutes")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::actualFirewallSubnetRoutes))
            .setter(setter(Builder::actualFirewallSubnetRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualFirewallSubnetRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INTERNET_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InternetGatewayId").getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::internetGatewayId))
            .setter(setter(Builder::internetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayId").build()).build();

    private static final SdkField<String> CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentInternetGatewayRouteTable")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::currentInternetGatewayRouteTable))
            .setter(setter(Builder::currentInternetGatewayRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInternetGatewayRouteTable")
                    .build()).build();

    private static final SdkField<List<ExpectedRoute>> EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD = SdkField
            .<List<ExpectedRoute>> builder(MarshallingType.LIST)
            .memberName("ExpectedInternetGatewayRoutes")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::expectedInternetGatewayRoutes))
            .setter(setter(Builder::expectedInternetGatewayRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedInternetGatewayRoutes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Route>> ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("ActualInternetGatewayRoutes")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::actualInternetGatewayRoutes))
            .setter(setter(Builder::actualInternetGatewayRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualInternetGatewayRoutes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(NetworkFirewallInvalidRouteConfigurationViolation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_SUBNETS_FIELD,
            ROUTE_TABLE_ID_FIELD, IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD, VIOLATING_ROUTE_FIELD,
            CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD, EXPECTED_FIREWALL_ENDPOINT_FIELD, ACTUAL_FIREWALL_ENDPOINT_FIELD,
            EXPECTED_FIREWALL_SUBNET_ID_FIELD, ACTUAL_FIREWALL_SUBNET_ID_FIELD, EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD,
            ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD, INTERNET_GATEWAY_ID_FIELD, CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD,
            EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD, ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> affectedSubnets;

    private final String routeTableId;

    private final Boolean isRouteTableUsedInDifferentAZ;

    private final Route violatingRoute;

    private final String currentFirewallSubnetRouteTable;

    private final String expectedFirewallEndpoint;

    private final String actualFirewallEndpoint;

    private final String expectedFirewallSubnetId;

    private final String actualFirewallSubnetId;

    private final List<ExpectedRoute> expectedFirewallSubnetRoutes;

    private final List<Route> actualFirewallSubnetRoutes;

    private final String internetGatewayId;

    private final String currentInternetGatewayRouteTable;

    private final List<ExpectedRoute> expectedInternetGatewayRoutes;

    private final List<Route> actualInternetGatewayRoutes;

    private final String vpcId;

    private NetworkFirewallInvalidRouteConfigurationViolation(BuilderImpl builder) {
        this.affectedSubnets = builder.affectedSubnets;
        this.routeTableId = builder.routeTableId;
        this.isRouteTableUsedInDifferentAZ = builder.isRouteTableUsedInDifferentAZ;
        this.violatingRoute = builder.violatingRoute;
        this.currentFirewallSubnetRouteTable = builder.currentFirewallSubnetRouteTable;
        this.expectedFirewallEndpoint = builder.expectedFirewallEndpoint;
        this.actualFirewallEndpoint = builder.actualFirewallEndpoint;
        this.expectedFirewallSubnetId = builder.expectedFirewallSubnetId;
        this.actualFirewallSubnetId = builder.actualFirewallSubnetId;
        this.expectedFirewallSubnetRoutes = builder.expectedFirewallSubnetRoutes;
        this.actualFirewallSubnetRoutes = builder.actualFirewallSubnetRoutes;
        this.internetGatewayId = builder.internetGatewayId;
        this.currentInternetGatewayRouteTable = builder.currentInternetGatewayRouteTable;
        this.expectedInternetGatewayRoutes = builder.expectedInternetGatewayRoutes;
        this.actualInternetGatewayRoutes = builder.actualInternetGatewayRoutes;
        this.vpcId = builder.vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AffectedSubnets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAffectedSubnets() {
        return affectedSubnets != null && !(affectedSubnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets that are affected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAffectedSubnets} method.
     * </p>
     * 
     * @return The subnets that are affected.
     */
    public final List<String> affectedSubnets() {
        return affectedSubnets;
    }

    /**
     * <p>
     * The route table ID.
     * </p>
     * 
     * @return The route table ID.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * Information about whether the route table is used in another Availability Zone.
     * </p>
     * 
     * @return Information about whether the route table is used in another Availability Zone.
     */
    public final Boolean isRouteTableUsedInDifferentAZ() {
        return isRouteTableUsedInDifferentAZ;
    }

    /**
     * <p>
     * The route that's in violation.
     * </p>
     * 
     * @return The route that's in violation.
     */
    public final Route violatingRoute() {
        return violatingRoute;
    }

    /**
     * <p>
     * The subnet route table for the current firewall.
     * </p>
     * 
     * @return The subnet route table for the current firewall.
     */
    public final String currentFirewallSubnetRouteTable() {
        return currentFirewallSubnetRouteTable;
    }

    /**
     * <p>
     * The firewall endpoint that's expected.
     * </p>
     * 
     * @return The firewall endpoint that's expected.
     */
    public final String expectedFirewallEndpoint() {
        return expectedFirewallEndpoint;
    }

    /**
     * <p>
     * The actual firewall endpoint.
     * </p>
     * 
     * @return The actual firewall endpoint.
     */
    public final String actualFirewallEndpoint() {
        return actualFirewallEndpoint;
    }

    /**
     * <p>
     * The expected subnet ID for the firewall.
     * </p>
     * 
     * @return The expected subnet ID for the firewall.
     */
    public final String expectedFirewallSubnetId() {
        return expectedFirewallSubnetId;
    }

    /**
     * <p>
     * The actual subnet ID for the firewall.
     * </p>
     * 
     * @return The actual subnet ID for the firewall.
     */
    public final String actualFirewallSubnetId() {
        return actualFirewallSubnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedFirewallSubnetRoutes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedFirewallSubnetRoutes() {
        return expectedFirewallSubnetRoutes != null && !(expectedFirewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The firewall subnet routes that are expected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedFirewallSubnetRoutes} method.
     * </p>
     * 
     * @return The firewall subnet routes that are expected.
     */
    public final List<ExpectedRoute> expectedFirewallSubnetRoutes() {
        return expectedFirewallSubnetRoutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActualFirewallSubnetRoutes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasActualFirewallSubnetRoutes() {
        return actualFirewallSubnetRoutes != null && !(actualFirewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actual firewall subnet routes that are expected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActualFirewallSubnetRoutes} method.
     * </p>
     * 
     * @return The actual firewall subnet routes that are expected.
     */
    public final List<Route> actualFirewallSubnetRoutes() {
        return actualFirewallSubnetRoutes;
    }

    /**
     * <p>
     * The internet gateway ID.
     * </p>
     * 
     * @return The internet gateway ID.
     */
    public final String internetGatewayId() {
        return internetGatewayId;
    }

    /**
     * <p>
     * The route table for the current internet gateway.
     * </p>
     * 
     * @return The route table for the current internet gateway.
     */
    public final String currentInternetGatewayRouteTable() {
        return currentInternetGatewayRouteTable;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedInternetGatewayRoutes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedInternetGatewayRoutes() {
        return expectedInternetGatewayRoutes != null && !(expectedInternetGatewayRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The expected routes for the internet gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedInternetGatewayRoutes} method.
     * </p>
     * 
     * @return The expected routes for the internet gateway.
     */
    public final List<ExpectedRoute> expectedInternetGatewayRoutes() {
        return expectedInternetGatewayRoutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActualInternetGatewayRoutes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasActualInternetGatewayRoutes() {
        return actualInternetGatewayRoutes != null && !(actualInternetGatewayRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actual internet gateway routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActualInternetGatewayRoutes} method.
     * </p>
     * 
     * @return The actual internet gateway routes.
     */
    public final List<Route> actualInternetGatewayRoutes() {
        return actualInternetGatewayRoutes;
    }

    /**
     * <p>
     * Information about the VPC ID.
     * </p>
     * 
     * @return Information about the VPC ID.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAffectedSubnets() ? affectedSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(isRouteTableUsedInDifferentAZ());
        hashCode = 31 * hashCode + Objects.hashCode(violatingRoute());
        hashCode = 31 * hashCode + Objects.hashCode(currentFirewallSubnetRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(expectedFirewallEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(actualFirewallEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(expectedFirewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(actualFirewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedFirewallSubnetRoutes() ? expectedFirewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActualFirewallSubnetRoutes() ? actualFirewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(currentInternetGatewayRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedInternetGatewayRoutes() ? expectedInternetGatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActualInternetGatewayRoutes() ? actualInternetGatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallInvalidRouteConfigurationViolation)) {
            return false;
        }
        NetworkFirewallInvalidRouteConfigurationViolation other = (NetworkFirewallInvalidRouteConfigurationViolation) obj;
        return hasAffectedSubnets() == other.hasAffectedSubnets() && Objects.equals(affectedSubnets(), other.affectedSubnets())
                && Objects.equals(routeTableId(), other.routeTableId())
                && Objects.equals(isRouteTableUsedInDifferentAZ(), other.isRouteTableUsedInDifferentAZ())
                && Objects.equals(violatingRoute(), other.violatingRoute())
                && Objects.equals(currentFirewallSubnetRouteTable(), other.currentFirewallSubnetRouteTable())
                && Objects.equals(expectedFirewallEndpoint(), other.expectedFirewallEndpoint())
                && Objects.equals(actualFirewallEndpoint(), other.actualFirewallEndpoint())
                && Objects.equals(expectedFirewallSubnetId(), other.expectedFirewallSubnetId())
                && Objects.equals(actualFirewallSubnetId(), other.actualFirewallSubnetId())
                && hasExpectedFirewallSubnetRoutes() == other.hasExpectedFirewallSubnetRoutes()
                && Objects.equals(expectedFirewallSubnetRoutes(), other.expectedFirewallSubnetRoutes())
                && hasActualFirewallSubnetRoutes() == other.hasActualFirewallSubnetRoutes()
                && Objects.equals(actualFirewallSubnetRoutes(), other.actualFirewallSubnetRoutes())
                && Objects.equals(internetGatewayId(), other.internetGatewayId())
                && Objects.equals(currentInternetGatewayRouteTable(), other.currentInternetGatewayRouteTable())
                && hasExpectedInternetGatewayRoutes() == other.hasExpectedInternetGatewayRoutes()
                && Objects.equals(expectedInternetGatewayRoutes(), other.expectedInternetGatewayRoutes())
                && hasActualInternetGatewayRoutes() == other.hasActualInternetGatewayRoutes()
                && Objects.equals(actualInternetGatewayRoutes(), other.actualInternetGatewayRoutes())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("NetworkFirewallInvalidRouteConfigurationViolation")
                .add("AffectedSubnets", hasAffectedSubnets() ? affectedSubnets() : null)
                .add("RouteTableId", routeTableId())
                .add("IsRouteTableUsedInDifferentAZ", isRouteTableUsedInDifferentAZ())
                .add("ViolatingRoute", violatingRoute())
                .add("CurrentFirewallSubnetRouteTable", currentFirewallSubnetRouteTable())
                .add("ExpectedFirewallEndpoint", expectedFirewallEndpoint())
                .add("ActualFirewallEndpoint", actualFirewallEndpoint())
                .add("ExpectedFirewallSubnetId", expectedFirewallSubnetId())
                .add("ActualFirewallSubnetId", actualFirewallSubnetId())
                .add("ExpectedFirewallSubnetRoutes", hasExpectedFirewallSubnetRoutes() ? expectedFirewallSubnetRoutes() : null)
                .add("ActualFirewallSubnetRoutes", hasActualFirewallSubnetRoutes() ? actualFirewallSubnetRoutes() : null)
                .add("InternetGatewayId", internetGatewayId())
                .add("CurrentInternetGatewayRouteTable", currentInternetGatewayRouteTable())
                .add("ExpectedInternetGatewayRoutes", hasExpectedInternetGatewayRoutes() ? expectedInternetGatewayRoutes() : null)
                .add("ActualInternetGatewayRoutes", hasActualInternetGatewayRoutes() ? actualInternetGatewayRoutes() : null)
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AffectedSubnets":
            return Optional.ofNullable(clazz.cast(affectedSubnets()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "IsRouteTableUsedInDifferentAZ":
            return Optional.ofNullable(clazz.cast(isRouteTableUsedInDifferentAZ()));
        case "ViolatingRoute":
            return Optional.ofNullable(clazz.cast(violatingRoute()));
        case "CurrentFirewallSubnetRouteTable":
            return Optional.ofNullable(clazz.cast(currentFirewallSubnetRouteTable()));
        case "ExpectedFirewallEndpoint":
            return Optional.ofNullable(clazz.cast(expectedFirewallEndpoint()));
        case "ActualFirewallEndpoint":
            return Optional.ofNullable(clazz.cast(actualFirewallEndpoint()));
        case "ExpectedFirewallSubnetId":
            return Optional.ofNullable(clazz.cast(expectedFirewallSubnetId()));
        case "ActualFirewallSubnetId":
            return Optional.ofNullable(clazz.cast(actualFirewallSubnetId()));
        case "ExpectedFirewallSubnetRoutes":
            return Optional.ofNullable(clazz.cast(expectedFirewallSubnetRoutes()));
        case "ActualFirewallSubnetRoutes":
            return Optional.ofNullable(clazz.cast(actualFirewallSubnetRoutes()));
        case "InternetGatewayId":
            return Optional.ofNullable(clazz.cast(internetGatewayId()));
        case "CurrentInternetGatewayRouteTable":
            return Optional.ofNullable(clazz.cast(currentInternetGatewayRouteTable()));
        case "ExpectedInternetGatewayRoutes":
            return Optional.ofNullable(clazz.cast(expectedInternetGatewayRoutes()));
        case "ActualInternetGatewayRoutes":
            return Optional.ofNullable(clazz.cast(actualInternetGatewayRoutes()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallInvalidRouteConfigurationViolation, T> g) {
        return obj -> g.apply((NetworkFirewallInvalidRouteConfigurationViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallInvalidRouteConfigurationViolation> {
        /**
         * <p>
         * The subnets that are affected.
         * </p>
         * 
         * @param affectedSubnets
         *        The subnets that are affected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedSubnets(Collection<String> affectedSubnets);

        /**
         * <p>
         * The subnets that are affected.
         * </p>
         * 
         * @param affectedSubnets
         *        The subnets that are affected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedSubnets(String... affectedSubnets);

        /**
         * <p>
         * The route table ID.
         * </p>
         * 
         * @param routeTableId
         *        The route table ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * Information about whether the route table is used in another Availability Zone.
         * </p>
         * 
         * @param isRouteTableUsedInDifferentAZ
         *        Information about whether the route table is used in another Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ);

        /**
         * <p>
         * The route that's in violation.
         * </p>
         * 
         * @param violatingRoute
         *        The route that's in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoute(Route violatingRoute);

        /**
         * <p>
         * The route that's in violation.
         * </p>
         * This is a convenience that creates an instance of the {@link Route.Builder} avoiding the need to create one
         * manually via {@link Route#builder()}.
         *
         * When the {@link Consumer} completes, {@link Route.Builder#build()} is called immediately and its result is
         * passed to {@link #violatingRoute(Route)}.
         * 
         * @param violatingRoute
         *        a consumer that will call methods on {@link Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violatingRoute(Route)
         */
        default Builder violatingRoute(Consumer<Route.Builder> violatingRoute) {
            return violatingRoute(Route.builder().applyMutation(violatingRoute).build());
        }

        /**
         * <p>
         * The subnet route table for the current firewall.
         * </p>
         * 
         * @param currentFirewallSubnetRouteTable
         *        The subnet route table for the current firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable);

        /**
         * <p>
         * The firewall endpoint that's expected.
         * </p>
         * 
         * @param expectedFirewallEndpoint
         *        The firewall endpoint that's expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedFirewallEndpoint(String expectedFirewallEndpoint);

        /**
         * <p>
         * The actual firewall endpoint.
         * </p>
         * 
         * @param actualFirewallEndpoint
         *        The actual firewall endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualFirewallEndpoint(String actualFirewallEndpoint);

        /**
         * <p>
         * The expected subnet ID for the firewall.
         * </p>
         * 
         * @param expectedFirewallSubnetId
         *        The expected subnet ID for the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedFirewallSubnetId(String expectedFirewallSubnetId);

        /**
         * <p>
         * The actual subnet ID for the firewall.
         * </p>
         * 
         * @param actualFirewallSubnetId
         *        The actual subnet ID for the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualFirewallSubnetId(String actualFirewallSubnetId);

        /**
         * <p>
         * The firewall subnet routes that are expected.
         * </p>
         * 
         * @param expectedFirewallSubnetRoutes
         *        The firewall subnet routes that are expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedFirewallSubnetRoutes(Collection<ExpectedRoute> expectedFirewallSubnetRoutes);

        /**
         * <p>
         * The firewall subnet routes that are expected.
         * </p>
         * 
         * @param expectedFirewallSubnetRoutes
         *        The firewall subnet routes that are expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedFirewallSubnetRoutes(ExpectedRoute... expectedFirewallSubnetRoutes);

        /**
         * <p>
         * The firewall subnet routes that are expected.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExpectedRoute>.Builder} avoiding the need
         * to create one manually via {@link List<ExpectedRoute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExpectedRoute>.Builder#build()} is called immediately and
         * its result is passed to {@link #expectedFirewallSubnetRoutes(List<ExpectedRoute>)}.
         * 
         * @param expectedFirewallSubnetRoutes
         *        a consumer that will call methods on {@link List<ExpectedRoute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedFirewallSubnetRoutes(List<ExpectedRoute>)
         */
        Builder expectedFirewallSubnetRoutes(Consumer<ExpectedRoute.Builder>... expectedFirewallSubnetRoutes);

        /**
         * <p>
         * The actual firewall subnet routes that are expected.
         * </p>
         * 
         * @param actualFirewallSubnetRoutes
         *        The actual firewall subnet routes that are expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualFirewallSubnetRoutes(Collection<Route> actualFirewallSubnetRoutes);

        /**
         * <p>
         * The actual firewall subnet routes that are expected.
         * </p>
         * 
         * @param actualFirewallSubnetRoutes
         *        The actual firewall subnet routes that are expected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualFirewallSubnetRoutes(Route... actualFirewallSubnetRoutes);

        /**
         * <p>
         * The actual firewall subnet routes that are expected.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Route>.Builder} avoiding the need to create
         * one manually via {@link List<Route>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Route>.Builder#build()} is called immediately and its result
         * is passed to {@link #actualFirewallSubnetRoutes(List<Route>)}.
         * 
         * @param actualFirewallSubnetRoutes
         *        a consumer that will call methods on {@link List<Route>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualFirewallSubnetRoutes(List<Route>)
         */
        Builder actualFirewallSubnetRoutes(Consumer<Route.Builder>... actualFirewallSubnetRoutes);

        /**
         * <p>
         * The internet gateway ID.
         * </p>
         * 
         * @param internetGatewayId
         *        The internet gateway ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayId(String internetGatewayId);

        /**
         * <p>
         * The route table for the current internet gateway.
         * </p>
         * 
         * @param currentInternetGatewayRouteTable
         *        The route table for the current internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable);

        /**
         * <p>
         * The expected routes for the internet gateway.
         * </p>
         * 
         * @param expectedInternetGatewayRoutes
         *        The expected routes for the internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedInternetGatewayRoutes(Collection<ExpectedRoute> expectedInternetGatewayRoutes);

        /**
         * <p>
         * The expected routes for the internet gateway.
         * </p>
         * 
         * @param expectedInternetGatewayRoutes
         *        The expected routes for the internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedInternetGatewayRoutes(ExpectedRoute... expectedInternetGatewayRoutes);

        /**
         * <p>
         * The expected routes for the internet gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExpectedRoute>.Builder} avoiding the need
         * to create one manually via {@link List<ExpectedRoute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExpectedRoute>.Builder#build()} is called immediately and
         * its result is passed to {@link #expectedInternetGatewayRoutes(List<ExpectedRoute>)}.
         * 
         * @param expectedInternetGatewayRoutes
         *        a consumer that will call methods on {@link List<ExpectedRoute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedInternetGatewayRoutes(List<ExpectedRoute>)
         */
        Builder expectedInternetGatewayRoutes(Consumer<ExpectedRoute.Builder>... expectedInternetGatewayRoutes);

        /**
         * <p>
         * The actual internet gateway routes.
         * </p>
         * 
         * @param actualInternetGatewayRoutes
         *        The actual internet gateway routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualInternetGatewayRoutes(Collection<Route> actualInternetGatewayRoutes);

        /**
         * <p>
         * The actual internet gateway routes.
         * </p>
         * 
         * @param actualInternetGatewayRoutes
         *        The actual internet gateway routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualInternetGatewayRoutes(Route... actualInternetGatewayRoutes);

        /**
         * <p>
         * The actual internet gateway routes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Route>.Builder} avoiding the need to create
         * one manually via {@link List<Route>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Route>.Builder#build()} is called immediately and its result
         * is passed to {@link #actualInternetGatewayRoutes(List<Route>)}.
         * 
         * @param actualInternetGatewayRoutes
         *        a consumer that will call methods on {@link List<Route>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualInternetGatewayRoutes(List<Route>)
         */
        Builder actualInternetGatewayRoutes(Consumer<Route.Builder>... actualInternetGatewayRoutes);

        /**
         * <p>
         * Information about the VPC ID.
         * </p>
         * 
         * @param vpcId
         *        Information about the VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> affectedSubnets = DefaultSdkAutoConstructList.getInstance();

        private String routeTableId;

        private Boolean isRouteTableUsedInDifferentAZ;

        private Route violatingRoute;

        private String currentFirewallSubnetRouteTable;

        private String expectedFirewallEndpoint;

        private String actualFirewallEndpoint;

        private String expectedFirewallSubnetId;

        private String actualFirewallSubnetId;

        private List<ExpectedRoute> expectedFirewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();

        private List<Route> actualFirewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();

        private String internetGatewayId;

        private String currentInternetGatewayRouteTable;

        private List<ExpectedRoute> expectedInternetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();

        private List<Route> actualInternetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallInvalidRouteConfigurationViolation model) {
            affectedSubnets(model.affectedSubnets);
            routeTableId(model.routeTableId);
            isRouteTableUsedInDifferentAZ(model.isRouteTableUsedInDifferentAZ);
            violatingRoute(model.violatingRoute);
            currentFirewallSubnetRouteTable(model.currentFirewallSubnetRouteTable);
            expectedFirewallEndpoint(model.expectedFirewallEndpoint);
            actualFirewallEndpoint(model.actualFirewallEndpoint);
            expectedFirewallSubnetId(model.expectedFirewallSubnetId);
            actualFirewallSubnetId(model.actualFirewallSubnetId);
            expectedFirewallSubnetRoutes(model.expectedFirewallSubnetRoutes);
            actualFirewallSubnetRoutes(model.actualFirewallSubnetRoutes);
            internetGatewayId(model.internetGatewayId);
            currentInternetGatewayRouteTable(model.currentInternetGatewayRouteTable);
            expectedInternetGatewayRoutes(model.expectedInternetGatewayRoutes);
            actualInternetGatewayRoutes(model.actualInternetGatewayRoutes);
            vpcId(model.vpcId);
        }

        public final Collection<String> getAffectedSubnets() {
            if (affectedSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return affectedSubnets;
        }

        public final void setAffectedSubnets(Collection<String> affectedSubnets) {
            this.affectedSubnets = ResourceIdListCopier.copy(affectedSubnets);
        }

        @Override
        @Transient
        public final Builder affectedSubnets(Collection<String> affectedSubnets) {
            this.affectedSubnets = ResourceIdListCopier.copy(affectedSubnets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder affectedSubnets(String... affectedSubnets) {
            affectedSubnets(Arrays.asList(affectedSubnets));
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        @Transient
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final Boolean getIsRouteTableUsedInDifferentAZ() {
            return isRouteTableUsedInDifferentAZ;
        }

        public final void setIsRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ) {
            this.isRouteTableUsedInDifferentAZ = isRouteTableUsedInDifferentAZ;
        }

        @Override
        @Transient
        public final Builder isRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ) {
            this.isRouteTableUsedInDifferentAZ = isRouteTableUsedInDifferentAZ;
            return this;
        }

        public final Route.Builder getViolatingRoute() {
            return violatingRoute != null ? violatingRoute.toBuilder() : null;
        }

        public final void setViolatingRoute(Route.BuilderImpl violatingRoute) {
            this.violatingRoute = violatingRoute != null ? violatingRoute.build() : null;
        }

        @Override
        @Transient
        public final Builder violatingRoute(Route violatingRoute) {
            this.violatingRoute = violatingRoute;
            return this;
        }

        public final String getCurrentFirewallSubnetRouteTable() {
            return currentFirewallSubnetRouteTable;
        }

        public final void setCurrentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
        }

        @Override
        @Transient
        public final Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
            return this;
        }

        public final String getExpectedFirewallEndpoint() {
            return expectedFirewallEndpoint;
        }

        public final void setExpectedFirewallEndpoint(String expectedFirewallEndpoint) {
            this.expectedFirewallEndpoint = expectedFirewallEndpoint;
        }

        @Override
        @Transient
        public final Builder expectedFirewallEndpoint(String expectedFirewallEndpoint) {
            this.expectedFirewallEndpoint = expectedFirewallEndpoint;
            return this;
        }

        public final String getActualFirewallEndpoint() {
            return actualFirewallEndpoint;
        }

        public final void setActualFirewallEndpoint(String actualFirewallEndpoint) {
            this.actualFirewallEndpoint = actualFirewallEndpoint;
        }

        @Override
        @Transient
        public final Builder actualFirewallEndpoint(String actualFirewallEndpoint) {
            this.actualFirewallEndpoint = actualFirewallEndpoint;
            return this;
        }

        public final String getExpectedFirewallSubnetId() {
            return expectedFirewallSubnetId;
        }

        public final void setExpectedFirewallSubnetId(String expectedFirewallSubnetId) {
            this.expectedFirewallSubnetId = expectedFirewallSubnetId;
        }

        @Override
        @Transient
        public final Builder expectedFirewallSubnetId(String expectedFirewallSubnetId) {
            this.expectedFirewallSubnetId = expectedFirewallSubnetId;
            return this;
        }

        public final String getActualFirewallSubnetId() {
            return actualFirewallSubnetId;
        }

        public final void setActualFirewallSubnetId(String actualFirewallSubnetId) {
            this.actualFirewallSubnetId = actualFirewallSubnetId;
        }

        @Override
        @Transient
        public final Builder actualFirewallSubnetId(String actualFirewallSubnetId) {
            this.actualFirewallSubnetId = actualFirewallSubnetId;
            return this;
        }

        public final List<ExpectedRoute.Builder> getExpectedFirewallSubnetRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedFirewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedFirewallSubnetRoutes(Collection<ExpectedRoute.BuilderImpl> expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedFirewallSubnetRoutes);
        }

        @Override
        @Transient
        public final Builder expectedFirewallSubnetRoutes(Collection<ExpectedRoute> expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes = ExpectedRoutesCopier.copy(expectedFirewallSubnetRoutes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder expectedFirewallSubnetRoutes(ExpectedRoute... expectedFirewallSubnetRoutes) {
            expectedFirewallSubnetRoutes(Arrays.asList(expectedFirewallSubnetRoutes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder expectedFirewallSubnetRoutes(Consumer<ExpectedRoute.Builder>... expectedFirewallSubnetRoutes) {
            expectedFirewallSubnetRoutes(Stream.of(expectedFirewallSubnetRoutes)
                    .map(c -> ExpectedRoute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Route.Builder> getActualFirewallSubnetRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.actualFirewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActualFirewallSubnetRoutes(Collection<Route.BuilderImpl> actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes = RoutesCopier.copyFromBuilder(actualFirewallSubnetRoutes);
        }

        @Override
        @Transient
        public final Builder actualFirewallSubnetRoutes(Collection<Route> actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes = RoutesCopier.copy(actualFirewallSubnetRoutes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actualFirewallSubnetRoutes(Route... actualFirewallSubnetRoutes) {
            actualFirewallSubnetRoutes(Arrays.asList(actualFirewallSubnetRoutes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actualFirewallSubnetRoutes(Consumer<Route.Builder>... actualFirewallSubnetRoutes) {
            actualFirewallSubnetRoutes(Stream.of(actualFirewallSubnetRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInternetGatewayId() {
            return internetGatewayId;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        @Override
        @Transient
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final String getCurrentInternetGatewayRouteTable() {
            return currentInternetGatewayRouteTable;
        }

        public final void setCurrentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
        }

        @Override
        @Transient
        public final Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
            return this;
        }

        public final List<ExpectedRoute.Builder> getExpectedInternetGatewayRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedInternetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedInternetGatewayRoutes(Collection<ExpectedRoute.BuilderImpl> expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedInternetGatewayRoutes);
        }

        @Override
        @Transient
        public final Builder expectedInternetGatewayRoutes(Collection<ExpectedRoute> expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes = ExpectedRoutesCopier.copy(expectedInternetGatewayRoutes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder expectedInternetGatewayRoutes(ExpectedRoute... expectedInternetGatewayRoutes) {
            expectedInternetGatewayRoutes(Arrays.asList(expectedInternetGatewayRoutes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder expectedInternetGatewayRoutes(Consumer<ExpectedRoute.Builder>... expectedInternetGatewayRoutes) {
            expectedInternetGatewayRoutes(Stream.of(expectedInternetGatewayRoutes)
                    .map(c -> ExpectedRoute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Route.Builder> getActualInternetGatewayRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.actualInternetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActualInternetGatewayRoutes(Collection<Route.BuilderImpl> actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes = RoutesCopier.copyFromBuilder(actualInternetGatewayRoutes);
        }

        @Override
        @Transient
        public final Builder actualInternetGatewayRoutes(Collection<Route> actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes = RoutesCopier.copy(actualInternetGatewayRoutes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actualInternetGatewayRoutes(Route... actualInternetGatewayRoutes) {
            actualInternetGatewayRoutes(Arrays.asList(actualInternetGatewayRoutes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actualInternetGatewayRoutes(Consumer<Route.Builder>... actualInternetGatewayRoutes) {
            actualInternetGatewayRoutes(Stream.of(actualInternetGatewayRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public NetworkFirewallInvalidRouteConfigurationViolation build() {
            return new NetworkFirewallInvalidRouteConfigurationViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
