/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for Network Firewall for a subnet that's not associated to the expected Firewall Manager managed
 * route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallMissingExpectedRTViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFirewallMissingExpectedRTViolation.Builder, NetworkFirewallMissingExpectedRTViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(NetworkFirewallMissingExpectedRTViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<String> VPC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VPC")
            .getter(getter(NetworkFirewallMissingExpectedRTViolation::vpc)).setter(setter(Builder::vpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(NetworkFirewallMissingExpectedRTViolation::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> CURRENT_ROUTE_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentRouteTable").getter(getter(NetworkFirewallMissingExpectedRTViolation::currentRouteTable))
            .setter(setter(Builder::currentRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRouteTable").build()).build();

    private static final SdkField<String> EXPECTED_ROUTE_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedRouteTable").getter(getter(NetworkFirewallMissingExpectedRTViolation::expectedRouteTable))
            .setter(setter(Builder::expectedRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedRouteTable").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            VPC_FIELD, AVAILABILITY_ZONE_FIELD, CURRENT_ROUTE_TABLE_FIELD, EXPECTED_ROUTE_TABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final String vpc;

    private final String availabilityZone;

    private final String currentRouteTable;

    private final String expectedRouteTable;

    private NetworkFirewallMissingExpectedRTViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.vpc = builder.vpc;
        this.availabilityZone = builder.availabilityZone;
        this.currentRouteTable = builder.currentRouteTable;
        this.expectedRouteTable = builder.expectedRouteTable;
    }

    /**
     * <p>
     * The ID of the Network Firewall or VPC resource that's in violation.
     * </p>
     * 
     * @return The ID of the Network Firewall or VPC resource that's in violation.
     */
    public final String violationTarget() {
        return violationTarget;
    }

    /**
     * <p>
     * The resource ID of the VPC associated with a violating subnet.
     * </p>
     * 
     * @return The resource ID of the VPC associated with a violating subnet.
     */
    public final String vpc() {
        return vpc;
    }

    /**
     * <p>
     * The Availability Zone of a violating subnet.
     * </p>
     * 
     * @return The Availability Zone of a violating subnet.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The resource ID of the current route table that's associated with the subnet, if one is available.
     * </p>
     * 
     * @return The resource ID of the current route table that's associated with the subnet, if one is available.
     */
    public final String currentRouteTable() {
        return currentRouteTable;
    }

    /**
     * <p>
     * The resource ID of the route table that should be associated with the subnet.
     * </p>
     * 
     * @return The resource ID of the route table that should be associated with the subnet.
     */
    public final String expectedRouteTable() {
        return expectedRouteTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(currentRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRouteTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallMissingExpectedRTViolation)) {
            return false;
        }
        NetworkFirewallMissingExpectedRTViolation other = (NetworkFirewallMissingExpectedRTViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget()) && Objects.equals(vpc(), other.vpc())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(currentRouteTable(), other.currentRouteTable())
                && Objects.equals(expectedRouteTable(), other.expectedRouteTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFirewallMissingExpectedRTViolation").add("ViolationTarget", violationTarget())
                .add("VPC", vpc()).add("AvailabilityZone", availabilityZone()).add("CurrentRouteTable", currentRouteTable())
                .add("ExpectedRouteTable", expectedRouteTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "VPC":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "CurrentRouteTable":
            return Optional.ofNullable(clazz.cast(currentRouteTable()));
        case "ExpectedRouteTable":
            return Optional.ofNullable(clazz.cast(expectedRouteTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallMissingExpectedRTViolation, T> g) {
        return obj -> g.apply((NetworkFirewallMissingExpectedRTViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallMissingExpectedRTViolation> {
        /**
         * <p>
         * The ID of the Network Firewall or VPC resource that's in violation.
         * </p>
         * 
         * @param violationTarget
         *        The ID of the Network Firewall or VPC resource that's in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * The resource ID of the VPC associated with a violating subnet.
         * </p>
         * 
         * @param vpc
         *        The resource ID of the VPC associated with a violating subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(String vpc);

        /**
         * <p>
         * The Availability Zone of a violating subnet.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of a violating subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The resource ID of the current route table that's associated with the subnet, if one is available.
         * </p>
         * 
         * @param currentRouteTable
         *        The resource ID of the current route table that's associated with the subnet, if one is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRouteTable(String currentRouteTable);

        /**
         * <p>
         * The resource ID of the route table that should be associated with the subnet.
         * </p>
         * 
         * @param expectedRouteTable
         *        The resource ID of the route table that should be associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRouteTable(String expectedRouteTable);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private String vpc;

        private String availabilityZone;

        private String currentRouteTable;

        private String expectedRouteTable;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallMissingExpectedRTViolation model) {
            violationTarget(model.violationTarget);
            vpc(model.vpc);
            availabilityZone(model.availabilityZone);
            currentRouteTable(model.currentRouteTable);
            expectedRouteTable(model.expectedRouteTable);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        @Transient
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final String getVpc() {
            return vpc;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        @Transient
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getCurrentRouteTable() {
            return currentRouteTable;
        }

        public final void setCurrentRouteTable(String currentRouteTable) {
            this.currentRouteTable = currentRouteTable;
        }

        @Override
        @Transient
        public final Builder currentRouteTable(String currentRouteTable) {
            this.currentRouteTable = currentRouteTable;
            return this;
        }

        public final String getExpectedRouteTable() {
            return expectedRouteTable;
        }

        public final void setExpectedRouteTable(String expectedRouteTable) {
            this.expectedRouteTable = expectedRouteTable;
        }

        @Override
        @Transient
        public final Builder expectedRouteTable(String expectedRouteTable) {
            this.expectedRouteTable = expectedRouteTable;
            return this;
        }

        @Override
        public NetworkFirewallMissingExpectedRTViolation build() {
            return new NetworkFirewallMissingExpectedRTViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
